/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import prefuse.util.force.AbstractForce;
import prefuse.util.force.ForceItem;

public class CircularWallForce
extends AbstractForce {
    private static String[] pnames = new String[]{"GravitationalConstant"};
    public static final float DEFAULT_GRAV_CONSTANT = -0.1f;
    public static final float DEFAULT_MIN_GRAV_CONSTANT = -1.0f;
    public static final float DEFAULT_MAX_GRAV_CONSTANT = 1.0f;
    public static final int GRAVITATIONAL_CONST = 0;
    private float x;
    private float y;
    private float r;

    public CircularWallForce(float gravConst, float x, float y, float r) {
        this.params = new float[]{gravConst};
        this.minValues = new float[]{-1.0f};
        this.maxValues = new float[]{1.0f};
        this.x = x;
        this.y = y;
        this.r = r;
    }

    public CircularWallForce(float x, float y, float r) {
        this(-0.1f, x, y, r);
    }

    @Override
    public boolean isItemForce() {
        return true;
    }

    @Override
    protected String[] getParameterNames() {
        return pnames;
    }

    @Override
    public void getForce(ForceItem item) {
        float[] n = item.location;
        float dx = this.x - n[0];
        float dy = this.y - n[1];
        float d = (float)Math.sqrt(dx * dx + dy * dy);
        float dr = this.r - d;
        float c = dr > 0.0f ? -1.0f : 1.0f;
        float v = c * this.params[0] * item.mass / (dr * dr);
        if ((double)d == 0.0) {
            dx = ((float)Math.random() - 0.5f) / 50.0f;
            dy = ((float)Math.random() - 0.5f) / 50.0f;
            d = (float)Math.sqrt(dx * dx + dy * dy);
        }
        item.force[0] = item.force[0] + v * dx / d;
        item.force[1] = item.force[1] + v * dy / d;
    }
}

