/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.prefuse.layouts.internal;

import java.io.IOException;
import org.cytoscape.view.layout.EdgeWeighter;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;

public class ForceDirectedLayoutContext
implements TunableValidator {
    @ContainsTunables
    public EdgeWeighter edgeWeighter = new EdgeWeighter();
    @Tunable(description="Number of Iterations:", context="both", longDescription="Number of Iterations, in numeric value", exampleStringValue="100")
    public int numIterations = 100;
    @Tunable(description="Default Spring Coefficient:", context="both", longDescription="Default Spring Coefficient, in numeric value", exampleStringValue="1e-4")
    public double defaultSpringCoefficient = 1.0E-4;
    @Tunable(description="Default Spring Length:", context="both", longDescription="Default Spring Length, in numeric value", exampleStringValue="50.0")
    public double defaultSpringLength = 50.0;
    @Tunable(description="Default Node Mass:", context="both", longDescription="Default Node Mass, in numeric value", exampleStringValue="3.0")
    public double defaultNodeMass = 3.0;
    @Tunable(description="Force deterministic layouts (slower):", context="both", longDescription="Force deterministic layouts (slower); boolean values only, ```true``` or ```false```; defaults to ```false```", exampleStringValue="false")
    public boolean isDeterministic;
    @Tunable(description="Don't partition graph before layout:", groups={"Standard Settings"}, context="both", longDescription="Don't partition graph before layout; boolean values only, ```true``` or ```false```; defaults to ```false```", exampleStringValue="false")
    public boolean singlePartition;

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        try {
            if (!ForceDirectedLayoutContext.isPositive(this.numIterations)) {
                errMsg.append("Number of iterations must be > 0; current value = " + this.numIterations);
            }
            if (!ForceDirectedLayoutContext.isPositive(this.defaultSpringCoefficient)) {
                errMsg.append("Default spring coefficient must be > 0; current value = " + this.defaultSpringCoefficient);
            }
            if (!ForceDirectedLayoutContext.isPositive(this.defaultSpringLength)) {
                errMsg.append("Default spring length must be > 0; current value = " + this.defaultSpringLength);
            }
            if (!ForceDirectedLayoutContext.isPositive(this.defaultNodeMass)) {
                errMsg.append("Default node mass must be > 0; current value = " + this.defaultNodeMass);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ForceDirectedLayoutContext.isPositive(this.numIterations) && ForceDirectedLayoutContext.isPositive(this.defaultSpringCoefficient) && ForceDirectedLayoutContext.isPositive(this.defaultSpringLength) && ForceDirectedLayoutContext.isPositive(this.defaultNodeMass) ? TunableValidator.ValidationState.OK : TunableValidator.ValidationState.INVALID;
    }

    private static boolean isPositive(int n) {
        return n > 0;
    }

    private static boolean isPositive(double n) {
        return n > 0.0;
    }
}

