/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.prefuse.layouts.internal;

import java.util.HashSet;
import java.util.Set;
import org.cytoscape.model.CyNode;
import org.cytoscape.prefuse.layouts.internal.ForceDirectedLayoutContext;
import org.cytoscape.prefuse.layouts.internal.ForceDirectedLayoutTask;
import org.cytoscape.view.layout.AbstractLayoutAlgorithm;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.undo.UndoSupport;
import prefuse.util.force.EulerIntegrator;
import prefuse.util.force.Integrator;
import prefuse.util.force.RungeKuttaIntegrator;
import prefuse.util.force.StateMonitor;

public class ForceDirectedLayout
extends AbstractLayoutAlgorithm {
    private static final String ALGORITHM_ID = "force-directed";
    static final String ALGORITHM_DISPLAY_NAME = "Prefuse Force Directed Layout";
    private Integrators integrator = Integrators.RUNGEKUTTA;

    public ForceDirectedLayout(UndoSupport undo) {
        super(ALGORITHM_ID, ALGORITHM_DISPLAY_NAME, undo);
    }

    public TaskIterator createTaskIterator(CyNetworkView networkView, Object context, Set<View<CyNode>> nodesToLayOut, String attrName) {
        return new TaskIterator(new Task[]{new ForceDirectedLayoutTask(this.toString(), networkView, nodesToLayOut, (ForceDirectedLayoutContext)context, this.integrator, attrName, this.undoSupport)});
    }

    public Object createLayoutContext() {
        return new ForceDirectedLayoutContext();
    }

    public Set<Class<?>> getSupportedEdgeAttributeTypes() {
        HashSet ret = new HashSet();
        ret.add(Integer.class);
        ret.add(Double.class);
        return ret;
    }

    public boolean getSupportsSelectedOnly() {
        return true;
    }

    public static enum Integrators {
        RUNGEKUTTA("Runge-Kutta"),
        EULER("Euler");

        private String name;

        private Integrators(String str) {
            this.name = str;
        }

        public String toString() {
            return this.name;
        }

        public Integrator getNewIntegrator(StateMonitor monitor) {
            if (this == EULER) {
                return new EulerIntegrator(monitor);
            }
            return new RungeKuttaIntegrator(monitor);
        }
    }
}

