/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.view;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupSettingsManager;
import org.cytoscape.group.events.GroupAboutToBeDestroyedEvent;
import org.cytoscape.group.events.GroupAboutToBeDestroyedListener;
import org.cytoscape.group.events.GroupAboutToCollapseEvent;
import org.cytoscape.group.events.GroupAboutToCollapseListener;
import org.cytoscape.group.events.GroupAddedEvent;
import org.cytoscape.group.events.GroupAddedListener;
import org.cytoscape.group.events.GroupCollapsedEvent;
import org.cytoscape.group.events.GroupCollapsedListener;
import org.cytoscape.group.internal.CyGroupImpl;
import org.cytoscape.group.internal.CyGroupManagerImpl;
import org.cytoscape.group.internal.data.CyGroupSettingsImpl;
import org.cytoscape.group.internal.data.GroupViewTypeChangedEvent;
import org.cytoscape.group.internal.data.GroupViewTypeChangedListener;
import org.cytoscape.group.internal.view.NodeChangeListener;
import org.cytoscape.group.internal.view.ViewUtils;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupViewCollapseHandler
implements GroupAboutToCollapseListener,
GroupCollapsedListener,
SessionLoadedListener,
GroupAboutToBeDestroyedListener,
GroupViewTypeChangedListener,
GroupAddedListener {
    private final CyGroupManagerImpl cyGroupManager;
    private final CyGroupSettingsImpl cyGroupSettings;
    private final NodeChangeListener nodeChangeListener;
    private CyNetworkManager cyNetworkManager;
    private CyNetworkViewManager cyNetworkViewManager;
    private CyNetworkViewFactory cyNetworkViewFactory;
    private VisualMappingManager cyStyleManager;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final VisualProperty<Double> xLoc = BasicVisualLexicon.NODE_X_LOCATION;
    private static final VisualProperty<Double> yLoc = BasicVisualLexicon.NODE_Y_LOCATION;
    private static final String X_LOCATION_ATTR = "__xLocation";
    private static final String Y_LOCATION_ATTR = "__yLocation";
    private static final String NETWORK_SUID_ATTR = "__groupNetworks.SUID";
    private static final String ISMEMBER_EDGE_ATTR = "__isMemberEdge";
    private static final int Z_OFFSET = -100;

    public GroupViewCollapseHandler(CyGroupManagerImpl groupManager, CyGroupSettingsImpl groupSettings, NodeChangeListener nodeChangeListener) {
        this.cyGroupManager = groupManager;
        this.cyGroupSettings = groupSettings;
        this.nodeChangeListener = nodeChangeListener;
    }

    @Override
    public void handleEvent(GroupViewTypeChangedEvent e) {
        this.getServices();
        CyGroupSettingsManager.GroupViewType oldType = e.getOldType();
        CyGroupSettingsManager.GroupViewType newType = e.getNewType();
        CyGroup group = e.getGroup();
        if (group == null || oldType.equals((Object)newType)) {
            return;
        }
        if (oldType == CyGroupSettingsManager.GroupViewType.COMPOUND || oldType == CyGroupSettingsManager.GroupViewType.SINGLENODE) {
            this.removeCompoundNode(group);
        } else if (oldType == CyGroupSettingsManager.GroupViewType.SHOWGROUPNODE) {
            ((CyGroupImpl)group).removeMemberEdges();
        }
        for (CyNetwork net : group.getNetworkSet()) {
            if (net.equals(group.getRootNetwork())) continue;
            if (newType == CyGroupSettingsManager.GroupViewType.NONE) {
                ((CyGroupImpl)group).setGroupNodeShown(net, false);
                if (group.isCollapsed(net) || !net.containsNode(group.getGroupNode())) continue;
                group.collapse(net);
                ((CyGroupImpl)group).setGroupNodeShown(net, false);
                continue;
            }
            if (!group.isCollapsed(net)) {
                group.collapse(net);
            }
            group.expand(net);
        }
    }

    public void handleEvent(GroupAboutToCollapseEvent e) {
        this.getServices();
        CyNetwork network = e.getNetwork();
        CyGroup group = (CyGroup)e.getSource();
        CyRootNetwork rootNetwork = group.getRootNetwork();
        Collection views = this.cyNetworkViewManager.getNetworkViews(network);
        CyNetworkView view = null;
        if (views.size() == 0) {
            return;
        }
        for (CyNetworkView v : views) {
            if (!v.getRendererId().equals("org.cytoscape.ding")) continue;
            view = v;
        }
        if (view == null) {
            return;
        }
        CyGroupSettingsManager.GroupViewType groupViewType = this.cyGroupSettings.getGroupViewType(group);
        if (e.collapsing()) {
            Dimension center = ViewUtils.calculateCenter(view, group.getNodeList());
            if (center != null) {
                ViewUtils.updateGroupLocation(network, group, center);
                for (CyNode node : group.getNodeList()) {
                    if (!network.containsNode(node)) continue;
                    Dimension offset = ViewUtils.calculateOffset(center, view, node);
                    ViewUtils.updateNodeOffset(network, group, node, offset);
                }
            }
        } else {
            View nView = view.getNodeView(group.getGroupNode());
            if (nView == null) {
                return;
            }
            double x = (Double)nView.getVisualProperty(xLoc);
            double y = (Double)nView.getVisualProperty(yLoc);
            ViewUtils.updateGroupLocation(network, group, x, y);
        }
    }

    public void handleEvent(GroupCollapsedEvent e) {
        this.getServices();
        CyNetwork network = e.getNetwork();
        CyGroup group = (CyGroup)e.getSource();
        Collection views = this.cyNetworkViewManager.getNetworkViews(network);
        CyNetworkView view = null;
        if (views.size() == 0) {
            return;
        }
        for (CyNetworkView v : views) {
            if (!v.getRendererId().equals("org.cytoscape.ding")) continue;
            view = v;
        }
        if (view == null) {
            return;
        }
        CyRootNetwork rootNetwork = group.getRootNetwork();
        CyGroupSettingsManager.GroupViewType groupViewType = this.cyGroupSettings.getGroupViewType(group);
        if (e.collapsed()) {
            Dimension d = ViewUtils.getLocation(network, group);
            if (d != null) {
                ViewUtils.moveNode(view, group.getGroupNode(), d);
            }
            View nView = view.getNodeView(group.getGroupNode());
            if (this.cyGroupSettings.getUseNestedNetworks(group)) {
                CyNetwork nn = group.getGroupNetwork();
                CyNetworkView nnView = null;
                if (!this.cyNetworkManager.networkExists(nn.getSUID().longValue())) {
                    this.cyNetworkManager.addNetwork(nn, false);
                    nnView = this.cyNetworkViewFactory.createNetworkView(nn);
                    this.cyNetworkViewManager.addNetworkView(nnView, false);
                    VisualStyle style = this.cyStyleManager.getVisualStyle(view);
                    this.cyStyleManager.setVisualStyle(style, nnView);
                    style.apply(nnView);
                } else if (this.cyNetworkViewManager.viewExists(nn)) {
                    nnView = (CyNetworkView)this.cyNetworkViewManager.getNetworkViews(nn).iterator().next();
                }
                if (nnView != null) {
                    ViewUtils.moveNodes(group, nnView, d);
                    nnView.updateView();
                    nView.clearValueLock(BasicVisualLexicon.NODE_NESTED_NETWORK_IMAGE_VISIBLE);
                }
            } else {
                nView.setLockedValue(BasicVisualLexicon.NODE_NESTED_NETWORK_IMAGE_VISIBLE, (Object)Boolean.FALSE);
            }
            if (groupViewType.equals((Object)CyGroupSettingsManager.GroupViewType.COMPOUND)) {
                this.deActivateCompoundNode(group, view);
            }
            this.styleGroupNode(group, view, views);
        } else {
            CyNode groupNode = group.getGroupNode();
            Dimension center = ViewUtils.getLocation(network, group);
            if (center != null) {
                ViewUtils.moveNodes(group, view, center);
            }
            if (!groupViewType.equals((Object)CyGroupSettingsManager.GroupViewType.NONE)) {
                CySubNetwork subnet = (CySubNetwork)network;
                subnet.addNode(group.getGroupNode());
                List groupNodeEdges = rootNetwork.getAdjacentEdgeList(groupNode, CyEdge.Type.ANY);
                for (CyEdge edge : groupNodeEdges) {
                    CyRow row = rootNetwork.getRow((CyIdentifiable)edge, "HIDDEN");
                    if (!(row == null || row.isSet("__isMetaEdge") && ((Boolean)row.get("__isMetaEdge", Boolean.class)).booleanValue())) {
                        subnet.addEdge(edge);
                        continue;
                    }
                    if (!subnet.containsEdge(edge) || row == null || !row.isSet("__isMetaEdge") || !((Boolean)row.get("__isMetaEdge", Boolean.class)).booleanValue()) continue;
                    subnet.removeEdges(Collections.singletonList(edge));
                }
                if (groupViewType.equals((Object)CyGroupSettingsManager.GroupViewType.SHOWGROUPNODE)) {
                    this.addMemberEdges(group, network);
                    this.styleGroupNode(group, view, views);
                }
                CyEventHelper cyEventHelper = this.cyGroupManager.getService(CyEventHelper.class);
                cyEventHelper.flushPayloadEvents();
                this.handleEvent(new GroupCollapsedEvent(group, network, true));
                if (groupViewType.equals((Object)CyGroupSettingsManager.GroupViewType.COMPOUND) || groupViewType.equals((Object)CyGroupSettingsManager.GroupViewType.SINGLENODE)) {
                    ((CyGroupImpl)group).setGroupNodeShown(network, true);
                    this.activateCompoundNode(group, view);
                }
                cyEventHelper.flushPayloadEvents();
                view.updateView();
                return;
            }
            List nodeList = group.getNodeList();
            for (CyNode node : nodeList) {
                if (!network.containsNode(node)) continue;
                View nView = view.getNodeView(node);
                if (node.getNetworkPointer() == null || !this.cyGroupManager.isGroup(node, network) || this.cyGroupSettings.getUseNestedNetworks(this.cyGroupManager.getGroup(node, network))) continue;
                nView.setLockedValue(BasicVisualLexicon.NODE_NESTED_NETWORK_IMAGE_VISIBLE, (Object)Boolean.FALSE);
            }
            ViewUtils.applyStyle(nodeList, views, this.cyStyleManager);
            ViewUtils.applyStyle(group.getInternalEdgeList(), views, this.cyStyleManager);
            ViewUtils.applyStyle(group.getExternalEdgeList(), views, this.cyStyleManager);
        }
        view.updateView();
    }

    public void handleEvent(GroupAddedEvent e) {
        this.getServices();
        CyGroup group = e.getGroup();
        CyGroupSettingsManager.GroupViewType groupViewType = this.cyGroupSettings.getGroupViewType(group);
        try {
            if (groupViewType.equals((Object)CyGroupSettingsManager.GroupViewType.COMPOUND) || groupViewType.equals((Object)CyGroupSettingsManager.GroupViewType.SINGLENODE)) {
                Set networkSet = group.getNetworkSet();
                if (networkSet == null || networkSet.size() == 0) {
                    return;
                }
                for (CyNetwork network : networkSet) {
                    ((CyGroupImpl)group).setGroupNodeShown(network, true);
                    GroupCollapsedEvent ev = new GroupCollapsedEvent(group, network, false);
                    this.handleEvent(ev);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handleEvent(GroupAboutToBeDestroyedEvent e) {
        this.getServices();
        CyGroup group = e.getGroup();
        CyGroupSettingsManager.GroupViewType groupViewType = this.cyGroupSettings.getGroupViewType(group);
        if (groupViewType.equals((Object)CyGroupSettingsManager.GroupViewType.COMPOUND)) {
            this.removeCompoundNode(group);
            return;
        }
        if (this.cyGroupSettings.getUseNestedNetworks(group)) {
            for (CyNetwork net : group.getNetworkSet()) {
                group.expand(net);
            }
            CyNetwork nn = group.getGroupNetwork();
            if (this.cyNetworkViewManager.viewExists(nn)) {
                for (CyNetworkView v : this.cyNetworkViewManager.getNetworkViews(nn)) {
                    this.cyNetworkViewManager.destroyNetworkView(v);
                }
            }
            this.cyNetworkManager.destroyNetwork(nn);
            group.getGroupNode().setNetworkPointer(null);
        }
    }

    public void handleEvent(SessionLoadedEvent e) {
        this.getServices();
        try {
            for (CyNetworkView networkView : e.getLoadedSession().getNetworkViews()) {
                CyNetwork network = (CyNetwork)networkView.getModel();
                for (CyGroup group : this.cyGroupManager.getGroupSet(network)) {
                    CyGroupSettingsManager.GroupViewType groupViewType = this.cyGroupSettings.getGroupViewType(group);
                    if (!groupViewType.equals((Object)CyGroupSettingsManager.GroupViewType.COMPOUND) && !groupViewType.equals((Object)CyGroupSettingsManager.GroupViewType.SINGLENODE)) continue;
                    boolean haveChildren = true;
                    for (CyNode node : group.getNodeList()) {
                        if (network.containsNode(node)) continue;
                        haveChildren = false;
                        break;
                    }
                    if (!haveChildren || !network.containsNode(group.getGroupNode())) continue;
                    ((CyGroupImpl)group).setCollapsed(network, false);
                    ((CyGroupImpl)group).setGroupNodeShown(network, true);
                    try {
                        this.activateCompoundNode(group, networkView);
                    }
                    catch (Exception rtree) {
                        rtree.printStackTrace();
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void styleGroupNode(CyGroup group, CyNetworkView view, Collection<CyNetworkView> views) {
        View nView = view.getNodeView(group.getGroupNode());
        double opacity = this.cyGroupSettings.getGroupNodeOpacity(group);
        if (opacity != 100.0) {
            nView.setVisualProperty(BasicVisualLexicon.NODE_TRANSPARENCY, (Object)((int)(opacity * 255.0 / 100.0)));
        }
        ViewUtils.applyStyle(Collections.singleton((CyNode)nView.getModel()), views, this.cyStyleManager);
        ViewUtils.applyStyle(((CyNetwork)view.getModel()).getAdjacentEdgeList(group.getGroupNode(), CyEdge.Type.ANY), views, this.cyStyleManager);
    }

    private void activateCompoundNode(CyGroup group, CyNetworkView view) {
        ViewUtils.styleCompoundNode(group, view, this.cyGroupManager, this.cyStyleManager, this.cyGroupSettings.getGroupViewType(group));
        ViewUtils.applyStyle(group.getNodeList(), Collections.singleton(view), this.cyStyleManager);
        ViewUtils.applyStyle(group.getInternalEdgeList(), Collections.singleton(view), this.cyStyleManager);
        ViewUtils.applyStyle(group.getExternalEdgeList(), Collections.singleton(view), this.cyStyleManager);
        this.nodeChangeListener.addGroup(group, view);
    }

    private void deActivateCompoundNode(CyGroup group, CyNetworkView view) {
        this.nodeChangeListener.removeGroup(group, view);
        ViewUtils.unStyleCompoundNode(group, view, this.cyStyleManager);
    }

    private void addMemberEdges(CyGroup group, CyNetwork network) {
        CyRootNetwork rootNetwork = ((CySubNetwork)network).getRootNetwork();
        CyNode groupNode = group.getGroupNode();
        ArrayList<CyEdge> newEdges = new ArrayList<CyEdge>();
        for (CyNode node : group.getNodeList()) {
            if (network.containsEdge(groupNode, node)) continue;
            CyEdge edge = network.addEdge(groupNode, node, true);
            CyRow edgeRow = network.getRow((CyIdentifiable)edge);
            CyRow edgeRootRow = rootNetwork.getRow((CyIdentifiable)edge, "SHARED_ATTRS");
            String name = this.getNodeName(groupNode, network) + " (member) " + this.getNodeName(node, network);
            edgeRow.set("name", (Object)name);
            edgeRootRow.set("shared name", (Object)name);
            edgeRow.set("interaction", (Object)"member");
            edgeRootRow.set("shared interaction", (Object)"member");
            newEdges.add(edge);
        }
        if (newEdges.size() > 0) {
            group.addEdges(newEdges);
        }
    }

    private void removeCompoundNode(CyGroup group) {
        for (CyNetwork network : group.getNetworkSet()) {
            Collection views = this.cyNetworkViewManager.getNetworkViews(network);
            CyNetworkView view = null;
            if (views.size() == 0) continue;
            for (CyNetworkView v : views) {
                if (!v.getRendererId().equals("org.cytoscape.ding")) continue;
                view = v;
            }
            if (view == null) continue;
            ViewUtils.unStyleCompoundNode(group, view, this.cyStyleManager);
            this.nodeChangeListener.removeGroup(group, view);
        }
    }

    private String getNodeName(CyNode node, CyNetwork network) {
        return (String)network.getRow((CyIdentifiable)node).get("name", String.class);
    }

    private void getServices() {
        if (this.cyNetworkManager == null) {
            this.cyNetworkManager = this.cyGroupManager.getService(CyNetworkManager.class);
        }
        if (this.cyNetworkViewManager == null) {
            this.cyNetworkViewManager = this.cyGroupManager.getService(CyNetworkViewManager.class);
        }
        if (this.cyNetworkViewFactory == null) {
            this.cyNetworkViewFactory = this.cyGroupManager.getService(CyNetworkViewFactory.class);
        }
        if (this.cyStyleManager == null) {
            this.cyStyleManager = this.cyGroupManager.getService(VisualMappingManager.class);
        }
    }
}

