/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.data.aggregators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.data.Aggregator;
import org.cytoscape.group.data.AttributeHandlingType;
import org.cytoscape.group.data.CyGroupAggregationManager;
import org.cytoscape.group.internal.data.aggregators.AbstractAggregator;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;

public class ListAggregator
extends AbstractAggregator {
    static AttributeHandlingType[] supportedTypes = new AttributeHandlingType[]{AttributeHandlingType.NONE, AttributeHandlingType.CONCAT, AttributeHandlingType.UNIQUE};
    static boolean registered = false;

    public static void registerAggregators(CyGroupAggregationManager mgr) {
        if (!registered) {
            for (AttributeHandlingType t : supportedTypes) {
                mgr.addAggregator((Aggregator)new ListAggregator(t));
            }
        }
        registered = true;
    }

    public ListAggregator(AttributeHandlingType type) {
        this.type = type;
    }

    public Class getSupportedType() {
        return List.class;
    }

    public List aggregate(CyTable table, CyGroup group, CyColumn column) {
        Class listType = column.getListElementType();
        ArrayList agg = new ArrayList();
        HashSet aggset = new HashSet();
        ArrayList aggregation = null;
        if (this.type == AttributeHandlingType.NONE) {
            return null;
        }
        for (CyNode node : group.getNodeList()) {
            List list = table.getRow((Object)node.getSUID()).getList(column.getName(), listType);
            if (list == null) continue;
            for (Object value : list) {
                switch (this.type) {
                    case CONCAT: {
                        agg.add(value);
                        break;
                    }
                    case UNIQUE: {
                        aggset.add(value);
                    }
                }
            }
        }
        if (this.type == AttributeHandlingType.CONCAT) {
            aggregation = agg;
        } else if (this.type == AttributeHandlingType.UNIQUE) {
            aggregation = new ArrayList(aggset);
        }
        if (aggregation != null) {
            table.getRow((Object)group.getGroupNode().getSUID()).set(column.getName(), aggregation);
        }
        return aggregation;
    }
}

