/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.data.aggregators;

import java.util.ArrayList;
import java.util.Arrays;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.data.Aggregator;
import org.cytoscape.group.data.AttributeHandlingType;
import org.cytoscape.group.data.CyGroupAggregationManager;
import org.cytoscape.group.internal.data.aggregators.AbstractAggregator;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;

public class IntegerAggregator
extends AbstractAggregator {
    static AttributeHandlingType[] supportedTypes = new AttributeHandlingType[]{AttributeHandlingType.NONE, AttributeHandlingType.AVG, AttributeHandlingType.MIN, AttributeHandlingType.MAX, AttributeHandlingType.MEDIAN, AttributeHandlingType.SUM};
    static boolean registered = false;

    public static void registerAggregators(CyGroupAggregationManager mgr) {
        if (!registered) {
            for (AttributeHandlingType t : supportedTypes) {
                mgr.addAggregator((Aggregator)new IntegerAggregator(t));
            }
        }
        registered = true;
    }

    public IntegerAggregator(AttributeHandlingType type) {
        this.type = type;
    }

    public Class getSupportedType() {
        return Integer.class;
    }

    public Integer aggregate(CyTable table, CyGroup group, CyColumn column) {
        double aggregation = 0.0;
        int count = 0;
        ArrayList<Integer> valueList = null;
        if (this.type == AttributeHandlingType.NONE) {
            return null;
        }
        switch (this.type) {
            case MAX: {
                aggregation = -2.147483648E9;
                break;
            }
            case MIN: {
                aggregation = 2.147483647E9;
                break;
            }
            case MEDIAN: {
                valueList = new ArrayList<Integer>();
            }
        }
        for (CyNode node : group.getNodeList()) {
            Integer v = (Integer)table.getRow((Object)node.getSUID()).get(column.getName(), Integer.class);
            if (v == null) continue;
            double value = v.doubleValue();
            ++count;
            switch (this.type) {
                case MAX: {
                    if (!(aggregation < value)) break;
                    aggregation = value;
                    break;
                }
                case MIN: {
                    if (!(aggregation > value)) break;
                    aggregation = value;
                    break;
                }
                case SUM: {
                    aggregation += value;
                    break;
                }
                case AVG: {
                    aggregation += value;
                    break;
                }
                case MEDIAN: {
                    valueList.add((int)value);
                }
            }
        }
        if (this.type == AttributeHandlingType.MEDIAN) {
            Object[] vArray = new Integer[valueList.size()];
            vArray = valueList.toArray(vArray);
            Arrays.sort(vArray);
            aggregation = vArray.length % 2 == 1 ? (double)((Integer)vArray[(vArray.length - 1) / 2]).intValue() : (double)(((Integer)vArray[vArray.length / 2 - 1] + (Integer)vArray[vArray.length / 2]) / 2);
        } else if (this.type == AttributeHandlingType.AVG) {
            aggregation /= (double)count;
        }
        Integer v = new Integer((int)aggregation);
        table.getRow((Object)group.getGroupNode().getSUID()).set(column.getName(), (Object)v);
        return v;
    }
}

