/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.data;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupSettingsManager;
import org.cytoscape.group.data.Aggregator;
import org.cytoscape.group.data.AttributeHandlingType;
import org.cytoscape.group.events.GroupAddedEvent;
import org.cytoscape.group.events.GroupAddedListener;
import org.cytoscape.group.internal.CyGroupImpl;
import org.cytoscape.group.internal.CyGroupManagerImpl;
import org.cytoscape.group.internal.data.CyGroupAggregationManagerImpl;
import org.cytoscape.group.internal.data.GroupViewTypeChangedEvent;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.NetworkAddedEvent;
import org.cytoscape.model.events.NetworkAddedListener;
import org.cytoscape.property.AbstractConfigDirPropsReader;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.PropertyUpdatedEvent;
import org.cytoscape.property.PropertyUpdatedListener;
import org.cytoscape.service.util.CyServiceRegistrar;

public class CyGroupSettingsImpl
implements GroupAddedListener,
NetworkAddedListener,
PropertyUpdatedListener,
CyGroupSettingsManager {
    final CyGroupManagerImpl cyGroupManager;
    final CyGroupAggregationManagerImpl cyAggManager;
    final CyServiceRegistrar cyServiceRegistrar;
    final CyApplicationManager appMgr;
    final CyEventHelper eventHelper;
    CyProperty<Properties> groupSettingsProperties;
    public static final String AGGREGATION_SETTINGS = "__AggregationSettings";
    public static final String AGGREGATION_OVERRIDE_SETTINGS = "__AggregationOverrideSettings";
    public static final String VIEW_SETTINGS = "__ViewSettings";
    static final String PROPERTY_NAME = "groupSettings";
    static final String DOUBLE_CLICK_ACTION = "doubleClickAction";
    static final String GROUP_VIEW_TYPE = "groupViewType";
    static final String GROUP_NODE_OPACITY = "groupNodeOpacity";
    static final String USE_NESTED_NETWORKS = "useNestedNetworks";
    static final String AGG_ENABLED = "aggregationEnabled";
    static final String DEFAULT_INT_AGGREGATION = "defaultIntegerAggregation";
    static final String DEFAULT_LONG_AGGREGATION = "defaultLongAggregation";
    static final String DEFAULT_DOUBLE_AGGREGATION = "defaultDoubleAggregation";
    static final String DEFAULT_STRING_AGGREGATION = "defaultStringAggregation";
    static final String DEFAULT_BOOLEAN_AGGREGATION = "defaultBooleanAggregation";
    static final String DEFAULT_STRING_LIST_AGGREGATION = "defaultStringListAggregation";
    static final String DEFAULT_INTEGER_LIST_AGGREGATION = "defaultIntegerListAggregation";
    static final String DEFAULT_LONG_LIST_AGGREGATION = "defaultLongListAggregation";
    static final String DEFAULT_DOUBLE_LIST_AGGREGATION = "defaultDoubleListAggregation";
    static final String OVERRIDE_AGGREGATION = "overrideColumnAggregations";
    Map<Class<?>, Aggregator<?>> allGroupDefaultMap;
    Map<Class<?>, Aggregator<?>> allGroupListDefaultMap;
    Map<CyColumn, Aggregator<?>> allGroupOverrideMap;
    Map<String, String> allGroupOverridePropertyMap;
    Map<CyGroup, GroupSpecificMaps> groupMap;
    Map<CyGroup, CyGroupSettingsManager.DoubleClickAction> groupActionMap;
    Map<CyGroup, CyGroupSettingsManager.GroupViewType> groupViewTypeMap;
    Map<CyGroup, Boolean> enableMap;
    Map<CyGroup, Boolean> nestedNetworkMap;
    Map<CyGroup, Double> opacityMap;
    CyGroupSettingsManager.DoubleClickAction action = CyGroupSettingsManager.DoubleClickAction.EXPANDCONTRACT;
    boolean enableAttributeAggregation = false;
    boolean useNestedNetworks = false;
    double groupNodeOpacity = 100.0;
    CyGroupSettingsManager.GroupViewType groupViewType = CyGroupSettingsManager.GroupViewType.NONE;
    boolean loadingNewGroup = false;
    private final Object lock = new Object();

    public CyGroupSettingsImpl(CyGroupManagerImpl mgr, CyGroupAggregationManagerImpl aggMgr, CyServiceRegistrar registrar) {
        this.cyGroupManager = mgr;
        this.cyAggManager = aggMgr;
        this.cyServiceRegistrar = registrar;
        this.appMgr = this.cyGroupManager.getService(CyApplicationManager.class);
        this.eventHelper = this.cyGroupManager.getService(CyEventHelper.class);
        this.allGroupDefaultMap = new HashMap();
        this.allGroupListDefaultMap = new HashMap();
        this.allGroupOverrideMap = new HashMap();
        this.allGroupOverridePropertyMap = new HashMap<String, String>();
        this.groupMap = new HashMap<CyGroup, GroupSpecificMaps>();
        this.groupActionMap = new ConcurrentHashMap<CyGroup, CyGroupSettingsManager.DoubleClickAction>(16, 0.75f, 2);
        this.groupViewTypeMap = new ConcurrentHashMap<CyGroup, CyGroupSettingsManager.GroupViewType>(16, 0.75f, 2);
        this.enableMap = new ConcurrentHashMap<CyGroup, Boolean>(16, 0.75f, 2);
        this.nestedNetworkMap = new ConcurrentHashMap<CyGroup, Boolean>(16, 0.75f, 2);
        this.opacityMap = new ConcurrentHashMap<CyGroup, Double>(16, 0.75f, 2);
        this.groupSettingsProperties = new PropsReader();
        Properties serviceProperties = new Properties();
        serviceProperties.setProperty("cyPropertyName", "groupSettings.props");
        this.cyServiceRegistrar.registerService(this.groupSettingsProperties, CyProperty.class, serviceProperties);
        this.loadProperties();
    }

    public CyGroupSettingsManager.DoubleClickAction getDoubleClickAction() {
        return this.action;
    }

    public CyGroupSettingsManager.DoubleClickAction getDoubleClickAction(CyGroup group) {
        if (this.groupActionMap.containsKey(group)) {
            return this.groupActionMap.get(group);
        }
        return this.action;
    }

    public void setDoubleClickAction(CyGroupSettingsManager.DoubleClickAction action) {
        this.action = action;
        this.updateProperties();
    }

    public void setDoubleClickAction(CyGroup group, CyGroupSettingsManager.DoubleClickAction action) {
        if (group != null) {
            this.groupActionMap.put(group, action);
            this.updateSettingsInTable(group);
        } else {
            this.action = action;
            this.updateProperties();
        }
    }

    public CyGroupSettingsManager.GroupViewType getGroupViewType() {
        return this.groupViewType;
    }

    public CyGroupSettingsManager.GroupViewType getGroupViewType(CyGroup group) {
        if (this.groupViewTypeMap.containsKey(group)) {
            return this.groupViewTypeMap.get(group);
        }
        return this.groupViewType;
    }

    public void setGroupViewType(CyGroupSettingsManager.GroupViewType groupViewType) {
        this.groupViewType = groupViewType;
        this.updateProperties();
    }

    public void setGroupViewType(CyGroup group, CyGroupSettingsManager.GroupViewType groupViewType) {
        if (group != null) {
            CyGroupSettingsManager.GroupViewType oldType = this.getGroupViewType(group);
            this.groupViewTypeMap.put(group, groupViewType);
            this.updateSettingsInTable(group);
            if (!this.loadingNewGroup) {
                this.eventHelper.fireEvent((CyEvent)new GroupViewTypeChangedEvent(group, oldType, groupViewType));
            } else if (!oldType.equals((Object)CyGroupSettingsManager.GroupViewType.NONE) && groupViewType.equals((Object)CyGroupSettingsManager.GroupViewType.NONE)) {
                for (CyNetwork net : group.getNetworkSet()) {
                    if (net.equals(group.getRootNetwork())) continue;
                    ((CyGroupImpl)group).setGroupNodeShown(net, false);
                }
            }
        } else {
            this.groupViewType = groupViewType;
            this.updateProperties();
        }
    }

    public boolean getUseNestedNetworks() {
        return this.useNestedNetworks;
    }

    public boolean getUseNestedNetworks(CyGroup group) {
        return this.get(this.nestedNetworkMap, group, this.useNestedNetworks);
    }

    public void setUseNestedNetworks(boolean useNN) {
        this.useNestedNetworks = useNN;
        this.updateProperties();
    }

    public void setUseNestedNetworks(CyGroup group, boolean useNN) {
        if (group != null) {
            this.nestedNetworkMap.put(group, useNN);
            this.updateSettingsInTable(group);
        } else {
            this.useNestedNetworks = useNN;
            this.updateProperties();
        }
    }

    public double getGroupNodeOpacity() {
        return this.groupNodeOpacity;
    }

    public double getGroupNodeOpacity(CyGroup group) {
        return this.get(this.opacityMap, group, this.groupNodeOpacity);
    }

    public void setGroupNodeOpacity(double opacity) {
        this.groupNodeOpacity = opacity;
        this.updateProperties();
    }

    public void setGroupNodeOpacity(CyGroup group, double opacity) {
        if (group != null) {
            this.opacityMap.put(group, opacity);
        } else {
            this.groupNodeOpacity = opacity;
            this.updateProperties();
        }
    }

    private <K, V> V get(Map<K, V> map, K key, V defaultValue) {
        V value = map.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregator<?> getAggregator(CyGroup group, CyColumn column) {
        Class type = column.getType();
        Object object = this.lock;
        synchronized (object) {
            Aggregator<?> aggregator;
            this.getOverrideAggregation(column);
            Map<CyColumn, Aggregator<?>> overrideMap = this.allGroupOverrideMap;
            Map<Class<?>, Aggregator<?>> defaultMap = this.allGroupDefaultMap;
            Map<Class<?>, Aggregator<?>> defaultListMap = this.allGroupListDefaultMap;
            GroupSpecificMaps groupSpecificMaps = this.groupMap.get(group);
            if (groupSpecificMaps != null) {
                defaultMap = groupSpecificMaps.getDefaults();
                defaultListMap = groupSpecificMaps.getListDefaults();
                overrideMap = groupSpecificMaps.getOverrides();
            }
            if ((aggregator = overrideMap.get(column)) != null) {
                return aggregator;
            }
            if (type.isAssignableFrom(List.class)) {
                return defaultListMap.get(column.getListElementType());
            }
            return defaultMap.get(column.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(GroupAddedEvent e) {
        Object object;
        CyGroup addedGroup = e.getGroup();
        HashMap defMap = new HashMap();
        HashMap defListMap = new HashMap();
        CyNetwork network = this.appMgr.getCurrentNetwork();
        if ((network == null || !addedGroup.isInNetwork(network)) && (object = addedGroup.getNetworkSet().iterator()).hasNext()) {
            CyNetwork net = (CyNetwork)object.next();
            network = net;
        }
        object = this.lock;
        synchronized (object) {
            for (Class clazz : this.allGroupDefaultMap.keySet()) {
                defMap.put(clazz, this.allGroupDefaultMap.get(clazz));
            }
            for (Class clazz : this.allGroupListDefaultMap.keySet()) {
                defListMap.put(clazz, this.allGroupListDefaultMap.get(clazz));
            }
            HashMap ovMap = new HashMap();
            for (CyColumn cKey : this.allGroupOverrideMap.keySet()) {
                ovMap.put(cKey, this.allGroupOverrideMap.get(cKey));
            }
            this.groupMap.put(addedGroup, new GroupSpecificMaps(defMap, defListMap, ovMap));
        }
        this.loadingNewGroup = true;
        try {
            this.loadSettingsFromTable(addedGroup, network);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.loadingNewGroup = false;
    }

    public void handleEvent(NetworkAddedEvent e) {
        CyNetwork net = e.getNetwork();
        Set<CyGroup> groupSet = this.cyGroupManager.getGroupSet(net);
        if (groupSet == null || groupSet.size() == 0) {
            return;
        }
        for (CyGroup group : groupSet) {
            this.loadSettingsFromTable(group, net);
        }
    }

    public void handleEvent(PropertyUpdatedEvent e) {
        if (e.getSource() != null && ((CyProperty)e.getSource()).getName().equals(PROPERTY_NAME)) {
            this.groupSettingsProperties = (CyProperty)e.getSource();
            this.loadProperties();
        }
    }

    public boolean getEnableAttributeAggregation() {
        return this.enableAttributeAggregation;
    }

    public void setEnableAttributeAggregation(boolean aggregate) {
        this.enableAttributeAggregation = aggregate;
        this.updateProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregator<?> getDefaultAggregation(Class<?> ovClass) {
        Object object = this.lock;
        synchronized (object) {
            if (ovClass.isAssignableFrom(List.class)) {
                return this.getDefaultListAggregation(String.class);
            }
            return this.get(this.allGroupDefaultMap, ovClass, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultAggregation(Class<?> ovClass, Aggregator<?> agg) {
        Object object = this.lock;
        synchronized (object) {
            this.allGroupDefaultMap.put(ovClass, agg);
        }
        this.updateProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregator<?> getDefaultListAggregation(Class<?> ovClass) {
        Object object = this.lock;
        synchronized (object) {
            return this.get(this.allGroupListDefaultMap, ovClass, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultListAggregation(Class<?> ovClass, Aggregator<?> agg) {
        Object object = this.lock;
        synchronized (object) {
            this.allGroupListDefaultMap.put(ovClass, agg);
        }
        this.updateProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregator<?> getOverrideAggregation(CyColumn column) {
        Object object = this.lock;
        synchronized (object) {
            if (this.allGroupOverrideMap.containsKey(column)) {
                return this.get(this.allGroupOverrideMap, column, null);
            }
            if (this.allGroupOverridePropertyMap.containsKey(column.getName())) {
                String aggrName = this.allGroupOverridePropertyMap.get(column.getName());
                Aggregator<?> aggr = column.getType().isAssignableFrom(List.class) ? this.cyAggManager.getListAggregator(column.getListElementType(), aggrName) : this.cyAggManager.getAggregator(column.getType(), aggrName);
                if (aggr != null) {
                    this.allGroupOverrideMap.put(column, aggr);
                }
                return aggr;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverrideAggregation(CyColumn column, Aggregator<?> agg) {
        Object object = this.lock;
        synchronized (object) {
            this.allGroupOverrideMap.put(column, agg);
        }
        this.updateProperties();
    }

    public boolean getEnableAttributeAggregation(CyGroup group) {
        return this.get(this.enableMap, group, this.enableAttributeAggregation);
    }

    public void setEnableAttributeAggregation(CyGroup group, boolean aggregate) {
        if (group != null) {
            this.enableMap.put(group, aggregate);
            this.updateSettingsInTable(group);
        } else {
            this.enableAttributeAggregation = aggregate;
            this.updateProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregator<?> getDefaultAggregation(CyGroup group, Class<?> ovClass) {
        Object object = this.lock;
        synchronized (object) {
            GroupSpecificMaps groupSpecificMaps = this.groupMap.get(group);
            if (groupSpecificMaps != null) {
                return groupSpecificMaps.getDefault(ovClass);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultAggregation(CyGroup group, Class<?> ovClass, Aggregator<?> agg) {
        Object object = this.lock;
        synchronized (object) {
            GroupSpecificMaps groupSpecificMaps = this.groupMap.get(group);
            if (groupSpecificMaps == null) {
                groupSpecificMaps = new GroupSpecificMaps();
                this.groupMap.put(group, groupSpecificMaps);
            }
            groupSpecificMaps.setDefault(ovClass, agg);
        }
        this.updateSettingsInTable(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregator<?> getDefaultListAggregation(CyGroup group, Class<?> ovClass) {
        Object object = this.lock;
        synchronized (object) {
            GroupSpecificMaps groupSpecificMaps = this.groupMap.get(group);
            if (groupSpecificMaps != null) {
                return groupSpecificMaps.getListDefault(ovClass);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultListAggregation(CyGroup group, Class<?> ovClass, Aggregator<?> agg) {
        Object object = this.lock;
        synchronized (object) {
            GroupSpecificMaps groupSpecificMaps = this.groupMap.get(group);
            if (groupSpecificMaps == null) {
                groupSpecificMaps = new GroupSpecificMaps();
                this.groupMap.put(group, groupSpecificMaps);
            }
            groupSpecificMaps.setListDefault(ovClass, agg);
        }
        this.updateSettingsInTable(group);
    }

    public void setDefaultAggregation(CyGroup group, Class<?> ovClass, String agg) {
        Aggregator<?> def = this.cyAggManager.getAggregator(ovClass, agg);
        if (def != null) {
            this.setDefaultAggregation(group, ovClass, def);
        }
    }

    public void setDefaultListAggregation(CyGroup group, Class<?> ovClass, String agg) {
        Aggregator<?> def = this.cyAggManager.getListAggregator(ovClass, agg);
        if (def != null) {
            this.setDefaultListAggregation(group, ovClass, def);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregator<?> getOverrideAggregation(CyGroup group, CyColumn column) {
        Object object = this.lock;
        synchronized (object) {
            GroupSpecificMaps groupSpecificMaps = this.groupMap.get(group);
            if (groupSpecificMaps != null) {
                return groupSpecificMaps.getOverride(column);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverrideAggregation(CyGroup group, CyColumn column, Aggregator<?> agg) {
        Object object = this.lock;
        synchronized (object) {
            GroupSpecificMaps groupSpecificMaps = this.groupMap.get(group);
            if (groupSpecificMaps == null) {
                groupSpecificMaps = new GroupSpecificMaps();
                this.groupMap.put(group, groupSpecificMaps);
            }
            groupSpecificMaps.setOverride(column, agg);
        }
        this.updateSettingsInTable(group);
    }

    public void updateProperties() {
        Properties p = (Properties)this.groupSettingsProperties.getProperties();
        this.setBooleanProperty(p, USE_NESTED_NETWORKS, this.useNestedNetworks);
        p.setProperty(DOUBLE_CLICK_ACTION, this.action.toString());
        p.setProperty(GROUP_VIEW_TYPE, this.groupViewType.toString());
        this.setBooleanProperty(p, AGG_ENABLED, this.enableAttributeAggregation);
        this.setAggregationProperty(p, DEFAULT_INT_AGGREGATION, Integer.class, null);
        this.setAggregationProperty(p, DEFAULT_LONG_AGGREGATION, Long.class, null);
        this.setAggregationProperty(p, DEFAULT_DOUBLE_AGGREGATION, Double.class, null);
        this.setAggregationProperty(p, DEFAULT_STRING_AGGREGATION, String.class, null);
        this.setAggregationProperty(p, DEFAULT_BOOLEAN_AGGREGATION, Boolean.class, null);
        this.setAggregationProperty(p, DEFAULT_STRING_LIST_AGGREGATION, List.class, String.class);
        this.setAggregationProperty(p, DEFAULT_INTEGER_LIST_AGGREGATION, List.class, Integer.class);
        this.setAggregationProperty(p, DEFAULT_LONG_LIST_AGGREGATION, List.class, Long.class);
        this.setAggregationProperty(p, DEFAULT_DOUBLE_LIST_AGGREGATION, List.class, Double.class);
        p.setProperty(OVERRIDE_AGGREGATION, this.encodeAggregationOverrides());
    }

    public void loadProperties() {
        Properties p = (Properties)this.groupSettingsProperties.getProperties();
        this.useNestedNetworks = this.getBooleanProperty(p, USE_NESTED_NETWORKS, this.useNestedNetworks);
        this.action = this.getDoubleClickProperty(p, DOUBLE_CLICK_ACTION, this.action);
        this.groupViewType = this.getGroupViewTypeProperty(p, GROUP_VIEW_TYPE, this.groupViewType);
        this.enableAttributeAggregation = this.getBooleanProperty(p, AGG_ENABLED, this.enableAttributeAggregation);
        this.getAggregationProperty(p, DEFAULT_INT_AGGREGATION, Integer.class, null, AttributeHandlingType.AVG);
        this.getAggregationProperty(p, DEFAULT_LONG_AGGREGATION, Long.class, null, AttributeHandlingType.NONE);
        this.getAggregationProperty(p, DEFAULT_DOUBLE_AGGREGATION, Double.class, null, AttributeHandlingType.AVG);
        this.getAggregationProperty(p, DEFAULT_STRING_AGGREGATION, String.class, null, AttributeHandlingType.CSV);
        this.getAggregationProperty(p, DEFAULT_BOOLEAN_AGGREGATION, Boolean.class, null, AttributeHandlingType.NONE);
        this.getAggregationProperty(p, DEFAULT_STRING_LIST_AGGREGATION, List.class, String.class, AttributeHandlingType.UNIQUE);
        this.getAggregationProperty(p, DEFAULT_INTEGER_LIST_AGGREGATION, List.class, Integer.class, AttributeHandlingType.AVG);
        this.getAggregationProperty(p, DEFAULT_LONG_LIST_AGGREGATION, List.class, Long.class, AttributeHandlingType.AVG);
        this.getAggregationProperty(p, DEFAULT_DOUBLE_LIST_AGGREGATION, List.class, Double.class, AttributeHandlingType.AVG);
        this.getOverrideAggregationProperty(p, OVERRIDE_AGGREGATION);
    }

    private void getOverrideAggregationProperty(Properties p, String key) {
        CyNetwork currentNetwork = this.appMgr.getCurrentNetwork();
        if (currentNetwork != null && p.containsKey(key)) {
            List<String[]> aggr = this.decodeAggregationOverrides(p.getProperty(key));
            for (String[] pair : aggr) {
                if (pair.length <= 1) continue;
                this.allGroupOverridePropertyMap.put(pair[0], pair[1]);
            }
        }
    }

    private boolean getBooleanProperty(Properties p, String key, boolean prop) {
        String v = p.getProperty(key, Boolean.valueOf(prop).toString());
        return Boolean.parseBoolean(v);
    }

    private void setBooleanProperty(Properties p, String key, boolean prop) {
        p.setProperty(key, Boolean.valueOf(prop).toString());
    }

    private CyGroupSettingsManager.DoubleClickAction getDoubleClickProperty(Properties p, String key, CyGroupSettingsManager.DoubleClickAction prop) {
        String v = p.getProperty(key, prop.toString());
        return this.convertDoubleClick(v);
    }

    private CyGroupSettingsManager.GroupViewType getGroupViewTypeProperty(Properties p, String key, CyGroupSettingsManager.GroupViewType prop) {
        String v = p.getProperty(key, prop.toString());
        return this.convertGroupViewType(v);
    }

    private Aggregator<?> getAggregationProperty(Properties p, String key, Class<?> c, Class<?> listClass, AttributeHandlingType defType) {
        Aggregator<?> def;
        String pValue = p.getProperty(key, defType.toString());
        if (c.isAssignableFrom(List.class)) {
            List<Aggregator<?>> aggs = this.cyAggManager.getListAggregators(listClass);
            def = this.cyAggManager.getListAggregator(listClass, pValue);
            if (def != null) {
                this.allGroupListDefaultMap.put(listClass, def);
            }
        } else {
            List<Aggregator<?>> aggs = this.cyAggManager.getAggregators(c);
            def = this.cyAggManager.getAggregator(c, pValue);
            if (def != null) {
                this.allGroupDefaultMap.put(c, def);
            }
        }
        return def;
    }

    private void setAggregationProperty(Properties p, String key, Class<?> clazz, Class<?> listClass) {
        Aggregator<?> a = null;
        if (clazz.isAssignableFrom(List.class)) {
            if (this.allGroupListDefaultMap.containsKey(listClass)) {
                a = this.allGroupListDefaultMap.get(listClass);
            }
        } else if (this.allGroupDefaultMap.containsKey(clazz)) {
            a = this.allGroupDefaultMap.get(clazz);
        }
        if (a != null) {
            p.setProperty(key, a.toString());
        } else {
            p.remove(key);
        }
    }

    public void updateSettingsInTable(CyGroup group) {
        Iterator iterator;
        CyNetwork network = this.appMgr.getCurrentNetwork();
        if ((network == null || !group.isInNetwork(network)) && (iterator = group.getNetworkSet().iterator()).hasNext()) {
            CyNetwork net;
            network = net = (CyNetwork)iterator.next();
        }
        ArrayList<String> viewSettings = new ArrayList<String>();
        this.createColumnIfNeeded(network, group.getGroupNode(), VIEW_SETTINGS, List.class, String.class);
        this.addViewSetting(viewSettings, DOUBLE_CLICK_ACTION, this.getDoubleClickAction(group).toString());
        this.addViewSetting(viewSettings, USE_NESTED_NETWORKS, "" + this.getUseNestedNetworks(group));
        this.addViewSetting(viewSettings, GROUP_VIEW_TYPE, "" + this.getGroupViewType(group));
        this.addViewSetting(viewSettings, GROUP_NODE_OPACITY, "" + this.getGroupNodeOpacity(group));
        network.getRow((CyIdentifiable)group.getGroupNode()).set(VIEW_SETTINGS, viewSettings);
        this.createColumnIfNeeded(network, group.getGroupNode(), AGGREGATION_SETTINGS, List.class, String.class);
        ArrayList<String> aggrSettings = new ArrayList<String>();
        aggrSettings.add("aggregationEnabled=" + this.getEnableAttributeAggregation(group));
        this.addAggregationSetting(group, DEFAULT_INT_AGGREGATION, Integer.class, null, aggrSettings);
        this.addAggregationSetting(group, DEFAULT_LONG_AGGREGATION, Long.class, null, aggrSettings);
        this.addAggregationSetting(group, DEFAULT_DOUBLE_AGGREGATION, Double.class, null, aggrSettings);
        this.addAggregationSetting(group, DEFAULT_STRING_AGGREGATION, String.class, null, aggrSettings);
        this.addAggregationSetting(group, DEFAULT_BOOLEAN_AGGREGATION, Boolean.class, null, aggrSettings);
        this.addAggregationSetting(group, DEFAULT_STRING_LIST_AGGREGATION, List.class, String.class, aggrSettings);
        this.addAggregationSetting(group, DEFAULT_INTEGER_LIST_AGGREGATION, List.class, Integer.class, aggrSettings);
        this.addAggregationSetting(group, DEFAULT_LONG_LIST_AGGREGATION, List.class, Long.class, aggrSettings);
        this.addAggregationSetting(group, DEFAULT_DOUBLE_LIST_AGGREGATION, List.class, Double.class, aggrSettings);
        network.getRow((CyIdentifiable)group.getGroupNode()).set(AGGREGATION_SETTINGS, aggrSettings);
        if (this.groupMap.containsKey(group)) {
            this.createColumnIfNeeded(network, group.getGroupNode(), AGGREGATION_OVERRIDE_SETTINGS, List.class, String.class);
            ArrayList<CallSite> aggrOverrideSettings = new ArrayList<CallSite>();
            GroupSpecificMaps gsm = this.groupMap.get(group);
            Map<CyColumn, Aggregator<?>> overrides = this.groupMap.get(group).getOverrides();
            if (overrides == null || overrides.size() == 0) {
                return;
            }
            for (CyColumn column : overrides.keySet()) {
                aggrOverrideSettings.add((CallSite)((Object)(column.getName() + "=" + overrides.get(column).toString())));
            }
            network.getRow((CyIdentifiable)group.getGroupNode()).set(AGGREGATION_OVERRIDE_SETTINGS, aggrOverrideSettings);
        }
    }

    void addAggregationSetting(CyGroup group, String attribute, Class<?> clazz, Class<?> listClass, List<String> settings) {
        Aggregator<?> agg = null;
        agg = clazz.isAssignableFrom(List.class) ? this.getDefaultListAggregation(group, listClass) : this.getDefaultAggregation(group, clazz);
        if (agg == null) {
            return;
        }
        settings.add(attribute + "=" + agg.toString());
    }

    void addViewSetting(List<String> settings, String attribute, String value) {
        settings.add(attribute + "=" + value);
    }

    public boolean loadSettingsFromTable(CyGroup group, CyNetwork network) {
        List aggrOverrideSettings;
        List aggrSettings;
        CyTable table = network.getTable(CyNode.class, "USER");
        if (table.getColumn(VIEW_SETTINGS) == null) {
            return false;
        }
        Long suid = group.getGroupNode().getSUID();
        List viewSettings = table.getRow((Object)suid).getList(VIEW_SETTINGS, String.class);
        if (viewSettings != null && viewSettings.size() > 0) {
            for (Object setting : viewSettings) {
                this.updateSetting(group, (String)setting);
            }
        }
        if ((aggrSettings = table.getRow((Object)suid).getList(AGGREGATION_SETTINGS, String.class)) != null && aggrSettings.size() > 0) {
            for (String setting : aggrSettings) {
                this.updateAggrSetting(group, setting);
            }
        }
        if ((aggrOverrideSettings = table.getRow((Object)suid).getList(AGGREGATION_OVERRIDE_SETTINGS, String.class)) != null && aggrOverrideSettings.size() > 0) {
            for (String setting : aggrSettings) {
                this.updateAggrOverrideSetting(group, setting);
            }
        }
        return true;
    }

    void updateSetting(CyGroup group, String setting) {
        String[] pair = setting.split("=");
        if (pair.length != 2) {
            return;
        }
        if (pair[0].equals(DOUBLE_CLICK_ACTION)) {
            CyGroupSettingsManager.DoubleClickAction action = this.convertDoubleClick(pair[1]);
            if (action != null) {
                this.setDoubleClickAction(group, action);
            }
        } else if (pair[0].equals(GROUP_VIEW_TYPE)) {
            CyGroupSettingsManager.GroupViewType type = this.convertGroupViewType(pair[1]);
            if (type != null) {
                this.setGroupViewType(group, type);
            }
        } else if (pair[0].equals(USE_NESTED_NETWORKS)) {
            this.setUseNestedNetworks(group, Boolean.parseBoolean(pair[1]));
        } else if (pair[0].equals(GROUP_NODE_OPACITY)) {
            this.setGroupNodeOpacity(group, Double.parseDouble(pair[1]));
        }
    }

    void updateAggrSetting(CyGroup group, String setting) {
        String[] pair = setting.split("=");
        if (AGG_ENABLED.equals(pair[0])) {
            this.setEnableAttributeAggregation(group, Boolean.parseBoolean(pair[1]));
        } else if (DEFAULT_INT_AGGREGATION.equals(pair[0])) {
            this.setDefaultAggregation(group, Integer.class, pair[1]);
        } else if (DEFAULT_LONG_AGGREGATION.equals(pair[0])) {
            this.setDefaultAggregation(group, Long.class, pair[1]);
        } else if (DEFAULT_DOUBLE_AGGREGATION.equals(pair[0])) {
            this.setDefaultAggregation(group, Double.class, pair[1]);
        } else if (DEFAULT_STRING_AGGREGATION.equals(pair[0])) {
            this.setDefaultAggregation(group, String.class, pair[1]);
        } else if (DEFAULT_STRING_LIST_AGGREGATION.equals(pair[0])) {
            this.setDefaultListAggregation(group, String.class, pair[1]);
        } else if (DEFAULT_INTEGER_LIST_AGGREGATION.equals(pair[0])) {
            this.setDefaultListAggregation(group, Integer.class, pair[1]);
        } else if (DEFAULT_LONG_LIST_AGGREGATION.equals(pair[0])) {
            this.setDefaultListAggregation(group, Long.class, pair[1]);
        } else if (DEFAULT_DOUBLE_LIST_AGGREGATION.equals(pair[0])) {
            this.setDefaultListAggregation(group, Double.class, pair[1]);
        } else if (DEFAULT_BOOLEAN_AGGREGATION.equals(pair[0])) {
            this.setDefaultAggregation(group, Boolean.class, pair[1]);
        }
    }

    void updateAggrOverrideSetting(CyGroup group, String setting) {
        String[] pair = setting.split("=");
        CyNetwork currentNetwork = this.appMgr.getCurrentNetwork();
        if (currentNetwork == null) {
            return;
        }
        CyColumn column = currentNetwork.getDefaultNodeTable().getColumn(pair[0]);
        if (column == null) {
            return;
        }
        Aggregator<?> def = this.cyAggManager.getAggregator(column.getType(), pair[1]);
        if (def == null) {
            return;
        }
        this.setOverrideAggregation(group, column, def);
    }

    public String encodeAggregationOverrides() {
        Object str = "";
        for (CyColumn column : this.allGroupOverrideMap.keySet()) {
            if (((String)str).length() == 0) {
                str = column.getName() + "=" + this.allGroupOverrideMap.get(column).toString();
                continue;
            }
            str = (String)str + "\t" + column.getName() + "=" + this.allGroupOverrideMap.get(column).toString();
        }
        return str;
    }

    public List<String[]> decodeAggregationOverrides(String overrides) {
        ArrayList<String[]> results = new ArrayList<String[]>();
        for (String override : overrides.split("\t")) {
            String[] pair = override.split("=");
            results.add(pair);
        }
        return results;
    }

    public void createColumnIfNeeded(CyNetwork network, CyNode node, String column, Class<?> clazz, Class<?> elementClazz) {
        CyTable nodeTable = network.getTable(CyNode.class, "USER");
        if (nodeTable.getColumn(column) == null) {
            if (clazz.isAssignableFrom(List.class)) {
                nodeTable.createListColumn(column, elementClazz, false);
            } else {
                nodeTable.createColumn(column, clazz, false);
            }
        }
    }

    private CyGroupSettingsManager.DoubleClickAction convertDoubleClick(String v) {
        for (CyGroupSettingsManager.DoubleClickAction action : CyGroupSettingsManager.DoubleClickAction.values()) {
            if (!action.toString().equals(v)) continue;
            return action;
        }
        return null;
    }

    private CyGroupSettingsManager.GroupViewType convertGroupViewType(String v) {
        for (CyGroupSettingsManager.GroupViewType type : CyGroupSettingsManager.GroupViewType.values()) {
            if (!type.toString().equals(v)) continue;
            return type;
        }
        return null;
    }

    class PropsReader
    extends AbstractConfigDirPropsReader {
        PropsReader() {
            super(CyGroupSettingsImpl.PROPERTY_NAME, "groupSettings.props", CyProperty.SavePolicy.SESSION_FILE_AND_CONFIG_DIR);
        }
    }

    class GroupSpecificMaps {
        Map<Class<?>, Aggregator<?>> defMap;
        Map<Class<?>, Aggregator<?>> defListMap;
        Map<CyColumn, Aggregator<?>> ovMap;

        GroupSpecificMaps() {
            this.defMap = null;
            this.defListMap = null;
            this.ovMap = null;
        }

        GroupSpecificMaps(Map<Class<?>, Aggregator<?>> defMap, Map<Class<?>, Aggregator<?>> defListMap, Map<CyColumn, Aggregator<?>> ovMap) {
            this.defMap = defMap;
            this.defListMap = defListMap;
            this.ovMap = ovMap;
        }

        void setDefault(Class<?> ovClass, Aggregator<?> agg) {
            if (this.defMap == null) {
                this.defMap = new HashMap();
            }
            this.defMap.put(ovClass, agg);
        }

        void setListDefault(Class<?> ovClass, Aggregator<?> agg) {
            if (this.defListMap == null) {
                this.defListMap = new HashMap();
            }
            this.defListMap.put(ovClass, agg);
        }

        void setOverride(CyColumn column, Aggregator<?> agg) {
            if (this.ovMap == null) {
                this.ovMap = new HashMap();
            }
            this.ovMap.put(column, agg);
        }

        Aggregator<?> getDefault(Class<?> c) {
            if (this.defMap != null && this.defMap.containsKey(c)) {
                return this.defMap.get(c);
            }
            return null;
        }

        Aggregator<?> getListDefault(Class<?> c) {
            if (this.defListMap != null && this.defListMap.containsKey(c)) {
                return this.defListMap.get(c);
            }
            return null;
        }

        Aggregator<?> getOverride(CyColumn c) {
            if (this.ovMap != null && this.ovMap.containsKey(c)) {
                return this.ovMap.get(c);
            }
            return null;
        }

        Map<Class<?>, Aggregator<?>> getDefaults() {
            return this.defMap;
        }

        Map<Class<?>, Aggregator<?>> getListDefaults() {
            return this.defListMap;
        }

        Map<CyColumn, Aggregator<?>> getOverrides() {
            return this.ovMap;
        }
    }
}

