/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.data;

import org.cytoscape.group.CyGroup;
import org.cytoscape.group.data.CyGroupAggregationManager;
import org.cytoscape.group.internal.CyGroupManagerImpl;
import org.cytoscape.group.internal.data.CyGroupSettingsImpl;
import org.cytoscape.group.internal.data.CyGroupSettingsTask;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.task.AbstractNodeViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class CyGroupNodeSettingsTaskFactory
extends AbstractNodeViewTaskFactory {
    final CyGroupAggregationManager cyAggManager;
    final CyGroupManagerImpl cyGroupManager;
    final CyGroupSettingsImpl settings;

    public CyGroupNodeSettingsTaskFactory(CyGroupManagerImpl groupManager, CyGroupAggregationManager aggMgr, CyGroupSettingsImpl settings) {
        this.settings = settings;
        this.cyAggManager = aggMgr;
        this.cyGroupManager = groupManager;
    }

    public boolean isReady(View<CyNode> nodeView, CyNetworkView netView) {
        CyNetwork network;
        CyNode node = (CyNode)nodeView.getModel();
        if (this.cyGroupManager.isGroup(node, network = (CyNetwork)netView.getModel())) {
            return true;
        }
        return this.cyGroupManager.getGroupsForNode(node, network) != null;
    }

    public CyGroupSettingsImpl getSettings() {
        return this.settings;
    }

    public TaskIterator createTaskIterator(View<CyNode> nodeView, CyNetworkView netView) {
        CyGroup group = this.cyGroupManager.getGroup((CyNode)nodeView.getModel(), (CyNetwork)netView.getModel());
        CyGroupSettingsTask task = new CyGroupSettingsTask(this.cyGroupManager, this.cyAggManager, this.settings, group);
        return new TaskIterator(new Task[]{task});
    }
}

