/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.data.Aggregator;
import org.cytoscape.group.data.AttributeHandlingType;
import org.cytoscape.group.data.CyGroupAggregationManager;
import org.cytoscape.group.internal.CyGroupManagerImpl;
import org.cytoscape.group.internal.data.CyGroupSettingsImpl;
import org.cytoscape.group.internal.data.aggregators.NoneAggregator;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;

public class CyGroupAggregationSettings {
    final CyGroupAggregationManager cyAggManager;
    final CyGroupSettingsImpl settings;
    final CyGroupManagerImpl cyGroupMgr;
    final CyApplicationManager appMgr;
    final CyGroup group;
    CyNetwork currentNetwork = null;
    Map<CyColumn, Aggregator<?>> overrides;
    @Tunable(description="Enable attribute aggregation:", groups={"Attribute Aggregation Settings"}, gravity=10.0)
    public boolean enableAttributeAggregation = false;
    @Tunable(description="Integer column aggregation default:", groups={"Attribute Aggregation Settings", "Default Aggregation Settings"}, params="displayState=collapsed", dependsOn="enableAttributeAggregation=true", gravity=11.0)
    public ListSingleSelection<Aggregator<?>> integerDefault;
    @Tunable(description="Long column aggregation default:", groups={"Attribute Aggregation Settings", "Default Aggregation Settings"}, dependsOn="enableAttributeAggregation=true", gravity=12.0)
    public ListSingleSelection<Aggregator<?>> longDefault;
    @Tunable(description="Float column aggregation default:", groups={"Attribute Aggregation Settings", "Default Aggregation Settings"}, dependsOn="enableAttributeAggregation=true", gravity=13.0)
    public ListSingleSelection<Aggregator<?>> floatDefault;
    @Tunable(description="Double column aggregation default:", groups={"Attribute Aggregation Settings", "Default Aggregation Settings"}, dependsOn="enableAttributeAggregation=true", gravity=14.0)
    public ListSingleSelection<Aggregator<?>> doubleDefault;
    @Tunable(description="String column aggregation default:", groups={"Attribute Aggregation Settings", "Default Aggregation Settings"}, dependsOn="enableAttributeAggregation=true", gravity=15.0)
    public ListSingleSelection<Aggregator<?>> stringDefault;
    @Tunable(description="Boolean column aggregation default:", groups={"Attribute Aggregation Settings", "Default Aggregation Settings"}, dependsOn="enableAttributeAggregation=true", gravity=16.0)
    public ListSingleSelection<Aggregator<?>> booleanDefault;
    @Tunable(description="String List column aggregation default:", groups={"Attribute Aggregation Settings", "Default Aggregation Settings"}, dependsOn="enableAttributeAggregation=true", gravity=17.0)
    public ListSingleSelection<Aggregator<?>> stringListDefault;
    @Tunable(description="Integer List column aggregation default:", groups={"Attribute Aggregation Settings", "Default Aggregation Settings"}, dependsOn="enableAttributeAggregation=true", gravity=17.1)
    public ListSingleSelection<Aggregator<?>> integerListDefault;
    @Tunable(description="Long List column aggregation default:", groups={"Attribute Aggregation Settings", "Default Aggregation Settings"}, dependsOn="enableAttributeAggregation=true", gravity=17.2)
    public ListSingleSelection<Aggregator<?>> longListDefault;
    @Tunable(description="Float List column aggregation default:", groups={"Attribute Aggregation Settings", "Default Aggregation Settings"}, dependsOn="enableAttributeAggregation=true", gravity=17.3)
    public ListSingleSelection<Aggregator<?>> floatListDefault;
    @Tunable(description="Double List column aggregation default:", groups={"Attribute Aggregation Settings", "Default Aggregation Settings"}, dependsOn="enableAttributeAggregation=true", gravity=17.4)
    public ListSingleSelection<Aggregator<?>> doubleListDefault;
    public ListSingleSelection<String> attrSelection = new ListSingleSelection(Collections.singletonList("No attributes available"));
    private ListSingleSelection<Aggregator<?>> aggregationType = null;

    @Tunable(description="Attribute to override:", groups={"Attribute Aggregation Settings", "Aggregation Overrides"}, dependsOn="enableAttributeAggregation=true", params="displayState=collapsed", gravity=20.0)
    public ListSingleSelection<String> getAttrSelection() {
        ArrayList<String> attrList = new ArrayList<String>();
        this.currentNetwork = this.appMgr.getCurrentNetwork();
        if (this.currentNetwork != null) {
            for (CyColumn column : this.currentNetwork.getDefaultNodeTable().getColumns()) {
                if (column.getName().equals("SUID")) continue;
                attrList.add(column.getName());
            }
        } else {
            attrList.add("No attributes available");
        }
        this.attrSelection = new ListSingleSelection(attrList);
        return this.attrSelection;
    }

    public void setAttrSelection(ListSingleSelection<String> input) {
    }

    @Tunable(description="Attribute Type:", groups={"Attribute Aggregation Settings", "Aggregation Overrides"}, dependsOn="enableAttributeAggregation=true", listenForChange={"AttrSelection"}, gravity=21.0)
    public String getAttrType() {
        Aggregator<?> type;
        if (this.currentNetwork == null || this.attrSelection == null || this.attrSelection.getSelectedValue() == null || ((String)this.attrSelection.getSelectedValue()).length() == 0) {
            if (this.aggregationType != null) {
                this.aggregationType.setPossibleValues(this.cyAggManager.getAggregators(NoneAggregator.class));
            } else {
                this.aggregationType = new ListSingleSelection(this.cyAggManager.getAggregators(NoneAggregator.class));
            }
            return "-- No Network --";
        }
        String columnName = (String)this.attrSelection.getSelectedValue();
        CyTable nodeTable = this.currentNetwork.getDefaultNodeTable();
        CyColumn column = nodeTable.getColumn(columnName);
        if (column == null) {
            return "-- No Such Column -- ";
        }
        if (this.aggregationType != null) {
            if (column.getType().equals(List.class)) {
                this.aggregationType.setPossibleValues(this.cyAggManager.getListAggregators(column.getListElementType()));
            } else {
                this.aggregationType.setPossibleValues(this.cyAggManager.getAggregators(column.getType()));
            }
        } else {
            this.aggregationType = column.getType().equals(List.class) ? new ListSingleSelection(this.cyAggManager.getListAggregators(column.getListElementType())) : new ListSingleSelection(this.cyAggManager.getAggregators(column.getType()));
        }
        if (this.group == null) {
            type = this.settings.getOverrideAggregation(column);
            if (type != null) {
                this.aggregationType.setSelectedValue(type);
            }
        } else {
            type = this.settings.getOverrideAggregation(this.group, column);
            if (type != null) {
                this.aggregationType.setSelectedValue(type);
            }
        }
        Object t = column.getType().getSimpleName();
        if (column.getType().equals(List.class)) {
            t = (String)t + " of " + column.getListElementType().getSimpleName() + "s";
        }
        return t;
    }

    public void setAttrType(String t) {
    }

    @Tunable(description="Aggregation Type:", groups={"Attribute Aggregation Settings", "Aggregation Overrides"}, dependsOn="enableAttributeAggregation=true", listenForChange={"AttrSelection"}, gravity=22.0)
    public ListSingleSelection<Aggregator<?>> getAggregationType() {
        if (this.aggregationType == null) {
            this.aggregationType = new ListSingleSelection(this.cyAggManager.getAggregators(NoneAggregator.class));
        }
        return this.aggregationType;
    }

    public void setAggregationType(ListSingleSelection<Aggregator<?>> input) {
        if (this.currentNetwork == null || this.aggregationType == null || this.aggregationType.getSelectedValue() == null) {
            return;
        }
        String columnName = (String)this.attrSelection.getSelectedValue();
        CyTable nodeTable = this.currentNetwork.getDefaultNodeTable();
        CyColumn column = nodeTable.getColumn(columnName);
        Aggregator agg = (Aggregator)this.aggregationType.getSelectedValue();
        this.overrides.put(column, agg);
    }

    public CyGroupAggregationSettings(CyGroupManagerImpl cyGroupMgr, CyGroupAggregationManager cyAggManager, CyGroupSettingsImpl settings, CyGroup group) {
        this.cyGroupMgr = cyGroupMgr;
        this.cyAggManager = cyAggManager;
        this.settings = settings;
        this.group = group;
        this.appMgr = cyGroupMgr.getService(CyApplicationManager.class);
        this.overrides = new HashMap();
        this.enableAttributeAggregation = settings.getEnableAttributeAggregation();
        this.initializeDefaults();
    }

    public Map<CyColumn, Aggregator<?>> getOverrideMap() {
        return this.overrides;
    }

    public boolean getAttributeAggregationEnabled() {
        return this.enableAttributeAggregation;
    }

    public Aggregator<?> getDefaultAggregator(Class<?> c) {
        if (c.equals(Integer.class)) {
            return (Aggregator)this.integerDefault.getSelectedValue();
        }
        if (c.equals(Long.class)) {
            return (Aggregator)this.longDefault.getSelectedValue();
        }
        if (c.equals(Float.class)) {
            return (Aggregator)this.floatDefault.getSelectedValue();
        }
        if (c.equals(Double.class)) {
            return (Aggregator)this.doubleDefault.getSelectedValue();
        }
        if (c.equals(String.class)) {
            return (Aggregator)this.stringDefault.getSelectedValue();
        }
        if (c.equals(List.class)) {
            return this.getDefaultListAggregator(String.class);
        }
        if (c.equals(Boolean.class)) {
            return (Aggregator)this.booleanDefault.getSelectedValue();
        }
        return null;
    }

    public Aggregator<?> getDefaultListAggregator(Class<?> c) {
        if (c.equals(String.class)) {
            return (Aggregator)this.stringListDefault.getSelectedValue();
        }
        if (c.equals(Integer.class)) {
            return (Aggregator)this.integerListDefault.getSelectedValue();
        }
        if (c.equals(Long.class)) {
            return (Aggregator)this.longListDefault.getSelectedValue();
        }
        if (c.equals(Float.class)) {
            return (Aggregator)this.floatListDefault.getSelectedValue();
        }
        if (c.equals(Double.class)) {
            return (Aggregator)this.doubleListDefault.getSelectedValue();
        }
        return null;
    }

    private void initializeDefaults() {
        this.integerDefault = this.createDefaults(Integer.class, AttributeHandlingType.AVG);
        this.longDefault = this.createDefaults(Long.class, AttributeHandlingType.NONE);
        this.floatDefault = this.createDefaults(Float.class, AttributeHandlingType.AVG);
        this.doubleDefault = this.createDefaults(Double.class, AttributeHandlingType.AVG);
        this.stringDefault = this.createDefaults(String.class, AttributeHandlingType.CSV);
        this.booleanDefault = this.createDefaults(Boolean.class, AttributeHandlingType.NONE);
        this.stringListDefault = this.createListDefaults(String.class, AttributeHandlingType.UNIQUE);
        this.integerListDefault = this.createListDefaults(Integer.class, AttributeHandlingType.AVG);
        this.longListDefault = this.createListDefaults(Long.class, AttributeHandlingType.AVG);
        this.floatListDefault = this.createListDefaults(Float.class, AttributeHandlingType.AVG);
        this.doubleListDefault = this.createListDefaults(Double.class, AttributeHandlingType.AVG);
    }

    private ListSingleSelection<Aggregator<?>> createDefaults(Class<?> c, AttributeHandlingType type) {
        List aggs = this.cyAggManager.getAggregators(c);
        Aggregator def = null;
        for (Aggregator a : aggs) {
            if (!a.toString().equals(type.toString())) continue;
            def = a;
            break;
        }
        ListSingleSelection lss = new ListSingleSelection(aggs);
        if (def != null) {
            if (this.settings.getDefaultAggregation(def.getSupportedType()) == null) {
                this.settings.setDefaultAggregation(def.getSupportedType(), def);
                lss.setSelectedValue((Object)def);
            } else {
                lss.setSelectedValue(this.settings.getDefaultAggregation(def.getSupportedType()));
            }
        }
        return lss;
    }

    private ListSingleSelection<Aggregator<?>> createListDefaults(Class<?> c, AttributeHandlingType type) {
        List aggs = this.cyAggManager.getListAggregators(c);
        Aggregator def = null;
        for (Aggregator a : aggs) {
            if (!a.toString().equals(type.toString())) continue;
            def = a;
            break;
        }
        ListSingleSelection lss = new ListSingleSelection(aggs);
        if (def != null) {
            if (this.settings.getDefaultListAggregation(def.getSupportedListType()) == null) {
                this.settings.setDefaultListAggregation(def.getSupportedListType(), def);
                lss.setSelectedValue((Object)def);
            } else {
                lss.setSelectedValue(this.settings.getDefaultListAggregation(def.getSupportedListType()));
            }
        }
        return lss;
    }
}

