/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.group.data.Aggregator;
import org.cytoscape.group.data.CyGroupAggregationManager;
import org.cytoscape.group.internal.data.aggregators.BooleanAggregator;
import org.cytoscape.group.internal.data.aggregators.DoubleAggregator;
import org.cytoscape.group.internal.data.aggregators.DoubleListAggregator;
import org.cytoscape.group.internal.data.aggregators.IntegerAggregator;
import org.cytoscape.group.internal.data.aggregators.IntegerListAggregator;
import org.cytoscape.group.internal.data.aggregators.LongAggregator;
import org.cytoscape.group.internal.data.aggregators.LongListAggregator;
import org.cytoscape.group.internal.data.aggregators.NoneAggregator;
import org.cytoscape.group.internal.data.aggregators.StringAggregator;
import org.cytoscape.group.internal.data.aggregators.StringListAggregator;

public class CyGroupAggregationManagerImpl
implements CyGroupAggregationManager {
    CyGroupManager cyGroupManager;
    Map<Class<?>, List<Aggregator<?>>> aggMap = new HashMap();
    Map<Class<?>, List<Aggregator<?>>> aggListMap = new HashMap();
    private final Object lock = new Object();

    public CyGroupAggregationManagerImpl(CyGroupManager mgr) {
        this.cyGroupManager = mgr;
        IntegerAggregator.registerAggregators(this);
        LongAggregator.registerAggregators(this);
        DoubleAggregator.registerAggregators(this);
        StringAggregator.registerAggregators(this);
        BooleanAggregator.registerAggregators(this);
        NoneAggregator.registerAggregators(this);
        StringListAggregator.registerAggregators(this);
        IntegerListAggregator.registerAggregators(this);
        LongListAggregator.registerAggregators(this);
        DoubleListAggregator.registerAggregators(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAggregator(Aggregator<?> aggregator) {
        Class type = aggregator.getSupportedType();
        Map<Class<?>, List<Aggregator<?>>> map = this.aggMap;
        if (type.isAssignableFrom(List.class)) {
            type = aggregator.getSupportedListType();
            map = this.aggListMap;
        }
        List<Object> aggList = null;
        Object object = this.lock;
        synchronized (object) {
            if (map.containsKey(type)) {
                aggList = map.get(type);
            } else {
                aggList = new ArrayList();
                map.put(type, aggList);
            }
            aggList.add(aggregator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAggregator(Aggregator<?> aggregator) {
        Class type = aggregator.getSupportedType();
        Map<Class<?>, List<Aggregator<?>>> map = this.aggMap;
        if (type.isAssignableFrom(List.class)) {
            type = aggregator.getSupportedListType();
            map = this.aggListMap;
        }
        Object object = this.lock;
        synchronized (object) {
            if (map.containsKey(type)) {
                List<Aggregator<?>> aggList = map.get(type);
                aggList.remove(aggregator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Aggregator<?>> getAggregators(Class<?> type) {
        Object object = this.lock;
        synchronized (object) {
            if (this.aggMap.containsKey(type)) {
                return this.aggMap.get(type);
            }
            return new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Aggregator<?>> getListAggregators(Class<?> type) {
        Object object = this.lock;
        synchronized (object) {
            if (this.aggListMap.containsKey(type)) {
                return this.aggListMap.get(type);
            }
            return new ArrayList();
        }
    }

    public Aggregator<?> getAggregator(Class<?> type, String name) {
        for (Aggregator<?> agg : this.getAggregators(type)) {
            if (!agg.toString().equals(name)) continue;
            return agg;
        }
        return null;
    }

    public Aggregator<?> getListAggregator(Class<?> type, String name) {
        for (Aggregator<?> agg : this.getListAggregators(type)) {
            if (!agg.toString().equals(name)) continue;
            return agg;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Aggregator<?>> getAggregators() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList allAggs = new ArrayList();
            for (Class<?> c : this.aggMap.keySet()) {
                allAggs.addAll(this.getAggregators(c));
            }
            return allAggs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Aggregator<?>> getListAggregators() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList allAggs = new ArrayList();
            for (Class<?> c : this.aggListMap.keySet()) {
                allAggs.addAll(this.getAggregators(c));
            }
            return allAggs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<?>> getSupportedClasses() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList(this.aggMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<?>> getSupportedListClasses() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList(this.aggListMap.keySet());
        }
    }
}

