/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.internal.CyGroupManagerImpl;
import org.cytoscape.group.internal.LockedVisualPropertiesManager;
import org.cytoscape.group.internal.data.CyGroupSettingsImpl;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.session.CySession;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.session.events.SessionAboutToBeSavedEvent;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupIO
implements SessionAboutToBeSavedListener,
SessionAboutToBeLoadedListener,
SessionLoadedListener {
    private static final String NAMESPACE = "org.cytoscape.group";
    private static final String FILENAME = "lockedVisualProperties.json";
    private final CyGroupManagerImpl groupMgr;
    private final CyGroupSettingsImpl settingsMgr;
    private final LockedVisualPropertiesManager lvpMgr;
    private final ObjectMapper mapper;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public GroupIO(CyGroupManagerImpl groupMgr, LockedVisualPropertiesManager lvpMgr, CyGroupSettingsImpl settingsMgr) {
        this.groupMgr = groupMgr;
        this.settingsMgr = settingsMgr;
        this.lvpMgr = lvpMgr;
        this.mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(Map.class, (JsonSerializer)new LockedVisualPropertiesMapSerializer());
        this.mapper.registerModule((Module)module);
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public void handleEvent(SessionAboutToBeSavedEvent event) {
        CyNetworkManager netMgr = this.groupMgr.getService(CyNetworkManager.class);
        Set networkSet = netMgr.getNetworkSet();
        LinkedHashSet<CyGroup> allGroups = new LinkedHashSet<CyGroup>();
        for (CyNetwork net : networkSet) {
            Set<CyGroup> groupSet = this.groupMgr.getGroupSet(net);
            if (groupSet == null) continue;
            allGroups.addAll(groupSet);
        }
        if (allGroups.isEmpty()) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        try {
            File root = File.createTempFile(NAMESPACE, ".temp");
            root.delete();
            root.mkdir();
            root.deleteOnExit();
            File file = new File(root, FILENAME);
            this.writeLockedVisualPropertiesMap(file, allGroups);
            files.add(file);
            file.deleteOnExit();
            event.addAppFiles(NAMESPACE, files);
        }
        catch (Exception e) {
            logger.error("Unexpected error", (Throwable)e);
        }
    }

    public void handleEvent(SessionLoadedEvent event) {
        List files = (List)event.getLoadedSession().getAppFileListMap().get(NAMESPACE);
        if (files == null) {
            return;
        }
        CySession session = event.getLoadedSession();
        for (File file : files) {
            try {
                if (!file.getName().equals(FILENAME)) continue;
                Map<LockedVisualPropertiesManager.Key, Map<VisualProperty<?>, Object>> map = this.readLockedVisualPropertiesMap(file, session);
                this.lvpMgr.addAll(map);
            }
            catch (IOException e) {
                logger.error("Unexpected error", (Throwable)e);
            }
        }
        this.settingsMgr.loadProperties();
    }

    public void handleEvent(SessionAboutToBeLoadedEvent event) {
        this.lvpMgr.reset();
    }

    private void writeLockedVisualPropertiesMap(File file, Set<CyGroup> groups) throws JsonGenerationException, JsonMappingException, IOException {
        CyNetworkViewManager netViewMgr = this.groupMgr.getService(CyNetworkViewManager.class);
        HashSet<CyNode> grElements = new HashSet<CyNode>();
        for (CyGroup gr : groups) {
            HashSet<CyNetworkView> netViews = new HashSet<CyNetworkView>();
            Set networks = gr.getNetworkSet();
            for (CyNetwork cyNetwork : networks) {
                if (!netViewMgr.viewExists(cyNetwork)) continue;
                netViews.addAll(netViewMgr.getNetworkViews(cyNetwork));
            }
            if (netViews.isEmpty()) continue;
            grElements.add(gr.getGroupNode());
            grElements.addAll(gr.getRootNetwork().getAdjacentEdgeList(gr.getGroupNode(), CyEdge.Type.ANY));
            grElements.addAll(gr.getNodeList());
            grElements.addAll(gr.getExternalEdgeList());
            grElements.addAll(gr.getInternalEdgeList());
            for (CyIdentifiable cyIdentifiable : grElements) {
                this.lvpMgr.saveLockedValues(cyIdentifiable, netViews);
            }
        }
        Map<LockedVisualPropertiesManager.Key, Map<VisualProperty<?>, Object>> map = this.lvpMgr.getLockedVisualPropertiesMap();
        if (map != null) {
            this.mapper.writeValue(file, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<LockedVisualPropertiesManager.Key, Map<VisualProperty<?>, Object>> readLockedVisualPropertiesMap(File file, CySession session) throws JsonParseException, JsonMappingException, IOException {
        LinkedHashMap map = new LinkedHashMap();
        JsonFactory factory = this.mapper.getFactory();
        try (JsonParser parser = factory.createParser(file);){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                LinkedHashMap linkedHashMap = map;
                return linkedHashMap;
            }
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                CyIdentifiable element;
                if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
                CyNetworkView netView = null;
                Class elementType = null;
                long elementId = -1L;
                LinkedHashMap lockedValues = new LinkedHashMap();
                while (parser.nextToken() != JsonToken.END_OBJECT) {
                    if (parser.getCurrentToken() != JsonToken.FIELD_NAME) continue;
                    String fieldName = parser.getCurrentName();
                    JsonToken valueToken = parser.nextToken();
                    if ("networkView".equals(fieldName) && valueToken == JsonToken.VALUE_NUMBER_INT) {
                        long suid = parser.getLongValue();
                        netView = (CyNetworkView)session.getObject(Long.valueOf(suid), CyNetworkView.class);
                        continue;
                    }
                    if ("element".equals(fieldName) && valueToken == JsonToken.VALUE_NUMBER_INT) {
                        elementId = parser.getLongValue();
                        continue;
                    }
                    if ("elementType".equals(fieldName) && valueToken == JsonToken.VALUE_STRING) {
                        elementType = parser.getText().equalsIgnoreCase("CyNode") ? CyNode.class : CyEdge.class;
                        continue;
                    }
                    if (!"lockedValues".equals(fieldName) || valueToken != JsonToken.START_ARRAY) continue;
                    VisualLexicon lexicon = this.getVisualLexicon(netView);
                    this.parseLockedValues(parser, lockedValues, lexicon, elementType);
                }
                if (netView == null || elementId == -1L || elementType == null || (element = session.getObject(Long.valueOf(elementId), elementType)) == null || lockedValues.isEmpty()) continue;
                LockedVisualPropertiesManager.Key key = new LockedVisualPropertiesManager.Key(netView, element);
                map.put(key, lockedValues);
            }
        }
        return map;
    }

    private void parseLockedValues(JsonParser parser, Map<VisualProperty<?>, Object> lockedValues, VisualLexicon lexicon, Class<? extends CyIdentifiable> elementType) throws JsonParseException, IOException {
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
            VisualProperty vp = null;
            String stringValue = null;
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                if (parser.getCurrentToken() != JsonToken.FIELD_NAME) continue;
                String fieldName = parser.getCurrentName();
                JsonToken valueToken = parser.nextToken();
                if ("visualProperty".equals(fieldName) && valueToken == JsonToken.VALUE_STRING) {
                    String id = parser.getText();
                    vp = id != null ? lexicon.lookup(elementType, id) : null;
                    continue;
                }
                if (!"value".equals(fieldName) || valueToken != JsonToken.VALUE_STRING) continue;
                stringValue = parser.getText();
            }
            if (vp == null || stringValue == null) continue;
            Object value = vp.parseSerializableString(stringValue);
            lockedValues.put(vp, value);
        }
    }

    private VisualLexicon getVisualLexicon(CyNetworkView netView) {
        RenderingEngineManager rendererMgr = this.groupMgr.getService(RenderingEngineManager.class);
        Collection renderingEngines = rendererMgr.getRenderingEngines((View)netView);
        if (renderingEngines != null && !renderingEngines.isEmpty()) {
            return ((RenderingEngine)renderingEngines.iterator().next()).getVisualLexicon();
        }
        return rendererMgr.getDefaultVisualLexicon();
    }

    private class LockedVisualPropertiesMapSerializer
    extends JsonSerializer<Map> {
        private LockedVisualPropertiesMapSerializer() {
        }

        public void serialize(Map map, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartArray();
            for (Object mapKey : map.keySet()) {
                LockedVisualPropertiesManager.Key key;
                Map lockedValues;
                if (!(mapKey instanceof LockedVisualPropertiesManager.Key) || (lockedValues = (Map)map.get(key = (LockedVisualPropertiesManager.Key)mapKey)) == null || lockedValues.isEmpty()) continue;
                jgen.writeStartObject();
                jgen.writeNumberField("networkView", key.getNetworkView().getSUID().longValue());
                jgen.writeStringField("elementType", key.getElement() instanceof CyNode ? "CyNode" : "CyEdge");
                jgen.writeNumberField("element", key.getElement().getSUID().longValue());
                jgen.writeArrayFieldStart("lockedValues");
                for (Map.Entry entry : lockedValues.entrySet()) {
                    VisualProperty vp = (VisualProperty)entry.getKey();
                    jgen.writeStartObject();
                    jgen.writeStringField("visualProperty", vp.getIdString());
                    jgen.writeStringField("value", vp.toSerializableString(entry.getValue()));
                    jgen.writeEndObject();
                }
                jgen.writeEndArray();
                jgen.writeEndObject();
            }
            jgen.writeEndArray();
        }
    }
}

