/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.WindowEvent;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.cytoscape.cyChart.internal.charts.oneD.HistogramChartController;
import org.cytoscape.cyChart.internal.charts.oneD.HistogramFilterDialog;
import org.cytoscape.cyChart.internal.model.CyChartManager;
import org.cytoscape.service.util.CyServiceRegistrar;

public class SwingPanel
extends JPanel {
    protected JFXPanel jfxPanel;
    private CyChartManager manager;
    public static final String EVENT_TYPE_CLICK = "click";
    public static final String EVENT_TYPE_CONTEXT_MENU = "contextmenu";
    private String title = null;
    private CyServiceRegistrar registrar;
    final Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");

    public SwingPanel(CyChartManager mgr, HistogramFilterDialog parentDialog) {
        super(new BorderLayout());
        this.manager = mgr;
        this.registrar = this.manager.getRegistrar();
        this.setPreferredSize(new Dimension(600, 500));
        this.initComponents();
        Platform.setImplicitExit((boolean)false);
    }

    public String getTitle() {
        return this.title;
    }

    public String execute(String script) {
        String[] returnVal = new String[1];
        CountDownLatch doneLatch = new CountDownLatch(1);
        try {
            doneLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return returnVal[0];
    }

    private void initComponents() {
        this.jfxPanel = new JFXPanel();
        StackPane pane = new StackPane();
        pane.setPrefWidth(520.0);
        pane.setPrefHeight(500.0);
        try {
            HistogramChartController ctrl = new HistogramChartController(pane, this.registrar, this.manager);
            Scene scene = new Scene((Parent)pane);
            Platform.runLater(() -> {
                this.jfxPanel.setScene(scene);
                scene.getWindow().addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> ctrl.unregister());
            });
            this.add((Component)this.jfxPanel, "Center");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

