/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.model;

import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import org.cytoscape.cyChart.internal.view.Cursors;

public class RectangleUtil {
    static double SLOP = 8.0;

    public static void setRect(Rectangle r, Point2D a, Point2D b) {
        double x = Math.min(a.getX(), b.getX());
        double y = Math.min(a.getY(), b.getY());
        double width = Math.abs(a.getX() - b.getX());
        double height = Math.abs(a.getY() - b.getY());
        RectangleUtil.setRect(r, x, y, width, height);
    }

    public static void setRect(Rectangle target, Rectangle src) {
        RectangleUtil.setRect(target, src.getX(), src.getY(), src.getWidth(), src.getHeight());
    }

    public static void setRect(Rectangle target, Rectangle src, Rectangle constraint) {
        double x = src.getX();
        double y = src.getY();
        if (constraint != null) {
            if (x < 0.0) {
                x = 0.0;
            }
            if (x > constraint.getX() - target.getWidth()) {
                x = constraint.getX() - target.getWidth();
            }
            if (y < 0.0) {
                y = 0.0;
            }
            if (y > constraint.getY() - target.getHeight()) {
                y = constraint.getY() - target.getHeight();
            }
        }
    }

    public static void moveRect(Rectangle r, Point2D diff) {
        double x = r.getX() + diff.getX();
        double y = r.getY() + diff.getY();
        RectangleUtil.setRect(r, x, y);
    }

    public static void moveRect(Rectangle r, Point2D diff, Point2D constraint) {
        double x = r.getX() + diff.getX();
        double y = r.getY() + diff.getY();
        if (constraint != null) {
            if (x < 0.0) {
                x = 0.0;
            }
            if (x > constraint.getX() - r.getWidth()) {
                x = constraint.getX() - r.getWidth();
            }
            if (y < 0.0) {
                y = 0.0;
            }
            if (y > constraint.getY() - r.getHeight()) {
                y = constraint.getY() - r.getHeight();
            }
        }
        RectangleUtil.setRect(r, x, y);
    }

    public static void moveRect(Rectangle r, double dx, double dy) {
        double x = r.getX();
        double y = r.getY();
        RectangleUtil.setRect(r, dx + x, dy + y);
    }

    public static void setRect(Rectangle r, double x, double y, double w, double h) {
        r.setX(x);
        r.setY(y);
        r.setWidth(w);
        r.setHeight(h);
    }

    public static void setRect(Region r, double x, double y, double w, double h) {
        r.setLayoutX(x);
        r.setLayoutY(y);
        r.prefWidth(w);
        r.prefHeight(h);
    }

    public static void setRect(StackPane r, Point2D a, Point2D b) {
        double x = Math.min(a.getX(), b.getX());
        double y = Math.min(a.getY(), b.getY());
        double width = Math.abs(a.getX() - b.getX());
        double height = Math.abs(a.getY() - b.getY());
        RectangleUtil.setRect(r, x, y, width, height);
    }

    public static void setRect(StackPane r, double x, double y, double w, double h) {
        r.setLayoutX(x);
        r.setLayoutY(y);
        r.prefWidth(w);
        r.prefHeight(h);
    }

    public static void setRect(ImageView r, double x, double y, double w, double h) {
        r.setX(x);
        r.setY(y);
        r.setFitWidth(w);
        r.setFitHeight(h);
    }

    public static void setRect(Rectangle r, double x, double y) {
        r.setX(x);
        r.setY(y);
    }

    public static Point2D diff(Point2D a, Point2D b) {
        return new Point2D(a.getX() - b.getX(), a.getY() - b.getY());
    }

    public static double distance(Point2D a, Point2D b) {
        return Math.sqrt((a.getX() - b.getX()) * (a.getX() - b.getX()) + (a.getY() - b.getY()) * (a.getY() - b.getY()));
    }

    public static boolean isRectangleSizeTooSmall(Point2D start, Point2D end) {
        double width = Math.abs(end.getX() - start.getX());
        double height = Math.abs(end.getY() - start.getY());
        return width < 10.0 || height < 10.0;
    }

    public static void offsetRectangle(Rectangle r, double dx, double dy) {
        r.setX(r.getX() + dx);
        r.setY(r.getY() + dy);
    }

    public static Rectangle union(Point2D a, Point2D b) {
        double x = Math.min(a.getX(), b.getX());
        double y = Math.min(a.getY(), b.getY());
        double width = Math.abs(a.getX() - b.getX());
        double height = Math.abs(a.getY() - b.getY());
        return new Rectangle(x, y, width, height);
    }

    public static Rectangle constrainedUnion(Point2D a, Point2D b, double aspectRatio) {
        double x = Math.min(a.getX(), b.getX());
        double y = Math.min(a.getY(), b.getY());
        double width = Math.abs(a.getX() - b.getX());
        double height = width / aspectRatio;
        return new Rectangle(x, y, width, height);
    }

    public static Rectangle intersect(Rectangle a, Rectangle b) {
        double x = Math.max(a.getX(), b.getX());
        double y = Math.max(a.getY(), b.getY());
        double width = Math.min(a.getWidth(), b.getWidth());
        double height = Math.min(a.getHeight(), b.getHeight());
        return new Rectangle(x, y, width, height);
    }

    public static Point2D oppositeCorner(MouseEvent ev, Rectangle r) {
        return RectangleUtil.oppositeCorner(ev.getX(), ev.getY(), r);
    }

    public static Point2D oppositeCorner(Point2D pt, Rectangle r) {
        return RectangleUtil.oppositeCorner(pt.getX(), pt.getY(), r);
    }

    public static Point2D oppositeCorner(Point2D pt, StackPane r) {
        return RectangleUtil.oppositeCorner(pt.getX(), pt.getY(), r.getBoundsInLocal());
    }

    public static Point2D oppositeCorner(Point2D pt, Bounds r) {
        return RectangleUtil.oppositeCorner(pt.getX(), pt.getY(), r);
    }

    public static Point2D oppositeCorner(double inX, double inY, Rectangle r) {
        double outX = -1.0;
        double outY = -1.0;
        double x = inX;
        double y = inY;
        double left = r.getX();
        double right = left + r.getWidth();
        double top = r.getY();
        double bottom = top + r.getHeight();
        if (Math.abs(x - left) < SLOP) {
            outX = right;
        } else if (Math.abs(x - right) < SLOP) {
            outX = left;
        } else {
            return null;
        }
        if (Math.abs(y - top) < SLOP) {
            outY = bottom;
        } else if (Math.abs(y - bottom) < SLOP) {
            outY = top;
        } else {
            return null;
        }
        return new Point2D(outX, outY);
    }

    public static Point2D oppositeCorner(double inX, double inY, Bounds r) {
        double outX = -1.0;
        double outY = -1.0;
        double x = inX;
        double y = inY;
        double left = r.getMinX();
        double right = left + r.getWidth();
        double top = r.getMinY();
        double bottom = top + r.getHeight();
        if (Math.abs(x - left) < SLOP) {
            outX = right;
        } else if (Math.abs(x - right) < SLOP) {
            outX = left;
        } else {
            return null;
        }
        if (Math.abs(y - top) < SLOP) {
            outY = bottom;
        } else if (Math.abs(y - bottom) < SLOP) {
            outY = top;
        } else {
            return null;
        }
        return new Point2D(outX, outY);
    }

    public static Pos getPos(MouseEvent ev, Rectangle r) {
        double x = ev.getX();
        double y = ev.getY();
        double left = r.getX();
        double right = left + r.getWidth();
        double xCenter = (left + right) / 2.0;
        double top = r.getY();
        double bottom = top + r.getHeight();
        double yCenter = (top + bottom) / 2.0;
        if (Math.abs(x - left) < SLOP) {
            if (y - top < SLOP) {
                return Pos.TOP_LEFT;
            }
            if (y - yCenter < SLOP) {
                return Pos.CENTER_LEFT;
            }
            if (y - bottom < SLOP) {
                return Pos.BOTTOM_LEFT;
            }
        }
        if (Math.abs(x - xCenter) < SLOP) {
            if (y - top < SLOP) {
                return Pos.TOP_CENTER;
            }
            if (y - yCenter < SLOP) {
                return Pos.CENTER;
            }
            if (y - bottom < SLOP) {
                return Pos.BOTTOM_CENTER;
            }
        }
        if (Math.abs(x - right) < SLOP) {
            if (y - top < SLOP) {
                return Pos.TOP_RIGHT;
            }
            if (y - yCenter < SLOP) {
                return Pos.CENTER_RIGHT;
            }
            if (y - bottom < SLOP) {
                return Pos.BOTTOM_RIGHT;
            }
        }
        return Pos.CENTER;
    }

    public static boolean inCorner(MouseEvent ev) {
        if (ev == null) {
            return false;
        }
        if (ev.getTarget() instanceof Rectangle) {
            return RectangleUtil.inCorner(ev.getX(), ev.getY(), (Rectangle)ev.getTarget());
        }
        if (ev.getTarget() instanceof StackPane) {
            return RectangleUtil.inCorner(ev.getX(), ev.getY(), (StackPane)ev.getTarget());
        }
        if (ev.getTarget() instanceof VBox) {
            return RectangleUtil.inCorner(ev.getX(), ev.getY(), (VBox)ev.getTarget());
        }
        return false;
    }

    public static boolean inCorner(Pos p) {
        if (p == Pos.TOP_LEFT || p == Pos.BOTTOM_LEFT) {
            return true;
        }
        return p == Pos.TOP_RIGHT || p == Pos.BOTTOM_RIGHT;
    }

    public static Point2D oppositeCorner(MouseEvent ev) {
        if (ev == null) {
            return null;
        }
        EventTarget target = ev.getTarget();
        if (target instanceof Rectangle) {
            return RectangleUtil.oppositeCorner(ev.getX(), ev.getY(), (Rectangle)target);
        }
        if (ev.getTarget() instanceof StackPane) {
            return RectangleUtil.oppositeCorner(ev.getX(), ev.getY(), ((StackPane)target).getBoundsInLocal());
        }
        if (ev.getTarget() instanceof VBox) {
            return RectangleUtil.oppositeCorner(ev.getX(), ev.getY(), ((VBox)target).getBoundsInLocal());
        }
        return null;
    }

    public static boolean inCorner(MouseEvent ev, Rectangle r) {
        return RectangleUtil.inCorner(ev.getX(), ev.getY(), r);
    }

    public static boolean inCorner(Point2D pt, Rectangle r) {
        if (pt == null || r == null) {
            return false;
        }
        return RectangleUtil.inCorner(pt.getX(), pt.getY(), r);
    }

    public static boolean inCorner(Point2D pt, StackPane r) {
        return RectangleUtil.inCorner(pt.getX(), pt.getY(), r.getBoundsInLocal());
    }

    public static boolean inCorner(double inX, double inY, StackPane r) {
        return RectangleUtil.inCorner(inX, inY, r.getBoundsInLocal());
    }

    public static boolean inCorner(double inX, double inY, VBox r) {
        return RectangleUtil.inCorner(inX, inY, r.getBoundsInLocal());
    }

    public static boolean inCorner(Point2D pt, Region r) {
        if (pt == null || r == null) {
            return false;
        }
        return RectangleUtil.inCorner(pt.getX(), pt.getY(), r.getBoundsInLocal());
    }

    public static boolean inCorner(double inX, double inY, Rectangle r) {
        double x = inX;
        double y = inY;
        double left = r.getX();
        double right = left + r.getWidth();
        double top = r.getY();
        double bottom = top + r.getHeight();
        return (Math.abs(x - left) < SLOP || Math.abs(x - right) < SLOP) && (Math.abs(y - top) < SLOP || Math.abs(y - bottom) < SLOP);
    }

    public static boolean inCorner(Point2D curPoint, Bounds bounds) {
        return RectangleUtil.inCorner(curPoint.getX(), curPoint.getY(), bounds);
    }

    public static boolean inCorner(double inX, double inY, Bounds bounds) {
        double left = bounds.getMinX();
        double right = left + bounds.getWidth();
        double top = bounds.getMinY();
        double bottom = top + bounds.getHeight();
        return (Math.abs(inX - left) < SLOP || Math.abs(inX - right) < SLOP) && (Math.abs(inY - top) < SLOP || Math.abs(inY - bottom) < SLOP);
    }

    public static void setupCursors(Rectangle r) {
        r.setOnMouseEntered(event -> r.setCursor(Cursors.getResizeCursor(RectangleUtil.getPos(event, r))));
        r.setOnMouseMoved(event -> r.setCursor(Cursors.getResizeCursor(RectangleUtil.getPos(event, r))));
        r.setOnMouseExited(event -> r.setCursor(Cursor.DEFAULT));
    }
}

