/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.model;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class MixedDataRow {
    IntegerProperty rowNum = new SimpleIntegerProperty(0);
    LongProperty rowID = new SimpleLongProperty(0L);
    private ObservableList<SimpleStringProperty> strs = FXCollections.observableArrayList();
    private ObservableList<SimpleDoubleProperty> vals = FXCollections.observableArrayList();
    private ObservableList<SimpleIntegerProperty> types = FXCollections.observableArrayList();
    private ObservableList<SimpleIntegerProperty> ranges = FXCollections.observableArrayList();

    public MixedDataRow(int nCols) {
        for (int i = 0; i < nCols; ++i) {
            this.strs.add((Object)new SimpleStringProperty(""));
            this.vals.add((Object)new SimpleDoubleProperty(0.0));
            this.types.add((Object)new SimpleIntegerProperty(0));
            this.ranges.add((Object)new SimpleIntegerProperty(0));
        }
    }

    public int getRowNum() {
        return this.rowNum.get();
    }

    public void setRowNum(int row) {
        this.rowNum.set(row);
    }

    public void setRowID(long id) {
        this.rowID.set(id);
    }

    public void setRowID(int row, long id) {
        this.setRowNum(row);
        this.setRowID(id);
    }

    public void set(int i, Double s) {
        ((SimpleDoubleProperty)this.vals.get(i)).set(s.doubleValue());
    }

    public void setString(int i, String s) {
        ((SimpleStringProperty)this.strs.get(i)).set(s);
    }

    public DoubleProperty get(int i) {
        return (DoubleProperty)this.vals.get(i);
    }

    public StringProperty getString(int i) {
        return (StringProperty)this.strs.get(i);
    }

    public IntegerProperty getType(int i) {
        return (IntegerProperty)this.types.get(i);
    }

    public IntegerProperty getRange(int i) {
        return (IntegerProperty)this.ranges.get(i);
    }

    public boolean isString(int i) {
        return ((SimpleIntegerProperty)this.types.get(i)).intValue() == 0;
    }

    public boolean isBool(int i) {
        return ((SimpleIntegerProperty)this.types.get(i)).intValue() == 1;
    }

    public boolean isNumber(int i) {
        return ((SimpleIntegerProperty)this.types.get(i)).intValue() > 1;
    }

    public int getWidth() {
        return this.vals.size();
    }
}

