/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.model;

import java.awt.Frame;
import java.util.Collection;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;

public class CyChartManager {
    private CyServiceRegistrar registrar;
    private String version = "unknown";
    CyColumn xColumn;
    CyColumn yColumn;
    boolean isDirected;

    public CyChartManager(CyServiceRegistrar reg) {
        this.registrar = reg;
    }

    public CyServiceRegistrar getRegistrar() {
        return this.registrar;
    }

    public CyNetwork getCurrentNetwork() {
        if (this.registrar == null) {
            return null;
        }
        CyApplicationManager appMgr = (CyApplicationManager)this.registrar.getService(CyApplicationManager.class);
        if (appMgr == null) {
            return null;
        }
        return appMgr.getCurrentNetwork();
    }

    public void setVersion(String v) {
        this.version = v;
    }

    public String getVersion() {
        return this.version;
    }

    public Frame getOwner() {
        CySwingApplication swingApplication = (CySwingApplication)this.registrar.getService(CySwingApplication.class);
        return swingApplication == null ? null : swingApplication.getJFrame();
    }

    public void setXColumn(CyColumn c) {
        this.xColumn = c;
    }

    public void setYColumn(CyColumn c) {
        this.yColumn = c;
    }

    public CyColumn getXColumn() {
        if (this.xColumn == null) {
            // empty if block
        }
        return this.xColumn;
    }

    public CyColumn getYColumn() {
        return this.yColumn;
    }

    public void setXColumnName(String x) {
        CyTable tab = this.getCurrentTable();
        if (tab == null) {
            return;
        }
        this.xColumn = tab.getColumn(x);
        if (this.xColumn == null && "Degree".equals(x)) {
            x = "EdgeCount";
            this.xColumn = tab.getColumn(x);
        }
    }

    public void setYColumnName(String y) {
        CyTable tab;
        if (this.isDirected && "Degree".equals(y)) {
            y = "EdgeCount";
        }
        if ((tab = this.getCurrentTable()) == null) {
            return;
        }
        if (y == null) {
            Collection cols = tab.getColumns();
            for (CyColumn col : cols) {
                if (col.getType() != Double.class) continue;
                y = col.getName();
                this.yColumn = col;
            }
        } else {
            this.yColumn = tab.getColumn(y);
        }
        if ("Degree".equals(y)) {
            y = "EdgeCount";
            this.yColumn = tab.getColumn(y);
        }
    }

    public CyTable getCurrentTable() {
        CyApplicationManager appMgr = (CyApplicationManager)this.registrar.getService(CyApplicationManager.class);
        return appMgr == null ? null : appMgr.getCurrentTable();
    }
}

