/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.charts.oneD;

import java.util.Collections;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.cytoscape.cyChart.internal.charts.oneD.OverlaidLineChart;
import org.cytoscape.cyChart.internal.model.Peak;
import org.cytoscape.cyChart.internal.model.Range;

public class Histogram1D {
    private static final int DEFAULT_HISTO_LEN = 100;
    private int size;
    private int[] counts;
    private Range range;
    boolean isLog = false;
    private String name;
    private List<Peak> peaks = FXCollections.observableArrayList();
    int area = 0;
    int GUTTER_WIDTH = 0;
    boolean grayscale = true;
    private int firstPercentile;
    private int tenthPercentile;
    private int ninetiethPercentile;
    private int topPercentile;
    private double count = 0.0;
    private double mode = 0.0;
    private double median;
    private double mean;
    private double stDev;
    private double below1Stdev;
    private double below2Stdev;
    private double above1Stdev;
    private double above2Stdev;
    private double[] smoothed;
    static double SQRT2 = Math.sqrt(2.0);

    public List<Peak> getPeaks() {
        if (this.peaks.isEmpty()) {
            this.scanPeaks(null);
        }
        return this.peaks;
    }

    public String toString() {
        return this.name + "  " + this.range.toString();
    }

    public Range getRange() {
        return this.range;
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public int[] getCounts() {
        return this.counts;
    }

    public int get(int i) {
        return this.counts[i];
    }

    public double getValue(int i) {
        return this.smoothed == null ? (double)this.get(i) : this.smoothed[i];
    }

    public Histogram1D(int len, Range inX) {
        this("", len, inX);
    }

    public Histogram1D(String inName, Range inX) {
        this(inName, 100, inX, false);
    }

    public Histogram1D(String name, List<Double> values) {
        this(name, values.size(), new Range(0, values.size()));
        this.range = this.getRange(values);
        for (Double d : values) {
            if (d == null) continue;
            double dd = d;
            this.count(dd);
        }
    }

    Range getRange(List<Double> values) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (Double d : values) {
            if (d == null) continue;
            if (d < min) {
                min = d;
            }
            if (!(d > max)) continue;
            max = d;
        }
        return new Range(min, max);
    }

    public Histogram1D(String inName, Range inX, int nBins) {
        this.name = inName;
        this.size = nBins;
        this.counts = new int[nBins];
        this.range = inX;
    }

    public Histogram1D(String inName, int len, Range inX) {
        this.name = inName;
        this.size = len;
        this.counts = new int[this.size];
        this.range = inX;
        if (this.range.width() == 0.0) {
            this.range.set(0.0, this.size);
        }
    }

    public Histogram1D(String inName, int len, Range inX, boolean log) {
        this(inName, len, inX);
        this.isLog = log;
    }

    public Histogram1D(Histogram1D orig) {
        this(orig.getName(), orig.getSize(), orig.getRange(), orig.isLog);
        for (int i = 0; i < this.size; ++i) {
            this.counts[i] = orig.counts[i];
        }
    }

    public double getPercentile(int perc) {
        double val = 0.0;
        int area = this.getArea();
        int evCount = area * perc / 100;
        int i = 0;
        while (val < (double)evCount) {
            val += (double)this.counts[i];
            ++i;
        }
        double out = this.range.min() + (double)i * this.range.width() / (double)this.size;
        return out;
    }

    public int getArea() {
        if (this.area == 0) {
            for (int i = 0; i < this.size; ++i) {
                this.area += this.counts[i];
            }
        }
        return this.area;
    }

    public int getGutterCount() {
        int area = 0;
        for (int i = 0; i < this.GUTTER_WIDTH; ++i) {
            area += this.counts[i];
        }
        return area;
    }

    public void count(double x) {
        int bin = -1;
        if (x < this.range.min()) {
            return;
        }
        bin = this.valToBin(x);
        if (bin < this.GUTTER_WIDTH) {
            return;
        }
        if (bin >= this.size) {
            bin = this.size - 1;
        }
        int n = bin;
        this.counts[n] = this.counts[n] + 1;
    }

    public double binToVal(int bin) {
        double binWidth = this.range.width() / (double)this.size;
        if (this.isLog) {
            return Math.log(this.range.min() + (double)bin * binWidth) - 5.0;
        }
        return this.range.min() + (double)bin * binWidth;
    }

    public int valToBin(double d) {
        double binWidth = (1.0 + this.range.width()) / (double)this.size;
        if (this.isLog) {
            return (int)Math.round((Math.log(d) - Math.log(this.range.min())) / Math.log(this.range.width()) * (double)this.size);
        }
        return (int)Math.round((d - this.range.min()) / binWidth);
    }

    public void add(Histogram1D other) {
        boolean log = other.isLog;
        if (log != this.isLog) {
            System.err.println("Transform mismatch error");
        }
        for (int i = 0; i < other.getSize(); ++i) {
            double ct = other.getCounts()[i];
            double val = other.binToVal(i);
            int bin = this.valToBin(val);
            if (bin < 0 || bin >= this.size) continue;
            int n = bin;
            this.counts[n] = (int)((double)this.counts[n] + ct);
        }
    }

    public double getMode() {
        int max = 0;
        for (int row = 0; row < this.size; ++row) {
            max = Math.max(max, this.counts[row]);
        }
        return max;
    }

    public double getModePosition() {
        int max = 0;
        int position = 0;
        for (int row = 0; row < this.size; ++row) {
            if (this.counts[row] > max) {
                position = row;
            }
            max = Math.max(max, this.counts[row]);
        }
        return this.range.min() + this.range.width() * (double)position / (double)this.size;
    }

    public void calcDistributionStats() {
        int sum = 0;
        this.count = 0.0;
        for (int row = 0; row < this.size; ++row) {
            this.count += (double)this.counts[row];
            sum = (int)((double)sum + (double)this.counts[row] * this.binToVal(row));
        }
        this.mean = (double)sum / this.count;
        int total = 0;
        int row = 0;
        while ((double)total < this.count / 100.0) {
            total += this.counts[row++];
        }
        this.firstPercentile = row;
        while ((double)total < this.count / 10.0) {
            total += this.counts[row++];
        }
        this.tenthPercentile = row;
        while ((double)total < this.count / 2.0) {
            total += this.counts[row++];
        }
        this.median = this.binToVal(row);
        while ((double)total < 9.0 * this.count / 10.0) {
            total += this.counts[row++];
        }
        this.ninetiethPercentile = row;
        while ((double)total < 99.0 * this.count / 100.0) {
            total += this.counts[row++];
        }
        this.topPercentile = row;
    }

    public double getMedian() {
        return this.median;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStDev() {
        return this.stDev;
    }

    public double getBelow1Stdev() {
        return this.below1Stdev;
    }

    public double getBelow2Stdev() {
        return this.below2Stdev;
    }

    public double getAbove1Stdev() {
        return this.above1Stdev;
    }

    public double getAbove2Stdev() {
        return this.above2Stdev;
    }

    public int getPercentile1() {
        return this.firstPercentile;
    }

    public int getPercentile10() {
        return this.tenthPercentile;
    }

    public int getPercentile90() {
        return this.ninetiethPercentile;
    }

    public int getPercentile99() {
        return this.topPercentile;
    }

    public double getPercentile1Val() {
        return this.binToVal(this.firstPercentile);
    }

    public double getPercentile10Val() {
        return this.binToVal(this.tenthPercentile);
    }

    public double getPercentile90Val() {
        return this.binToVal(this.ninetiethPercentile);
    }

    public double getPercentile99Val() {
        return this.binToVal(this.topPercentile);
    }

    public String getStatString() {
        double modeHeight = this.getMode();
        double mode = this.getModePosition();
        double area = this.getArea();
        double mean = this.getMean();
        mode = Math.log(mode) - 5.0;
        Object s = String.format("Stats: \nHeight: %.2f\nMode:  %.2f\n", modeHeight /= area, mode);
        s = (String)s + String.format("Mean: %.2f\n", mean);
        s = (String)s + String.format("Median: %.2f\n90th:%.2f\n99th: %.2f\n", this.getMedian(), this.getPercentile90Val(), this.getPercentile99Val());
        return s;
    }

    Color colorLookup(int val) {
        if (this.mode != 0.0 && this.grayscale) {
            double v = (double)val / this.mode;
            return new Color(v, v, v, 1.0);
        }
        return Color.RED;
    }

    public XYChart.Series<Number, Number> rawDataSeries() {
        System.out.println("Mode: " + this.getMode());
        double scale = this.range.width() / (double)this.size;
        XYChart.Series series = new XYChart.Series();
        for (int i = 0; i < this.size; ++i) {
            series.getData().add((Object)new XYChart.Data((Object)((double)i * scale), (Object)this.counts[i]));
        }
        return series;
    }

    public XYChart.Series<Number, Number> getDataSeries(String seriesName) {
        return this.getDataSeries(seriesName, 0.0);
    }

    public XYChart.Series<Number, Number> getDataSeries(String seriesName, double yOffset) {
        return this.getDataSeries(seriesName, yOffset, this.getArea());
    }

    public XYChart.Series<Number, Number> getDataSeries(String seriesName, double yOffset, double area) {
        XYChart.Series series = new XYChart.Series();
        series.nameProperty().set((Object)seriesName);
        try {
            double[] smoothed = this.smooth();
            double scale = this.range.width() / (double)(this.size + 1);
            ObservableList data = series.getData();
            for (int i = 0; i < this.size; ++i) {
                double x = this.range.min() + (double)i * scale;
                double y = smoothed[i] / area + yOffset;
                data.add((Object)new XYChart.Data((Object)x, (Object)y));
            }
        }
        catch (Exception e) {
            System.out.println("EXCEPTION CAUGHT " + e.getMessage());
        }
        return series;
    }

    public double[] smooth() {
        int i;
        int bin;
        if (this.smoothed != null) {
            return this.smoothed;
        }
        int resolution = this.size;
        int numBins = resolution + 1;
        int radius = (int)this.getRadius(resolution);
        int bins = numBins + 2 * radius;
        double[] destvector = new double[bins + 2];
        for (bin = radius + 0; bin < radius + numBins - 1; ++bin) {
            double binCt = this.counts[bin - radius];
            if (binCt == 0.0) continue;
            int elements = this.smoothingVectorSize(binCt, resolution);
            double[] smoothVector = this.smoothingVector(resolution, binCt, 2.4, elements, bin);
            int n = bin;
            destvector[n] = destvector[n] + smoothVector[0] * binCt;
            for (i = 1; i <= elements; ++i) {
                double v = smoothVector[i] * binCt;
                if (bin + i < destvector.length) {
                    int n2 = bin + i;
                    destvector[n2] = destvector[n2] + v;
                }
                if (bin - i < 0) continue;
                int n3 = bin - i;
                destvector[n3] = destvector[n3] + v;
            }
        }
        for (i = 1; i <= radius; ++i) {
            int leftEdge = radius;
            int rightEdge = radius + numBins;
            int n = leftEdge + i - 1;
            destvector[n] = destvector[n] + destvector[leftEdge - i];
            int n4 = rightEdge - i + 1;
            destvector[n4] = destvector[n4] + destvector[rightEdge + i];
        }
        double[] destBins = new double[numBins];
        for (bin = 0; bin < numBins; ++bin) {
            destBins[bin] = destvector[bin + radius];
        }
        this.smoothed = destBins;
        return destBins;
    }

    private int smoothingVectorSize(double binCt, int resolution) {
        int vectorElements;
        double sqrtZ;
        double radius = this.getRadius(resolution);
        double r = radius / Math.sqrt(sqrtZ = Math.sqrt(binCt));
        if (r - (double)(vectorElements = (int)r) > 0.0) {
            ++vectorElements;
        }
        return vectorElements;
    }

    private double[] smoothingVector(int resolution, double binCt, double nDevs, int vSize, int bin) {
        double sqrtN = Math.sqrt(binCt);
        double[] vector = new double[vSize + 1];
        double radius = this.getRadius(resolution);
        double factor = -0.5 * sqrtN * (nDevs / radius) * (nDevs / radius);
        for (int i = 0; i <= vSize; ++i) {
            vector[i] = Math.exp(factor * (double)i * (double)i);
        }
        return this.normalized(vector, vSize);
    }

    private double[] normalized(double[] vector, int vSize) {
        int i;
        double vectorTotal = 0.0;
        for (i = -vSize; i <= vSize; ++i) {
            for (int j = -vSize; j <= vSize; ++j) {
                vectorTotal += vector[Math.abs(i)] * vector[Math.abs(j)];
            }
        }
        vectorTotal = Math.sqrt(vectorTotal);
        i = 0;
        while (i <= vSize) {
            int n = i++;
            vector[n] = vector[n] / vectorTotal;
        }
        return vector;
    }

    private double getRadius(int resolution) {
        return 10.0;
    }

    public OverlaidLineChart makeChart() {
        NumberAxis xAxis = new NumberAxis();
        NumberAxis yAxis = new NumberAxis();
        OverlaidLineChart chart = new OverlaidLineChart((Axis<Number>)xAxis, (Axis<Number>)yAxis);
        chart.setTitle(this.getName());
        chart.setCreateSymbols(false);
        chart.getData().add(this.getDataSeries("All"));
        chart.setLegendVisible(false);
        chart.setPrefHeight(150.0);
        chart.setPrefWidth(400.0);
        chart.setMaxWidth(600.0);
        VBox.setVgrow((Node)chart, (Priority)Priority.NEVER);
        chart.setId(this.getName());
        return chart;
    }

    public OverlaidLineChart makePeakFitChart() {
        OverlaidLineChart chart = this.makeChart();
        return chart;
    }

    public void addPeakMarkers(OverlaidLineChart peakFitChart) {
        this.scanPeaks(peakFitChart);
        for (Peak p : this.peaks) {
            p.calcStdev();
            p.setHistogram(this);
            p.setChart((XYChart<Number, Number>)peakFitChart);
            peakFitChart.addBellCurveMarker(p, Color.FORESTGREEN, 0.6);
        }
    }

    public LineChart<Number, Number> makeRawDataChart() {
        NumberAxis xAxis = new NumberAxis();
        NumberAxis yAxis = new NumberAxis();
        LineChart chart = new LineChart((Axis)xAxis, (Axis)yAxis);
        chart.setTitle(this.getName());
        chart.setCreateSymbols(false);
        chart.getData().add(this.rawDataSeries());
        chart.setLegendVisible(false);
        chart.setPrefHeight(300.0);
        VBox.setVgrow((Node)chart, (Priority)Priority.ALWAYS);
        chart.setId("Profile: " + this.getName());
        return chart;
    }

    public void scanPeaks(OverlaidLineChart peakFitChart) {
        this.peaks.clear();
        boolean allPeaks = false;
        int mode = 0;
        double[] peakHisto = new double[this.size];
        try {
            boolean finished = false;
            int totalPeakArea = 0;
            int area = 0;
            for (int i = 0; i < this.size; ++i) {
                peakHisto[i] = this.getValue(i);
                area = (int)((double)area + peakHisto[i]);
            }
            while (!finished && this.peaks.size() < 10) {
                int highEnd;
                int bin;
                double modeValue = 0.0;
                for (bin = 0; bin < this.size; ++bin) {
                    if (!(peakHisto[bin] > modeValue)) continue;
                    modeValue = peakHisto[bin];
                    mode = bin;
                }
                if (modeValue == 0.0) {
                    finished = true;
                    break;
                }
                int lowEnd = highEnd = mode;
                int sub = mode;
                int sooper = mode;
                sub = lowEnd = this.findBounds(mode, -1, peakHisto, modeValue);
                sooper = highEnd = this.findBounds(mode, 1, peakHisto, modeValue);
                if (lowEnd <= 0) {
                    lowEnd = 0;
                }
                if (sub <= 0) {
                    sub = 0;
                }
                Peak peak = new Peak(this, (XYChart<Number, Number>)peakFitChart);
                peak.setBounds(lowEnd, highEnd);
                peak.setAmplitude(modeValue);
                peak.setArea(0.0);
                for (bin = lowEnd; bin < highEnd; ++bin) {
                    peak.addArea(peakHisto[bin]);
                }
                double peakArea = peak.getArea();
                double seen = 0.0;
                for (bin = lowEnd; bin <= highEnd && seen < peakArea / 2.0; seen += peakHisto[bin], ++bin) {
                }
                if (bin == 0) {
                    peak.setMean(bin);
                } else {
                    double crossover = peakHisto[bin - 1];
                    double intoChannel = seen - peak.getArea() / 2.0;
                    double ratio = intoChannel / crossover;
                    peak.setMean((double)bin - ratio);
                }
                assert (sooper <= 100);
                for (bin = sub; bin < sooper; ++bin) {
                    totalPeakArea = (int)((double)totalPeakArea + peakHisto[bin]);
                    peakHisto[bin] = 0.0;
                }
                double minArea = this.getMinPeakArea(area);
                if (!allPeaks && peak.getArea() < minArea) {
                    finished = (double)totalPeakArea / peakArea > 0.95;
                    continue;
                }
                this.peaks.add(peak);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        Collections.sort(this.peaks);
    }

    private int findBounds(int mode, int direction, double[] peakHisto, double modeValue) {
        double halfMax = modeValue / 2.0;
        boolean shoulderPeaks = false;
        double halfWidthHalfMax = 0.0;
        boolean wasBelowThreshold = false;
        double WIDTHFACTOR = SQRT2;
        double FLOOR = 0.01;
        int bin = mode;
        while (this.between(bin, 0.0, this.size)) {
            boolean rising;
            int slopeWidth = (int)this.pin(halfWidthHalfMax, (double)this.size / 32.0, (double)this.size / 8.0);
            int slopeLow = Math.max(0, bin - slopeWidth / 2);
            int slopeHigh = Math.min(this.size - 1, bin + slopeWidth / 2);
            double slope = Histogram1D.getSlope(peakHisto, slopeLow, slopeHigh - slopeLow + 1);
            boolean bl = direction == 0 ? slope < 0.0 : (rising = slope > 0.0);
            if (halfWidthHalfMax > 0.0) {
                double curWidth = Math.abs(bin - mode);
                double expected = Math.abs(modeValue - peakHisto[bin]) / halfMax * halfWidthHalfMax;
                if (peakHisto[bin] < FLOOR) {
                    return bin;
                }
                if (curWidth > expected && rising) {
                    return bin;
                }
                if (curWidth > WIDTHFACTOR * expected) {
                    return bin;
                }
            } else if (halfWidthHalfMax > 0.0) {
                if (peakHisto[bin] == 0.0 || rising) {
                    return bin;
                }
            } else {
                if (rising && shoulderPeaks && wasBelowThreshold) {
                    return bin;
                }
                if (peakHisto[bin] < halfMax) {
                    int chanMinusOne = Math.max(0, bin - 1);
                    halfWidthHalfMax = (double)Math.abs(bin - mode) - (halfMax - peakHisto[bin]) / (peakHisto[chanMinusOne] - halfMax);
                }
            }
            if (peakHisto[bin] < halfMax * WIDTHFACTOR) {
                wasBelowThreshold = true;
            }
            bin += direction;
        }
        return bin;
    }

    private double getMinPeakArea(int area) {
        return Math.max(100.0, (double)area / 100.0);
    }

    int pin(int x, int min, int max) {
        return Math.min(max, Math.max(x, min));
    }

    double pin(double x, double min, double max) {
        return Math.min(max, Math.max(x, min));
    }

    boolean between(double x, double min, double max) {
        return min <= x && x < max;
    }

    public static Double getSlope(double[] x, int start, int nValues) {
        double totalXY = 0.0;
        double totalX = 0.0;
        double totalY = 0.0;
        double totalXSquared = 0.0;
        for (int i = 0; i < nValues; ++i) {
            double xi = x[start + i];
            totalX += (double)i;
            totalXSquared += (double)(i * i);
            totalY += xi;
            totalXY += (double)i * xi;
        }
        double slope = 0.0;
        double denom = (double)nValues * totalXSquared - totalX * totalX;
        if (denom != 0.0) {
            slope = ((double)nValues * totalXY - totalX * totalY) / denom;
        }
        return slope;
    }

    public void dump() {
        System.out.println(this.toString());
    }
}

