/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.splash.internal;

import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.cytoscape.application.events.CyStartEvent;
import org.cytoscape.application.events.CyStartListener;
import org.cytoscape.launcher.internal.SplashPanel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class SplashManipulator
implements BundleListener,
CyStartListener {
    private Set<Long> resolved;
    private Set<Long> started;
    private BundleContext context;
    private SplashPanel splashPanel;

    public SplashManipulator(BundleContext context, SplashPanel splashPanel) {
        this.context = context;
        this.resolved = new HashSet<Long>();
        this.started = new HashSet<Long>();
        for (Bundle bundle : context.getBundles()) {
            long id = bundle.getBundleId();
            this.resolved.add(id);
            if (bundle.getState() != 32) continue;
            this.started.add(id);
        }
        this.splashPanel = splashPanel;
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (event.getType() == 32) {
            this.resolved.add(bundle.getBundleId());
        }
        if (event.getType() == 2) {
            this.started.add(bundle.getBundleId());
            String name = bundle.getSymbolicName();
            this.splashPanel.updateMessage(name + " started", this.getProgress());
        }
    }

    double getProgress() {
        int totalResolved = this.resolved.size();
        int totalStarted = this.started.size();
        return totalResolved == 0 ? 0.0 : (double)totalStarted / (double)totalResolved;
    }

    public void handleEvent(CyStartEvent e) {
        this.context.removeBundleListener((BundleListener)this);
        this.resolved.clear();
        this.started.clear();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SplashManipulator.this.splashPanel.close();
            }
        });
    }
}

