/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.VisualProperty;
import org.slf4j.Logger;

public final class ViewUtil {
    public static final String TEXT_EDITOR_LABEL = "Enter a new text value:";
    private static Set<Font> fonts;

    public static void invokeOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeOnEDTAndWait(Runnable runnable) {
        ViewUtil.invokeOnEDTAndWait(runnable, null);
    }

    public static void invokeOnEDTAndWait(Runnable runnable, Logger logger) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                if (logger != null) {
                    logger.error("Unexpected error", (Throwable)e);
                }
                e.printStackTrace();
            }
        }
    }

    public static String showMultiLineTextEditor(Component parent, String initialValue) {
        return ViewUtil.showMultiLineTextEditor(parent, initialValue, null);
    }

    public static String showMultiLineTextEditor(Component parent, String initialValue, VisualProperty<String> vp) {
        JLabel label = new JLabel(TEXT_EDITOR_LABEL);
        JTextArea ta = new JTextArea(initialValue, 5, 30);
        JScrollPane scrollPane = new JScrollPane(ta);
        JPanel panel = new JPanel();
        if (LookAndFeelUtil.isAquaLAF()) {
            panel.setOpaque(false);
        }
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(label, -2, -1, -2).addComponent(scrollPane, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(label, -2, -1, -2).addComponent(scrollPane, -1, -1, Short.MAX_VALUE));
        if (0 == JOptionPane.showConfirmDialog(parent, panel, vp != null ? vp.getDisplayName() : "Text Editor", 2, -1, null)) {
            return ta.getText();
        }
        return initialValue;
    }

    public static void styleToolBarButton(AbstractButton btn) {
        ViewUtil.styleToolBarButton(btn, null, true);
    }

    public static void styleToolBarButton(AbstractButton btn, boolean addPadding) {
        ViewUtil.styleToolBarButton(btn, null, addPadding);
    }

    public static void styleToolBarButton(AbstractButton btn, Font font) {
        ViewUtil.styleToolBarButton(btn, font, true);
    }

    public static void styleToolBarButton(AbstractButton btn, Font font, boolean addPadding) {
        int hPad = addPadding ? 5 : 0;
        int vPad = addPadding ? 4 : 0;
        ViewUtil.styleToolBarButton(btn, font, hPad, vPad);
    }

    public static void styleToolBarButton(AbstractButton btn, Font font, int hPad, int vPad) {
        if (font != null) {
            btn.setFont(font);
        }
        btn.setFocusPainted(false);
        btn.setFocusable(false);
        btn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        btn.setContentAreaFilled(false);
        btn.setOpaque(true);
        btn.setHorizontalAlignment(0);
        btn.setVerticalAlignment(0);
        btn.setHorizontalTextPosition(0);
        btn.setVerticalTextPosition(1);
        if (hPad > 0 || vPad > 0) {
            Dimension d = btn.getPreferredSize();
            d = new Dimension(d.width + 2 * hPad, d.height + 2 * vPad);
            btn.setPreferredSize(d);
            btn.setMinimumSize(d);
            btn.setMaximumSize(d);
            btn.setSize(d);
        }
        if (btn instanceof JToggleButton) {
            btn.addItemListener(evt -> ViewUtil.updateToolBarStyle((JToggleButton)btn));
            ViewUtil.updateToolBarStyle((JToggleButton)btn);
        }
    }

    public static void updateToolBarStyle(JToggleButton btn) {
        ViewUtil.updateToolBarStyle(btn, true);
    }

    public static void updateToolBarStyle(JToggleButton btn, boolean showSelectionBorder) {
        Border defBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        if (btn.isEnabled()) {
            Border selBorder = showSelectionBorder ? BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("CyToggleButton[Selected].borderColor")), BorderFactory.createEmptyBorder(1, 1, 1, 1)) : defBorder;
            btn.setBorder(btn.isSelected() ? selBorder : defBorder);
            btn.setBackground(btn.isSelected() ? UIManager.getColor("CyToggleButton[Selected].background") : UIManager.getColor("CyToggleButton.background"));
            btn.setForeground(btn.isSelected() ? UIManager.getColor("CyToggleButton[Selected].foreground") : UIManager.getColor("CyToggleButton.foreground"));
        } else {
            btn.setBorder(defBorder);
            btn.setForeground(UIManager.getColor("ToggleButton.disabledForeground"));
            btn.setBackground(UIManager.getColor("CyToggleButton.unselectedBackground"));
        }
    }

    public static Set<Font> getAvailableFonts() {
        if (fonts == null) {
            fonts = new LinkedHashSet<Font>();
            Font[] sysFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            if (sysFonts != null) {
                for (Font f : sysFonts) {
                    fonts.add(f);
                }
            }
        }
        return new LinkedHashSet<Font>(fonts);
    }

    private ViewUtil() {
    }
}

