/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.legend;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellRenderer;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;

public class LegendTable
extends JPanel {
    static final Color BACKGROUND_COLOR = Color.WHITE;
    static final Color FOREGROUND_COLOR = Color.BLACK;
    private final CyApplicationManager appManager;
    private VisualProperty<?> vp;
    private JTable legendTable;

    public LegendTable(Object[][] data, VisualProperty<?> vp, ServicesUtil servicesUtil) {
        this.appManager = servicesUtil.get(CyApplicationManager.class);
        this.vp = vp;
        this.legendTable = new JTable(data.length, 2);
        this.legendTable.setRowHeight(50);
        this.legendTable.setDefaultRenderer(Object.class, new LegendCellRenderer());
        this.vp = vp;
        this.setLayout(new BorderLayout());
        Object value = null;
        for (int i = 0; i < data.length; ++i) {
            value = this.getIcon(data[i][0]);
            if (value != null) {
                this.legendTable.getModel().setValueAt(value, i, 0);
            }
            this.legendTable.getModel().setValueAt(data[i][1], i, 1);
        }
        this.add((Component)this.legendTable, 0);
    }

    private Object getIcon(Object value) {
        if (value == null) {
            return null;
        }
        RenderingEngine engine = this.appManager.getCurrentRenderingEngine();
        Icon icon = engine.createIcon(this.vp, value, 32, 32);
        return icon;
    }

    public static JPanel getHeader(String attrName, VisualProperty<?> vp) {
        JPanel titles = new JPanel();
        JLabel[] labels = new JLabel[]{new JLabel(vp.getDisplayName()), new JLabel(attrName)};
        for (int i = 0; i < labels.length; ++i) {
            labels[i].setVerticalAlignment(0);
            labels[i].setHorizontalAlignment(10);
            labels[i].setVerticalTextPosition(0);
            labels[i].setHorizontalTextPosition(10);
            labels[i].setForeground(FOREGROUND_COLOR);
            labels[i].setBorder(new EmptyBorder(10, 0, 7, 10));
            labels[i].setFont(new Font("SansSerif", 1, 14));
        }
        titles.setLayout(new GridLayout(1, 2));
        titles.setBackground(BACKGROUND_COLOR);
        titles.add(labels[0]);
        titles.add(labels[1]);
        titles.setBorder(new MatteBorder(0, 0, 1, 0, FOREGROUND_COLOR));
        return titles;
    }

    public class LegendCellRenderer
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel cell = new JLabel();
            if (value instanceof Icon) {
                Icon icon = (Icon)value;
                cell.setIcon(icon);
                cell.setVerticalAlignment(0);
                cell.setHorizontalAlignment(0);
            } else {
                cell.setText(value.toString());
                cell.setVerticalTextPosition(0);
                cell.setVerticalAlignment(0);
                cell.setHorizontalAlignment(10);
                cell.setHorizontalTextPosition(10);
            }
            cell.setPreferredSize(new Dimension(170, 1));
            return cell;
        }
    }
}

