/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.legend;

import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.C2CMappingEditorPanel;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.C2DMappingEditorPanel;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.GradientEditorPanel;
import org.cytoscape.view.vizmap.gui.internal.view.legend.AbstractMappingLegendPanel;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;

public class ContinuousLegendPanel
extends AbstractMappingLegendPanel {
    private JLabel legend;
    private final VisualStyle style;
    private final ContinuousMapping<?, ?> mapping;
    private final CyTable table;

    public ContinuousLegendPanel(VisualStyle style, ContinuousMapping<?, ?> mapping, CyTable table, ServicesUtil servicesUtil) {
        super((VisualMappingFunction<?, ?>)mapping, servicesUtil);
        this.style = style;
        this.mapping = mapping;
        this.table = table;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ContinuousLegendPanel.this.setLegend(e);
            }
        });
        this.add((Component)this.getTitleLabel(), "North");
        this.setLegend(null);
    }

    private void setLegend(ComponentEvent e) {
        if (this.legend != null) {
            this.remove(this.legend);
        }
        Integer trackW = null;
        if (this.getParent() == null) {
            trackW = 600;
        } else {
            trackW = ((Number)((double)this.getParent().getParent().getParent().getWidth() * 0.82)).intValue();
            if (trackW < 200) {
                trackW = 200;
            }
        }
        if (Paint.class.isAssignableFrom(this.visualProperty.getRange().getType())) {
            GradientEditorPanel panel = new GradientEditorPanel(this.style, this.mapping, this.table, null, null, this.servicesUtil);
            this.legend = new JLabel(panel.getLegend(trackW, 100));
        } else if (Number.class.isAssignableFrom(this.visualProperty.getRange().getType())) {
            C2CMappingEditorPanel panel = new C2CMappingEditorPanel(this.style, this.mapping, this.table, null, this.servicesUtil);
            this.legend = new JLabel(panel.getLegend(trackW, 150));
        } else {
            try {
                C2DMappingEditorPanel panel = new C2DMappingEditorPanel(this.style, (ContinuousMapping<Number, ?>)this.mapping, this.table, null, this.servicesUtil);
                this.legend = new JLabel(panel.getLegend(trackW, 150));
            }
            catch (Exception ex) {
                this.legend = new JLabel("Legend Generator not available");
            }
        }
        this.legend.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)this.legend, "Center");
        this.repaint();
    }
}

