/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor;

import java.util.HashMap;
import java.util.Map;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.TableVisualMappingManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;

public class EditorValueRangeTracer {
    private final Map<VisualProperty<?>, Range> rangeMap = new HashMap();

    public EditorValueRangeTracer(ServicesUtil servicesUtil) {
        VisualMappingManager vmMgr = servicesUtil.get(VisualMappingManager.class);
        for (VisualLexicon lexicon : vmMgr.getAllVisualLexicon()) {
            for (VisualProperty vp : lexicon.getAllVisualProperties()) {
                this.rangeMap.put(vp, new Range(0.0, 0.0));
            }
        }
        TableVisualMappingManager tblMgr = servicesUtil.get(TableVisualMappingManager.class);
        for (VisualLexicon lexicon : tblMgr.getAllVisualLexicon()) {
            for (VisualProperty vp : lexicon.getAllVisualProperties()) {
                this.rangeMap.put(vp, new Range(0.0, 0.0));
            }
        }
    }

    public Double getRange(VisualProperty<?> t) {
        return this.rangeMap.get(t).getRange();
    }

    public Double getMin(VisualProperty<?> t) {
        return this.rangeMap.get(t).getMin();
    }

    public Double getMax(VisualProperty<?> t) {
        return this.rangeMap.get(t).getMax();
    }

    public void setMin(VisualProperty<?> t, Double min) {
        this.rangeMap.get(t).setMin(min);
    }

    public void setMax(VisualProperty<?> t, Double max) {
        this.rangeMap.get(t).setMax(max);
    }

    private final class Range {
        private Double min;
        private Double max;

        public Range(Double min, Double max) {
            this.min = min;
            this.max = max;
        }

        public void setMin(Double min) {
            this.min = min;
        }

        public void setMax(Double max) {
            this.max = max;
        }

        public Double getMin() {
            return this.min;
        }

        public Double getMax() {
            return this.max;
        }

        public Double getRange() {
            return Math.abs(this.min - this.max);
        }
    }
}

