/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.EditorValueRangeTracer;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.VizMapTrackRenderer;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.multislider.Thumb;

public class CyGradientTrackRenderer
extends JComponent
implements VizMapTrackRenderer {
    private static final long serialVersionUID = 1202339877115160L;
    private static final int THUMB_WIDTH = 12;
    private int trackHeight = 40;
    private JXMultiThumbSlider<Color> slider;
    private Color below;
    private Color above;
    private String attrName;
    private final VisualProperty<Color> type;
    private final EditorValueRangeTracer tracer;

    public CyGradientTrackRenderer(VisualProperty<Color> type, Color below, Color above, String title, EditorValueRangeTracer tracer) {
        this.below = below;
        this.above = above;
        this.tracer = tracer;
        this.attrName = title;
        this.type = type;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintComponent(g);
    }

    @Override
    protected void paintComponent(Graphics gfx) {
        Graphics2D g = (Graphics2D)gfx;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double minValue = this.tracer.getMin(this.type);
        double maxValue = this.tracer.getMax(this.type);
        double range = this.tracer.getRange(this.type);
        int track_width = this.slider.getWidth() - 12;
        g.translate(6, 12);
        List stops = this.slider.getModel().getSortedThumbs();
        int len = stops.size();
        if (len != 0) {
            float[] fractions = new float[len + 2];
            Color[] colors = new Color[len + 2];
            int i = 1;
            colors[0] = this.below;
            fractions[0] = ((Thumb)stops.get(0)).getPosition() / 100.0f;
            for (Thumb thumb : stops) {
                int y;
                int x;
                colors[i] = (Color)thumb.getObject();
                fractions[i] = thumb.getPosition() / 100.0f;
                Double value = minValue + (double)fractions[i] * range;
                String valueString = Math.abs(minValue) < 3.0 || Math.abs(maxValue) < 3.0 ? String.format("%.4f", value) : String.format("%.2f", value);
                int curPosition = (int)((float)track_width * fractions[i]);
                int stringWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), valueString);
                if (curPosition < stringWidth / 2) {
                    x = curPosition;
                    y = this.trackHeight + 15;
                } else if (track_width - curPosition < stringWidth / 2) {
                    x = curPosition - stringWidth;
                    y = this.trackHeight + 15;
                } else {
                    x = curPosition - stringWidth / 2;
                    y = this.trackHeight + 15;
                }
                g.setFont(SMALL_FONT);
                g.setColor(LABEL_COLOR);
                g.drawString(valueString, x, y);
                ++i;
            }
            colors[colors.length - 1] = this.above;
            fractions[fractions.length - 1] = ((Thumb)stops.get(stops.size() - 1)).getPosition() / 100.0f;
            g.setStroke(new BasicStroke(1.0f));
            Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
            Point2D.Float end = new Point2D.Float(track_width, this.trackHeight);
            CyGradientTrackRenderer.drawGradient(g, start, end, fractions, colors);
        }
        Rectangle rect = new Rectangle(0, 0, track_width, this.trackHeight);
        g.setColor(BORDER_COLOR);
        g.drawLine((int)((Rectangle2D)rect).getBounds2D().getMinX(), (int)((Rectangle2D)rect).getBounds2D().getMaxY(), 8, (int)((Rectangle2D)rect).getBounds2D().getMaxY() + 25);
        g.setFont(SMALL_FONT);
        g.drawString("Min=" + minValue, (int)((Rectangle2D)rect).getBounds2D().getMinX(), (int)((Rectangle2D)rect).getBounds2D().getMaxY() + 38);
        g.drawLine((int)((Rectangle2D)rect).getBounds2D().getMaxX(), (int)((Rectangle2D)rect).getBounds2D().getMaxY(), (int)((Rectangle2D)rect).getBounds2D().getMaxX() - 8, (int)((Rectangle2D)rect).getBounds2D().getMaxY() + 25);
        g.setFont(SMALL_FONT);
        String maxString = "Max=" + maxValue;
        g.drawString(maxString, (int)((Rectangle2D)rect).getBounds2D().getMaxX() - SwingUtilities.computeStringWidth(g.getFontMetrics(), maxString), (int)((Rectangle2D)rect).getBounds2D().getMaxY() + 38);
        g.setFont(TITLE_FONT);
        int titleWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), this.attrName);
        g.setColor(LABEL_COLOR);
        g.drawString(this.attrName, (int)((Rectangle2D)rect).getBounds2D().getWidth() / 2 - titleWidth / 2, (int)((Rectangle2D)rect).getBounds2D().getMaxY() + 33);
        g.draw(rect);
        g.translate(-6, -12);
    }

    private static void drawGradient(Graphics2D g, Point2D start, Point2D end, float[] fractions, Color[] colors) {
        if (fractions.length < 1) {
            return;
        }
        int width = (int)(end.getX() - start.getX());
        int height = (int)(end.getY() - start.getY());
        if (colors.length == 3) {
            int pivot = (int)(fractions[1] * (float)width);
            g.setColor(colors[0]);
            g.fillRect((int)start.getX(), (int)start.getY(), pivot, height);
            g.setColor(colors[2]);
            g.fillRect(pivot, (int)start.getY(), width - pivot, height);
            g.setColor(colors[1]);
            g.drawLine(pivot, (int)start.getY(), pivot, height);
        } else if (colors.length > 3) {
            int pivot = (int)(fractions[1] * (float)width);
            g.setColor(colors[0]);
            g.fillRect((int)start.getX(), (int)start.getY(), pivot, height);
            for (int i = 1; i < colors.length - 2; ++i) {
                int nextPivot = (int)((float)width * fractions[i + 1]);
                GradientPaint gp = new GradientPaint(pivot, height / 2, colors[i], nextPivot, height / 2, colors[i + 1]);
                g.setPaint(gp);
                g.fillRect(pivot, 0, nextPivot - pivot, height);
                pivot = nextPivot;
            }
            int lastPivot = (int)(fractions[fractions.length - 1] * (float)width);
            g.setColor(colors[colors.length - 1]);
            g.fillRect(lastPivot, (int)start.getY(), width - lastPivot, height);
        }
    }

    public JComponent getRendererComponent(JXMultiThumbSlider slider) {
        this.slider = slider;
        this.trackHeight = slider.getHeight() - 50;
        return this;
    }

    public Object getObjectInRange(int x, int y) {
        return null;
    }

    public String getToolTipForCurrentLocation(int x, int y) {
        return null;
    }

    public ImageIcon getLegend(int iconWidth, int iconHeight) {
        return this.drawIcon(iconWidth, iconHeight, true);
    }

    public ImageIcon drawIcon(int iconWidth, int iconHeight, boolean detail) {
        if (this.slider == null) {
            return null;
        }
        BufferedImage bi = new BufferedImage(iconWidth, iconHeight, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double minValue = this.tracer.getMin(this.type);
        double maxValue = this.tracer.getMax(this.type);
        double range = this.tracer.getRange(this.type);
        g2.setColor(BACKGROUND_COLOR);
        g2.fillRect(0, 0, iconWidth, iconHeight);
        List stops = this.slider.getModel().getSortedThumbs();
        int len = stops.size();
        float[] fractions = null;
        Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float end = null;
        end = detail ? new Point2D.Float(iconWidth - 3, iconHeight - 30) : new Point2D.Float(iconWidth - 3, iconHeight - 9);
        if (len != 0) {
            fractions = new float[len + 2];
            Color[] colors = new Color[len + 2];
            int i = 1;
            colors[0] = this.below;
            fractions[0] = ((Thumb)stops.get(0)).getPosition() / 100.0f;
            for (Thumb thumb : stops) {
                colors[i] = (Color)thumb.getObject();
                fractions[i] = thumb.getPosition() / 100.0f;
                ++i;
            }
            colors[colors.length - 1] = this.above;
            fractions[fractions.length - 1] = ((Thumb)stops.get(stops.size() - 1)).getPosition() / 100.0f;
            CyGradientTrackRenderer.drawGradient(g2, start, end, fractions, colors);
        }
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(BORDER_COLOR);
        g2.drawRect(0, 0, ((Number)((Point2D)end).getX()).intValue(), ((Number)((Point2D)end).getY()).intValue());
        g2.setFont(ICON_FONT);
        String minStr = String.format("%.2f", minValue);
        String maxStr = String.format("%.2f", maxValue);
        g2.setColor(LABEL_COLOR);
        if (detail && fractions != null) {
            int strWidth;
            String fNum = null;
            for (int i = 0; i < fractions.length; ++i) {
                fNum = String.format("%.2f", (double)fractions[i] * range + minValue);
                strWidth = SwingUtilities.computeStringWidth(g2.getFontMetrics(), fNum);
                g2.drawString(fNum, fractions[i] * (float)iconWidth - (float)(strWidth / 2), (float)(iconHeight - 20));
            }
            g2.drawString(minStr, 0, iconHeight);
            strWidth = SwingUtilities.computeStringWidth(g2.getFontMetrics(), maxStr);
            g2.drawString(maxStr, iconWidth - strWidth - 2, iconHeight);
            g2.setFont(TITLE_FONT);
            int titleWidth = SwingUtilities.computeStringWidth(g2.getFontMetrics(), this.attrName);
            g2.setColor(LABEL_COLOR);
            g2.drawString(this.attrName, iconWidth / 2 - titleWidth / 2, iconHeight - 5);
            Polygon p = new Polygon();
            p.addPoint(iconWidth, iconHeight - 9);
            p.addPoint(iconWidth - 15, iconHeight - 15);
            p.addPoint(iconWidth - 15, iconHeight - 9);
            g2.fillPolygon(p);
            g2.drawLine(0, iconHeight - 9, iconWidth / 2 - titleWidth / 2 - 3, iconHeight - 9);
            g2.drawLine(iconWidth / 2 + titleWidth / 2 + 3, iconHeight - 9, iconWidth, iconHeight - 9);
        } else {
            g2.drawString(minStr, 0, iconHeight);
            int strWidth = SwingUtilities.computeStringWidth(g2.getFontMetrics(), maxStr);
            g2.drawString(maxStr, iconWidth - strWidth - 2, iconHeight);
        }
        return new ImageIcon(bi);
    }

    public Double getSelectedThumbValue() {
        float position = this.slider.getModel().getThumbAt(this.slider.getSelectedIndex()).getPosition();
        double thumbVal = (double)(position / 100.0f) * this.tracer.getRange(this.type) + this.tracer.getMin(this.type);
        return thumbVal;
    }
}

