/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.util.NumberConverter;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.EditorValueRangeTracer;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.VizMapTrackRenderer;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.multislider.Thumb;
import org.jdesktop.swingx.multislider.ThumbDataEvent;
import org.jdesktop.swingx.multislider.ThumbDataListener;

public class ContinuousTrackRenderer<K extends Number, V extends Number>
extends JComponent
implements VizMapTrackRenderer {
    private static final long serialVersionUID = 1202339877100033L;
    private final Color VALUE_AREA_COLOR;
    private final Color TRACK_COLOR;
    private static final Float UPPER_LIMIT = Float.valueOf(2000.0f);
    private static final int THUMB_WIDTH = 12;
    private static final int LEFT_SPACE = 50;
    private Map<Integer, Double> valueMap;
    private int trackHeight = 120;
    private int arrowBarPosition = this.trackHeight + 50;
    private float min;
    private float max;
    private boolean clickFlag;
    private boolean dragFlag;
    private Point curPoint;
    private JXMultiThumbSlider<V> slider;
    private CMouseListener listener;
    private Map<Integer, Point> verticesList;
    private int selectedIdx = -1;
    private String title;
    private V below;
    private V above;
    private List<V> values = new ArrayList<V>();
    private Polygon valueArea = new Polygon();
    private Point belowSquare;
    private Point aboveSquare;
    private final EditorValueRangeTracer tracer;
    private final VisualStyle style;
    private final VisualProperty<V> vp;
    private final ContinuousMapping<K, V> cMapping;
    private final Class<V> vpValueType;
    private final Class<K> columnType;
    private final ServicesUtil servicesUtil;

    public ContinuousTrackRenderer(VisualStyle style, ContinuousMapping<K, V> mapping, V below, V above, EditorValueRangeTracer tracer, ServicesUtil servicesUtil) {
        if (mapping == null) {
            throw new IllegalArgumentException("'mapping' must not be null.");
        }
        if (tracer == null) {
            throw new IllegalArgumentException("'tracer' must not be null.");
        }
        this.below = below;
        this.above = above;
        this.vp = mapping.getVisualProperty();
        this.tracer = tracer;
        this.style = style;
        this.servicesUtil = servicesUtil;
        this.cMapping = mapping;
        this.columnType = mapping.getMappingColumnType();
        this.vpValueType = mapping.getVisualProperty().getRange().getType();
        this.title = this.cMapping.getMappingColumnName();
        Color c = UIManager.getColor("CyColor.complement(+2)");
        this.VALUE_AREA_COLOR = new Color(c.getRed(), c.getGreen(), c.getBlue(), 60);
        this.TRACK_COLOR = UIManager.getColor("CyColor.complement(-1)");
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintComponent(g);
    }

    protected void removeSquare(Integer index) {
        this.verticesList.remove(index);
    }

    @Override
    protected void paintComponent(Graphics gfx) {
        this.trackHeight = this.slider.getHeight() - 100;
        this.arrowBarPosition = this.trackHeight + 50;
        Graphics2D g = (Graphics2D)gfx;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double minValue = this.tracer.getMin(this.vp);
        double maxValue = this.tracer.getMax(this.vp);
        int thumb_width = 12;
        int track_width = this.slider.getWidth() - thumb_width;
        g.translate(thumb_width / 2, 12);
        List stops = this.slider.getModel().getSortedThumbs();
        int numPoints = stops.size();
        float[] fractions = new float[numPoints];
        Double[] doubleValues = new Double[numPoints];
        int i = 0;
        this.values.clear();
        this.values.add(this.below);
        this.values.add(this.above);
        for (Thumb thumb : stops) {
            doubleValues[i] = ((Number)thumb.getObject()).doubleValue();
            fractions[i] = thumb.getPosition();
            this.values.add((Number)thumb.getObject());
            ++i;
        }
        for (Number val : this.values) {
            if (this.min >= val.floatValue()) {
                this.min = val.floatValue();
            }
            if (!(this.max <= val.floatValue())) continue;
            this.max = val.floatValue();
        }
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(LABEL_COLOR);
        g.drawLine(0, this.arrowBarPosition, track_width, this.arrowBarPosition);
        Polygon arrow = new Polygon();
        arrow.addPoint(track_width, this.arrowBarPosition);
        arrow.addPoint(track_width - 20, this.arrowBarPosition - 8);
        arrow.addPoint(track_width - 20, this.arrowBarPosition);
        g.fill(arrow);
        g.setColor(DISABLED_LABEL_COLOR);
        g.drawLine(0, this.arrowBarPosition, 15, this.arrowBarPosition - 30);
        g.drawLine(15, this.arrowBarPosition - 30, 25, this.arrowBarPosition - 30);
        g.setFont(SMALL_FONT);
        g.drawString("Min=" + minValue, 28, this.arrowBarPosition - 25);
        g.drawLine(track_width, this.arrowBarPosition, track_width - 15, this.arrowBarPosition + 30);
        g.drawLine(track_width - 15, this.arrowBarPosition + 30, track_width - 25, this.arrowBarPosition + 30);
        String maxStr = "Max=" + maxValue;
        int strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), maxStr);
        g.drawString(maxStr, track_width - strWidth - 26, this.arrowBarPosition + 35);
        g.setFont(DEF_FONT);
        g.setColor(LABEL_COLOR);
        strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), this.title);
        g.drawString(this.title, track_width / 2 - strWidth / 2, this.arrowBarPosition + 35);
        if (numPoints == 0) {
            g.setColor(BORDER_COLOR);
            g.setStroke(new BasicStroke(1.5f));
            g.drawRect(0, 5, track_width, this.trackHeight);
            return;
        }
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 5, track_width, this.trackHeight);
        int newX = 0;
        int lastY = 0;
        Point2D.Float p1 = new Point2D.Float(0.0f, 5.0f);
        Point2D.Float p2 = new Point2D.Float(0.0f, 5.0f);
        for (i = 0; i < doubleValues.length; ++i) {
            newX = (int)((float)track_width * (fractions[i] / 100.0f));
            ((Point2D)p2).setLocation(newX, 5.0);
            int newY = 5 + this.trackHeight - (int)(doubleValues[i].floatValue() / this.max * (float)this.trackHeight);
            this.valueArea.reset();
            g.setColor(this.VALUE_AREA_COLOR);
            if (i == 0) {
                int h = 5 + this.trackHeight - (int)(((Number)this.below).floatValue() / this.max * (float)this.trackHeight);
                g.fillRect(0, h, newX, (int)(((Number)this.below).floatValue() / this.max * (float)this.trackHeight));
                g.setColor(this.TRACK_COLOR);
                g.fillRect(-5, h - 5, 10, 10);
                this.belowSquare = new Point(0, h);
            } else {
                this.valueArea.addPoint((int)((Point2D)p1).getX(), lastY);
                this.valueArea.addPoint(newX, newY);
                this.valueArea.addPoint(newX, this.trackHeight + 5);
                this.valueArea.addPoint((int)((Point2D)p1).getX(), this.trackHeight + 5);
                g.fill(this.valueArea);
            }
            for (int j = 0; j < stops.size(); ++j) {
                Number tValue = (Number)this.slider.getModel().getThumbAt(j).getObject();
                if (tValue.doubleValue() != doubleValues[i].doubleValue()) continue;
                Point newPoint = new Point(newX, newY);
                if (this.verticesList.containsValue(newPoint)) break;
                this.verticesList.put(j, new Point(newX, newY));
                break;
            }
            lastY = newY;
            g.setColor(LABEL_COLOR);
            g.setStroke(new BasicStroke(1.5f));
            g.setFont(SMALL_FONT);
            int numberWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), doubleValues[i].toString());
            g.setColor(LABEL_COLOR);
            if (fractions[i] < 10.0f) {
                g.drawLine(newX, newY, newX + 15, newY - 35);
                g.drawString(doubleValues[i].toString(), newX + numberWidth, newY - 48);
            } else {
                g.drawLine(newX, newY, newX - 15, newY + 35);
                g.drawString(doubleValues[i].toString(), newX - (numberWidth + 5), newY + 48);
            }
            g.setColor(LABEL_COLOR);
            g.setFont(SMALL_FONT);
            Double curPositionValue = (double)(fractions[i] / 100.0f) * this.tracer.getRange(this.vp) + minValue;
            String valueString = String.format("%.4f", curPositionValue);
            int flipLimit = 90;
            int borderVal = track_width - newX;
            if (i % 2 == 0 && flipLimit < borderVal) {
                g.drawLine(newX, this.arrowBarPosition, newX + 20, this.arrowBarPosition - 15);
                g.drawLine(newX + 20, this.arrowBarPosition - 15, newX + 30, this.arrowBarPosition - 15);
                g.setColor(LABEL_COLOR);
                g.drawString(valueString, newX + 33, this.arrowBarPosition - 11);
            } else if (i % 2 == 1 && flipLimit < borderVal) {
                g.drawLine(newX, this.arrowBarPosition, newX + 20, this.arrowBarPosition + 15);
                g.drawLine(newX + 20, this.arrowBarPosition + 15, newX + 30, this.arrowBarPosition + 15);
                g.setColor(LABEL_COLOR);
                g.drawString(valueString, newX + 33, this.arrowBarPosition + 19);
            } else if (i % 2 == 0 && flipLimit >= borderVal) {
                g.drawLine(newX, this.arrowBarPosition, newX - 20, this.arrowBarPosition - 15);
                g.drawLine(newX - 20, this.arrowBarPosition - 15, newX - 30, this.arrowBarPosition - 15);
                g.setColor(LABEL_COLOR);
                g.drawString(valueString, newX - 90, this.arrowBarPosition - 11);
            } else {
                g.drawLine(newX, this.arrowBarPosition, newX - 20, this.arrowBarPosition + 15);
                g.drawLine(newX - 20, this.arrowBarPosition + 15, newX - 30, this.arrowBarPosition + 15);
                g.setColor(LABEL_COLOR);
                g.drawString(valueString, newX - 90, this.arrowBarPosition + 19);
            }
            g.setColor(LABEL_COLOR);
            g.fillOval(newX - 3, this.arrowBarPosition - 3, 6, 6);
            p1.setLocation(p2);
        }
        ((Point2D)p2).setLocation(track_width, 5.0);
        g.setColor(this.VALUE_AREA_COLOR);
        int h = 5 + this.trackHeight - (int)(((Number)this.above).floatValue() / this.max * (float)this.trackHeight);
        g.fillRect((int)((Point2D)p1).getX(), h, track_width - (int)((Point2D)p1).getX(), (int)(((Number)this.above).floatValue() / this.max * (float)this.trackHeight));
        g.setColor(this.TRACK_COLOR);
        g.fillRect(track_width - 5, h - 5, 10, 10);
        this.aboveSquare = new Point(track_width, h);
        g.setColor(BORDER_COLOR);
        g.setStroke(new BasicStroke(1.5f));
        g.drawRect(0, 5, track_width, this.trackHeight);
        g.setColor(this.TRACK_COLOR);
        g.setStroke(new BasicStroke(1.5f));
        for (Integer key : this.verticesList.keySet()) {
            Point p = this.verticesList.get(key);
            if (this.clickFlag) {
                int diffX = Math.abs(p.x - (this.curPoint.x - 6));
                int diffY = Math.abs(p.y - (this.curPoint.y - 12));
                if (diffX < 6 && diffY < 6 || key == this.selectedIdx) {
                    g.setColor(FOCUS_COLOR);
                    g.setStroke(new BasicStroke(2.5f));
                } else {
                    g.setColor(this.TRACK_COLOR);
                    g.setStroke(new BasicStroke(1.5f));
                }
            }
            g.drawRect(p.x - 5, p.y - 5, 10, 10);
        }
        g.translate(-6, -12);
    }

    public JComponent getRendererComponent(JXMultiThumbSlider slider) {
        if (this.slider != slider) {
            if (this.listener == null) {
                this.listener = new CMouseListener();
            }
            slider.addMouseListener((MouseListener)this.listener);
            slider.addMouseMotionListener((MouseMotionListener)new CMouseMotionListener());
            slider.getModel().addThumbDataListener(new ThumbDataListener(){

                public void thumbRemoved(ThumbDataEvent evt) {
                    if (ContinuousTrackRenderer.this.selectedIdx == evt.getIndex()) {
                        ContinuousTrackRenderer.this.selectedIdx = -1;
                    }
                }

                public void thumbAdded(ThumbDataEvent evt) {
                }

                public void positionChanged(ThumbDataEvent evt) {
                }

                public void valueChanged(ThumbDataEvent evt) {
                }
            });
            this.slider = slider;
        }
        if (this.verticesList == null) {
            this.verticesList = new HashMap<Integer, Point>();
        }
        if (this.valueMap == null) {
            this.valueMap = new HashMap<Integer, Double>();
        }
        return this;
    }

    public ImageIcon getTrackGraphicIcon(int iconWidth, int iconHeight) {
        return this.drawIcon(iconWidth, iconHeight, false);
    }

    public ImageIcon getLegend(int iconWidth, int iconHeight) {
        return this.drawIcon(iconWidth, iconHeight, true);
    }

    private ImageIcon drawIcon(int iconWidth, int iconHeight, boolean detail) {
        if (this.slider == null) {
            return null;
        }
        BufferedImage bi = new BufferedImage(iconWidth, iconHeight, 1);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double minValue = this.tracer.getMin(this.vp);
        double maxValue = this.tracer.getMax(this.vp);
        double valueRange = this.tracer.getRange(this.vp);
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 0, iconWidth, iconHeight);
        int leftSpace = 10;
        int trackHeight = iconHeight - 9;
        int trackWidth = iconWidth - leftSpace;
        List stops = this.slider.getModel().getSortedThumbs();
        int numPoints = stops.size();
        float[] fractions = new float[numPoints];
        Float[] floatProperty = new Float[numPoints];
        int i = 0;
        this.values.clear();
        this.values.add(this.below);
        this.values.add(this.above);
        for (Thumb thumb : stops) {
            floatProperty[i] = Float.valueOf(((Number)thumb.getObject()).floatValue());
            fractions[i] = thumb.getPosition();
            this.values.add((Number)thumb.getObject());
            ++i;
        }
        for (Number val : this.values) {
            if (this.min >= val.floatValue()) {
                this.min = val.floatValue();
            }
            if (!(this.max <= val.floatValue())) continue;
            this.max = val.floatValue();
        }
        g.setColor(LABEL_COLOR);
        g.setFont(ICON_FONT);
        int minWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), String.format("%.1f", Float.valueOf(this.min)));
        int maxWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), String.format("%.1f", Float.valueOf(this.max)));
        if (detail) {
            leftSpace = 50;
            trackHeight = iconHeight - 30;
        } else {
            leftSpace = Math.max(minWidth, maxWidth) + 1;
        }
        trackWidth = iconWidth - leftSpace;
        g.drawString(String.format("%.1f", Float.valueOf(this.min)), 0, trackHeight);
        g.drawString(String.format("%.1f", Float.valueOf(this.max)), 0, 8);
        if (numPoints == 0) {
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(LABEL_COLOR);
            g.drawRect(leftSpace, 0, trackWidth - 3, trackHeight);
            return new ImageIcon(bi);
        }
        g.translate(leftSpace, 0);
        g.setStroke(new BasicStroke(1.0f));
        int newX = 0;
        int lastY = 0;
        Point2D.Float p1 = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float p2 = new Point2D.Float(0.0f, 0.0f);
        for (i = 0; i < floatProperty.length; ++i) {
            newX = (int)((float)trackWidth * (fractions[i] / 100.0f)) - 3;
            if (newX < 0) {
                newX = 0;
            }
            ((Point2D)p2).setLocation(newX, 0.0);
            int newY = trackHeight - (int)(floatProperty[i].floatValue() / this.max * (float)trackHeight);
            this.valueArea.reset();
            g.setColor(this.VALUE_AREA_COLOR);
            if (i == 0) {
                int h = trackHeight - (int)(((Number)this.below).floatValue() / this.max * (float)trackHeight);
                g.fillRect(0, h, newX, (int)(((Number)this.below).floatValue() / this.max * (float)trackHeight));
            } else {
                this.valueArea.addPoint((int)((Point2D)p1).getX(), lastY);
                this.valueArea.addPoint(newX, newY);
                this.valueArea.addPoint(newX, trackHeight);
                this.valueArea.addPoint((int)((Point2D)p1).getX(), trackHeight);
                g.fill(this.valueArea);
            }
            for (int j = 0; j < stops.size(); ++j) {
                if (this.slider.getModel().getThumbAt(j).getObject() != floatProperty[i]) continue;
                Point newPoint = new Point(newX, newY);
                if (this.verticesList.containsValue(newPoint)) break;
                this.verticesList.put(j, new Point(newX, newY));
                break;
            }
            lastY = newY;
            p1.setLocation(p2);
        }
        ((Point2D)p2).setLocation(trackWidth, 0.0);
        g.setColor(this.VALUE_AREA_COLOR);
        int h = trackHeight - (int)(((Number)this.above).floatValue() / this.max * (float)trackHeight);
        g.fillRect((int)((Point2D)p1).getX(), h, trackWidth - (int)((Point2D)p1).getX() - 3, (int)(((Number)this.above).floatValue() / this.max * (float)trackHeight));
        g.translate(-leftSpace, 0);
        g.setColor(BORDER_COLOR);
        g.setStroke(new BasicStroke(1.0f));
        g.drawRect(leftSpace, 0, trackWidth - 3, trackHeight);
        g.setFont(ICON_FONT);
        String minStr = String.format("%.2f", minValue);
        String maxStr = String.format("%.2f", maxValue);
        g.setColor(LABEL_COLOR);
        if (detail) {
            int strWidth;
            String fNum = null;
            for (int j = 0; j < fractions.length; ++j) {
                fNum = String.format("%.2f", (double)(fractions[j] / 100.0f) * valueRange + minValue);
                strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), fNum);
                g.drawString(fNum, fractions[j] / 100.0f * (float)trackWidth - (float)(strWidth / 2) + (float)leftSpace, (float)(iconHeight - 20));
            }
            g.drawString(minStr, leftSpace, iconHeight);
            strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), maxStr);
            g.drawString(maxStr, iconWidth - strWidth - 2, iconHeight);
            g.setFont(TITLE_FONT);
            int titleWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), this.title);
            g.setColor(LABEL_COLOR);
            g.drawString(this.title, iconWidth / 2 - titleWidth / 2, iconHeight - 5);
            Polygon p = new Polygon();
            p.addPoint(iconWidth, iconHeight - 9);
            p.addPoint(iconWidth - 15, iconHeight - 15);
            p.addPoint(iconWidth - 15, iconHeight - 9);
            g.fillPolygon(p);
            g.drawLine(leftSpace, iconHeight - 9, (iconWidth - leftSpace) / 2 - titleWidth / 2 - 3, iconHeight - 9);
            g.drawLine(iconWidth / 2 + titleWidth / 2 + 3, iconHeight - 9, iconWidth, iconHeight - 9);
            int panelHeight = iconHeight - 30;
            Polygon poly = new Polygon();
            int top = 0;
            g.setStroke(new BasicStroke(1.0f));
            int center = leftSpace / 2 + 6;
            poly.addPoint(center, top);
            poly.addPoint(center - 6, top + 15);
            poly.addPoint(center, top + 15);
            g.fillPolygon(poly);
            g.drawLine(center, top, center, panelHeight);
            g.setColor(LABEL_COLOR);
            g.setFont(SMALL_FONT);
            String label = this.vp.getDisplayName();
            int width = SwingUtilities.computeStringWidth(g.getFontMetrics(), label);
            AffineTransform af = new AffineTransform();
            af.rotate(4.71238898038469);
            g.setTransform(af);
            g.setColor(LABEL_COLOR);
            g.drawString(this.vp.getDisplayName(), -panelHeight / 2 - width / 2, leftSpace / 2 + 5);
        } else {
            g.drawString(minStr, 0, iconHeight);
            int strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), maxStr);
            g.drawString(maxStr, iconWidth - strWidth - 2, iconHeight);
        }
        return new ImageIcon(bi);
    }

    class CMouseListener
    extends MouseAdapter {
        CMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.isPointerInSquare(e) && e.getClickCount() == 2) {
                Double newVal;
                String val = JOptionPane.showInputDialog(ContinuousTrackRenderer.this.slider, (Object)"Please type new value for this pivot.");
                if (val == null) {
                    return;
                }
                try {
                    newVal = Double.valueOf(val);
                }
                catch (Exception ne) {
                    return;
                }
                if (ContinuousTrackRenderer.this.selectedIdx >= 0 && ContinuousTrackRenderer.this.slider.getModel().getThumbCount() > ContinuousTrackRenderer.this.selectedIdx) {
                    ContinuousTrackRenderer.this.slider.getModel().getThumbAt(ContinuousTrackRenderer.this.selectedIdx).setObject((Object)newVal);
                }
                this.updateMax();
                ContinuousMappingPoint point = ContinuousTrackRenderer.this.selectedIdx >= 0 && ContinuousTrackRenderer.this.cMapping.getPointCount() > ContinuousTrackRenderer.this.selectedIdx ? ContinuousTrackRenderer.this.cMapping.getPoint(ContinuousTrackRenderer.this.selectedIdx) : null;
                Double lesserVal = point != null ? (Number)((Number)point.getRange().lesserValue) : (Number)newVal;
                Double greaterVal = point != null ? (Number)((Number)point.getRange().greaterValue) : (Number)newVal;
                int numPoints = ContinuousTrackRenderer.this.cMapping.getAllPoints().size();
                if (numPoints > 1) {
                    if (ContinuousTrackRenderer.this.selectedIdx == 0) {
                        greaterVal = newVal;
                    } else if (ContinuousTrackRenderer.this.selectedIdx == numPoints - 1) {
                        lesserVal = newVal;
                    } else {
                        lesserVal = newVal;
                        greaterVal = newVal;
                    }
                }
                BoundaryRangeValues brv = new BoundaryRangeValues((Object)((Number)NumberConverter.convert(ContinuousTrackRenderer.this.vpValueType, lesserVal)), (Object)((Number)NumberConverter.convert(ContinuousTrackRenderer.this.vpValueType, newVal)), (Object)((Number)NumberConverter.convert(ContinuousTrackRenderer.this.vpValueType, greaterVal)));
                if (point != null) {
                    point.setRange(brv);
                }
                ContinuousTrackRenderer.this.repaint();
                ContinuousTrackRenderer.this.slider.repaint();
                ContinuousTrackRenderer.this.repaint();
            } else if (e.getClickCount() == 2 && this.isBelow(e.getPoint())) {
                String val = JOptionPane.showInputDialog(ContinuousTrackRenderer.this.slider, (Object)"Please type new value for BELOW:");
                if (val == null) {
                    return;
                }
                try {
                    ContinuousTrackRenderer.this.below = Double.valueOf(val);
                }
                catch (Exception ne) {
                    return;
                }
                Object newValue = ContinuousTrackRenderer.this.below;
                BoundaryRangeValues original = ContinuousTrackRenderer.this.cMapping.getPoint(0).getRange();
                BoundaryRangeValues brv = new BoundaryRangeValues((Object)((Number)NumberConverter.convert(ContinuousTrackRenderer.this.vpValueType, newValue)), (Object)((Number)NumberConverter.convert(ContinuousTrackRenderer.this.vpValueType, (Number)original.equalValue)), (Object)((Number)NumberConverter.convert(ContinuousTrackRenderer.this.vpValueType, (Number)original.greaterValue)));
                ContinuousTrackRenderer.this.cMapping.getPoint(0).setRange(brv);
                ContinuousTrackRenderer.this.slider.repaint();
                ContinuousTrackRenderer.this.repaint();
                ContinuousTrackRenderer.this.firePropertyChange("BELOW_VALUE_CHANGED", null, ContinuousTrackRenderer.this.below);
            } else if (e.getClickCount() == 2 && this.isAbove(e.getPoint())) {
                String val = JOptionPane.showInputDialog(ContinuousTrackRenderer.this.slider, (Object)"Please type new value for ABOVE:");
                if (val == null) {
                    return;
                }
                try {
                    ContinuousTrackRenderer.this.above = Double.valueOf(val);
                }
                catch (Exception ne) {
                    return;
                }
                BoundaryRangeValues original = ContinuousTrackRenderer.this.cMapping.getPoint(ContinuousTrackRenderer.this.cMapping.getPointCount() - 1).getRange();
                BoundaryRangeValues brv = new BoundaryRangeValues((Object)((Number)NumberConverter.convert(ContinuousTrackRenderer.this.vpValueType, (Number)original.lesserValue)), (Object)((Number)NumberConverter.convert(ContinuousTrackRenderer.this.vpValueType, (Number)original.equalValue)), (Object)((Number)NumberConverter.convert(ContinuousTrackRenderer.this.vpValueType, ContinuousTrackRenderer.this.above)));
                ContinuousTrackRenderer.this.cMapping.getPoint(ContinuousTrackRenderer.this.cMapping.getPointCount() - 1).setRange(brv);
                ContinuousTrackRenderer.this.slider.repaint();
                ContinuousTrackRenderer.this.repaint();
                ContinuousTrackRenderer.this.firePropertyChange("ABOVE_VALUE_CHANGED", null, ContinuousTrackRenderer.this.above);
            }
        }

        private boolean isBelow(Point p) {
            if (ContinuousTrackRenderer.this.belowSquare == null) {
                return false;
            }
            int diffY = Math.abs(p.y - 12 - ContinuousTrackRenderer.this.belowSquare.y);
            int diffX = Math.abs(p.x - 6 - ContinuousTrackRenderer.this.belowSquare.x);
            return diffX < 6 && diffY < 6;
        }

        private boolean isAbove(Point p) {
            if (ContinuousTrackRenderer.this.aboveSquare == null) {
                return false;
            }
            int diffY = Math.abs(p.y - 12 - ContinuousTrackRenderer.this.aboveSquare.y);
            int diffX = Math.abs(p.x - 6 - ContinuousTrackRenderer.this.aboveSquare.x);
            return diffX < 6 && diffY < 6;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ContinuousTrackRenderer.this.curPoint = e.getPoint();
            for (Integer key : ContinuousTrackRenderer.this.verticesList.keySet()) {
                Point p = ContinuousTrackRenderer.this.verticesList.get(key);
                int diffY = Math.abs(p.y + 12 - ContinuousTrackRenderer.this.curPoint.y);
                int diffX = Math.abs(p.x + 6 - ContinuousTrackRenderer.this.curPoint.x);
                if (diffX >= 6 || diffY >= 6) continue;
                ContinuousTrackRenderer.this.selectedIdx = key;
                ContinuousTrackRenderer.this.clickFlag = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ContinuousTrackRenderer.this.clickFlag = false;
            this.updateMax();
            if (ContinuousTrackRenderer.this.slider.getSelectedThumb() == null) {
                ContinuousTrackRenderer.this.slider.repaint();
            }
            ContinuousTrackRenderer.this.dragFlag = false;
            ContinuousTrackRenderer.this.repaint();
        }

        private boolean isPointerInSquare(MouseEvent e) {
            ContinuousTrackRenderer.this.curPoint = e.getPoint();
            for (Integer key : ContinuousTrackRenderer.this.verticesList.keySet()) {
                Point p = ContinuousTrackRenderer.this.verticesList.get(key);
                int diffY = Math.abs(p.y + 12 - ContinuousTrackRenderer.this.curPoint.y);
                int diffX = Math.abs(p.x + 6 - ContinuousTrackRenderer.this.curPoint.x);
                if (diffX >= 6 || diffY >= 6) continue;
                ContinuousTrackRenderer.this.selectedIdx = key;
                return true;
            }
            return false;
        }

        private void updateMax() {
            Float curMax = Float.valueOf(0.0f);
            for (Thumb thumb : ContinuousTrackRenderer.this.slider.getModel().getSortedThumbs()) {
                Number val = (Number)thumb.getObject();
                if (!(val.floatValue() > curMax.floatValue())) continue;
                curMax = Float.valueOf(val.floatValue());
            }
            ContinuousTrackRenderer.this.max = curMax.floatValue();
        }
    }

    class CMouseMotionListener
    implements MouseMotionListener {
        CMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.getY() < 12 && !ContinuousTrackRenderer.this.dragFlag) {
                return;
            }
            ContinuousTrackRenderer.this.dragFlag = true;
            ContinuousTrackRenderer.this.curPoint = e.getPoint();
            if (ContinuousTrackRenderer.this.clickFlag && ContinuousTrackRenderer.this.selectedIdx >= 0 && ContinuousTrackRenderer.this.slider.getModel().getThumbCount() > ContinuousTrackRenderer.this.selectedIdx) {
                Thumb selectedThumb = ContinuousTrackRenderer.this.slider.getModel().getThumbAt(ContinuousTrackRenderer.this.selectedIdx);
                Double zero = 0.0;
                if (ContinuousTrackRenderer.this.curPoint.getY() >= (double)(ContinuousTrackRenderer.this.trackHeight + 5)) {
                    selectedThumb.setObject((Object)zero);
                    return;
                }
                double curY = ContinuousTrackRenderer.this.curPoint.getY();
                Number newY = ((double)(ContinuousTrackRenderer.this.trackHeight + 5) - curY) * (double)ContinuousTrackRenderer.this.max / (double)(ContinuousTrackRenderer.this.trackHeight + 5);
                if (newY > (double)UPPER_LIMIT.floatValue()) {
                    newY = UPPER_LIMIT;
                }
                selectedThumb.setObject((Object)newY);
                Number newVal = newY;
                ContinuousMappingPoint point = ContinuousTrackRenderer.this.selectedIdx >= 0 && ContinuousTrackRenderer.this.cMapping.getPointCount() > ContinuousTrackRenderer.this.selectedIdx ? ContinuousTrackRenderer.this.cMapping.getPoint(ContinuousTrackRenderer.this.selectedIdx) : null;
                Number lesserVal = point != null ? (Number)((Number)point.getRange().lesserValue) : (Number)newVal;
                Number greaterVal = point != null ? (Number)((Number)point.getRange().greaterValue) : (Number)newVal;
                int numPoints = ContinuousTrackRenderer.this.cMapping.getAllPoints().size();
                if (numPoints > 1) {
                    if (ContinuousTrackRenderer.this.selectedIdx == 0) {
                        greaterVal = newVal;
                    } else if (ContinuousTrackRenderer.this.selectedIdx == numPoints - 1) {
                        lesserVal = newVal;
                    } else {
                        lesserVal = newVal;
                        greaterVal = newVal;
                    }
                }
                BoundaryRangeValues brv = new BoundaryRangeValues((Object)((Number)NumberConverter.convert(ContinuousTrackRenderer.this.vpValueType, lesserVal)), (Object)((Number)NumberConverter.convert(ContinuousTrackRenderer.this.vpValueType, newVal)), (Object)((Number)NumberConverter.convert(ContinuousTrackRenderer.this.vpValueType, greaterVal)));
                if (point != null) {
                    point.setRange(brv);
                }
            }
            ContinuousTrackRenderer.this.slider.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent arg0) {
        }
    }
}

