/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor;

import com.l2fprod.common.propertysheet.PropertyEditorRegistry;
import java.awt.Component;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JOptionPane;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetCurrentRenderingEngineListener;
import org.cytoscape.application.swing.CyColumnPresentationManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.ContinuousRange;
import org.cytoscape.view.model.DiscreteRange;
import org.cytoscape.view.model.Range;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.presentation.property.values.ArrowShape;
import org.cytoscape.view.presentation.property.values.LineType;
import org.cytoscape.view.presentation.property.values.VisualPropertyValue;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.gui.editor.ContinuousEditorType;
import org.cytoscape.view.vizmap.gui.editor.ContinuousMappingCellRendererFactory;
import org.cytoscape.view.vizmap.gui.editor.EditorManager;
import org.cytoscape.view.vizmap.gui.editor.ListEditor;
import org.cytoscape.view.vizmap.gui.editor.ValueEditor;
import org.cytoscape.view.vizmap.gui.editor.VisualPropertyEditor;
import org.cytoscape.view.vizmap.gui.editor.VisualPropertyValueEditor;
import org.cytoscape.view.vizmap.gui.internal.model.AttributeSetProxy;
import org.cytoscape.view.vizmap.gui.internal.model.MappingFunctionFactoryProxy;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.editor.DiscreteValueVisualPropertyEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.C2CEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.C2DEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.GradientEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor.AttributeComboBoxPropertyEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor.CyComboBoxPropertyEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor.CyDiscreteValuePropertyEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor.MappingTypeComboBoxPropertyEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.valueeditor.DiscreteValueEditor;

public class EditorManagerImpl
implements EditorManager {
    private static final PropertyEditorRegistry REGISTRY = new PropertyEditorRegistry();
    private static final Map<Class<? extends VisualPropertyValue>, Integer> ICON_WIDTH_MAP = new HashMap<Class<? extends VisualPropertyValue>, Integer>();
    private static final int ICON_W = 14;
    private static final int ICON_H = 14;
    private final Map<Class<?>, VisualPropertyEditor<?>> editors;
    private final Map<String, PropertyEditor> comboBoxEditors;
    private final Map<Class<?>, ListEditor> attrComboBoxEditors;
    private final Map<Class<?>, ValueEditor<?>> valueEditors;
    private final Map<Class<?>, VisualPropertyValueEditor<?>> vizPropValueEditors;
    private final PropertyEditor mappingTypeEditor;
    private final ServicesUtil servicesUtil;
    private final Object mutex = new Object();

    public EditorManagerImpl(AttributeSetProxy attrProxy, MappingFunctionFactoryProxy mappingFactoryProxy, ServicesUtil servicesUtil) {
        this.servicesUtil = servicesUtil;
        this.editors = new HashMap();
        this.comboBoxEditors = new HashMap<String, PropertyEditor>();
        this.valueEditors = new HashMap();
        this.vizPropValueEditors = new HashMap();
        CyApplicationManager appMgr = servicesUtil.get(CyApplicationManager.class);
        CyNetworkManager netMgr = servicesUtil.get(CyNetworkManager.class);
        CyColumnPresentationManager presMgr = servicesUtil.get(CyColumnPresentationManager.class);
        AttributeComboBoxPropertyEditor nodeAttrEditor = new AttributeComboBoxPropertyEditor(CyNode.class, attrProxy, appMgr, netMgr, presMgr);
        AttributeComboBoxPropertyEditor edgeAttrEditor = new AttributeComboBoxPropertyEditor(CyEdge.class, attrProxy, appMgr, netMgr, presMgr);
        AttributeComboBoxPropertyEditor networkAttrEditor = new AttributeComboBoxPropertyEditor(CyNetwork.class, attrProxy, appMgr, netMgr, presMgr);
        AttributeComboBoxPropertyEditor columnAttrEditor = new AttributeComboBoxPropertyEditor(CyColumn.class, attrProxy, appMgr, netMgr, presMgr);
        this.attrComboBoxEditors = new HashMap();
        this.attrComboBoxEditors.put(nodeAttrEditor.getTargetObjectType(), nodeAttrEditor);
        this.attrComboBoxEditors.put(edgeAttrEditor.getTargetObjectType(), edgeAttrEditor);
        this.attrComboBoxEditors.put(networkAttrEditor.getTargetObjectType(), networkAttrEditor);
        this.attrComboBoxEditors.put(columnAttrEditor.getTargetObjectType(), columnAttrEditor);
        this.mappingTypeEditor = new MappingTypeComboBoxPropertyEditor(mappingFactoryProxy);
        this.comboBoxEditors.put("mappingTypeEditor", this.mappingTypeEditor);
        VisualMappingManager vmMgr = servicesUtil.get(VisualMappingManager.class);
        Set lexSet = vmMgr.getAllVisualLexicon();
        for (VisualLexicon lex : lexSet) {
            this.buildDiscreteEditors(lex);
        }
    }

    public AttributeComboBoxPropertyEditor getNodeEditor() {
        return (AttributeComboBoxPropertyEditor)this.attrComboBoxEditors.get(CyNode.class);
    }

    public AttributeComboBoxPropertyEditor getEdgeEditor() {
        return (AttributeComboBoxPropertyEditor)this.attrComboBoxEditors.get(CyEdge.class);
    }

    public AttributeComboBoxPropertyEditor getNetworkEditor() {
        return (AttributeComboBoxPropertyEditor)this.attrComboBoxEditors.get(CyNetwork.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValueEditor(ValueEditor<?> ve, Map properties) {
        Object object = this.mutex;
        synchronized (object) {
            this.valueEditors.put(ve.getValueType(), ve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValueEditor(ValueEditor<?> ve, Map properties) {
        Object object = this.mutex;
        synchronized (object) {
            this.valueEditors.remove(ve.getValueType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVisualPropertyValueEditor(VisualPropertyValueEditor<?> ve, Map properties) {
        Object object = this.mutex;
        synchronized (object) {
            this.vizPropValueEditors.put(ve.getValueType(), ve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVisualPropertyValueEditor(VisualPropertyValueEditor<?> ve, Map properties) {
        Object object = this.mutex;
        synchronized (object) {
            this.vizPropValueEditors.remove(ve.getValueType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVisualPropertyEditor(VisualPropertyEditor<?> vpEditor, Map properties) {
        Object object = this.mutex;
        synchronized (object) {
            this.editors.put(vpEditor.getType(), vpEditor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVisualPropertyEditor(VisualPropertyEditor<?> vpEditor, Map properties) {
        Object object = this.mutex;
        synchronized (object) {
            this.editors.remove(vpEditor.getType());
        }
    }

    @Override
    public <V> V showVisualPropertyValueEditor(Component parentComponent, VisualProperty<V> type, V initialValue) throws Exception {
        V newValue = null;
        Class valueType = type.getRange().getType();
        VisualPropertyValueEditor<?> vizPropEditor = this.vizPropValueEditors.get(valueType);
        ValueEditor<?> editor = this.valueEditors.get(valueType);
        if (vizPropEditor != null) {
            newValue = (V)vizPropEditor.showEditor(parentComponent, initialValue, type);
        } else if (editor != null) {
            newValue = (V)editor.showEditor(parentComponent, initialValue);
        } else {
            throw new IllegalStateException("No value editor for " + type.getDisplayName() + " is available.");
        }
        if (newValue == null) {
            return null;
        }
        if (type.getRange().inRange(newValue)) {
            return newValue;
        }
        Object message = "Value is out-of-range.";
        if (type.getRange() instanceof ContinuousRange) {
            message = (String)message + ": " + ((ContinuousRange)type.getRange()).getMin() + " to " + ((ContinuousRange)type.getRange()).getMax();
        }
        JOptionPane.showMessageDialog(parentComponent, message, "Invalid Value", 0);
        return initialValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> VisualPropertyEditor<V> getVisualPropertyEditor(VisualProperty<V> vp) {
        Object object = this.mutex;
        synchronized (object) {
            return this.editors.get(vp.getRange().getType());
        }
    }

    @Override
    public List<PropertyEditor> getCellEditors() {
        ArrayList<PropertyEditor> ret = new ArrayList<PropertyEditor>();
        for (Class<?> type : this.editors.keySet()) {
            ret.add(this.editors.get(type).getPropertyEditor());
        }
        return ret;
    }

    @Override
    public PropertyEditor getDefaultComboBoxEditor(String editorName) {
        Object editor = this.comboBoxEditors.get(editorName);
        if (editor == null) {
            editor = new CyComboBoxPropertyEditor();
            this.comboBoxEditors.put(editorName, (PropertyEditor)editor);
        }
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> ValueEditor<V> getValueEditor(Class<V> dataType) {
        Object object = this.mutex;
        synchronized (object) {
            return this.valueEditors.get(dataType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> VisualPropertyValueEditor<V> getVisualPropertyValueEditor(VisualProperty<V> vp) {
        Object object = this.mutex;
        synchronized (object) {
            return this.vizPropValueEditors.get(vp.getRange().getType());
        }
    }

    @Override
    public PropertyEditor getDataTableComboBoxEditor(Class<? extends CyIdentifiable> targetObjectType) {
        ListEditor editor = this.attrComboBoxEditors.get(targetObjectType);
        if (editor == null) {
            throw new IllegalArgumentException("No such list editor: " + targetObjectType);
        }
        return (PropertyEditor)((Object)editor);
    }

    @Override
    public Collection<PropertyEditor> getAttributeSelectors() {
        HashSet<PropertyEditor> selectors = new HashSet<PropertyEditor>();
        for (ListEditor selector : this.attrComboBoxEditors.values()) {
            selectors.add((PropertyEditor)((Object)selector));
        }
        return selectors;
    }

    @Override
    public PropertyEditor getMappingFunctionSelector() {
        return this.mappingTypeEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> void buildDiscreteEditors(VisualLexicon lexicon) {
        Set vps = lexicon.getAllVisualProperties();
        for (VisualProperty vp : vps) {
            Range range = vp.getRange();
            Class targetDataType = range.getType();
            Object object = this.mutex;
            synchronized (object) {
                if (REGISTRY.getEditor(targetDataType) != null) {
                    continue;
                }
                if (this.getVisualPropertyEditor(vp) != null) {
                    continue;
                }
                if (range instanceof DiscreteRange) {
                    DiscreteValueEditor valEditor = (DiscreteValueEditor)this.getVisualPropertyValueEditor(vp);
                    if (valEditor == null) {
                        valEditor = new DiscreteValueEditor(range.getType(), ((DiscreteRange)range).values(), this.servicesUtil);
                        this.addVisualPropertyValueEditor(valEditor, null);
                    }
                    CyDiscreteValuePropertyEditor discretePropEditor = new CyDiscreteValuePropertyEditor(valEditor);
                    Set values = ((DiscreteRange)range).values();
                    Integer width = ICON_WIDTH_MAP.get(range.getType());
                    if (width == null) {
                        width = 14;
                    }
                    ContinuousMappingCellRendererFactory cellRendererFactory = this.servicesUtil.get(ContinuousMappingCellRendererFactory.class);
                    DiscreteValueVisualPropertyEditor vpEditor = new DiscreteValueVisualPropertyEditor(range.getType(), discretePropEditor, cellRendererFactory, values, width, 14);
                    this.addVisualPropertyEditor(vpEditor, null);
                    this.servicesUtil.registerService(vpEditor, SetCurrentRenderingEngineListener.class, new Properties());
                }
            }
        }
    }

    public void addRenderingEngineFactory(RenderingEngineFactory<?> factory, Map<?, ?> props) {
        VisualLexicon lexicon = factory.getVisualLexicon();
        this.buildDiscreteEditors(lexicon);
    }

    public void removeRenderingEngineFactory(RenderingEngineFactory<?> factory, Map<?, ?> props) {
    }

    @Override
    public PropertyEditor getContinuousEditor(VisualProperty<?> vp) {
        ContinuousEditorType editorType = this.getVisualPropertyEditor(vp).getContinuousEditorType();
        if (editorType == ContinuousEditorType.COLOR) {
            return new GradientEditor(this, this.servicesUtil);
        }
        if (editorType == ContinuousEditorType.CONTINUOUS) {
            return new C2CEditor(this, this.servicesUtil);
        }
        if (editorType == ContinuousEditorType.DISCRETE) {
            return new C2DEditor(this, this.servicesUtil);
        }
        return null;
    }

    static {
        ICON_WIDTH_MAP.put(LineType.class, 42);
        ICON_WIDTH_MAP.put(ArrowShape.class, 42);
    }
}

