/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor;

import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.cytoscape.application.events.SetCurrentRenderingEngineEvent;
import org.cytoscape.application.events.SetCurrentRenderingEngineListener;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.vizmap.gui.editor.ContinuousEditorType;
import org.cytoscape.view.vizmap.gui.editor.ContinuousMappingCellRendererFactory;
import org.cytoscape.view.vizmap.gui.editor.VisualPropertyEditor2;
import org.cytoscape.view.vizmap.gui.internal.view.cellrenderer.IconCellRenderer;
import org.cytoscape.view.vizmap.gui.internal.view.editor.BasicVisualPropertyEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor.CyDiscreteValuePropertyEditor;

public class DiscreteValueVisualPropertyEditor<T>
extends BasicVisualPropertyEditor<T>
implements VisualPropertyEditor2<T>,
SetCurrentRenderingEngineListener {
    private final Set<T> values;
    private final int iconW;
    private final int iconH;

    public DiscreteValueVisualPropertyEditor(Class<T> type, CyDiscreteValuePropertyEditor<T> propEditor, ContinuousMappingCellRendererFactory cellRendererFactory, Set<T> values, int iconW, int iconH) {
        super(type, (PropertyEditor)((Object)propEditor), ContinuousEditorType.DISCRETE, cellRendererFactory);
        this.values = new HashSet<T>(values);
        this.iconH = iconH;
        this.iconW = iconW;
        this.discreteTableCellRenderer = REG.getRenderer(type);
    }

    public void handleEvent(SetCurrentRenderingEngineEvent e) {
        RenderingEngine engine = e.getRenderingEngine();
        if (engine == null) {
            return;
        }
        HashMap<T, Icon> iconMap = new HashMap<T, Icon>();
        for (T value : this.values) {
            iconMap.put(value, engine.createIcon(null, value, this.iconW, this.iconH));
        }
        this.discreteTableCellRenderer = new IconCellRenderer(iconMap);
    }

    @Override
    public PropertyEditor getPropertyEditor() {
        CyDiscreteValuePropertyEditor pe = (CyDiscreteValuePropertyEditor)((Object)super.getPropertyEditor());
        pe.setVisualProperty(null);
        return pe;
    }

    @Override
    public PropertyEditor getPropertyEditor(VisualProperty<T> vp) {
        CyDiscreteValuePropertyEditor pe = (CyDiscreteValuePropertyEditor)((Object)super.getPropertyEditor());
        pe.setVisualProperty(vp);
        return pe;
    }
}

