/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.cellrenderer;

import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;

public class FontCellRenderer
extends DefaultCellRenderer {
    private static final float FONT_SIZE = 12.0f;

    public FontCellRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setBackground(isSelected ? UIManager.getColor("Table.selectionBackground") : UIManager.getColor("Table.background"));
        String label = this.convertToString(value);
        this.setText(label);
        this.setToolTipText(label);
        if (value instanceof Font) {
            this.setFont(((Font)value).deriveFont(12.0f));
        }
        return this;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
        this.setText(this.convertToString(value));
        if (value instanceof Font) {
            this.setFont(((Font)value).deriveFont(12.0f));
        }
        return this;
    }

    protected String convertToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Font) {
            Font font = (Font)value;
            return font.getFontName();
        }
        return "-- Unknown Font --";
    }
}

