/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuListener;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.event.DebounceTimer;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.events.ColumnCreatedEvent;
import org.cytoscape.model.events.ColumnCreatedListener;
import org.cytoscape.model.events.ColumnDeletedEvent;
import org.cytoscape.model.events.ColumnDeletedListener;
import org.cytoscape.model.events.ColumnNameChangedEvent;
import org.cytoscape.model.events.ColumnNameChangedListener;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.events.UpdateNetworkPresentationEvent;
import org.cytoscape.view.model.events.UpdateNetworkPresentationListener;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.DefaultVisualizableVisualProperty;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.events.VisualMappingFunctionChangedEvent;
import org.cytoscape.view.vizmap.events.VisualMappingFunctionChangedListener;
import org.cytoscape.view.vizmap.gui.editor.EditorManager;
import org.cytoscape.view.vizmap.gui.event.LexiconStateChangedEvent;
import org.cytoscape.view.vizmap.gui.event.LexiconStateChangedListener;
import org.cytoscape.view.vizmap.gui.internal.VizMapperProperty;
import org.cytoscape.view.vizmap.gui.internal.action.GenerateDiscreteValuesAction;
import org.cytoscape.view.vizmap.gui.internal.model.AttributeSetProxy;
import org.cytoscape.view.vizmap.gui.internal.model.LockedValueState;
import org.cytoscape.view.vizmap.gui.internal.model.LockedValuesVO;
import org.cytoscape.view.vizmap.gui.internal.model.MappingFunctionFactoryProxy;
import org.cytoscape.view.vizmap.gui.internal.model.PropsProxy;
import org.cytoscape.view.vizmap.gui.internal.model.VizMapperProxy;
import org.cytoscape.view.vizmap.gui.internal.util.ServicePropertiesUtil;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheet;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItem;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItemModel;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetModel;
import org.cytoscape.view.vizmap.gui.internal.view.VisualStylePanelProvider;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapPropertyBuilder;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapperMainPanel;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.ContinuousMappingEditorPanel;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.EditorValueRangeTracer;
import org.cytoscape.view.vizmap.gui.internal.view.util.ViewUtil;
import org.cytoscape.view.vizmap.gui.util.DiscreteMappingGenerator;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.swing.DialogTaskManager;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;
import org.puremvc.java.multicore.interfaces.INotification;
import org.puremvc.java.multicore.patterns.mediator.Mediator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VizMapperMediator
extends Mediator
implements LexiconStateChangedListener,
RowsSetListener,
ColumnCreatedListener,
ColumnDeletedListener,
ColumnNameChangedListener,
UpdateNetworkPresentationListener,
VisualMappingFunctionChangedListener {
    public static final String NAME = "VizMapperMediator";
    static final List<Class<? extends CyIdentifiable>> NETWORK_SHEET_TYPES = Arrays.asList(CyNode.class, CyEdge.class, CyNetwork.class);
    static final List<Class<? extends CyIdentifiable>> TABLE_SHEET_TYPES = Arrays.asList(CyColumn.class);
    private VizMapperProxy vmProxy;
    private AttributeSetProxy attrProxy;
    private MappingFunctionFactoryProxy mappingFactoryProxy;
    private PropsProxy propsProxy;
    private boolean ignoreVisualStyleSelectedEvents;
    private VisualPropertySheetItem<?> curVpSheetItem;
    private VizMapperProperty<?, ?, ?> curVizMapperProperty;
    private Map<Long, Long> selectedColumns;
    private ActionListener tableChangeListener;
    private ActionListener columnChangeListener;
    private String curRendererId;
    private final ServicesUtil servicesUtil;
    private final VizMapperMainPanel vizMapperMainPanel;
    private final VizMapPropertyBuilder vizMapPropertyBuilder;
    private final Map<String, GenerateDiscreteValuesAction> mappingGenerators;
    private final Map<TaskFactory, JMenuItem> taskFactories;
    private final Map<CyAction, JMenuItem> actions;
    private final Map<String, Boolean> userProps;
    private final Map<Class<? extends CyIdentifiable>, Set<String>> defVisibleProps;
    private final DebounceTimer debounceTimer = new DebounceTimer(240);
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public VizMapperMediator(VizMapperMainPanel vizMapperMainPanel, ServicesUtil servicesUtil, VizMapPropertyBuilder vizMapPropertyBuilder) {
        super(NAME, (Object)vizMapperMainPanel);
        this.vizMapperMainPanel = Objects.requireNonNull(vizMapperMainPanel, "'vizMapperMainPanel' must not be null");
        this.servicesUtil = Objects.requireNonNull(servicesUtil, "'servicesUtil' must not be null");
        this.vizMapPropertyBuilder = Objects.requireNonNull(vizMapPropertyBuilder, "'vizMapPropertyBuilder' must not be null");
        this.mappingGenerators = new TreeMap<String, GenerateDiscreteValuesAction>(Collator.getInstance(Locale.getDefault())::compare);
        this.taskFactories = new HashMap<TaskFactory, JMenuItem>();
        this.actions = new HashMap<CyAction, JMenuItem>();
        this.userProps = new HashMap<String, Boolean>();
        this.defVisibleProps = new HashMap<Class<? extends CyIdentifiable>, Set<String>>();
        this.selectedColumns = new HashMap<Long, Long>();
        this.setViewComponent(vizMapperMainPanel);
    }

    public final void onRegister() {
        this.vmProxy = (VizMapperProxy)this.getFacade().retrieveProxy("VisualStyleProxy");
        this.attrProxy = (AttributeSetProxy)this.getFacade().retrieveProxy("AttributeSetProxy");
        this.mappingFactoryProxy = (MappingFunctionFactoryProxy)this.getFacade().retrieveProxy("MappingFunctionFactoryProxy");
        this.propsProxy = (PropsProxy)this.getFacade().retrieveProxy("VizMapperPropsProxy");
        this.updateDefaultProps();
        this.initView();
        super.onRegister();
    }

    public String[] listNotificationInterests() {
        return new String[]{"VISUAL_STYLE_SET_CHANGED", "VISUAL_STYLE_ADDED", "VISUAL_STYLE_REMOVED", "CURRENT_VISUAL_STYLE_CHANGED", "VISUAL_STYLE_UPDATED", "CURRENT_NETWORK_VIEW_CHANGED", "VISUAL_STYLE_NAME_CHANGED", "CURRENT_TABLE_CHANGED", "CURRENT_TABLE_VISUAL_STYLE_CHANGED"};
    }

    public void handleNotification(INotification notification) {
        String id = notification.getName();
        Object body = notification.getBody();
        switch (id) {
            case "VISUAL_STYLE_SET_CHANGED": {
                this.updateVisualStyleList((SortedSet)body, true);
                break;
            }
            case "VISUAL_STYLE_ADDED": 
            case "VISUAL_STYLE_REMOVED": {
                this.updateVisualStyleList(this.vmProxy.getVisualStyles(), false);
                break;
            }
            case "CURRENT_VISUAL_STYLE_CHANGED": {
                ViewUtil.invokeOnEDTAndWait(() -> {
                    this.ignoreVisualStyleSelectedEvents = true;
                    try {
                        this.selectCurrentVisualStyle((VisualStyle)body);
                    }
                    finally {
                        this.ignoreVisualStyleSelectedEvents = false;
                    }
                });
                ViewUtil.invokeOnEDT(() -> {
                    VisualStyle vs = (VisualStyle)body;
                    this.updateNetworkVisualPropertySheets(vs, false);
                });
                break;
            }
            case "CURRENT_TABLE_VISUAL_STYLE_CHANGED": {
                ViewUtil.invokeOnEDT(() -> {
                    CyTable table = (CyTable)body;
                    this.updateTableVisualPropertySheets(table, false, true);
                });
                break;
            }
            case "VISUAL_STYLE_UPDATED": {
                if (body == null) break;
                VisualStyle style = (VisualStyle)body;
                if (this.vmProxy.isTableStyle(style)) {
                    CyColumn currentColumn = this.vizMapperMainPanel.getColumnStylePnl().getColumnComboBox().getSelectedItem();
                    if (this.vmProxy.getVisualStyle(currentColumn) != style) break;
                    this.updateTableVisualPropertySheets(currentColumn.getTable(), false, false);
                    break;
                }
                if (style.equals(this.vmProxy.getCurrentVisualStyle())) {
                    this.updateNetworkVisualPropertySheets(style, false);
                }
                ViewUtil.invokeOnEDT(() -> this.vizMapperMainPanel.getStylesPanelProvider().update(style));
                break;
            }
            case "CURRENT_NETWORK_VIEW_CHANGED": {
                String newRendererId;
                CyNetworkView view = (CyNetworkView)body;
                String string = newRendererId = view != null ? view.getRendererId() : null;
                if (view != null && newRendererId != null && !newRendererId.equals(this.curRendererId)) {
                    this.updateNetworkVisualPropertySheets(this.vmProxy.getVisualStyle(view), false);
                    this.curRendererId = newRendererId;
                    break;
                }
                if (view != null && !this.vmProxy.getVisualStyle(view).equals(this.vizMapperMainPanel.getSelectedVisualStyle())) break;
                this.updateLockedValues(view);
                if (body instanceof CyNetworkView) {
                    this.updateMappings(CyNode.class, ((CyNetwork)view.getModel()).getDefaultNodeTable());
                    this.updateMappings(CyEdge.class, ((CyNetwork)view.getModel()).getDefaultEdgeTable());
                }
                this.updateItemsStatus();
                break;
            }
            case "VISUAL_STYLE_NAME_CHANGED": {
                ViewUtil.invokeOnEDT(() -> {
                    this.vizMapperMainPanel.getStylesBtn().update();
                    this.vizMapperMainPanel.getStylesPanelProvider().update((VisualStyle)body);
                });
                break;
            }
            case "CURRENT_TABLE_CHANGED": {
                CyTable table = (CyTable)body;
                ViewUtil.invokeOnEDT(() -> this.updateTableVisualPropertySheets(table, false, false));
            }
        }
    }

    protected RenderingEngine<?> getRenderingEngine(Class<? extends CyIdentifiable> type) {
        if (NETWORK_SHEET_TYPES.contains(type)) {
            return this.vmProxy.getCurrentRenderingEngine();
        }
        return this.vmProxy.getCurrentTableRenderingEngine();
    }

    private VisualProperty<?> getRootVP(Class<? extends CyIdentifiable> type) {
        if (NETWORK_SHEET_TYPES.contains(type)) {
            return BasicVisualLexicon.NETWORK;
        }
        return BasicTableVisualLexicon.CELL;
    }

    public VisualStyle getCurrentVisualStyle(Class<? extends CyIdentifiable> type) {
        if (NETWORK_SHEET_TYPES.contains(type)) {
            return this.vmProxy.getCurrentVisualStyle();
        }
        CyColumn col = this.vizMapperMainPanel.getColumnStylePnl().getColumnComboBox().getSelectedItem();
        return this.vmProxy.getVisualStyle(col);
    }

    public CyColumn getCurrentColumn() {
        return this.vizMapperMainPanel.getColumnStylePnl().getColumnComboBox().getSelectedItem();
    }

    private CyTable getTable(Class<? extends CyIdentifiable> type) {
        if (type == CyNode.class) {
            CyNetwork curNet = this.vmProxy.getCurrentNetwork();
            return curNet == null ? null : curNet.getDefaultNodeTable();
        }
        if (type == CyEdge.class) {
            CyNetwork curNet = this.vmProxy.getCurrentNetwork();
            return curNet == null ? null : curNet.getDefaultEdgeTable();
        }
        if (type == CyNetwork.class) {
            CyNetwork curNet = this.vmProxy.getCurrentNetwork();
            return curNet == null ? null : curNet.getDefaultNetworkTable();
        }
        if (type == CyColumn.class) {
            return this.vmProxy.getCurrentTable();
        }
        return null;
    }

    @Override
    public void handleEvent(LexiconStateChangedEvent e) {
        VisualStyle curStyle = this.vmProxy.getCurrentVisualStyle();
        Set<CyNetworkView> views = this.vmProxy.getNetworkViewsWithStyle(curStyle);
        for (CyNetworkView view : views) {
            curStyle.apply(view);
            view.updateView();
        }
        ViewUtil.invokeOnEDT(() -> this.updateItemsStatus());
    }

    public void handleEvent(RowsSetEvent e) {
        CyNetwork curNet;
        CyTable tbl = (CyTable)e.getSource();
        CyNetworkView curNetView = this.vmProxy.getCurrentNetworkView();
        if (curNetView != null && e.containsColumn("selected")) {
            curNet = (CyNetwork)curNetView.getModel();
            if (tbl.equals(curNet.getDefaultEdgeTable())) {
                this.updateLockedValues(this.vmProxy.getSelectedEdgeViews(curNetView), CyEdge.class);
            } else if (tbl.equals(curNet.getDefaultNodeTable())) {
                this.updateLockedValues(this.vmProxy.getSelectedNodeViews(curNetView), CyNode.class);
            } else if (tbl.equals(curNet.getDefaultNetworkTable())) {
                this.updateLockedValues(Collections.singleton(curNetView), CyNetwork.class);
            }
        }
        if ((curNet = this.vmProxy.getCurrentNetwork()) != null) {
            ArrayList<VisualPropertySheet> vpSheets = new ArrayList<VisualPropertySheet>(2);
            if (tbl.equals(curNet.getDefaultEdgeTable())) {
                vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyEdge.class));
            } else if (tbl.equals(curNet.getDefaultNodeTable())) {
                vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyNode.class));
            } else if (tbl.equals(curNet.getDefaultNetworkTable())) {
                vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyNetwork.class));
            }
            if (tbl.equals(this.vmProxy.getCurrentTable())) {
                vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyColumn.class));
            }
            if (!vpSheets.isEmpty()) {
                Set columns = e.getColumns();
                for (VisualPropertySheet vpSheet : vpSheets) {
                    if (vpSheet == null) continue;
                    block1: for (VisualPropertySheetItem visualPropertySheetItem : vpSheet.getItems()) {
                        VisualMappingFunction mapping = visualPropertySheetItem.getModel().getVisualMappingFunction();
                        if (mapping == null) continue;
                        for (String columnName : columns) {
                            if (!mapping.getMappingColumnName().equalsIgnoreCase(columnName)) continue;
                            ViewUtil.invokeOnEDT(() -> item.updateMapping());
                            continue block1;
                        }
                    }
                }
            }
        }
    }

    public void handleEvent(ColumnDeletedEvent e) {
        CyTable table = (CyTable)e.getSource();
        if (table == this.getTable(CyColumn.class)) {
            this.selectedColumns.remove(table.getSUID());
            this.updateTableVisualPropertySheets(table, false, false);
        }
        this.onColumnChangedUpdateMappings(e.getColumnName(), table);
    }

    public void handleEvent(ColumnCreatedEvent e) {
        CyTable table = (CyTable)e.getSource();
        if (table == this.getTable(CyColumn.class)) {
            this.updateTableVisualPropertySheets(table, false, false);
        }
        this.onColumnChangedUpdateMappings(e.getColumnName(), table);
    }

    public void handleEvent(ColumnNameChangedEvent e) {
        CyTable table = (CyTable)e.getSource();
        if (table == this.getTable(CyColumn.class)) {
            this.updateTableVisualPropertySheets(table, false, false);
        }
        this.onColumnChangedUpdateMappings(e.getOldColumnName(), table);
        this.onColumnChangedUpdateMappings(e.getNewColumnName(), table);
    }

    public void handleEvent(UpdateNetworkPresentationEvent e) {
        CyNetworkView view = (CyNetworkView)e.getSource();
        if (view.equals(this.vmProxy.getCurrentNetworkView())) {
            this.updateLockedValues(view);
        }
    }

    public void handleEvent(VisualMappingFunctionChangedEvent e) {
        VisualPropertySheetItem vpSheetItem;
        VisualPropertySheet vpSheet;
        VisualMappingFunction vm = (VisualMappingFunction)e.getSource();
        VisualProperty vp = vm.getVisualProperty();
        VisualStyle curStyle = this.getCurrentVisualStyle(vp.getTargetDataType());
        if (curStyle != null && vm.equals(curStyle.getVisualMappingFunction(vp)) && (vpSheet = this.vizMapperMainPanel.getVisualPropertySheet(vp.getTargetDataType())) != null && (vpSheetItem = vpSheet.getItem(vp)) != null) {
            ViewUtil.invokeOnEDT(() -> vpSheetItem.updateMapping());
        }
    }

    public VisualPropertySheetItem<?> getCurrentVisualPropertySheetItem() {
        return this.curVpSheetItem;
    }

    public VisualPropertySheet getSelectedVisualPropertySheet() {
        return this.vizMapperMainPanel.getSelectedVisualPropertySheet();
    }

    public VizMapperProperty<?, ?, ?> getCurrentVizMapperProperty() {
        return this.curVizMapperProperty;
    }

    public synchronized void onCyActionRegistered(CyAction action, Map<?, ?> properties) {
        String serviceType = ServicePropertiesUtil.getServiceType(properties);
        if (serviceType != null && serviceType.startsWith("vizmapUI")) {
            ViewUtil.invokeOnEDT(() -> {
                JMenuItem menuItem = this.createMenuItem(action, properties);
                if (menuItem != null) {
                    this.actions.put(action, menuItem);
                }
            });
        }
    }

    public synchronized void onCyActionUnregistered(CyAction action, Map<?, ?> properties) {
        JMenuItem menuItem = this.actions.remove(action);
        if (menuItem != null) {
            ViewUtil.invokeOnEDT(() -> {
                this.vizMapperMainPanel.removeOption(menuItem);
                this.vizMapperMainPanel.removeContextMenuItem(menuItem);
            });
        }
    }

    public void onTaskFactoryRegistered(final TaskFactory taskFactory, Map<?, ?> properties) {
        String serviceType = ServicePropertiesUtil.getServiceType(properties);
        if (serviceType == null || !serviceType.toString().startsWith("vizmapUI")) {
            return;
        }
        String title = ServicePropertiesUtil.getTitle(properties);
        if (title == null) {
            logger.error("Cannot create VizMapper menu item for: " + taskFactory + "; \"title\" metadata is missing from properties: " + properties);
            return;
        }
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("title", title.toString());
        AbstractCyAction action = new AbstractCyAction(config, taskFactory){

            public void actionPerformed(ActionEvent e) {
                new Thread(() -> VizMapperMediator.this.servicesUtil.get(DialogTaskManager.class).execute(taskFactory.createTaskIterator())).start();
            }
        };
        ViewUtil.invokeOnEDT(() -> this.lambda$onTaskFactoryRegistered$11(action, properties, taskFactory));
    }

    public void onTaskFactoryUnregistered(TaskFactory taskFactory, Map<?, ?> properties) {
        JMenuItem menuItem = this.taskFactories.remove(taskFactory);
        if (menuItem != null) {
            ViewUtil.invokeOnEDT(() -> {
                this.vizMapperMainPanel.removeOption(menuItem);
                this.vizMapperMainPanel.removeContextMenuItem(menuItem);
            });
        }
    }

    public void onMappingGeneratorRegistered(DiscreteMappingGenerator<?> generator, Map<?, ?> properties) {
        String serviceType = ServicePropertiesUtil.getServiceType(properties);
        if (serviceType == null) {
            logger.error("Cannot create VizMapper context menu item for: " + generator + "; \"service.type\" metadata is missing from properties: " + properties);
            return;
        }
        String title = ServicePropertiesUtil.getTitle(properties);
        if (title == null) {
            logger.error("Cannot create VizMapper context menu item for: " + generator + "; \"title\" metadata is missing from properties: " + properties);
            return;
        }
        GenerateDiscreteValuesAction action = new GenerateDiscreteValuesAction(title.toString(), generator, this.servicesUtil);
        this.vizMapperMainPanel.getContextMenu().addPopupMenuListener((PopupMenuListener)((Object)action));
        this.mappingGenerators.put(generator.getDataType().getSimpleName() + "::" + title.toString(), action);
    }

    public void onMappingGeneratorUnregistered(DiscreteMappingGenerator<?> generator, Map<?, ?> properties) {
        Iterator<Map.Entry<String, GenerateDiscreteValuesAction>> iter = this.mappingGenerators.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, GenerateDiscreteValuesAction> entry = iter.next();
            GenerateDiscreteValuesAction action = entry.getValue();
            if (!action.getGenerator().equals(generator)) continue;
            this.vizMapperMainPanel.getContextMenu().removePopupMenuListener((PopupMenuListener)((Object)action));
            iter.remove();
            break;
        }
    }

    private void updateDefaultProps() {
        this.defVisibleProps.clear();
        this.defVisibleProps.put(CyNode.class, this.propsProxy.getDefaultVisualProperties(CyNode.class));
        this.defVisibleProps.put(CyEdge.class, this.propsProxy.getDefaultVisualProperties(CyEdge.class));
        this.defVisibleProps.put(CyNetwork.class, this.propsProxy.getDefaultVisualProperties(CyNetwork.class));
        this.defVisibleProps.put(CyColumn.class, this.propsProxy.getDefaultVisualProperties(CyColumn.class));
    }

    private void initView() {
        this.servicesUtil.registerAllServices(this.vizMapperMainPanel, new Properties());
        this.addViewListeners();
    }

    private void addViewListeners() {
        VisualStylePanelProvider.VisualStyleDropDownButton stylesBtn = this.vizMapperMainPanel.getStylesBtn();
        stylesBtn.addPropertyChangeListener("selectedStyle", evt -> this.onSelectedVisualStyleChanged(evt));
        this.tableChangeListener = e -> this.onSelectedTableChanged();
        this.vizMapperMainPanel.getColumnStylePnl().getTableComboBox().addActionListener(this.tableChangeListener);
        this.columnChangeListener = e -> this.onSelectedColumnChanged();
        this.vizMapperMainPanel.getColumnStylePnl().getColumnComboBox().addActionListener(this.columnChangeListener);
    }

    private void addViewListeners(VisualPropertySheet vpSheet) {
        for (VisualPropertySheetItem visualPropertySheetItem : vpSheet.getItems()) {
            this.addViewListeners(vpSheet, visualPropertySheetItem);
        }
    }

    private void addViewListeners(VisualPropertySheet vpSheet, final VisualPropertySheetItem<?> vpSheetItem) {
        if (vpSheetItem.getModel().getVisualPropertyDependency() == null) {
            vpSheetItem.getDefaultBtn().addActionListener(evt -> this.openDefaultValueEditor(evt, vpSheetItem));
            vpSheetItem.getDefaultBtn().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.maybeShowContextMenu(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.maybeShowContextMenu(e);
                }

                private void maybeShowContextMenu(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        JPopupMenu contextMenu = new JPopupMenu();
                        contextMenu.add(new JMenuItem(new AbstractAction("Reset Default Value"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                vpSheetItem.getModel().resetDefaultValue();
                            }
                        }));
                        VizMapperMediator.this.showContextMenu(contextMenu, e);
                    }
                }
            });
            if (vpSheetItem.getModel().isLockedValueAllowed()) {
                final JPopupMenu bypassMenu = new JPopupMenu();
                bypassMenu.add(new JMenuItem(new AbstractAction("Set Bypass..."){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VizMapperMediator.this.openLockedValueEditor(e, vpSheetItem);
                    }
                }));
                final JMenuItem removeBypassMenuItem = new JMenuItem(new AbstractAction("Remove Bypass"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VizMapperMediator.this.removeLockedValue(e, vpSheetItem);
                    }
                });
                bypassMenu.add(removeBypassMenuItem);
                vpSheetItem.getBypassBtn().addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        this.maybeShowContextMenu(e);
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        this.maybeShowContextMenu(e);
                    }

                    private void maybeShowContextMenu(MouseEvent e) {
                        if (vpSheetItem.getBypassBtn().isEnabled() && e.isPopupTrigger()) {
                            LockedValueState state = vpSheetItem.getModel().getLockedValueState();
                            removeBypassMenuItem.setEnabled(state != LockedValueState.ENABLED_NOT_SET);
                            VizMapperMediator.this.showContextMenu(bypassMenu, e);
                        }
                    }
                });
                vpSheetItem.getBypassBtn().addActionListener(evt -> {
                    LockedValueState state = vpSheetItem.getModel().getLockedValueState();
                    JButton btn = vpSheetItem.getBypassBtn();
                    if (state == LockedValueState.ENABLED_NOT_SET) {
                        this.openLockedValueEditor(evt, vpSheetItem);
                    } else {
                        bypassMenu.show(btn, 0, btn.getHeight());
                        bypassMenu.requestFocusInWindow();
                    }
                });
            }
            ContextMenuMouseListener cmMouseListener = new ContextMenuMouseListener(vpSheet, vpSheetItem);
            vpSheetItem.addMouseListener(cmMouseListener);
            if (vpSheetItem.getModel().isVisualMappingAllowed()) {
                vpSheetItem.getPropSheetPnl().getTable().addMouseListener((MouseListener)cmMouseListener);
                vpSheetItem.getRemoveMappingBtn().addActionListener(evt -> {
                    this.curVpSheetItem = vpSheetItem;
                    this.removeVisualMapping(vpSheetItem);
                });
                vpSheetItem.getPropSheetTbl().addPropertyChangeListener("editingVizMapperProperty", evt -> {
                    this.curVpSheetItem = vpSheetItem;
                    this.curVizMapperProperty = (VizMapperProperty)((Object)((Object)evt.getNewValue()));
                    VizMapperProperty<String, VisualMappingFunctionFactory, VisualMappingFunction<?, ?>> mappingTypeProperty = this.vizMapPropertyBuilder.getMappingTypeProperty(vpSheetItem.getPropSheetPnl());
                    VisualMappingFunctionFactory factory = (VisualMappingFunctionFactory)mappingTypeProperty.getValue();
                    this.attrProxy.setCurrentMappingType(factory != null ? factory.getMappingFunctionType() : null);
                    VizMapperProperty<VisualProperty<?>, String, VisualMappingFunctionFactory> columnProp = this.vizMapPropertyBuilder.getColumnProperty(vpSheetItem.getPropSheetPnl());
                    Object columnValue = columnProp.getValue();
                    this.mappingFactoryProxy.setCurrentColumnName(columnValue != null ? columnValue.toString() : null);
                    this.mappingFactoryProxy.setCurrentTargetDataType(vpSheet.getModel().getTargetDataType());
                });
            }
        } else {
            vpSheetItem.getDependencyCkb().addItemListener(evt -> this.onDependencySelectionChanged(evt, vpSheetItem));
        }
        vpSheetItem.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                VizMapperMediator.this.userProps.put(vpSheetItem.getModel().getId(), Boolean.TRUE);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                VizMapperMediator.this.userProps.put(vpSheetItem.getModel().getId(), Boolean.FALSE);
            }
        });
    }

    protected void removeVisualMapping(VisualPropertySheetItem<?> vpSheetItem) {
        VisualMappingFunction<?, ?> vm = vpSheetItem.getModel().getVisualMappingFunction();
        if (vm != null) {
            this.sendNotification("REMOVE_VISUAL_MAPPINGS", Collections.singleton(vm));
        }
    }

    private void updateVisualStyleList(SortedSet<VisualStyle> styles, boolean resetDefaultVisibleItems) {
        this.attrProxy.setCurrentMappingType(null);
        this.mappingFactoryProxy.setCurrentColumnName(null);
        this.debounceTimer.debounce(() -> {
            VisualStyle vs = this.vmProxy.getCurrentVisualStyle();
            CyTable table = this.vmProxy.getCurrentTable();
            ViewUtil.invokeOnEDT(() -> {
                this.ignoreVisualStyleSelectedEvents = true;
                this.vizMapperMainPanel.updateVisualStyles(styles, vs);
                this.selectCurrentVisualStyle(vs);
                this.ignoreVisualStyleSelectedEvents = false;
                this.updateNetworkVisualPropertySheets(vs, resetDefaultVisibleItems);
                if (table != null) {
                    this.updateTableVisualPropertySheets(table, resetDefaultVisibleItems, false);
                }
            });
        });
    }

    private void selectCurrentVisualStyle(VisualStyle vs) {
        ViewUtil.invokeOnEDT(() -> {
            VisualStyle selectedVs = this.vizMapperMainPanel.getSelectedVisualStyle();
            ContinuousMappingEditorPanel.setTracer(new EditorValueRangeTracer(this.servicesUtil));
            if (vs != null && !vs.equals(selectedVs)) {
                this.vizMapperMainPanel.setSelectedVisualStyle(vs);
            }
        });
    }

    private void updateNetworkVisualPropertySheets(VisualStyle vs, boolean resetDefaultVisibleItems) {
        boolean rebuild = this.shouldRebuildNetworkVisualPropertySheets(vs);
        this.updateVisualPropertySheets(vs, NETWORK_SHEET_TYPES, resetDefaultVisibleItems, rebuild);
    }

    private void updateTableVisualPropertySheets(CyTable table, boolean resetDefaultVisibleItems, boolean forceRebuild) {
        boolean rebuild;
        VisualStyle vs;
        if (table != null && !table.isPublic()) {
            table = null;
        }
        Collection<Object> pubTables = null;
        CyTable tableToUse = null;
        Collection columns = null;
        CyColumn columnToUse = null;
        if (table == null) {
            vs = this.servicesUtil.get(VisualStyleFactory.class).createVisualStyle("column-dummy");
            rebuild = true;
        } else {
            tableToUse = table;
            columns = tableToUse.getColumns();
            columnToUse = this.getSelectedColumn(tableToUse);
            vs = this.vmProxy.getVisualStyle(columnToUse);
            if (vs == null) {
                tableToUse = null;
                columns = null;
                columnToUse = null;
            } else {
                pubTables = new LinkedHashSet<CyTable>();
                CyNetworkTableManager netTableManager = this.servicesUtil.get(CyNetworkTableManager.class);
                CyNetwork net = netTableManager.getNetworkForTable(table);
                if (net == null) {
                    net = this.vmProxy.getCurrentNetwork();
                }
                if (net != null) {
                    pubTables.add(netTableManager.getTable(net, CyNode.class, "USER"));
                    pubTables.addAll(netTableManager.getTables(net, CyNode.class).values());
                    pubTables.add(netTableManager.getTable(net, CyEdge.class, "USER"));
                    pubTables.addAll(netTableManager.getTables(net, CyEdge.class).values());
                    pubTables.add(netTableManager.getTable(net, CyNetwork.class, "USER"));
                    pubTables.addAll(netTableManager.getTables(net, CyNetwork.class).values());
                }
                pubTables.addAll(this.servicesUtil.get(CyTableManager.class).getGlobalTables());
                if (!pubTables.contains(table)) {
                    pubTables.add(table);
                }
                pubTables = pubTables.stream().filter(t -> t.isPublic()).collect(Collectors.toList());
            }
            rebuild = forceRebuild || this.shouldRebuildTableVisualPropertySheets(vs);
        }
        this.updateVisualPropertySheets(vs, TABLE_SHEET_TYPES, resetDefaultVisibleItems, rebuild);
        this.vizMapperMainPanel.getColumnStylePnl().getTableComboBox().removeActionListener(this.tableChangeListener);
        this.vizMapperMainPanel.getColumnStylePnl().getColumnComboBox().removeActionListener(this.columnChangeListener);
        this.vizMapperMainPanel.updateColumns(pubTables, tableToUse, columns, columnToUse);
        this.vizMapperMainPanel.getColumnStylePnl().getTableComboBox().addActionListener(this.tableChangeListener);
        this.vizMapperMainPanel.getColumnStylePnl().getColumnComboBox().addActionListener(this.columnChangeListener);
    }

    private CyColumn getSelectedColumn(CyTable table) {
        Collection columns = table.getColumns();
        Long colSuid = this.selectedColumns.get(table.getSUID());
        if (colSuid == null) {
            for (CyColumn col : columns) {
                if ("SUID".equals(col.getName())) continue;
                return col;
            }
        } else {
            for (CyColumn col : columns) {
                if (!colSuid.equals(col.getSUID())) continue;
                return col;
            }
        }
        return (CyColumn)columns.iterator().next();
    }

    private void onSelectedTableChanged() {
        CyTable table = (CyTable)this.vizMapperMainPanel.getColumnStylePnl().getTableComboBox().getSelectedItem();
        if (table != null) {
            this.servicesUtil.get(CyApplicationManager.class).setCurrentTable(table);
        }
    }

    private void onSelectedColumnChanged() {
        ContinuousMappingEditorPanel.setTracer(new EditorValueRangeTracer(this.servicesUtil));
        CyColumn col = this.vizMapperMainPanel.getColumnStylePnl().getColumnComboBox().getSelectedItem();
        this.selectedColumns.put(col.getTable().getSUID(), col.getSUID());
        this.updateTableVisualPropertySheets(col.getTable(), false, true);
    }

    private void updateVisualPropertySheets(VisualStyle vs, List<Class<? extends CyIdentifiable>> sheetTypes, boolean resetDefaultVisibleItems, boolean rebuild) {
        if (vs == null) {
            return;
        }
        if (!rebuild) {
            HashMap<String, VisualPropertyDependency> map = new HashMap<String, VisualPropertyDependency>();
            Set dependencies = vs.getAllVisualPropertyDependencies();
            for (VisualPropertyDependency dep : dependencies) {
                Class clazz = dep.getParentVisualProperty().getTargetDataType();
                VisualPropertySheet sheet = this.vizMapperMainPanel.getVisualPropertySheet(clazz);
                if (sheet == null) continue;
                if (sheet.getItem(dep) == null) {
                    rebuild = true;
                    break;
                }
                map.put(dep.getIdString(), dep);
            }
            if (!rebuild) {
                Set<VisualPropertySheet> vpSheets = this.vizMapperMainPanel.getVisualPropertySheets();
                block1: for (VisualPropertySheet visualPropertySheet : vpSheets) {
                    for (VisualPropertySheetItem visualPropertySheetItem : visualPropertySheet.getItems()) {
                        VisualPropertyDependency dep = visualPropertySheetItem.getModel().getVisualPropertyDependency();
                        if (dep == null || map.containsKey(dep.getIdString())) continue;
                        rebuild = true;
                        continue block1;
                    }
                }
            }
        }
        if (rebuild) {
            this.createVisualPropertySheets(vs, sheetTypes, resetDefaultVisibleItems);
        } else {
            Set<VisualPropertySheet> vpSheets = this.vizMapperMainPanel.getVisualPropertySheets();
            for (VisualPropertySheet sheet : vpSheets) {
                for (VisualPropertySheetItem visualPropertySheetItem : sheet.getItems()) {
                    VisualPropertySheetItemModel model = visualPropertySheetItem.getModel();
                    model.update(this.getRenderingEngine(model.getTargetDataType()));
                    if (model.getVisualPropertyDependency() != null) {
                        visualPropertySheetItem.update();
                    }
                    if (model.getVisualMappingFunction() == null) continue;
                    visualPropertySheetItem.setVisible(true);
                }
            }
            if (resetDefaultVisibleItems) {
                this.updateVisibleItems(resetDefaultVisibleItems);
            }
        }
    }

    private boolean shouldRebuildNetworkVisualPropertySheets(VisualStyle vs) {
        boolean rebuild;
        VisualPropertySheet curNetSheet = this.vizMapperMainPanel.getVisualPropertySheet(CyNetwork.class);
        VisualPropertySheetModel curModel = curNetSheet != null ? curNetSheet.getModel() : null;
        VisualStyle curStyle = curModel != null ? curModel.getVisualStyle() : null;
        CyNetworkView curNetView = this.vmProxy.getCurrentNetworkView();
        String newRendererId = curNetView != null ? curNetView.getRendererId() : "";
        boolean bl = rebuild = !vs.equals(curStyle) || !newRendererId.equals(this.curRendererId);
        if (curNetView != null) {
            this.curRendererId = curNetView.getRendererId();
        }
        return rebuild;
    }

    private boolean shouldRebuildTableVisualPropertySheets(VisualStyle vs) {
        CyColumn col = this.vizMapperMainPanel.getColumnStylePnl().getColumnComboBox().getSelectedItem();
        VisualStyle curStyle = this.vmProxy.getVisualStyle(col);
        return vs != null && !vs.equals(curStyle);
    }

    private void createVisualPropertySheets(VisualStyle style, List<Class<? extends CyIdentifiable>> sheetTypes, boolean resetDefaultVisibleItems) {
        ViewUtil.invokeOnEDT(() -> {
            VisualPropertySheet selVpSheet = this.getSelectedVisualPropertySheet();
            Class<? extends CyIdentifiable> selectedTargetDataType = selVpSheet != null ? selVpSheet.getModel().getTargetDataType() : null;
            for (Object type : sheetTypes) {
                JMenuItem mi;
                Set<VisualPropertySheetItem<?>> vpSheetItems;
                VisualPropertySheet vpSheet;
                RenderingEngine<?> re = this.getRenderingEngine((Class<? extends CyIdentifiable>)type);
                if (re == null) {
                    VisualPropertySheetModel model = new VisualPropertySheetModel((Class<? extends CyIdentifiable>)type, style, null);
                    vpSheet = new VisualPropertySheet(model, this.servicesUtil);
                    this.vizMapperMainPanel.addVisualPropertySheet(vpSheet);
                    vpSheetItems = Collections.emptySet();
                    vpSheet.setItems(vpSheetItems);
                } else {
                    VisualLexicon lexicon = re.getVisualLexicon();
                    VisualPropertySheetModel model = new VisualPropertySheetModel((Class<? extends CyIdentifiable>)type, style, lexicon);
                    vpSheet = new VisualPropertySheet(model, this.servicesUtil);
                    this.vizMapperMainPanel.addVisualPropertySheet(vpSheet);
                    vpSheetItems = this.createVisualPropertySheetItems(vpSheet.getModel().getTargetDataType(), lexicon, style);
                    vpSheet.setItems(vpSheetItems);
                }
                this.addViewListeners(vpSheet);
                if (vpSheetItems.size() > 1) {
                    vpSheet.getVpsMenu().add(new JSeparator());
                    mi = new JMenuItem("Show Default");
                    mi.addActionListener(evt -> this.showDefaultItems(vpSheet));
                    vpSheet.getVpsMenu().add(mi);
                    mi = new JMenuItem("Show All");
                    mi.addActionListener(evt -> this.setVisibleItems(vpSheet, true));
                    vpSheet.getVpsMenu().add(mi);
                    mi = new JMenuItem("Hide All");
                    mi.addActionListener(evt -> this.setVisibleItems(vpSheet, false));
                    vpSheet.getVpsMenu().add(mi);
                }
                vpSheet.getVpsMenu().add(new JSeparator());
                mi = new JMenuItem("Make Default");
                mi.addActionListener(evt -> this.saveDefaultVisibleItems(vpSheet));
                vpSheet.getVpsMenu().add(mi);
            }
            this.updateVisibleItems(resetDefaultVisibleItems);
            this.updateItemsStatus();
            int minWidth = 200;
            for (VisualPropertySheet vpSheet : this.vizMapperMainPanel.getVisualPropertySheets()) {
                minWidth = Math.max(minWidth, vpSheet.getMinimumSize().width);
            }
            this.vizMapperMainPanel.setPreferredSize(new Dimension(this.vizMapperMainPanel.getPropertiesPnl().getComponent().getMinimumSize().width + 20, this.vizMapperMainPanel.getPreferredSize().height));
            VisualPropertySheet vpSheet = this.vizMapperMainPanel.getVisualPropertySheet(selectedTargetDataType);
            this.vizMapperMainPanel.setSelectedVisualPropertySheet(vpSheet);
        });
    }

    private Set<VisualPropertySheetItem<?>> createVisualPropertySheetItems(Class<? extends CyIdentifiable> type, VisualLexicon lexicon, VisualStyle style) {
        VisualPropertySheetItem sheetItem;
        HashSet items = new HashSet();
        if (lexicon == null || style == null) {
            return items;
        }
        Collection vpList = lexicon.getAllDescendants(this.getRootVP(type));
        RenderingEngine<?> engine = this.getRenderingEngine(type);
        for (VisualProperty vp : vpList) {
            Set values;
            CyNetworkView curNetView;
            if (vp.getTargetDataType() != type || vp instanceof DefaultVisualizableVisualProperty || !VizMapperProxy.isSupported(lexicon, vp)) continue;
            VisualPropertySheetItemModel model = new VisualPropertySheetItemModel(vp, style, engine, lexicon);
            if (vp.getTargetDataType() == CyNode.class) {
                curNetView = this.vmProxy.getCurrentNetworkView();
                Set selectedNodeViews = this.vmProxy.getSelectedNodeViews(curNetView);
                values = this.getDistinctLockedValues(vp, selectedNodeViews);
                this.updateVpInfoLockedState(model, values, selectedNodeViews);
            } else if (vp.getTargetDataType() == CyEdge.class) {
                curNetView = this.vmProxy.getCurrentNetworkView();
                Set selectedEdgeViews = this.vmProxy.getSelectedEdgeViews(curNetView);
                values = this.getDistinctLockedValues(vp, selectedEdgeViews);
                this.updateVpInfoLockedState(model, values, selectedEdgeViews);
            } else if (vp.getTargetDataType() == CyNetwork.class) {
                curNetView = this.vmProxy.getCurrentNetworkView();
                Set<CyNetworkView> selectedNetViews = curNetView != null ? Collections.singleton(curNetView) : Collections.EMPTY_SET;
                values = this.getDistinctLockedValues(vp, selectedNetViews);
                this.updateVpInfoLockedState(model, values, selectedNetViews);
            }
            sheetItem = new VisualPropertySheetItem(model, this.vizMapPropertyBuilder, this.servicesUtil);
            items.add(sheetItem);
            if (model.isVisualMappingAllowed()) {
                sheetItem.getPropSheetPnl().addPropertySheetChangeListener(evt -> {
                    if (evt.getPropertyName().equals("value") && evt.getSource() instanceof VizMapperProperty) {
                        this.updateMappingStatus(sheetItem);
                    }
                });
            }
            model.addPropertyChangeListener("defaultValue", evt -> {
                VisualStyle vs = model.getVisualStyle();
                vs.setDefaultValue(vp, evt.getNewValue());
            });
            model.addPropertyChangeListener("visualMappingFunction", evt -> {
                VisualStyle vs = model.getVisualStyle();
                if (evt.getNewValue() == null && vs.getVisualMappingFunction(vp) != null) {
                    vs.removeVisualMappingFunction(vp);
                } else if (evt.getNewValue() != null && !evt.getNewValue().equals(vs.getVisualMappingFunction(vp))) {
                    vs.addVisualMappingFunction((VisualMappingFunction)evt.getNewValue());
                }
                this.updateMappingStatus(sheetItem);
            });
        }
        Set dependencies = style.getAllVisualPropertyDependencies();
        for (VisualPropertyDependency dep : dependencies) {
            if (dep.getParentVisualProperty().getTargetDataType() != type || !VizMapperProxy.isSupported(lexicon, dep)) continue;
            VisualPropertySheetItemModel model = new VisualPropertySheetItemModel(dep, style, engine, lexicon);
            sheetItem = new VisualPropertySheetItem(model, this.vizMapPropertyBuilder, this.servicesUtil);
            items.add(sheetItem);
        }
        return items;
    }

    private void updateItemsStatus() {
        HashSet<VisualProperty> disabled = new HashSet<VisualProperty>();
        HashMap<VisualProperty, String> messages = new HashMap<VisualProperty, String>();
        VisualStyle style = this.vmProxy.getCurrentVisualStyle();
        String infoMsgTemplate = "<html>To enable this visual property,<br><b>%s</b> the dependency <i><b>%s</b></i></html>";
        for (VisualPropertyDependency dep : style.getAllVisualPropertyDependencies()) {
            VisualProperty parent = dep.getParentVisualProperty();
            Set properties = dep.getVisualProperties();
            if (dep.isDependencyEnabled()) {
                disabled.addAll(properties);
                for (VisualProperty vp : properties) {
                    messages.put(vp, String.format(infoMsgTemplate, "uncheck", dep.getDisplayName()));
                }
                continue;
            }
            disabled.add(parent);
            messages.put(parent, String.format(infoMsgTemplate, "check", dep.getDisplayName()));
        }
        for (VisualPropertySheet vpSheet : this.vizMapperMainPanel.getVisualPropertySheets()) {
            SortedSet<VisualPropertySheetItem<?>> vpSheetItems = vpSheet.getItems();
            for (VisualPropertySheetItem visualPropertySheetItem : vpSheetItems) {
                String msg = null;
                VisualPropertySheetItem.MessageType msgType = null;
                if (msgType == null && visualPropertySheetItem.getModel().getVisualPropertyDependency() == null) {
                    visualPropertySheetItem.setEnabled(!disabled.contains(visualPropertySheetItem.getModel().getVisualProperty()));
                    msg = (String)messages.get(visualPropertySheetItem.getModel().getVisualProperty());
                    msgType = visualPropertySheetItem.isEnabled() ? null : VisualPropertySheetItem.MessageType.INFO;
                }
                visualPropertySheetItem.setMessage(msg, msgType);
                this.updateMappingStatus(visualPropertySheetItem);
            }
        }
    }

    private void updateVisibleItems(boolean reset) {
        if (reset) {
            this.userProps.clear();
        }
        for (VisualPropertySheet vpSheet : this.vizMapperMainPanel.getVisualPropertySheets()) {
            for (VisualPropertySheetItem visualPropertySheetItem : vpSheet.getItems()) {
                Set<String> set = this.defVisibleProps.get(visualPropertySheetItem.getModel().getTargetDataType());
                String vpId = visualPropertySheetItem.getModel().getId();
                boolean b = set != null && set.contains(vpId) && !Boolean.FALSE.equals(this.userProps.get(vpId));
                b = b || visualPropertySheetItem.getModel().getVisualMappingFunction() != null;
                b = b || Boolean.TRUE.equals(this.userProps.get(vpId));
                visualPropertySheetItem.setVisible(b);
            }
        }
    }

    private void setVisibleItems(VisualPropertySheet vpSheet, boolean visible) {
        this.userProps.clear();
        for (VisualPropertySheetItem visualPropertySheetItem : vpSheet.getItems()) {
            visualPropertySheetItem.setVisible(visible);
        }
    }

    private void showDefaultItems(VisualPropertySheet vpSheet) {
        this.userProps.clear();
        for (VisualPropertySheetItem visualPropertySheetItem : vpSheet.getItems()) {
            Set<String> set = this.defVisibleProps.get(visualPropertySheetItem.getModel().getTargetDataType());
            String vpId = visualPropertySheetItem.getModel().getId();
            boolean b = set != null && set.contains(vpId);
            b = b || visualPropertySheetItem.getModel().getVisualMappingFunction() != null;
            visualPropertySheetItem.setVisible(b);
        }
    }

    private void saveDefaultVisibleItems(VisualPropertySheet vpSheet) {
        HashSet<String> idSet = new HashSet<String>();
        for (VisualPropertySheetItem visualPropertySheetItem : vpSheet.getItems()) {
            if (!visualPropertySheetItem.isVisible()) continue;
            idSet.add(visualPropertySheetItem.getModel().getId());
        }
        this.propsProxy.setDefaultVisualProperties(vpSheet.getModel().getTargetDataType(), idSet);
        this.updateDefaultProps();
    }

    private void updateMappings(Class<? extends CyIdentifiable> targetDataType, CyTable table) {
        VisualPropertySheet vpSheet;
        if (table != null && (vpSheet = this.vizMapperMainPanel.getVisualPropertySheet(targetDataType)) != null) {
            Collection columns = table.getColumns();
            HashMap<String, Class> colTypes = new HashMap<String, Class>();
            for (CyColumn cyColumn : columns) {
                colTypes.put(cyColumn.getName().toLowerCase(), cyColumn.getType());
            }
            for (VisualPropertySheetItem visualPropertySheetItem : vpSheet.getItems()) {
                Class colType;
                VisualMappingFunction mapping = visualPropertySheetItem.getModel().getVisualMappingFunction();
                if (!(mapping instanceof DiscreteMapping) && !(mapping instanceof ContinuousMapping) || (colType = (Class)colTypes.get(mapping.getMappingColumnName().toLowerCase())) == null || !mapping.getMappingColumnType().isAssignableFrom(colType)) continue;
                ViewUtil.invokeOnEDT(() -> item.updateMapping());
            }
        }
    }

    private void updateMappingStatus(VisualPropertySheetItem<?> item) {
        if (!item.isEnabled()) {
            return;
        }
        Class<CyIdentifiable> targetDataType = item.getModel().getTargetDataType();
        if (targetDataType != CyNetwork.class) {
            String msg = null;
            VisualPropertySheetItem.MessageType msgType = null;
            CyTable table = this.getTable(targetDataType);
            if (table != null) {
                String colName;
                VizMapperProperty<VisualProperty<?>, String, VisualMappingFunctionFactory> columnProp = this.vizMapPropertyBuilder.getColumnProperty(item.getPropSheetPnl());
                String string = colName = columnProp != null && columnProp.getValue() != null ? columnProp.getValue().toString() : null;
                if (colName != null) {
                    Class<String> colType;
                    VisualMappingFunction<?, ?> mapping = item.getModel().getVisualMappingFunction();
                    Class<String> mapColType = mapping != null ? mapping.getMappingColumnType() : null;
                    CyColumn column = table.getColumn(colName);
                    Class<String> clazz = colType = column != null ? column.getType() : null;
                    if (mapColType == List.class) {
                        mapColType = String.class;
                    }
                    if (colType == List.class) {
                        colType = String.class;
                    }
                    if (column == null || mapColType != null && !mapColType.isAssignableFrom(colType)) {
                        String tableName = table != null ? targetDataType.getSimpleName().replace("Cy", "") : null;
                        msg = "<html>Visual Mapping cannot be applied to current network:<br>" + tableName + " table does not have column <b>\"" + colName + "\"</b>" + (String)(mapColType != null ? " (" + mapColType.getSimpleName() + ")" : "") + "</html>";
                        msgType = VisualPropertySheetItem.MessageType.WARNING;
                    }
                }
            }
            String finalMsg = msg;
            VisualPropertySheetItem.MessageType finalMsgType = msgType;
            ViewUtil.invokeOnEDT(() -> item.setMessage(finalMsg, finalMsgType));
        }
    }

    private void updateLockedValues(CyNetworkView currentView) {
        if (currentView != null) {
            this.updateLockedValues(Collections.singleton(currentView), CyNetwork.class);
            this.updateLockedValues(this.vmProxy.getSelectedNodeViews(currentView), CyNode.class);
            this.updateLockedValues(this.vmProxy.getSelectedEdgeViews(currentView), CyEdge.class);
        } else {
            this.updateLockedValues(Collections.EMPTY_SET, CyNetwork.class);
        }
    }

    private <S extends CyIdentifiable> void updateLockedValues(Set<View<S>> selectedViews, Class<S> targetDataType) {
        ViewUtil.invokeOnEDT(() -> {
            Set<VisualPropertySheet> vpSheets = this.vizMapperMainPanel.getVisualPropertySheets();
            for (VisualPropertySheet sheet : vpSheets) {
                SortedSet<VisualPropertySheetItem<?>> vpItems = sheet.getItems();
                for (VisualPropertySheetItem visualPropertySheetItem : vpItems) {
                    VisualPropertySheetItemModel model = visualPropertySheetItem.getModel();
                    if (model.getTargetDataType() != targetDataType) continue;
                    Set values = this.getDistinctLockedValues(model.getVisualProperty(), selectedViews);
                    this.updateVpInfoLockedState(model, values, selectedViews);
                }
            }
        });
    }

    private <T, S extends CyIdentifiable> void updateVpInfoLockedState(VisualPropertySheetItemModel<T> model, Set<T> lockedValues, Set<View<S>> selectedViews) {
        Object value = null;
        LockedValueState state = LockedValueState.DISABLED;
        if (lockedValues.size() == 1) {
            value = lockedValues.iterator().next();
            state = value == null ? LockedValueState.ENABLED_NOT_SET : LockedValueState.ENABLED_UNIQUE_VALUE;
        } else if (lockedValues.size() > 1) {
            state = LockedValueState.ENABLED_MULTIPLE_VALUES;
        }
        model.setLockedValue(value);
        model.setLockedValueState(state);
    }

    private <T, S extends CyIdentifiable> Set<T> getDistinctLockedValues(VisualProperty<T> vp, Set<View<S>> views) {
        HashSet<Object> values = new HashSet<Object>();
        for (View<S> view : views) {
            if (view == null) continue;
            if (view.isValueLocked(vp)) {
                values.add(view.getVisualProperty(vp));
            } else {
                values.add(null);
            }
            if (values.size() <= 1) continue;
            break;
        }
        return values;
    }

    private JMenuItem createMenuItem(CyAction action, Map<?, ?> properties) {
        String title = ServicePropertiesUtil.getTitle(properties);
        if (title == null) {
            title = action.getName();
        }
        if (title == null) {
            logger.error("Cannot create VizMapper menu item for: " + action + "; \"title\" metadata is missing from properties: " + properties);
            return null;
        }
        JMenuItem menuItem = new JMenuItem((Action)action);
        menuItem.setText(title);
        double gravity = ServicePropertiesUtil.getGravity(properties);
        boolean insertSeparatorBefore = ServicePropertiesUtil.getInsertSeparatorBefore(properties);
        boolean insertSeparatorAfter = ServicePropertiesUtil.getInsertSeparatorAfter(properties);
        String menuId = ServicePropertiesUtil.getString(properties, "menu", "");
        if (menuId.equals("context")) {
            this.vizMapperMainPanel.addContextMenuItem(menuItem, gravity, insertSeparatorBefore, insertSeparatorAfter);
        } else if (menuId.equals("table")) {
            this.vizMapperMainPanel.addTableOption(menuItem, gravity, insertSeparatorBefore, insertSeparatorAfter);
        } else {
            this.vizMapperMainPanel.addOption(menuItem, gravity, insertSeparatorBefore, insertSeparatorAfter);
        }
        return menuItem;
    }

    private void openDefaultValueEditor(ActionEvent evt, VisualPropertySheetItem vpSheetItem) {
        VisualPropertySheetItemModel model = vpSheetItem.getModel();
        final VisualProperty vp = model.getVisualProperty();
        final VisualStyle style = vpSheetItem.getModel().getVisualStyle();
        final Object oldValue = style.getDefaultValue(vp);
        Object val = null;
        try {
            EditorManager editorMgr = this.servicesUtil.get(EditorManager.class);
            val = editorMgr.showVisualPropertyValueEditor(this.vizMapperMainPanel, vp, oldValue);
        }
        catch (Exception ex) {
            logger.error("Error opening Visual Property values editor for: " + vp, (Throwable)ex);
        }
        final Object newValue = val;
        if (newValue != null && !newValue.equals(oldValue)) {
            style.setDefaultValue(vp, newValue);
            UndoSupport undo = this.servicesUtil.get(UndoSupport.class);
            undo.postEdit(new AbstractCyEdit("Set Default Value"){

                public void undo() {
                    style.setDefaultValue(vp, oldValue);
                }

                public void redo() {
                    style.setDefaultValue(vp, newValue);
                }
            });
        }
    }

    private void openLockedValueEditor(ActionEvent evt, VisualPropertySheetItem vpSheetItem) {
        VisualPropertySheetItemModel model = vpSheetItem.getModel();
        VisualProperty vp = model.getVisualProperty();
        Object curValue = model.getLockedValue();
        Object newValue = null;
        try {
            EditorManager editorMgr = this.servicesUtil.get(EditorManager.class);
            newValue = editorMgr.showVisualPropertyValueEditor(this.vizMapperMainPanel, vp, curValue);
        }
        catch (Exception editorMgr) {
            // empty catch block
        }
        if (newValue != null && !newValue.equals(curValue)) {
            LockedValuesVO vo = new LockedValuesVO(Collections.singletonMap(vp, newValue));
            this.sendNotification("SET_LOCKED_VALUES", vo);
        }
    }

    private void removeLockedValue(ActionEvent e, VisualPropertySheetItem<?> vpSheetItem) {
        VisualProperty<?> visualProperty = vpSheetItem.getModel().getVisualProperty();
        LockedValuesVO vo = new LockedValuesVO(Collections.singleton(visualProperty));
        this.sendNotification("REMOVE_LOCKED_VALUES", vo);
    }

    private void onSelectedVisualStyleChanged(PropertyChangeEvent e) {
        VisualStyle oldStyle;
        if (this.ignoreVisualStyleSelectedEvents) {
            return;
        }
        final VisualStyle newStyle = (VisualStyle)e.getNewValue();
        if (!Objects.equals(newStyle, oldStyle = this.vmProxy.getCurrentVisualStyle())) {
            new Thread(() -> {
                this.vmProxy.setCurrentVisualStyle(newStyle);
                UndoSupport undo = this.servicesUtil.get(UndoSupport.class);
                undo.postEdit(new AbstractCyEdit("Set Current Style"){

                    public void undo() {
                        VizMapperMediator.this.vmProxy.setCurrentVisualStyle(oldStyle);
                    }

                    public void redo() {
                        VizMapperMediator.this.vmProxy.setCurrentVisualStyle(newStyle);
                    }
                });
            }).start();
        }
    }

    private void onDependencySelectionChanged(ItemEvent e, VisualPropertySheetItem<?> vpSheetItem) {
        boolean selected = e.getStateChange() == 1;
        VisualPropertyDependency<?> dep = vpSheetItem.getModel().getVisualPropertyDependency();
        dep.setDependency(selected);
        ViewUtil.invokeOnEDT(() -> this.updateItemsStatus());
    }

    private void onColumnChangedUpdateMappings(String colName, CyTable tbl) {
        CyNetwork curNet = this.vmProxy.getCurrentNetwork();
        if (curNet == null) {
            return;
        }
        ArrayList<VisualPropertySheet> vpSheets = new ArrayList<VisualPropertySheet>(2);
        if (tbl.equals(curNet.getDefaultEdgeTable())) {
            vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyEdge.class));
        } else if (tbl.equals(curNet.getDefaultNodeTable())) {
            vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyNode.class));
        } else if (tbl.equals(curNet.getDefaultNetworkTable())) {
            vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyNetwork.class));
        }
        if (tbl.equals(this.vmProxy.getCurrentTable())) {
            vpSheets.add(this.vizMapperMainPanel.getVisualPropertySheet(CyColumn.class));
        }
        if (vpSheets != null && !vpSheets.isEmpty()) {
            for (VisualPropertySheet vpSheet : vpSheets) {
                if (vpSheet == null) continue;
                for (VisualPropertySheetItem visualPropertySheetItem : vpSheet.getItems()) {
                    VisualMappingFunction mapping = visualPropertySheetItem.getModel().getVisualMappingFunction();
                    if (mapping == null || !mapping.getMappingColumnName().equalsIgnoreCase(colName)) continue;
                    this.updateMappingStatus(visualPropertySheetItem);
                }
            }
        }
    }

    private void showContextMenu(JPopupMenu contextMenu, MouseEvent e) {
        ViewUtil.invokeOnEDT(() -> {
            Component parent = (Component)e.getSource();
            contextMenu.show(parent, e.getX(), e.getY());
        });
    }

    private /* synthetic */ void lambda$onTaskFactoryRegistered$11(1 action, Map properties, TaskFactory taskFactory) {
        JMenuItem menuItem = this.createMenuItem((CyAction)action, properties);
        if (menuItem != null) {
            this.taskFactories.put(taskFactory, menuItem);
        }
    }

    private class ContextMenuMouseListener
    extends MouseAdapter {
        private VisualPropertySheet vpSheet;
        private VisualPropertySheetItem<?> vpSheetItem;

        ContextMenuMouseListener(VisualPropertySheet vpSheet, VisualPropertySheetItem<?> vpSheetItem) {
            this.vpSheet = vpSheet;
            this.vpSheetItem = vpSheetItem;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowContextMenu(e, this.vpSheet, this.vpSheetItem);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowContextMenu(e, this.vpSheet, this.vpSheetItem);
        }

        private void maybeShowContextMenu(MouseEvent e, VisualPropertySheet vpSheet, VisualPropertySheetItem<?> vpSheetItem) {
            if (!e.isPopupTrigger()) {
                return;
            }
            if (!vpSheetItem.isSelected()) {
                vpSheet.setSelectedItems(Collections.singleton(vpSheetItem));
            }
            JPopupMenu contextMenu = VizMapperMediator.this.vizMapperMainPanel.getContextMenu();
            ViewUtil.invokeOnEDT(() -> {
                JMenu mapValueGeneratorsMenu = VizMapperMediator.this.vizMapperMainPanel.getMapValueGeneratorsSubMenu();
                Class<? extends CyIdentifiable> targetDataType = vpSheet.getModel().getTargetDataType();
                mapValueGeneratorsMenu.setVisible(targetDataType != CyNetwork.class);
                if (mapValueGeneratorsMenu.isVisible()) {
                    mapValueGeneratorsMenu.removeAll();
                    Class<?> dataType = null;
                    for (Map.Entry<String, GenerateDiscreteValuesAction> entry : VizMapperMediator.this.mappingGenerators.entrySet()) {
                        if (dataType != null && dataType != entry.getValue().getGenerator().getDataType()) {
                            mapValueGeneratorsMenu.add(new JSeparator());
                        }
                        mapValueGeneratorsMenu.add((Action)((Object)entry.getValue()));
                        dataType = entry.getValue().getGenerator().getDataType();
                    }
                }
                VizMapperMediator.this.showContextMenu(contextMenu, e);
            });
        }
    }
}

