/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualLexiconNode;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.DropDownMenuButton;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItem;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItemModel;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetModel;
import org.cytoscape.view.vizmap.gui.util.PropertySheetUtil;

public class VisualPropertySheet
extends JPanel {
    private JPanel toolBarPnl;
    private JPanel vpListHeaderPnl;
    private JScrollPane vpListScr;
    private DropDownMenuButton vpsBtn;
    private JPopupMenu vpsMenu;
    private JButton expandAllBtn;
    private JButton collapseAllBtn;
    private final VisualPropertySheetModel model;
    private final TreeSet<VisualPropertySheetItem<?>> items;
    private final Map<VisualProperty<?>, VisualPropertySheetItem<?>> vpItemMap;
    private final Map<String, VisualPropertySheetItem<?>> depItemMap;
    private final Map<VisualPropertySheetItem<?>, JCheckBoxMenuItem> menuItemMap;
    private VisualPropertySheetItem<?> selectionHead;
    private VisualPropertySheetItem<?> selectionTail;
    private boolean doNotUpdateCollapseExpandButtons;
    private final ServicesUtil servicesUtil;

    public VisualPropertySheet(VisualPropertySheetModel model, ServicesUtil servicesUtil) {
        if (model == null) {
            throw new IllegalArgumentException("'model' must not be null");
        }
        if (servicesUtil == null) {
            throw new IllegalArgumentException("'servicesUtil' must not be null");
        }
        this.model = model;
        this.servicesUtil = servicesUtil;
        this.items = new TreeSet();
        this.vpItemMap = new HashMap();
        this.depItemMap = new HashMap();
        this.menuItemMap = new HashMap();
        this.init();
    }

    public VisualPropertySheetModel getModel() {
        return this.model;
    }

    public void setItems(Set<VisualPropertySheetItem<?>> newItems) {
        this.vpItemMap.clear();
        this.depItemMap.clear();
        this.items.clear();
        if (newItems != null) {
            this.items.addAll(newItems);
            JPanel p = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.anchor = 23;
            c.gridx = 0;
            c.weightx = 1.0;
            int y = 0;
            int minWidth = 120;
            for (final VisualPropertySheetItem<?> i : this.items) {
                c.gridy = y++;
                p.add(i, c);
                if (i.getModel().getVisualPropertyDependency() == null) {
                    this.vpItemMap.put(i.getModel().getVisualProperty(), i);
                } else {
                    this.depItemMap.put(i.getModel().getVisualPropertyDependency().getIdString(), i);
                }
                i.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        VisualPropertySheet.this.onMousePressedItem(e, i);
                    }
                });
                if (i.getModel().isVisualMappingAllowed()) {
                    i.addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentShown(ComponentEvent e) {
                            VisualPropertySheet.this.updateCollapseExpandButtons();
                        }

                        @Override
                        public void componentHidden(ComponentEvent e) {
                            if (VisualPropertySheet.this.selectionHead == i) {
                                VisualPropertySheet.this.selectionHead = null;
                            }
                            if (VisualPropertySheet.this.selectionTail == i) {
                                VisualPropertySheet.this.selectionTail = null;
                            }
                            VisualPropertySheet.this.updateCollapseExpandButtons();
                        }
                    });
                    i.addPropertyChangeListener("enabled", evt -> this.updateCollapseExpandButtons());
                    i.addPropertyChangeListener("expanded", evt -> this.updateCollapseExpandButtons());
                    i.getPropSheetPnl().getTable().addMouseListener((MouseListener)new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            VisualPropertySheet.this.onMousePressedItem(e, i);
                        }
                    });
                }
                minWidth = Math.max(minWidth, i.getPreferredSize().width);
            }
            JPanel fillPnl = new JPanel();
            fillPnl.setBackground(VisualPropertySheetItem.getBackgroundColor());
            c.fill = 1;
            c.weighty = 1.0;
            p.add((Component)fillPnl, c);
            fillPnl.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!e.isShiftDown() || e.isControlDown()) {
                        VisualPropertySheet.this.setSelectedItems(Collections.EMPTY_SET);
                    }
                }
            });
            this.getVpListScr().setViewportView(p);
            minWidth += 10;
            minWidth = Math.min(minWidth, 400);
            this.getVpListScr().setMinimumSize(new Dimension(minWidth, 140));
            if (this.getParent() != null) {
                minWidth = Math.max(minWidth + 8, this.getParent().getMinimumSize().width);
                this.getParent().setMinimumSize(new Dimension(minWidth, this.getParent().getMinimumSize().height));
            }
        }
        this.updateCollapseExpandButtons();
        this.createMenuItems();
    }

    public SortedSet<VisualPropertySheetItem<?>> getItems() {
        return (SortedSet)this.items.clone();
    }

    public <T> VisualPropertySheetItem<T> getItem(VisualProperty<T> vp) {
        return this.vpItemMap.get(vp);
    }

    public <T> VisualPropertySheetItem<T> getItem(VisualPropertyDependency<T> dep) {
        return this.depItemMap.get(dep.getIdString());
    }

    public synchronized Set<VisualPropertySheetItem<?>> getSelectedItems() {
        HashSet set = new HashSet();
        for (VisualPropertySheetItem<?> i : this.items) {
            if (!i.isSelected()) continue;
            set.add(i);
        }
        return set;
    }

    public synchronized void setSelectedItems(Set<VisualPropertySheetItem<?>> selectedItems) {
        for (VisualPropertySheetItem<?> i : this.items) {
            i.setSelected(selectedItems != null && i.isVisible() && selectedItems.contains(i));
            if (i.isSelected()) continue;
            if (i == this.selectionHead) {
                this.selectionHead = null;
            }
            if (i != this.selectionTail) continue;
            this.selectionTail = null;
        }
    }

    public void setVisible(VisualPropertySheetItem<?> item, boolean visible) {
        if (!visible) {
            item.setSelected(false);
        }
        item.setVisible(visible);
    }

    private void init() {
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getToolBarPnl()).addComponent(this.getVpListHeaderPnl()).addComponent(this.getVpListScr()));
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.getToolBarPnl()).addComponent(this.getVpListHeaderPnl()).addComponent(this.getVpListScr()));
    }

    private JPanel getToolBarPnl() {
        if (this.toolBarPnl == null) {
            this.toolBarPnl = new JPanel();
            this.toolBarPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.toolBarPnl.setLayout(new BoxLayout(this.toolBarPnl, 0));
            this.toolBarPnl.add(this.getVpsBtn());
            this.toolBarPnl.add(Box.createHorizontalGlue());
            if (this.model.getTargetDataType() != CyNetwork.class) {
                this.toolBarPnl.add(this.getExpandAllBtn());
                this.toolBarPnl.add(this.getCollapseAllBtn());
            }
        }
        return this.toolBarPnl;
    }

    private JPanel getVpListHeaderPnl() {
        if (this.vpListHeaderPnl == null) {
            this.vpListHeaderPnl = new JPanel();
            this.vpListHeaderPnl.setLayout(new BoxLayout(this.vpListHeaderPnl, 0));
            this.vpListHeaderPnl.add(Box.createRigidArea(new Dimension(2, 12)));
            HeaderLabel defLbl = new HeaderLabel("Def.");
            defLbl.setToolTipText("Default Value");
            this.vpListHeaderPnl.add(defLbl);
            if (this.model.getTargetDataType() != CyNetwork.class) {
                HeaderLabel mapLbl = new HeaderLabel("Map.");
                mapLbl.setToolTipText("Mapping");
                this.vpListHeaderPnl.add(mapLbl);
            }
            if (this.model.getTargetDataType() != CyColumn.class) {
                HeaderLabel bypassLbl = new HeaderLabel("Byp.");
                bypassLbl.setToolTipText("Bypass");
                this.vpListHeaderPnl.add(bypassLbl);
            }
            this.vpListHeaderPnl.add(Box.createHorizontalGlue());
        }
        return this.vpListHeaderPnl;
    }

    private JScrollPane getVpListScr() {
        if (this.vpListScr == null) {
            this.vpListScr = new JScrollPane(20, 31);
            this.vpListScr.getVerticalScrollBar().setUnitIncrement(8);
            this.vpListScr.getViewport().addChangeListener(evt -> {
                for (VisualPropertySheetItem visualPropertySheetItem : this.getItems()) {
                    visualPropertySheetItem.fitToWidth(this.vpListScr.getViewport().getWidth());
                }
            });
        }
        return this.vpListScr;
    }

    private DropDownMenuButton getVpsBtn() {
        if (this.vpsBtn == null) {
            this.vpsBtn = new DropDownMenuButton(this.getVpsMenu());
            this.vpsBtn.setText("Properties");
            this.vpsBtn.setToolTipText("Show/Hide Properties...");
            this.vpsBtn.setHorizontalAlignment(2);
            this.vpsBtn.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.vpsBtn.setContentAreaFilled(false);
        }
        return this.vpsBtn;
    }

    protected JPopupMenu getVpsMenu() {
        if (this.vpsMenu == null) {
            this.vpsMenu = new JPopupMenu();
            this.vpsMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    VisualPropertySheet.this.updateMenuItems();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        return this.vpsMenu;
    }

    protected JButton getExpandAllBtn() {
        if (this.expandAllBtn == null) {
            IconManager iconManager = this.servicesUtil.get(IconManager.class);
            this.expandAllBtn = new JButton("\uf103");
            this.expandAllBtn.setToolTipText("Expand all mappings");
            this.expandAllBtn.setBorderPainted(false);
            this.expandAllBtn.setContentAreaFilled(false);
            this.expandAllBtn.setFocusPainted(false);
            this.expandAllBtn.setFont(iconManager.getIconFont(17.0f));
            this.expandAllBtn.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            this.expandAllBtn.addActionListener(evt -> this.expandAllMappings());
        }
        return this.expandAllBtn;
    }

    protected JButton getCollapseAllBtn() {
        if (this.collapseAllBtn == null) {
            IconManager iconManager = this.servicesUtil.get(IconManager.class);
            this.collapseAllBtn = new JButton("\uf102");
            this.collapseAllBtn.setToolTipText("Collapse all mappings");
            this.collapseAllBtn.setBorderPainted(false);
            this.collapseAllBtn.setContentAreaFilled(false);
            this.collapseAllBtn.setFocusPainted(false);
            this.collapseAllBtn.setFont(iconManager.getIconFont(17.0f));
            this.collapseAllBtn.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            this.collapseAllBtn.addActionListener(evt -> this.collapseAllMappings());
        }
        return this.collapseAllBtn;
    }

    private void createMenuItems() {
        JPopupMenu rootMenu = this.getVpsMenu();
        this.menuItemMap.clear();
        int length = rootMenu.getSubElements() != null ? rootMenu.getSubElements().length : 0;
        for (int i = 0; i < length; ++i) {
            rootMenu.remove(i);
        }
        VisualLexicon lexicon = this.model.getVisualLexicon();
        if (lexicon == null) {
            return;
        }
        VisualProperty<?> rootVp = this.model.getRootVisualProperty();
        VisualLexiconNode rootNode = lexicon.getVisualLexiconNode(rootVp);
        PriorityQueue<VisualLexiconNode> queue = new PriorityQueue<VisualLexiconNode>(50, new Comparator<VisualLexiconNode>(){

            @Override
            public int compare(VisualLexiconNode n1, VisualLexiconNode n2) {
                Collator collator = Collator.getInstance(Locale.getDefault());
                collator.setStrength(0);
                return collator.compare(VisualPropertySheetItemModel.createTitle(n1.getVisualProperty()), VisualPropertySheetItemModel.createTitle(n2.getVisualProperty()));
            }
        });
        queue.addAll(rootNode.getChildren());
        HashMap<VisualLexiconNode, JComponent> menuMap = new HashMap<VisualLexiconNode, JComponent>();
        menuMap.put(rootNode, rootMenu);
        VisualStyle style = this.model.getVisualStyle();
        HashSet disabledProps = new HashSet();
        HashSet nextNodes = new HashSet();
        while (!queue.isEmpty()) {
            VisualLexiconNode curNode = (VisualLexiconNode)queue.poll();
            VisualProperty vp = curNode.getVisualProperty();
            if (vp.getTargetDataType() == this.model.getTargetDataType()) {
                Collection children = curNode.getChildren();
                nextNodes.addAll(children);
                if (PropertySheetUtil.isCompatible(vp).booleanValue()) {
                    String label;
                    VisualLexiconNode parentNode = curNode.getParent();
                    boolean leaf = children.isEmpty();
                    VisualPropertySheetItem vpSheetItem = this.getItem(vp);
                    String string = label = vpSheetItem != null ? vpSheetItem.getModel().getTitle() : VisualPropertySheetItemModel.createTitle(vp);
                    if (!leaf) {
                        JMenu nonLeafMenu = new JMenu(label);
                        menuMap.put(curNode, nonLeafMenu);
                        ((JComponent)menuMap.get(parentNode)).add(nonLeafMenu);
                        parentNode = curNode;
                    }
                    if (vpSheetItem != null) {
                        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(label, vpSheetItem.isVisible());
                        mi.addActionListener(evt -> this.setVisible(vpSheetItem, !vpSheetItem.isVisible()));
                        ((JComponent)menuMap.get(parentNode)).add(mi);
                        this.menuItemMap.put(vpSheetItem, mi);
                        if (parentNode == curNode) {
                            ((JComponent)menuMap.get(parentNode)).add(new JSeparator());
                        }
                        if (disabledProps.contains(vp)) {
                            mi.setEnabled(false);
                        }
                    }
                }
            }
            queue.addAll(nextNodes);
            nextNodes.clear();
        }
        TreeSet depTreeSet = new TreeSet((d1, d2) -> {
            Collator collator = Collator.getInstance(Locale.getDefault());
            collator.setStrength(0);
            return collator.compare(d1.getDisplayName(), d2.getDisplayName());
        });
        depTreeSet.addAll(style.getAllVisualPropertyDependencies());
        for (VisualPropertyDependency dep : depTreeSet) {
            VisualPropertySheetItem vpSheetItem = this.getItem(dep);
            if (vpSheetItem == null) continue;
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(dep.getDisplayName(), vpSheetItem.isVisible());
            mi.addActionListener(evt -> this.setVisible(vpSheetItem, !vpSheetItem.isVisible()));
            VisualLexiconNode parentNode = lexicon.getVisualLexiconNode(dep.getParentVisualProperty());
            JComponent parentMenu = (JComponent)menuMap.get(parentNode);
            if (parentMenu == null) {
                parentMenu = rootMenu;
            }
            parentMenu.add(mi);
            this.menuItemMap.put(vpSheetItem, mi);
        }
    }

    private void updateMenuItems() {
        for (Map.Entry<VisualPropertySheetItem<?>, JCheckBoxMenuItem> entry : this.menuItemMap.entrySet()) {
            entry.getValue().setSelected(entry.getKey().isVisible());
        }
    }

    private void updateCollapseExpandButtons() {
        if (this.doNotUpdateCollapseExpandButtons || this.model.getTargetDataType() == CyNetwork.class) {
            return;
        }
        boolean enableCollapse = false;
        boolean enableExpand = false;
        for (VisualPropertySheetItem<?> item : this.items) {
            if (item.isVisible() && item.isEnabled()) {
                if (item.isExpanded()) {
                    enableCollapse = true;
                } else if (!enableExpand && !item.isExpanded() && item.getModel().getVisualMappingFunction() != null) {
                    enableExpand = true;
                }
            }
            if (!enableExpand || !enableCollapse) continue;
            break;
        }
        this.getCollapseAllBtn().setEnabled(enableCollapse);
        this.getExpandAllBtn().setEnabled(enableExpand);
    }

    private void collapseAllMappings() {
        this.doNotUpdateCollapseExpandButtons = true;
        for (VisualPropertySheetItem<?> item : this.items) {
            item.collapse();
        }
        this.doNotUpdateCollapseExpandButtons = false;
        this.updateCollapseExpandButtons();
    }

    private void expandAllMappings() {
        this.doNotUpdateCollapseExpandButtons = true;
        for (VisualPropertySheetItem<?> item : this.items) {
            if (!item.isEnabled() || item.getModel().getVisualMappingFunction() == null) continue;
            item.expand();
        }
        this.doNotUpdateCollapseExpandButtons = false;
        this.updateCollapseExpandButtons();
    }

    private void onMousePressedItem(MouseEvent e, VisualPropertySheetItem<?> item) {
        if (e.isPopupTrigger()) {
            this.selectionHead = item;
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            boolean isMac = LookAndFeelUtil.isMac();
            if (isMac && e.isMetaDown() || !isMac && e.isControlDown()) {
                item.setSelected(!item.isSelected());
                this.selectionHead = item.isSelected() ? item : this.findNextSelectionHead(this.selectionHead);
            } else {
                if (e.isShiftDown()) {
                    if (this.selectionHead != null && this.selectionHead.isVisible() && this.selectionHead.isSelected() && this.selectionHead != item) {
                        if (this.selectionTail != null) {
                            this.changeRangeSelection(this.selectionHead, this.selectionTail, false);
                        }
                        this.selectionTail = item;
                        this.changeRangeSelection(this.selectionHead, this.selectionTail, true);
                    } else if (!item.isSelected()) {
                        item.setSelected(true);
                    }
                } else {
                    this.setSelectedItems(Collections.singleton(item));
                }
                if (this.getSelectedItems().size() == 1) {
                    this.selectionHead = item;
                }
            }
        }
    }

    private void changeRangeSelection(VisualPropertySheetItem<?> item1, VisualPropertySheetItem<?> item2, boolean selected) {
        NavigableSet<VisualPropertySheetItem<?>> subSet = item1.compareTo(item2) <= 0 ? this.items.subSet(item1, false, item2, true) : this.items.subSet(item2, true, item1, false);
        for (VisualPropertySheetItem<?> nextItem : subSet) {
            if (!nextItem.isVisible()) continue;
            nextItem.setSelected(selected);
        }
    }

    private VisualPropertySheetItem<?> findNextSelectionHead(VisualPropertySheetItem<?> fromItem) {
        VisualPropertySheetItem<?> head = null;
        if (fromItem != null) {
            NavigableSet<VisualPropertySheetItem<?>> subSet = this.items.tailSet(fromItem, false);
            for (VisualPropertySheetItem<?> nextItem : subSet) {
                if (!nextItem.isVisible() || !nextItem.isSelected()) continue;
                head = nextItem;
                break;
            }
            if (head == null) {
                subSet = this.items.headSet(fromItem, false);
                Iterator<VisualPropertySheetItem<?>> iterator = subSet.descendingIterator();
                while (iterator.hasNext()) {
                    VisualPropertySheetItem<?> nextItem;
                    nextItem = iterator.next();
                    if (!nextItem.isVisible() || !nextItem.isSelected()) continue;
                    head = nextItem;
                    break;
                }
            }
        }
        return head;
    }

    private static class HeaderLabel
    extends JLabel {
        HeaderLabel(String text) {
            super(text);
            this.setFont(this.getFont().deriveFont(1).deriveFont(10.0f));
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(3);
            Dimension d = new Dimension(VisualPropertySheetItem.VPButtonUI.getPreferredWidth(), 18);
            this.setMinimumSize(d);
            this.setPreferredSize(d);
            this.setMaximumSize(d);
        }
    }
}

