/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.event.PopupMenuListener;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.util.swing.GravityTracker;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.MenuGravityTracker;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheet;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItem;

public class PropertySheetPanel {
    private JTabbedPane propertiesPn;
    private final Map<Class<? extends CyIdentifiable>, VisualPropertySheet> vpSheetMap = new HashMap<Class<? extends CyIdentifiable>, VisualPropertySheet>();
    private JPopupMenu contextPopupMenu;
    private JMenu editSubMenu;
    private MenuGravityTracker editSubMenuGravityTracker;
    private JMenu mapValueGeneratorsSubMenu;
    private final Icon networkIcon;
    private final Icon tableIcon;
    private static Map<Class<?>, Integer> tabOrder = new HashMap();

    public PropertySheetPanel(ServicesUtil servicesUtil) {
        IconManager iconManager = servicesUtil.get(IconManager.class);
        Font iconFont = iconManager.getIconFont(14.0f);
        this.networkIcon = new TextIcon("\uf1e1", iconFont, 16, 16);
        this.tableIcon = new TextIcon("\uf0ce", iconFont, 16, 16);
    }

    public JComponent getComponent() {
        return this.getPropertiesPn();
    }

    public Set<VisualPropertySheet> getVisualPropertySheets() {
        return new HashSet<VisualPropertySheet>(this.vpSheetMap.values());
    }

    public VisualPropertySheet getVisualPropertySheet(Class<? extends CyIdentifiable> targetDataType) {
        return this.vpSheetMap.get(targetDataType);
    }

    public void addVisualPropertySheet(VisualPropertySheet sheet) {
        if (sheet == null) {
            return;
        }
        Class<? extends CyIdentifiable> type = sheet.getModel().getTargetDataType();
        this.vpSheetMap.put(type, sheet);
        this.getPropertiesPn().removeAll();
        ArrayList<VisualPropertySheet> sheets = new ArrayList<VisualPropertySheet>(this.vpSheetMap.values());
        sheets.sort((s1, s2) -> {
            int o1 = tabOrder.get(s1.getModel().getTargetDataType());
            int o2 = tabOrder.get(s2.getModel().getTargetDataType());
            return Integer.compare(o1, o2);
        });
        for (VisualPropertySheet s : sheets) {
            Icon icon = s.getModel().getTargetDataType() == CyColumn.class ? this.tableIcon : null;
            this.getPropertiesPn().addTab(s.getModel().getTitle(), icon, s);
        }
    }

    public void removeAllVisualPropertySheets() {
        this.getPropertiesPn().removeAll();
        this.vpSheetMap.clear();
    }

    public VisualPropertySheet getSelectedVisualPropertySheet() {
        return (VisualPropertySheet)this.getPropertiesPn().getSelectedComponent();
    }

    public void setSelectedVisualPropertySheet(VisualPropertySheet sheet) {
        int idx;
        if (sheet != null && (idx = this.getPropertiesPn().indexOfTab(sheet.getModel().getTitle())) != -1) {
            this.getPropertiesPn().setSelectedIndex(idx);
        }
    }

    JTabbedPane getPropertiesPn() {
        if (this.propertiesPn == null) {
            this.propertiesPn = new JTabbedPane(3, 0);
        }
        return this.propertiesPn;
    }

    JPopupMenu getContextMenu() {
        if (this.contextPopupMenu == null) {
            this.contextPopupMenu = new JPopupMenu();
            this.contextPopupMenu.add(this.getEditSubMenu());
            this.contextPopupMenu.add(this.getMapValueGeneratorsSubMenu());
            this.contextPopupMenu.add(new JSeparator());
            JMenuItem mi = new JMenuItem("Hide Selected Visual Properties");
            mi.addActionListener(evt -> this.hideSelectedItems());
            this.contextPopupMenu.add(mi);
        }
        return this.contextPopupMenu;
    }

    JMenu getEditSubMenu() {
        if (this.editSubMenu == null) {
            this.editSubMenu = new JMenu("Edit");
        }
        return this.editSubMenu;
    }

    JMenu getMapValueGeneratorsSubMenu() {
        if (this.mapValueGeneratorsSubMenu == null) {
            this.mapValueGeneratorsSubMenu = new JMenu("Mapping Value Generators");
        }
        return this.mapValueGeneratorsSubMenu;
    }

    public void hideSelectedItems() {
        VisualPropertySheet vpSheet = this.getSelectedVisualPropertySheet();
        if (vpSheet != null) {
            for (VisualPropertySheetItem<?> item : vpSheet.getSelectedItems()) {
                vpSheet.setVisible(item, false);
            }
        }
    }

    private MenuGravityTracker getEditSubMenuGravityTracker() {
        if (this.editSubMenuGravityTracker == null) {
            this.editSubMenuGravityTracker = new MenuGravityTracker(this.getEditSubMenu());
        }
        return this.editSubMenuGravityTracker;
    }

    public void addContextMenuItem(JMenuItem menuItem, double gravity, boolean insertSeparatorBefore, boolean insertSeparatorAfter) {
        this.addMenuItem((GravityTracker)this.getEditSubMenuGravityTracker(), menuItem, gravity, insertSeparatorBefore, insertSeparatorAfter);
        if (menuItem.getAction() instanceof CyAction) {
            this.getContextMenu().addPopupMenuListener((PopupMenuListener)((CyAction)menuItem.getAction()));
        }
    }

    public void removeContextMenuItem(JMenuItem menuItem) {
        this.getEditSubMenuGravityTracker().removeComponent((Component)menuItem);
        if (menuItem.getAction() instanceof CyAction) {
            this.getContextMenu().removePopupMenuListener((PopupMenuListener)((CyAction)menuItem.getAction()));
        }
    }

    private void addMenuItem(GravityTracker gravityTracker, JMenuItem menuItem, double gravity, boolean insertSeparatorBefore, boolean insertSeparatorAfter) {
        if (insertSeparatorBefore) {
            gravityTracker.addMenuSeparator(gravity - 1.0E-4);
        }
        gravityTracker.addMenuItem(menuItem, gravity);
        if (insertSeparatorAfter) {
            gravityTracker.addMenuSeparator(gravity + 1.0E-4);
        }
    }

    static {
        tabOrder.put(CyNode.class, 1);
        tabOrder.put(CyEdge.class, 2);
        tabOrder.put(CyNetwork.class, 3);
        tabOrder.put(CyColumn.class, 4);
    }
}

