/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.util.mapgenerator;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.swing.JOptionPane;
import org.cytoscape.view.vizmap.gui.internal.util.mapgenerator.AbstractDiscreteMappingGenerator;
import org.cytoscape.view.vizmap.gui.internal.view.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomNumberMappingGenerator
extends AbstractDiscreteMappingGenerator<Number> {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public RandomNumberMappingGenerator() {
        super(Number.class);
    }

    @Override
    public <T> Map<T, Number> generateMap(Set<T> attributeSet) {
        Double max;
        Double min;
        HashMap<T, Double> valueMap = new HashMap<T, Double>();
        if (attributeSet == null || attributeSet.size() == 0) {
            return valueMap;
        }
        String[] range = new String[2];
        ViewUtil.invokeOnEDTAndWait(() -> this.getRange(range), logger);
        try {
            min = Double.valueOf(range[0]);
            max = Double.valueOf(range[1]);
        }
        catch (Exception e) {
            return this.generateMap(attributeSet);
        }
        Double valueRange = max - min;
        long seed = System.currentTimeMillis();
        Random rand = new Random(seed);
        for (T key : attributeSet) {
            valueMap.put(key, (double)rand.nextFloat() * valueRange + min);
        }
        return valueMap;
    }

    private void getRange(String[] range) {
        String s = JOptionPane.showInputDialog(null, "Please enter the value range (example: 30-100):", "Assign Random Numbers", -1);
        String[] split = s.split("-");
        if (split.length == 2) {
            range[0] = split[0];
            range[1] = split[1];
        }
    }
}

