/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.task;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class RemoveLockedValuesTask
extends AbstractTask {
    private final Set<VisualProperty<?>> visualProperties;
    private final Set<View<? extends CyIdentifiable>> views;
    private final ServicesUtil servicesUtil;
    private final CyNetworkView netView;
    private Map<View<? extends CyIdentifiable>, Map<VisualProperty<?>, Object>> previousViewValues;

    public RemoveLockedValuesTask(Set<VisualProperty<?>> visualProperties, Set<View<? extends CyIdentifiable>> views, CyNetworkView netView, ServicesUtil servicesUtil) {
        this.visualProperties = visualProperties;
        this.views = views;
        this.netView = netView;
        this.servicesUtil = servicesUtil;
        this.previousViewValues = new HashMap();
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        boolean removed;
        if (this.visualProperties != null && this.views != null && this.netView != null && (removed = this.removeLockedValues(true))) {
            UndoSupport undo = this.servicesUtil.get(UndoSupport.class);
            undo.postEdit((AbstractCyEdit)new RemoveLockedValuesEdit());
        }
    }

    private boolean removeLockedValues(boolean firstTime) {
        boolean removed = false;
        HashMap previousValues = null;
        for (View<? extends CyIdentifiable> view : this.views) {
            if (firstTime) {
                previousValues = new HashMap();
            }
            for (VisualProperty<?> vp : this.visualProperties) {
                if (!vp.getTargetDataType().isAssignableFrom(((CyIdentifiable)view.getModel()).getClass())) continue;
                if (firstTime && view.isDirectlyLocked(vp)) {
                    previousValues.put(vp, view.getVisualProperty(vp));
                }
                view.clearValueLock(vp);
                removed = true;
            }
            if (!firstTime || previousValues.isEmpty()) continue;
            this.previousViewValues.put(view, previousValues);
        }
        if (removed) {
            this.updateView();
        }
        return removed;
    }

    private void updateView() {
        VisualStyle style = this.servicesUtil.get(VisualMappingManager.class).getVisualStyle(this.netView);
        style.apply(this.netView);
        this.netView.updateView();
    }

    private boolean isNetworkViewRegistered() {
        CyNetworkViewManager netViewMgr = this.servicesUtil.get(CyNetworkViewManager.class);
        return netViewMgr.getNetworkViews((CyNetwork)this.netView.getModel()).contains(this.netView);
    }

    private class RemoveLockedValuesEdit
    extends AbstractCyEdit {
        public RemoveLockedValuesEdit() {
            super("Remove Bypass");
        }

        public void undo() {
            if (RemoveLockedValuesTask.this.isNetworkViewRegistered()) {
                for (Map.Entry<View<CyIdentifiable>, Map<VisualProperty<?>, Object>> entry : RemoveLockedValuesTask.this.previousViewValues.entrySet()) {
                    View<? extends CyIdentifiable> view = entry.getKey();
                    Map<VisualProperty<?>, Object> previousValues = entry.getValue();
                    for (VisualProperty<?> vp : previousValues.keySet()) {
                        Object value = previousValues.get(vp);
                        if (value == null) continue;
                        view.setLockedValue(vp, value);
                    }
                }
                RemoveLockedValuesTask.this.updateView();
            }
        }

        public void redo() {
            if (RemoveLockedValuesTask.this.isNetworkViewRegistered()) {
                RemoveLockedValuesTask.this.removeLockedValues(false);
            }
        }
    }
}

