/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.task;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.io.read.VizmapReader;
import org.cytoscape.io.read.VizmapReaderManager;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportDefaultVizmapTask
extends AbstractTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final ServicesUtil servicesUtil;
    private final File vizmapFile;

    public ImportDefaultVizmapTask(ServicesUtil servicesUtil) {
        this.servicesUtil = servicesUtil;
        CyApplicationConfiguration config = servicesUtil.get(CyApplicationConfiguration.class);
        this.vizmapFile = new File(config.getConfigurationDirectoryLocation(), "default_vizmap.xml");
    }

    public void run(TaskMonitor tm) throws Exception {
        VizmapReader reader;
        VizmapReaderManager vizmapReaderMgr = this.servicesUtil.get(VizmapReaderManager.class);
        if (!this.vizmapFile.exists()) {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("default_vizmap.xml");
            reader = vizmapReaderMgr.getReader(url.toURI(), url.getPath());
        } else {
            reader = vizmapReaderMgr.getReader(this.vizmapFile.toURI(), this.vizmapFile.getName());
        }
        logger.debug("Default vizmap file = " + this.vizmapFile.getName());
        if (reader == null) {
            throw new NullPointerException("Failed to find Default Vizmap loader.");
        }
        this.insertTasksAfterCurrentTask(new Task[]{reader, new AddVisualStylesTask(reader)});
    }

    private final class AddVisualStylesTask
    extends AbstractTask {
        private final VizmapReader reader;

        public AddVisualStylesTask(VizmapReader reader) {
            this.reader = reader;
        }

        public void run(TaskMonitor taskMonitor) throws Exception {
            taskMonitor.setTitle("Load Preset Styles");
            taskMonitor.setProgress(0.0);
            Set styles = this.reader.getVisualStyles();
            if (styles != null) {
                VisualMappingManager vmMgr = ImportDefaultVizmapTask.this.servicesUtil.get(VisualMappingManager.class);
                VisualStyle defStyle = vmMgr.getDefaultVisualStyle();
                String DEFAULT_STYLE_NAME = defStyle.getTitle();
                VisualStyle newDefStyle = null;
                int count = 1;
                int total = styles.size();
                for (VisualStyle vs : styles) {
                    if (this.cancelled) break;
                    if (vs.getTitle().equals(DEFAULT_STYLE_NAME)) {
                        newDefStyle = vs;
                        continue;
                    }
                    logger.debug(count + " of " + total + ": " + vs.getTitle());
                    vmMgr.addVisualStyle(vs);
                    taskMonitor.setProgress((double)(count / total));
                    ++count;
                }
                if (this.cancelled) {
                    for (VisualStyle vs : styles) {
                        if (vs.getTitle().equals(DEFAULT_STYLE_NAME)) continue;
                        vmMgr.removeVisualStyle(vs);
                    }
                } else {
                    if (newDefStyle != null) {
                        taskMonitor.setStatusMessage(total + " of " + total + ": " + DEFAULT_STYLE_NAME);
                        this.updateVisualStyle(newDefStyle, defStyle);
                    }
                    vmMgr.setCurrentVisualStyle(defStyle);
                }
                ImportDefaultVizmapTask.this.servicesUtil.get(CyEventHelper.class).flushPayloadEvents();
                taskMonitor.setProgress(1.0);
            }
        }

        private void updateVisualStyle(VisualStyle source, VisualStyle target) {
            HashSet mapingSet = new HashSet(target.getAllVisualMappingFunctions());
            for (Object mapping : mapingSet) {
                target.removeVisualMappingFunction(mapping.getVisualProperty());
            }
            HashSet depList = new HashSet(target.getAllVisualPropertyDependencies());
            for (VisualPropertyDependency dep : depList) {
                target.removeVisualPropertyDependency(dep);
            }
            RenderingEngineManager renderingEngineMgr = ImportDefaultVizmapTask.this.servicesUtil.get(RenderingEngineManager.class);
            VisualLexicon lexicon = renderingEngineMgr.getDefaultVisualLexicon();
            Set properties = lexicon.getAllVisualProperties();
            for (VisualProperty vp : properties) {
                if (vp.equals(BasicVisualLexicon.NETWORK) || vp.equals(BasicVisualLexicon.NODE) || vp.equals(BasicVisualLexicon.EDGE)) continue;
                target.setDefaultValue(vp, source.getDefaultValue(vp));
            }
            for (VisualPropertyDependency dep : source.getAllVisualPropertyDependencies()) {
                target.addVisualPropertyDependency(dep);
            }
            for (VisualMappingFunction mapping : source.getAllVisualMappingFunctions()) {
                target.addVisualMappingFunction(mapping);
            }
        }
    }
}

