/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.property.AbstractConfigDirPropsReader;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.PropertyUpdatedEvent;
import org.cytoscape.property.PropertyUpdatedListener;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.puremvc.java.multicore.patterns.proxy.Proxy;

public class PropsProxy
extends Proxy
implements PropertyUpdatedListener {
    public static final String NAME = "VizMapperPropsProxy";
    public static final String DEF_VISUAL_PROPS_TOKEN = "defaultVisualProperties";
    private final PropsReader propsReader = new PropsReader();

    public PropsProxy(ServicesUtil servicesUtil) {
        super(NAME);
        Properties props = new Properties();
        props.setProperty("cyPropertyName", "vizmapper");
        servicesUtil.registerAllServices((Object)this.propsReader, props);
        this.setData(this.propsReader.getProperties());
    }

    public Properties getProperties() {
        return this.propsReader.getProperties();
    }

    public Set<String> getDefaultVisualProperties(Class<? extends CyIdentifiable> targetDataType) {
        String key = "defaultVisualProperties." + PropsProxy.toPropsToken(targetDataType);
        Properties props = this.getProperties();
        String[] val = props.getProperty(key, "").split(",");
        return new HashSet<String>(Arrays.asList(val));
    }

    public void setDefaultVisualProperties(Class<? extends CyIdentifiable> targetDataType, Set<String> idSet) {
        if (targetDataType != null && idSet != null) {
            String key = "defaultVisualProperties." + PropsProxy.toPropsToken(targetDataType);
            String value = "";
            if (!idSet.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                Iterator<String> iter = idSet.iterator();
                while (iter.hasNext()) {
                    sb.append(iter.next());
                    if (!iter.hasNext()) continue;
                    sb.append(",");
                }
                value = sb.toString();
            }
            Properties props = this.propsReader.getProperties();
            props.put(key, value);
            this.setData(props);
        }
    }

    public void handleEvent(PropertyUpdatedEvent e) {
        CyProperty cyProp = (CyProperty)e.getSource();
        if (cyProp != null && "vizmapper".equals(cyProp.getName())) {
            this.setData(cyProp.getProperties());
            this.sendNotification("VIZMAP_PROPS_CHANGED", this.getProperties());
        }
    }

    private static String toPropsToken(Class<? extends CyIdentifiable> targetDataType) {
        return targetDataType.getSimpleName().toLowerCase().replace("cy", "");
    }

    private static class PropsReader
    extends AbstractConfigDirPropsReader {
        static final String NAME = "vizmapper";
        static final String FILE_NAME = "vizmapper.props";

        public PropsReader() {
            super(NAME, FILE_NAME, CyProperty.SavePolicy.CONFIG_DIR);
        }
    }
}

