/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.model;

import java.text.Collator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.gui.MappingFunctionFactoryManager;
import org.cytoscape.view.vizmap.gui.internal.CurrentTableService;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.puremvc.java.multicore.patterns.proxy.Proxy;

public class MappingFunctionFactoryProxy
extends Proxy {
    public static final String NAME = "MappingFunctionFactoryProxy";
    private String currentColumnName;
    private Class<? extends CyIdentifiable> currentTargetDataType;
    private final ServicesUtil servicesUtil;

    public MappingFunctionFactoryProxy(ServicesUtil servicesUtil) {
        super(NAME);
        this.servicesUtil = servicesUtil;
    }

    public void setCurrentColumnName(String name) {
        this.currentColumnName = name;
    }

    public String getCurrentColumnName() {
        return this.currentColumnName;
    }

    public void setCurrentTargetDataType(Class<? extends CyIdentifiable> type) {
        this.currentTargetDataType = type;
    }

    public Class<? extends CyIdentifiable> getCurrentTargetDataType() {
        return this.currentTargetDataType;
    }

    public Set<VisualMappingFunctionFactory> getMappingFactories() {
        CyColumn column;
        CurrentTableService currentTableService;
        CyTable table;
        Collator collator = Collator.getInstance(Locale.getDefault());
        collator.setStrength(0);
        TreeSet<VisualMappingFunctionFactory> set = new TreeSet<VisualMappingFunctionFactory>((f1, f2) -> collator.compare(f1.toString(), f2.toString()));
        MappingFunctionFactoryManager mappingFactoryMgr = this.servicesUtil.get(MappingFunctionFactoryManager.class);
        set.addAll(mappingFactoryMgr.getFactories());
        if (this.currentColumnName != null && this.currentTargetDataType != null && (table = (currentTableService = this.servicesUtil.get(CurrentTableService.class)).getCurrentTable(this.currentTargetDataType)) != null && (column = table.getColumn(this.currentColumnName)) != null && !Number.class.isAssignableFrom(column.getType())) {
            set.remove(mappingFactoryMgr.getFactory(ContinuousMapping.class));
        }
        return set;
    }
}

