/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.ColumnCreatedEvent;
import org.cytoscape.model.events.ColumnCreatedListener;
import org.cytoscape.model.events.ColumnDeletedEvent;
import org.cytoscape.model.events.ColumnDeletedListener;
import org.cytoscape.model.events.ColumnNameChangedEvent;
import org.cytoscape.model.events.ColumnNameChangedListener;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedEvent;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import org.cytoscape.model.events.NetworkAddedEvent;
import org.cytoscape.model.events.NetworkAddedListener;
import org.cytoscape.view.vizmap.gui.internal.model.AttributeSet;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.puremvc.java.multicore.patterns.proxy.Proxy;

public class AttributeSetProxy
extends Proxy
implements ColumnDeletedListener,
ColumnCreatedListener,
ColumnNameChangedListener,
NetworkAddedListener,
NetworkAboutToBeDestroyedListener {
    public static final String NAME = "AttributeSetProxy";
    private final Set<Class<? extends CyIdentifiable>> graphObjects = (Set)this.getData();
    private final Map<CyNetwork, Map<Class<? extends CyIdentifiable>, AttributeSet>> attrSets;
    private final Map<CyNetwork, Map<Class<? extends CyIdentifiable>, Set<CyTable>>> tableSets;
    private Class<?> currentMappingType;
    private final ServicesUtil servicesUtil;

    public AttributeSetProxy(ServicesUtil servicesUtil) {
        super(NAME, new HashSet());
        this.graphObjects.add(CyNode.class);
        this.graphObjects.add(CyEdge.class);
        this.graphObjects.add(CyNetwork.class);
        this.servicesUtil = servicesUtil;
        this.attrSets = new WeakHashMap<CyNetwork, Map<Class<? extends CyIdentifiable>, AttributeSet>>();
        this.tableSets = new WeakHashMap<CyNetwork, Map<Class<? extends CyIdentifiable>, Set<CyTable>>>();
    }

    public void setCurrentMappingType(Class<?> mappingType) {
        this.currentMappingType = mappingType;
    }

    public Class<?> getCurrentMappingType() {
        return this.currentMappingType;
    }

    public AttributeSet getAttributeSet(CyNetwork network, Class<? extends CyIdentifiable> objectType) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(objectType);
        Map<Class<? extends CyIdentifiable>, AttributeSet> attrSetMap = this.attrSets.get(network);
        if (attrSetMap == null) {
            throw new NullPointerException("No such network registered in this mamager: " + network);
        }
        AttributeSet attributeSet = attrSetMap.get(objectType);
        if (this.currentMappingType == ContinuousMapping.class) {
            AttributeSet newAttributeSet = new AttributeSet(objectType);
            for (Map.Entry<String, Class<?>> entry : attributeSet.getAttrMap().entrySet()) {
                if (!Number.class.isAssignableFrom(entry.getValue())) continue;
                newAttributeSet.getAttrMap().put(entry.getKey(), entry.getValue());
            }
            attributeSet = newAttributeSet;
        }
        return attributeSet;
    }

    public AttributeSet getAttributeSet(CyTable table) {
        Objects.requireNonNull(table);
        AttributeSet attributeSet = new AttributeSet(CyColumn.class);
        Map<String, Class<?>> attrs = attributeSet.getAttrMap();
        for (CyColumn col : table.getColumns()) {
            Class type = col.getType();
            if (this.currentMappingType == ContinuousMapping.class && !Number.class.isAssignableFrom(type)) continue;
            attrs.put(col.getName(), type);
        }
        return attributeSet;
    }

    public void handleEvent(NetworkAddedEvent e) {
        CyNetwork network = e.getNetwork();
        HashMap object2tableMap = new HashMap();
        HashMap<Class<? extends CyIdentifiable>, AttributeSet> attrSetMap = new HashMap<Class<? extends CyIdentifiable>, AttributeSet>();
        CyNetworkTableManager netTblMgr = this.servicesUtil.get(CyNetworkTableManager.class);
        for (Class<? extends CyIdentifiable> objectType : this.graphObjects) {
            Map tableMap = netTblMgr.getTables(network, objectType);
            Collection tables = tableMap.values();
            object2tableMap.put(objectType, new HashSet(tables));
            AttributeSet attrSet = new AttributeSet(objectType);
            for (CyTable table : tables) {
                Collection columns = table.getColumns();
                for (CyColumn column : columns) {
                    Class type = column.getType();
                    attrSet.getAttrMap().put(column.getName(), type);
                }
            }
            attrSetMap.put(objectType, attrSet);
        }
        this.attrSets.put(network, attrSetMap);
        this.tableSets.put(network, object2tableMap);
    }

    public void handleEvent(NetworkAboutToBeDestroyedEvent e) {
        CyNetwork network = e.getNetwork();
        this.attrSets.remove(network);
        this.tableSets.remove(network);
    }

    public void handleEvent(ColumnCreatedEvent e) {
        String newAttrName = e.getColumnName();
        CyTable table = (CyTable)e.getSource();
        for (CyNetwork network : this.tableSets.keySet()) {
            Map<Class<? extends CyIdentifiable>, Set<CyTable>> tMap = this.tableSets.get(network);
            for (Class<? extends CyIdentifiable> objectType : this.graphObjects) {
                Set<CyTable> targetTables = tMap.get(objectType);
                if (!targetTables.contains(table)) continue;
                this.attrSets.get(network).get(objectType).getAttrMap().put(newAttrName, table.getColumn(newAttrName).getType());
                return;
            }
        }
    }

    public void handleEvent(ColumnDeletedEvent e) {
        CyTable table = (CyTable)e.getSource();
        for (CyNetwork network : this.tableSets.keySet()) {
            Map<Class<? extends CyIdentifiable>, Set<CyTable>> tMap = this.tableSets.get(network);
            for (Class<? extends CyIdentifiable> objectType : this.graphObjects) {
                Set<CyTable> targetTables = tMap.get(objectType);
                if (!targetTables.contains(table)) continue;
                this.attrSets.get(network).get(objectType).getAttrMap().remove(e.getColumnName());
                return;
            }
        }
    }

    public void handleEvent(ColumnNameChangedEvent e) {
        CyTable table = (CyTable)e.getSource();
        for (CyNetwork network : this.tableSets.keySet()) {
            Map<Class<? extends CyIdentifiable>, Set<CyTable>> tMap = this.tableSets.get(network);
            for (Class<? extends CyIdentifiable> objectType : this.graphObjects) {
                Set<CyTable> targetTables = tMap.get(objectType);
                if (!targetTables.contains(table)) continue;
                this.attrSets.get(network).get(objectType).getAttrMap().remove(e.getOldColumnName());
                this.attrSets.get(network).get(objectType).getAttrMap().put(e.getNewColumnName(), table.getColumn(e.getNewColumnName()).getType());
                return;
            }
        }
    }
}

