/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.controller;

import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.gui.internal.model.VizMapperProxy;
import org.cytoscape.view.vizmap.gui.internal.task.ImportDefaultVizmapTask;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;
import org.puremvc.java.multicore.interfaces.INotification;
import org.puremvc.java.multicore.patterns.command.SimpleCommand;

public class ImportDefaultVisualStylesCommand
extends SimpleCommand {
    private final ServicesUtil servicesUtil;

    public ImportDefaultVisualStylesCommand(ServicesUtil servicesUtil) {
        this.servicesUtil = servicesUtil;
    }

    public void execute(INotification notification) {
        TaskIterator iterator = new TaskIterator(new Task[]{new ImportDefaultVizmapTask(this.servicesUtil)});
        DialogTaskManager taskManager = this.servicesUtil.get(DialogTaskManager.class);
        final VizMapperProxy proxy = (VizMapperProxy)this.getFacade().retrieveProxy("VisualStyleProxy");
        proxy.setIgnoreStyleEvents(true);
        taskManager.execute(iterator, new TaskObserver(){

            public void taskFinished(ObservableTask task) {
            }

            public void allFinished(FinishStatus finishStatus) {
                proxy.setIgnoreStyleEvents(false);
                proxy.loadVisualStyles();
                proxy.setCurrentVisualStyle(ImportDefaultVisualStylesCommand.this.servicesUtil.get(VisualMappingManager.class).getDefaultVisualStyle());
            }
        });
    }
}

