/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.action;

import com.l2fprod.common.propertysheet.PropertySheetTable;
import com.l2fprod.common.propertysheet.PropertySheetTableModel;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.gui.editor.EditorManager;
import org.cytoscape.view.vizmap.gui.internal.VizMapperProperty;
import org.cytoscape.view.vizmap.gui.internal.action.AbstractVizMapperAction;
import org.cytoscape.view.vizmap.gui.internal.event.CellType;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheet;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItem;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItemModel;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapperMainPanel;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditSelectedDiscreteValuesAction
extends AbstractVizMapperAction {
    public static final String NAME = "Edit Selected Discrete Mapping Values";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final Map<DiscreteMapping<?, ?>, Map<Object, Object>> previousMappingValues;
    private final Map<DiscreteMapping<?, ?>, Map<Object, Object>> newMappingValues;
    private final EditorManager editorManager;

    public EditSelectedDiscreteValuesAction(ServicesUtil servicesUtil, EditorManager editorManager) {
        super(NAME, servicesUtil);
        this.editorManager = editorManager;
        this.previousMappingValues = new HashMap();
        this.newMappingValues = new HashMap();
    }

    public void actionPerformed(ActionEvent e) {
        VizMapperMainPanel vizMapperMainPanel = this.getVizMapperMainPanel();
        if (vizMapperMainPanel == null) {
            return;
        }
        VisualPropertySheet vpSheet = vizMapperMainPanel.getSelectedVisualPropertySheet();
        if (vpSheet == null) {
            return;
        }
        for (VisualPropertySheetItem<?> vpSheetItem : vpSheet.getSelectedItems()) {
            VisualPropertySheetItemModel<?> model = vpSheetItem.getModel();
            PropertySheetTable table = vpSheetItem.getPropSheetPnl().getTable();
            int[] selected = table.getSelectedRows();
            if (selected == null || selected.length == 0 || !(model.getVisualMappingFunction() instanceof DiscreteMapping)) continue;
            DiscreteMapping dm = (DiscreteMapping)model.getVisualMappingFunction();
            VisualProperty vp = dm.getVisualProperty();
            Object newValue = null;
            try {
                newValue = this.editorManager.showVisualPropertyValueEditor(vizMapperMainPanel, vp, vp.getDefault());
            }
            catch (Exception ex) {
                logger.error("Could not edit value.", (Throwable)ex);
            }
            if (newValue == null) continue;
            HashMap newValues = new HashMap();
            HashMap previousValues = new HashMap();
            for (int i = 0; i < selected.length; ++i) {
                VizMapperProperty prop;
                PropertySheetTableModel.Item item = (PropertySheetTableModel.Item)table.getValueAt(selected[i], 0);
                if (item == null || !(item.getProperty() instanceof VizMapperProperty) || (prop = (VizMapperProperty)item.getProperty()).getCellType() != CellType.DISCRETE) continue;
                previousValues.put(prop.getKey(), prop.getValue());
                newValues.put(prop.getKey(), newValue);
            }
            if (!previousValues.isEmpty()) {
                this.previousMappingValues.put(dm, previousValues);
            }
            if (!newValues.isEmpty()) {
                this.newMappingValues.put(dm, newValues);
            }
            dm.putAll(newValues);
        }
        if (!this.previousMappingValues.isEmpty()) {
            UndoSupport undo = this.servicesUtil.get(UndoSupport.class);
            undo.postEdit((AbstractCyEdit)new EditSelectedDiscreteValuesEdit());
        }
    }

    public void updateEnableState() {
        boolean enabled = false;
        VizMapperMainPanel vizMapperMainPanel = this.getVizMapperMainPanel();
        VisualPropertySheet vpSheet = null;
        if (vizMapperMainPanel != null) {
            vpSheet = vizMapperMainPanel.getSelectedVisualPropertySheet();
        }
        if (vpSheet != null) {
            block0: for (VisualPropertySheetItem<?> vpSheetItem : vpSheet.getSelectedItems()) {
                VisualPropertySheetItemModel<?> model = vpSheetItem.getModel();
                PropertySheetTable table = vpSheetItem.getPropSheetPnl().getTable();
                int[] selected = table.getSelectedRows();
                if (selected == null || !(model.getVisualMappingFunction() instanceof DiscreteMapping)) continue;
                for (int i = 0; i < selected.length; ++i) {
                    VizMapperProperty prop;
                    PropertySheetTableModel.Item item = (PropertySheetTableModel.Item)table.getValueAt(selected[i], 0);
                    if (item == null || !(item.getProperty() instanceof VizMapperProperty) || (prop = (VizMapperProperty)item.getProperty()).getCellType() != CellType.DISCRETE) continue;
                    enabled = true;
                    continue block0;
                }
            }
        }
        this.setEnabled(enabled);
    }

    public void setIsInMenuBar(boolean b) {
    }

    public void setIsInToolBar(boolean b) {
    }

    public void setPreferredMenu(String menu) {
    }

    public void setToolbarGravity(float f) {
    }

    public void setMenuGravity(float f) {
    }

    private class EditSelectedDiscreteValuesEdit
    extends AbstractCyEdit {
        public EditSelectedDiscreteValuesEdit() {
            super(EditSelectedDiscreteValuesAction.NAME);
        }

        public void undo() {
            for (Map.Entry<DiscreteMapping<?, ?>, Map<Object, Object>> entry : EditSelectedDiscreteValuesAction.this.previousMappingValues.entrySet()) {
                DiscreteMapping<?, ?> dm = entry.getKey();
                dm.putAll(entry.getValue());
            }
        }

        public void redo() {
            for (Map.Entry<DiscreteMapping<?, ?>, Map<Object, Object>> entry : EditSelectedDiscreteValuesAction.this.newMappingValues.entrySet()) {
                DiscreteMapping<?, ?> dm = entry.getKey();
                dm.putAll(entry.getValue());
            }
        }
    }
}

