/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.util;

import java.util.HashMap;
import java.util.Map;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;

public class AttributeFields {
    private final Map<String, Class<?>> columnTypeMap = new HashMap();

    public AttributeFields(CyNetwork network) {
        this.initFields(network);
    }

    private void initFields(CyNetwork network) {
        CyTable nodeCyDataTable = network.getDefaultNodeTable();
        for (CyColumn column : nodeCyDataTable.getColumns()) {
            String name = column.getName();
            if (name == null) continue;
            this.columnTypeMap.put(name.toLowerCase(), column.getType());
        }
        CyTable edgeCyDataTable = network.getDefaultEdgeTable();
        for (CyColumn column : edgeCyDataTable.getColumns()) {
            String name = column.getName();
            if (name == null) continue;
            this.columnTypeMap.put(name.toLowerCase(), column.getType());
        }
    }

    public String[] getFields() {
        String[] keys = new String[this.columnTypeMap.size()];
        int i = 0;
        for (String key : this.columnTypeMap.keySet()) {
            keys[i++] = key;
        }
        return keys;
    }

    public Class<?> getType(String attrName) {
        Class<?> valueType = this.columnTypeMap.get(attrName);
        return valueType;
    }
}

