/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.search.internal.EnhancedSearch;
import org.cytoscape.search.internal.IndexAndSearchTask;
import org.cytoscape.search.internal.SearchResults;
import org.cytoscape.search.internal.SearchTaskFactory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedSearchPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final EnhancedSearch searchMgr;
    private final CyServiceRegistrar serviceRegistrar;
    private JTextField tfSearchText;

    public EnhancedSearchPanel(EnhancedSearch searchMgr, CyServiceRegistrar serviceRegistrar) {
        this.searchMgr = searchMgr;
        this.serviceRegistrar = serviceRegistrar;
        this.initComponents();
    }

    private void doSearching() {
        String queryStr = this.tfSearchText.getText().trim();
        if (queryStr == null || queryStr.length() == 0) {
            return;
        }
        CyApplicationManager appManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyNetwork currentNetwork = appManager.getCurrentNetwork();
        if (currentNetwork != null) {
            SearchTaskFactory factory = new SearchTaskFactory(this.searchMgr, queryStr, this.serviceRegistrar);
            DialogTaskManager taskMgr = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
            taskMgr.execute(factory.createTaskIterator(currentNetwork), new TaskObserver(){

                public void taskFinished(ObservableTask task) {
                    if (task instanceof IndexAndSearchTask) {
                        IndexAndSearchTask searchTask = (IndexAndSearchTask)task;
                        SearchResults result = searchTask.getResults(SearchResults.class);
                        EnhancedSearchPanel.this.showPopup(result);
                    }
                }

                public void allFinished(FinishStatus finishStatus) {
                }
            });
        } else {
            logger.error("Could not find network for search");
        }
    }

    private void showPopup(SearchResults results) {
        if (results == null) {
            return;
        }
        JLabel label = new JLabel();
        if (results.isError()) {
            label.setForeground(Color.RED);
        }
        label.setText("   " + results.getMessage() + "   ");
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{label});
        JPopupMenu popup = new JPopupMenu();
        popup.add(label);
        Timer timer = new Timer(3400, e -> popup.setVisible(false));
        timer.setRepeats(false);
        timer.start();
        popup.show(this.tfSearchText, 0, this.tfSearchText.getHeight());
    }

    private void initComponents() {
        final String defText = "Enter search term...";
        final Font defFont = UIManager.getFont("TextField.font") != null ? UIManager.getFont("TextField.font").deriveFont(LookAndFeelUtil.getSmallFontSize()) : null;
        this.tfSearchText = new JTextField();
        this.tfSearchText.putClientProperty("JTextField.variant", "search");
        this.tfSearchText.setToolTipText("<html>Example Search Queries:<br><br>YL* -- Search all columns<br>name:YL* -- Search 'name' column<br>GO\\:1232 -- Escape special characters and spaces with backslash</html>");
        this.tfSearchText.setName("tfSearchText");
        if (!LookAndFeelUtil.isAquaLAF()) {
            this.tfSearchText.setText(defText);
            if (defFont != null) {
                this.tfSearchText.setFont(defFont);
            }
        }
        this.tfSearchText.addActionListener(evt -> this.doSearching());
        this.tfSearchText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (EnhancedSearchPanel.this.tfSearchText.getText().equals(defText)) {
                    EnhancedSearchPanel.this.tfSearchText.setText("");
                    EnhancedSearchPanel.this.tfSearchText.setFont(UIManager.getFont("TextField.font"));
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!LookAndFeelUtil.isAquaLAF() && EnhancedSearchPanel.this.tfSearchText.getText().trim().isEmpty()) {
                    EnhancedSearchPanel.this.tfSearchText.setText(defText);
                    if (defFont != null) {
                        EnhancedSearchPanel.this.tfSearchText.setFont(defFont);
                    }
                }
            }
        });
        this.setKeyBindings(this.tfSearchText);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.tfSearchText, 120, 240, 300));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.tfSearchText, -2, -1, -2));
    }

    private void setKeyBindings(JComponent comp) {
        ActionMap actionMap = comp.getActionMap();
        InputMap inputMap = comp.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "FOCUS");
        actionMap.put("FOCUS", new KeyAction("FOCUS"));
    }

    private class KeyAction
    extends AbstractAction {
        static final String FOCUS = "FOCUS";

        KeyAction(String actionCommand) {
            this.putValue("ActionCommandKey", actionCommand);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(FOCUS) && EnhancedSearchPanel.this.tfSearchText.isVisible()) {
                EnhancedSearchPanel.this.tfSearchText.requestFocusInWindow();
                EnhancedSearchPanel.this.tfSearchText.selectAll();
            }
        }
    }
}

