/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.search.internal.IdentifiersCollector;
import org.cytoscape.search.internal.SearchResults;
import org.cytoscape.search.internal.util.AttributeFields;
import org.cytoscape.search.internal.util.CaseInsensitiveWhitespaceAnalyzer;
import org.cytoscape.search.internal.util.CustomMultiFieldQueryParser;
import org.cytoscape.search.internal.util.EnhancedSearchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedSearchQuery
implements Callable {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final RAMDirectory idx;
    private final CyNetwork network;
    private SearchResults results;
    private Searcher searcher;
    private final String query;

    public EnhancedSearchQuery(CyNetwork network, RAMDirectory index, String query) {
        this.network = network;
        this.idx = index;
        this.query = query;
    }

    public SearchResults call() throws Exception {
        this.executeQuery(this.query);
        return this.results;
    }

    public void executeQuery(String queryString) {
        try {
            logger.debug("Query start for: " + queryString);
            AttributeFields attFields = new AttributeFields(this.network);
            this.searcher = new IndexSearcher((Directory)this.idx);
            queryString = EnhancedSearchUtils.queryToLowerCase(queryString);
            this.search(queryString, attFields);
            this.searcher.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void search(String queryString, AttributeFields attFields) {
        CustomMultiFieldQueryParser queryParser = new CustomMultiFieldQueryParser(attFields, new CaseInsensitiveWhitespaceAnalyzer());
        try {
            Query query = queryParser.parse(queryString);
            IdentifiersCollector hitCollector = new IdentifiersCollector(this.searcher);
            this.searcher.search(query, (Collector)hitCollector);
            this.results = SearchResults.results(hitCollector.getNodeHits(), hitCollector.getEdgeHits());
        }
        catch (ParseException pe) {
            this.results = pe.getMessage() != null && pe.getMessage().endsWith("too many boolean clauses") ? SearchResults.syntaxError("At " + queryString.length() + " characters query string is too large") : SearchResults.syntaxError();
            logger.error(pe.getMessage(), (Throwable)pe);
        }
        catch (Exception e) {
            this.results = SearchResults.fatalError();
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public SearchResults getResults() {
        return this.results;
    }
}

