/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.search.internal.util.CaseInsensitiveWhitespaceAnalyzer;
import org.cytoscape.work.TaskMonitor;

public class EnhancedSearchIndex
implements Callable {
    private static final int PROGRESS_UPDATE_INTERVAL = 10000;
    private CyNetwork network;
    private TaskMonitor taskMonitor;

    protected EnhancedSearchIndex(CyNetwork network, TaskMonitor taskMonitor) {
        this.network = network;
        this.taskMonitor = taskMonitor;
    }

    public RAMDirectory call() throws Exception {
        RAMDirectory idx = EnhancedSearchIndex.buildIndex(this.network, this.taskMonitor);
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RAMDirectory buildIndex(CyNetwork network, TaskMonitor taskMonitor) {
        if (network == null) {
            throw new NullPointerException("Network is null.");
        }
        try {
            RAMDirectory idx = new RAMDirectory();
            CaseInsensitiveWhitespaceAnalyzer analyzer = new CaseInsensitiveWhitespaceAnalyzer();
            IndexWriter writer = new IndexWriter((Directory)idx, (Analyzer)analyzer, IndexWriter.MaxFieldLength.UNLIMITED);
            List nodeList = network.getNodeList();
            List edgeList = network.getEdgeList();
            int totalElements = nodeList.size() + edgeList.size();
            int counter = 0;
            taskMonitor.setProgress(0.0);
            for (CyNode cyNode : nodeList) {
                writer.addDocument(EnhancedSearchIndex.createDocument(network, (CyIdentifiable)cyNode, "node", cyNode.getSUID()));
                if (++counter % 10000 != 0) continue;
                taskMonitor.setProgress(EnhancedSearchIndex.updateProgress(counter, totalElements));
            }
            for (CyEdge cyEdge : edgeList) {
                writer.addDocument(EnhancedSearchIndex.createDocument(network, (CyIdentifiable)cyEdge, "edge", cyEdge.getSUID()));
                if (++counter % 10000 != 0) continue;
                taskMonitor.setProgress(EnhancedSearchIndex.updateProgress(counter, totalElements));
            }
            taskMonitor.setStatusMessage("Optimizing index");
            taskMonitor.setProgress(0.5);
            writer.optimize();
            writer.close();
            RAMDirectory rAMDirectory = idx;
            return rAMDirectory;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            RAMDirectory rAMDirectory = null;
            return rAMDirectory;
        }
        finally {
            taskMonitor.setProgress(0.95);
        }
    }

    private static double updateProgress(int processedElementCount, int totalElements) {
        if (totalElements <= 0) {
            return 0.0;
        }
        return (double)processedElementCount / (double)totalElements;
    }

    private static Document createDocument(CyNetwork network, CyIdentifiable graphObject, String graphObjectType, long index) {
        Document doc = new Document();
        String identifier = Long.toString(index);
        doc.add((Fieldable)new Field("ESP_INDEX", identifier, Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("ESP_TYPE", graphObjectType, Field.Store.YES, Field.Index.ANALYZED));
        CyRow cyRow = network.getRow(graphObject);
        CyTable cyDataTable = cyRow.getTable();
        Set attributeNames = CyTableUtil.getColumnNames((CyTable)cyDataTable);
        for (String attrName : attributeNames) {
            List attrValueList;
            Object attrValue;
            if (attrName == null) continue;
            String attrIndexingName = attrName.toLowerCase();
            Class valueType = cyDataTable.getColumn(attrName).getType();
            if (valueType == String.class) {
                attrValue = (String)network.getRow(graphObject).get(attrName, String.class);
                if (attrValue == null) continue;
                doc.add((Fieldable)new Field(attrIndexingName, (String)attrValue, Field.Store.YES, Field.Index.ANALYZED));
                continue;
            }
            if (valueType == Integer.class) {
                attrValue = (Integer)network.getRow(graphObject).get(attrName, Integer.class);
                if (attrValue == null) continue;
                NumericField field = new NumericField(attrIndexingName);
                field.setIntValue(((Integer)attrValue).intValue());
                doc.add((Fieldable)field);
                continue;
            }
            if (valueType == Long.class) {
                attrValue = (Long)network.getRow(graphObject).get(attrName, Long.class);
                if (attrValue == null) continue;
                NumericField field = new NumericField(attrIndexingName);
                field.setLongValue(((Long)attrValue).longValue());
                doc.add((Fieldable)field);
                continue;
            }
            if (valueType == Double.class) {
                attrValue = (Double)network.getRow(graphObject).get(attrName, Double.class);
                if (attrValue == null) continue;
                NumericField field = new NumericField(attrIndexingName);
                field.setDoubleValue(((Double)attrValue).doubleValue());
                doc.add((Fieldable)field);
                continue;
            }
            if (valueType == Boolean.class) {
                attrValue = (Boolean)network.getRow(graphObject).get(attrName, Boolean.class);
                if (attrValue == null) continue;
                doc.add((Fieldable)new Field(attrIndexingName, ((Boolean)attrValue).toString(), Field.Store.YES, Field.Index.ANALYZED));
                continue;
            }
            if (valueType != List.class || (attrValueList = (List)network.getRow(graphObject).get(attrName, List.class)) == null) continue;
            for (int j = 0; j < attrValueList.size(); ++j) {
                String attrValue2 = attrValueList.get(j).toString();
                doc.add((Fieldable)new Field(attrIndexingName, attrValue2, Field.Store.YES, Field.Index.ANALYZED));
            }
        }
        return doc;
    }
}

