/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class NetworkViewPreviewDialog
extends JDialog {
    private static int MAX_VISIBLE_THUMBNAILS = 3;
    private static int DEFAULT_THUMBNAIL_SIZE = 120;
    private static int PAD = 1;
    private static int GAP = 1;
    private static int BORDER_WIDTH = 2;
    private static int IMG_BORDER_WIDTH = 0;
    private JScrollPane scrollPane;
    private JPanel gridPanel;
    private CyNetworkView currentNetworkView;
    private final CySubNetwork network;
    private final CyServiceRegistrar serviceRegistrar;

    public NetworkViewPreviewDialog(CySubNetwork network, CyNetworkView currentView, Window owner, CyServiceRegistrar serviceRegistrar) {
        super(owner);
        this.network = network;
        this.currentNetworkView = currentView;
        this.serviceRegistrar = serviceRegistrar;
        this.init();
    }

    @Override
    public void setVisible(boolean b) {
        Component[] components = this.getGridPanel().getComponents();
        if (components != null) {
            for (Component c : this.getGridPanel().getComponents()) {
                if (!(c instanceof ThumbnailPanel)) continue;
                ((ThumbnailPanel)c).update();
            }
            if (components.length > MAX_VISIBLE_THUMBNAILS) {
                this.getScrollPane().setHorizontalScrollBarPolicy(32);
                Dimension d = new Dimension(3 * DEFAULT_THUMBNAIL_SIZE, this.getScrollPane().getPreferredSize().height);
                this.getScrollPane().setPreferredSize(d);
                this.pack();
            }
        }
        super.setVisible(b);
    }

    public CySubNetwork getNetwork() {
        return this.network;
    }

    public CyNetworkView getCurrentNetworkView() {
        return this.currentNetworkView;
    }

    private void setCurrentNetworkView(CyNetworkView newValue) {
        if (!newValue.equals(this.currentNetworkView)) {
            CyNetworkView oldValue = this.currentNetworkView;
            this.currentNetworkView = newValue;
            this.firePropertyChange("currentNetworkView", oldValue, newValue);
        }
    }

    private void init() {
        this.setUndecorated(true);
        this.setBackground(NetworkViewPreviewDialog.getBackgroundColor());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.getScrollPane(), -2, -1, -2));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getScrollPane(), -2, -1, -2));
        this.pack();
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getGridPanel());
            this.scrollPane.setVerticalScrollBarPolicy(21);
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.scrollPane.getViewport().setBackground(NetworkViewPreviewDialog.getBackgroundColor());
        }
        return this.scrollPane;
    }

    private JPanel getGridPanel() {
        if (this.gridPanel == null) {
            this.gridPanel = new GridPanel();
            this.gridPanel.setOpaque(false);
            this.gridPanel.setLayout(new BoxLayout(this.gridPanel, 0));
            CyNetworkViewManager netViewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
            RenderingEngineManager engineManager = (RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class);
            Collection netViews = netViewManager.getNetworkViews((CyNetwork)this.network);
            for (CyNetworkView view : netViews) {
                Collection engines = engineManager.getRenderingEngines((View)view);
                Iterator iterator = engines.iterator();
                if (!iterator.hasNext()) continue;
                RenderingEngine re = (RenderingEngine)iterator.next();
                ThumbnailPanel tp = new ThumbnailPanel(re, DEFAULT_THUMBNAIL_SIZE);
                this.gridPanel.add(tp);
            }
        }
        return this.gridPanel;
    }

    private static Color getBackgroundColor() {
        return UIManager.getColor("Table.background");
    }

    class ThumbnailPanel
    extends JPanel {
        private int MARGING_THICKNESS = 1;
        private JLabel currentLabel;
        private JLabel titleLabel;
        private JLabel imageLabel;
        private boolean hover;
        private boolean detached;
        private final RenderingEngine<?> engine;
        private final Color BORDER_COLOR = UIManager.getColor("Separator.foreground");
        private final Color HOVER_COLOR = UIManager.getColor("Focus.color");
        private Border MARGIN_BORDER = BorderFactory.createLineBorder(NetworkViewPreviewDialog.getBackgroundColor(), this.MARGING_THICKNESS);
        private Border SIMPLE_BORDER = BorderFactory.createLineBorder(this.BORDER_COLOR, 1);
        private Border DEFAULT_BORDER = BorderFactory.createCompoundBorder(this.MARGIN_BORDER, this.SIMPLE_BORDER);
        private Border DEFAULT_HOVER_BORDER = BorderFactory.createCompoundBorder(this.MARGIN_BORDER, BorderFactory.createLineBorder(this.HOVER_COLOR, 1));

        ThumbnailPanel(RenderingEngine<?> engine, int size) {
            this.engine = engine;
            this.setBorder(this.DEFAULT_BORDER);
            this.setOpaque(false);
            Dimension d = new Dimension(size - BORDER_WIDTH, size - BORDER_WIDTH);
            this.setMinimumSize(d);
            this.setPreferredSize(d);
            int CURR_LABEL_W = this.getCurrentLabel().getWidth();
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addGap(PAD).addComponent(this.getCurrentLabel(), CURR_LABEL_W, CURR_LABEL_W, CURR_LABEL_W).addGap(GAP, GAP, Short.MAX_VALUE).addComponent(this.getTitleLabel(), -2, -1, -2).addGap(GAP, GAP, Short.MAX_VALUE).addGap(CURR_LABEL_W).addGap(PAD)).addComponent(this.getImageLabel(), -2, -1, -2));
            layout.setVerticalGroup(layout.createSequentialGroup().addGap(GAP).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getCurrentLabel(), -2, -1, -2).addComponent(this.getTitleLabel(), -2, -1, -2)).addGap(GAP).addComponent(this.getImageLabel(), -2, -1, -2).addGap(0, 0, Short.MAX_VALUE));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ThumbnailPanel.this.hover = true;
                    ThumbnailPanel.this.updateBorder();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ThumbnailPanel.this.hover = false;
                    ThumbnailPanel.this.updateBorder();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    NetworkViewPreviewDialog.this.setCurrentNetworkView(ThumbnailPanel.this.getNetworkView());
                    NetworkViewPreviewDialog.this.dispose();
                }
            });
            this.update();
        }

        boolean isCurrent() {
            return this.getNetworkView().equals(NetworkViewPreviewDialog.this.currentNetworkView);
        }

        boolean isDetached() {
            return this.detached;
        }

        void setDetached(boolean detached) {
            this.detached = detached;
        }

        void update() {
            CyNetworkView netView = this.getNetworkView();
            String title = ViewUtil.getTitle(netView);
            this.getCurrentLabel().setText(this.isCurrent() ? "\uf111" : " ");
            this.getTitleLabel().setText(title);
            this.setToolTipText(title);
            int maxTitleWidth = (int)Math.round(this.getPreferredSize().getWidth() - (double)(2 * BORDER_WIDTH) - (double)(2 * PAD) - (double)(2 * GAP) - (double)(2 * this.getCurrentLabel().getWidth()));
            Dimension titleSize = new Dimension(maxTitleWidth, this.getTitleLabel().getPreferredSize().height);
            this.getTitleLabel().setPreferredSize(titleSize);
            this.getTitleLabel().setMaximumSize(titleSize);
            this.getTitleLabel().setSize(titleSize);
            this.updateBorder();
            this.updateIcon();
        }

        void updateIcon() {
            Dimension size = this.getSize();
            if (size != null && this.getTitleLabel().getSize() != null) {
                int lh = this.getTitleLabel().getHeight();
                int iw = size.width - 2 * BORDER_WIDTH - IMG_BORDER_WIDTH;
                int ih = size.height - 2 * BORDER_WIDTH - 2 * GAP - lh - IMG_BORDER_WIDTH;
                if (iw > 0 && ih > 0) {
                    Image img = this.createThumbnail(iw, ih);
                    ImageIcon icon = img != null ? new ImageIcon(img) : null;
                    this.getImageLabel().setIcon(icon);
                    this.updateUI();
                }
            }
        }

        private void updateBorder() {
            this.setBorder(this.hover && !this.isCurrent() ? this.DEFAULT_HOVER_BORDER : this.DEFAULT_BORDER);
        }

        CyNetworkView getNetworkView() {
            return (CyNetworkView)this.engine.getViewModel();
        }

        JLabel getCurrentLabel() {
            if (this.currentLabel == null) {
                this.currentLabel = new JLabel("\uf111");
                this.currentLabel.setFont(((IconManager)NetworkViewPreviewDialog.this.serviceRegistrar.getService(IconManager.class)).getIconFont(10.0f));
                this.currentLabel.setMinimumSize(this.currentLabel.getPreferredSize());
                this.currentLabel.setMaximumSize(this.currentLabel.getPreferredSize());
                this.currentLabel.setSize(this.currentLabel.getPreferredSize());
                this.currentLabel.setForeground(UIManager.getColor("Focus.color"));
            }
            return this.currentLabel;
        }

        JLabel getTitleLabel() {
            if (this.titleLabel == null) {
                this.titleLabel = new JLabel();
                this.titleLabel.setHorizontalAlignment(0);
                this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            }
            return this.titleLabel;
        }

        JLabel getImageLabel() {
            if (this.imageLabel == null) {
                this.imageLabel = new JLabel();
                this.imageLabel.setOpaque(true);
                this.imageLabel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Label.foreground"), IMG_BORDER_WIDTH));
            }
            return this.imageLabel;
        }

        private Image createThumbnail(double w, double h) {
            int iw = (int)Math.round(w);
            int ih = (int)Math.round(h);
            if (iw <= 0 || ih <= 0) {
                return null;
            }
            BufferedImage image = null;
            CyNetworkView netView = this.getNetworkView();
            netView.updateView();
            double vw = (Double)netView.getVisualProperty(BasicVisualLexicon.NETWORK_WIDTH);
            double vh = (Double)netView.getVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT);
            if (vw > 0.0 && vh > 0.0) {
                double viewRatio = vh / vw;
                double rectRatio = h / w;
                double scale = viewRatio > rectRatio ? w / vw : h / vh;
                int svw = (int)Math.round(vw * scale);
                int svh = (int)Math.round(vh * scale);
                if (svw > 0 && svh > 0) {
                    image = new BufferedImage(svw, svh, 2);
                    Graphics2D g = (Graphics2D)image.getGraphics();
                    g.scale(scale, scale);
                    this.engine.printCanvas((Graphics)g);
                    g.dispose();
                    image = image.getSubimage((svw - iw) / 2, (svh - ih) / 2, iw, ih);
                }
            }
            if (image == null) {
                image = new BufferedImage(iw, ih, 1);
                Graphics2D g2 = image.createGraphics();
                Paint bg = (Paint)netView.getVisualProperty(BasicVisualLexicon.NETWORK_BACKGROUND_PAINT);
                g2.setPaint(bg);
                g2.drawRect(IMG_BORDER_WIDTH, IMG_BORDER_WIDTH, iw, ih);
                g2.dispose();
            }
            return image;
        }

        @Override
        public String toString() {
            return (String)this.getNetworkView().getVisualProperty(BasicVisualLexicon.NETWORK_TITLE);
        }
    }

    private class GridPanel
    extends JPanel
    implements Scrollable {
        private GridPanel() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return (orientation == 1 ? visibleRect.height : visibleRect.width) - 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return true;
        }
    }
}

