/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import org.cytoscape.app.event.AppsFinishedStartingEvent;
import org.cytoscape.app.event.AppsFinishedStartingListener;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.CyShutdown;
import org.cytoscape.application.events.CyStartEvent;
import org.cytoscape.application.events.CyStartListener;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelComponent2;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.ToolBarComponent;
import org.cytoscape.application.swing.events.CytoPanelComponentSelectedEvent;
import org.cytoscape.application.swing.events.CytoPanelComponentSelectedListener;
import org.cytoscape.event.DebounceTimer;
import org.cytoscape.internal.actions.CytoPanelAction;
import org.cytoscape.internal.command.CommandToolPanel;
import org.cytoscape.internal.view.BiModalJSplitPane;
import org.cytoscape.internal.view.CytoPanelImpl;
import org.cytoscape.internal.view.CytoPanelNameInternal;
import org.cytoscape.internal.view.CytoPanelStateInternal;
import org.cytoscape.internal.view.CytoPanelUtil;
import org.cytoscape.internal.view.CytoscapeMenus;
import org.cytoscape.internal.view.CytoscapeToolBar;
import org.cytoscape.internal.view.MemStatusPanel;
import org.cytoscape.internal.view.NetworkViewMainPanel;
import org.cytoscape.internal.view.NetworkViewMediator;
import org.cytoscape.internal.view.StarterPanel;
import org.cytoscape.internal.view.util.ToggleableButtonGroup;
import org.cytoscape.internal.view.util.VerticalButtonUI;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.events.TableAddedEvent;
import org.cytoscape.model.events.TableAddedListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.session.events.SessionSavedEvent;
import org.cytoscape.session.events.SessionSavedListener;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.work.swing.DialogTaskManager;
import org.cytoscape.work.swing.StatusBarPanelFactory;
import org.jdesktop.swingx.border.DropShadowBorder;

public class CytoscapeDesktop
extends JFrame
implements CySwingApplication,
CyStartListener,
AppsFinishedStartingListener,
SessionLoadedListener,
SessionSavedListener,
SetCurrentNetworkListener,
SetCurrentNetworkViewListener,
TableAddedListener,
CytoPanelComponentSelectedListener {
    private static final String TITLE_PREFIX_STRING = "Session: ";
    private static final String NEW_SESSION_NAME = "New Session";
    static final Dimension DEF_DESKTOP_SIZE = new Dimension(1300, 850);
    private static final int DEF_DIVIDER_LOATION = 540;
    private static final String SMALL_ICON = "/images/logo.png";
    protected CytoscapeMenus cyMenus;
    protected NetworkViewMediator netViewMediator;
    private SideBar westSideBar;
    private SideBar eastSideBar;
    private SideBar southSideBar;
    private ComponentPopup popup;
    private final ToggleableButtonGroup undockedButtonGroup;
    private boolean isAdjusting;
    private boolean updatingTrimStack;
    private BiModalJSplitPane masterPane;
    private BiModalJSplitPane topPane;
    private BiModalJSplitPane leftPane;
    private BiModalJSplitPane rightPane;
    private BiModalJSplitPane topRightPane;
    private CytoPanelImpl northWestPanel;
    private CytoPanelImpl southWestPanel;
    private CytoPanelImpl eastPanel;
    private CytoPanelImpl southPanel;
    private CytoPanelImpl automationPanel;
    private JPanel mainPanel;
    private JPanel centerPanel;
    private JPanel bottomPanel;
    private JToolBar statusToolBar;
    private StarterPanel starterPanel;
    private StatusBarPanelFactory taskStatusPanelFactory;
    private StatusBarPanelFactory jobStatusPanelFactory;
    private final GlassPaneMouseListener glassPaneMouseListener = new GlassPaneMouseListener();
    private final Map<CytoPanelNameInternal, Dimension> undockPreferredSizes = new HashMap<CytoPanelNameInternal, Dimension>();
    private final Map<CytoPanelNameInternal, Dimension> dockPreferredSizes = new HashMap<CytoPanelNameInternal, Dimension>();
    private final DebounceTimer resizeEventTimer = new DebounceTimer(200);
    private List<String> controlComponentsOrder = Arrays.asList("org.cytoscape.Network", "org.cytoscape.Style", "org.cytoscape.Filter", "org.cytoscape.Annotation");
    private final Map<CytoPanel, JFrame> floatingFrames = new HashMap<CytoPanel, JFrame>();
    private boolean ignoreFloatingFrameCloseEvents;
    private boolean appsFinishedStarting;
    private final CyServiceRegistrar serviceRegistrar;

    public CytoscapeDesktop(final CytoscapeMenus cyMenus, NetworkViewMediator netViewMediator, final CyServiceRegistrar serviceRegistrar) {
        super("Session: New Session");
        this.cyMenus = cyMenus;
        this.netViewMediator = netViewMediator;
        this.serviceRegistrar = serviceRegistrar;
        final DialogTaskManager taskManager = (DialogTaskManager)serviceRegistrar.getService(DialogTaskManager.class);
        taskManager.setExecutionContext((Object)this);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(SMALL_ICON)));
        this.setDefaultCloseOperation(0);
        this.setJMenuBar(cyMenus.getJMenuBar());
        ((JComponent)this.getGlassPane()).setLayout(null);
        this.undockedButtonGroup = new ToggleableButtonGroup(true){

            @Override
            public void setSelected(ButtonModel model, boolean selected) {
                if (CytoscapeDesktop.this.isAdjusting || selected == this.isSelected(model)) {
                    return;
                }
                CytoscapeDesktop.this.isAdjusting = true;
                CytoscapeDesktop.this.onSidebarButtonSelected((SidebarToggleButton)this.getButton(model), selected);
                super.setSelected(model, selected);
                CytoscapeDesktop.this.isAdjusting = false;
            }
        };
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                JMenuBar menuBar = cyMenus.getJMenuBar();
                Window window = SwingUtilities.getWindowAncestor(menuBar);
                if (!CytoscapeDesktop.this.equals(window)) {
                    if (window instanceof JFrame && !ViewUtil.isScreenMenuBar()) {
                        JMenuBar dummyMenuBar = cyMenus.createDummyMenuBar();
                        ((JFrame)window).setJMenuBar(dummyMenuBar);
                        dummyMenuBar.updateUI();
                        window.repaint();
                    }
                    if (ViewUtil.isScreenMenuBar()) {
                        cyMenus.setMenuBarVisible(true);
                    }
                    CytoscapeDesktop.this.setJMenuBar(menuBar);
                    menuBar.updateUI();
                }
                taskManager.setExecutionContext((Object)CytoscapeDesktop.this);
            }

            @Override
            public void windowClosing(WindowEvent we) {
                CyShutdown cyShutdown = (CyShutdown)serviceRegistrar.getService(CyShutdown.class);
                cyShutdown.exit(0);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                if (CytoscapeDesktop.this.jobStatusPanelFactory == null || CytoscapeDesktop.this.taskStatusPanelFactory == null) {
                    CytoscapeDesktop.this.jobStatusPanelFactory = (StatusBarPanelFactory)serviceRegistrar.getService(StatusBarPanelFactory.class, "(type=JobStatus)");
                    CytoscapeDesktop.this.taskStatusPanelFactory = (StatusBarPanelFactory)serviceRegistrar.getService(StatusBarPanelFactory.class, "(type=TaskStatus)");
                    CytoscapeDesktop.this.statusToolBar = CytoscapeDesktop.this.setupStatusPanel(CytoscapeDesktop.this.jobStatusPanelFactory, CytoscapeDesktop.this.taskStatusPanelFactory);
                }
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                if (CytoscapeDesktop.this.isVisible()) {
                    CytoscapeDesktop.this.resizeEventTimer.debounce(() -> ViewUtil.invokeOnEDT(() -> {
                        for (CytoPanelImpl cp : CytoscapeDesktop.this.getAllCytoPanels()) {
                            SideBar.TrimStack ts = CytoscapeDesktop.this.getTrimStackOf(cp);
                            if (ts == null || cp.getStateInternal() == CytoPanelStateInternal.HIDE) continue;
                            ts.update();
                        }
                    }));
                }
            }
        });
        this.setContentPane(this.getMainPanel());
        for (CytoPanelImpl cp : this.getAllCytoPanels()) {
            this.handleStateInternalChanged(cp, cp.getStateInternal());
            this.addListeners(cp);
        }
        this.pack();
        this.setSize(DEF_DESKTOP_SIZE);
        this.setLocationRelativeTo(null);
    }

    private List<CytoPanelImpl> getAllCytoPanels() {
        return Arrays.asList(this.getNorthWestPanel(), this.getSouthWestPanel(), this.getEastPanel(), this.getSouthPanel(), this.getAutomationPanel());
    }

    private void addListeners(final CytoPanelImpl cp) {
        cp.addPropertyChangeListener("stateInternal", evt -> {
            if (this.appsFinishedStarting && evt.getOldValue() == CytoPanelStateInternal.DOCK) {
                this.saveDockedSize(cp);
            }
            this.handleStateInternalChanged(cp, (CytoPanelStateInternal)((Object)((Object)evt.getNewValue())));
        });
        cp.getFloatButton().addActionListener(evt -> cp.setStateInternal(CytoPanelStateInternal.FLOAT));
        cp.getDockButton().addActionListener(evt -> cp.setStateInternal(CytoPanelStateInternal.DOCK));
        cp.getUndockButton().addActionListener(evt -> cp.setStateInternal(CytoPanelStateInternal.UNDOCK));
        cp.getMinimizeButton().addActionListener(evt -> cp.setStateInternal(CytoPanelStateInternal.MINIMIZE));
        cp.getTitlePanel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    CytoscapeDesktop.this.toggleMaximizeCytoPanel(cp);
                }
            }
        });
    }

    private void handleStateInternalChanged(CytoPanelImpl cp, CytoPanelStateInternal state) {
        switch (state) {
            case HIDE: {
                ViewUtil.invokeOnEDT(() -> this.removeCytoPanel(cp));
                break;
            }
            case MINIMIZE: {
                ViewUtil.invokeOnEDT(() -> this.minimizeCytoPanel(cp));
                break;
            }
            case DOCK: {
                ViewUtil.invokeOnEDT(() -> this.dockCytoPanel(cp));
                break;
            }
            case UNDOCK: {
                ViewUtil.invokeOnEDT(() -> this.undockCytoPanel(cp));
                break;
            }
            case FLOAT: {
                ViewUtil.invokeOnEDT(() -> this.floatCytoPanel(cp));
            }
        }
    }

    private JToolBar setupStatusPanel(StatusBarPanelFactory jobStatusPanelFactory, StatusBarPanelFactory taskStatusPanelFactory) {
        JPanel taskStatusPanel = taskStatusPanelFactory.createTaskStatusPanel();
        JPanel jobStatusPanel = jobStatusPanelFactory.createTaskStatusPanel();
        MemStatusPanel memStatusPanel = new MemStatusPanel(this.serviceRegistrar);
        JToolBar statusToolBar = new JToolBar();
        statusToolBar.setFloatable(false);
        statusToolBar.setBorder(BorderFactory.createEmptyBorder());
        if (LookAndFeelUtil.isNimbusLAF()) {
            jobStatusPanel.setOpaque(false);
            taskStatusPanel.setOpaque(false);
            statusToolBar.setOpaque(false);
            memStatusPanel.setOpaque(false);
        }
        JPanel statusPanel = new JPanel();
        statusPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("Separator.foreground")));
        GroupLayout layout = new GroupLayout(statusPanel);
        statusPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addComponent(jobStatusPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(taskStatusPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(statusToolBar, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(memStatusPanel, -2, -1, -2).addContainerGap());
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(LookAndFeelUtil.isWinLAF() ? 5 : 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(jobStatusPanel, -1, -1, Short.MAX_VALUE).addComponent(taskStatusPanel, -1, -1, Short.MAX_VALUE).addComponent(statusToolBar, -2, -1, -2).addComponent(memStatusPanel, -1, -1, Short.MAX_VALUE)).addGap(LookAndFeelUtil.isWinLAF() ? 5 : 0));
        this.getBottomPanel().add((Component)statusPanel, "South");
        return statusToolBar;
    }

    public void addAction(CyAction action, Map<?, ?> props) {
        this.cyMenus.addAction(action, props);
    }

    public void addAction(CyAction action) {
        this.cyMenus.addAction(action, new HashMap());
    }

    public void removeAction(CyAction action, Map<?, ?> props) {
        this.cyMenus.removeAction(action);
    }

    public void removeAction(CyAction action) {
        this.cyMenus.removeAction(action);
    }

    public JMenu getJMenu(String name) {
        return this.cyMenus.getJMenu(name);
    }

    @Override
    public JMenuBar getJMenuBar() {
        return this.cyMenus.getJMenuBar();
    }

    public JToolBar getJToolBar() {
        return this.cyMenus.getJToolBar();
    }

    public JFrame getJFrame() {
        return this;
    }

    public CytoPanel getCytoPanel(CytoPanelName compassDirection) {
        return this.getCytoPanelInternal(CytoPanelNameInternal.valueOf(compassDirection));
    }

    public CytoPanel getCytoPanel(CytoPanelNameInternal compassDirection) {
        return this.getCytoPanelInternal(compassDirection);
    }

    private CytoPanelImpl getCytoPanelInternal(CytoPanelNameInternal compassDirection) {
        switch (compassDirection) {
            case BOTTOM: {
                return this.getAutomationPanel();
            }
            case SOUTH: {
                return this.getSouthPanel();
            }
            case EAST: {
                return this.getEastPanel();
            }
            case WEST: {
                return this.getNorthWestPanel();
            }
            case SOUTH_WEST: {
                return this.getSouthWestPanel();
            }
        }
        throw new IllegalArgumentException("Illegal Argument:  " + compassDirection + ".  Must be one of:  {SOUTH,EAST,WEST,SOUTH_WEST}.");
    }

    public void addCytoPanelComponent(CytoPanelComponent cpc, Map<?, ?> props) {
        ViewUtil.invokeOnEDTAndWait(() -> {
            CytoPanelImpl cytoPanel = cpc instanceof CommandToolPanel ? this.getCytoPanelInternal(CytoPanelNameInternal.BOTTOM) : this.getCytoPanelInternal(CytoPanelNameInternal.valueOf(cpc.getCytoPanelName()));
            int index = this.getInsertIndex(cpc, cytoPanel);
            boolean inserted = cytoPanel.insert(cpc, index);
            this.getTrimStackOf(cytoPanel).update();
            if (cytoPanel.getCytoPanelComponentCount() == 1) {
                if (cytoPanel.getStateInternal() == CytoPanelStateInternal.DOCK) {
                    BiModalJSplitPane splitPane = this.getSplitPaneOf(cytoPanel);
                    if (splitPane != null) {
                        splitPane.update();
                    }
                    this.getTrimStackOf(cytoPanel).update();
                    this.getSideBarOf(cytoPanel).update();
                    if (this.appsFinishedStarting && inserted) {
                        this.restoreDockedSize(cytoPanel);
                    }
                } else if (cytoPanel.getStateInternal() == CytoPanelStateInternal.FLOAT) {
                    this.floatCytoPanel(cytoPanel);
                }
            }
        });
    }

    public void removeCytoPanelComponent(CytoPanelComponent cpc, Map<?, ?> props) {
        ViewUtil.invokeOnEDTAndWait(() -> {
            CytoPanelImpl cytoPanel = cpc instanceof CommandToolPanel ? this.getCytoPanelInternal(CytoPanelNameInternal.BOTTOM) : this.getCytoPanelInternal(CytoPanelNameInternal.valueOf(cpc.getCytoPanelName()));
            boolean removed = cytoPanel.remove(cpc);
            if (removed && cytoPanel.getCytoPanelComponentCount() == 0) {
                if (cytoPanel.getStateInternal() == CytoPanelStateInternal.DOCK) {
                    this.saveDockedSize(cytoPanel);
                }
                this.hideCytoPanel(cytoPanel);
            }
            this.getTrimStackOf(cytoPanel).update();
            this.getSideBarOf(cytoPanel).update();
            if (cytoPanel.getCytoPanelComponentCount() == 0 && cytoPanel.getStateInternal() == CytoPanelStateInternal.DOCK) {
                BiModalJSplitPane splitPane = this.getSplitPaneOf(cytoPanel);
                if (splitPane != null) {
                    splitPane.update();
                }
                this.getSideBarOf(cytoPanel).update();
            }
        });
    }

    public JToolBar getStatusToolBar() {
        return this.statusToolBar;
    }

    public void addToolBarComponent(ToolBarComponent tp, Map<?, ?> props) {
        ViewUtil.invokeOnEDTAndWait(() -> ((CytoscapeToolBar)this.cyMenus.getJToolBar()).addToolBarComponent(tp, props));
    }

    public void removeToolBarComponent(ToolBarComponent tp, Map<?, ?> props) {
        ViewUtil.invokeOnEDTAndWait(() -> ((CytoscapeToolBar)this.cyMenus.getJToolBar()).removeToolBarComponent(tp));
    }

    public void handleEvent(CyStartEvent e) {
        ViewUtil.invokeOnEDT(() -> {
            this.setVisible(true);
            for (CytoPanelImpl cp : this.getAllCytoPanels()) {
                SideBar.TrimStack ts = this.getTrimStackOf(cp);
                if (ts == null || cp.getStateInternal() == CytoPanelStateInternal.HIDE) continue;
                ts.update();
            }
            this.toFront();
        });
    }

    public void handleEvent(AppsFinishedStartingEvent e) {
        ViewUtil.invokeOnEDT(() -> {
            CyNetworkManager netManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
            CyTableManager tableManager = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
            if (netManager.getNetworkSet().isEmpty() && tableManager.getAllTables(false).isEmpty()) {
                this.showStarterPanel();
                if (this.getCenterPanel().getHeight() < this.getStarterPanel().getPreferredSize().height) {
                    this.getRightPane().setDividerLocation(this.getStarterPanel().getPreferredSize().height + this.getRightPane().getDividerSize() / 2);
                    this.getRightPane().resetToPreferredSizes();
                }
            }
            this.appsFinishedStarting = true;
        });
    }

    public void handleEvent(SessionLoadedEvent e) {
        String sessionName = e.getLoadedFileName();
        if (sessionName == null || sessionName.endsWith(".tmpCYS")) {
            sessionName = NEW_SESSION_NAME;
        }
        String title = TITLE_PREFIX_STRING + sessionName;
        ViewUtil.invokeOnEDT(() -> {
            this.setTitle(title);
            this.hideStarterPanel();
        });
    }

    public void handleEvent(SessionSavedEvent e) {
        String sessionName = e.getSavedFileName();
        ViewUtil.invokeOnEDT(() -> this.setTitle(TITLE_PREFIX_STRING + sessionName));
    }

    public void handleEvent(SetCurrentNetworkEvent e) {
        ViewUtil.invokeOnEDT(() -> {
            if (e.getNetwork() != null && !this.isCommandDocGenNetwork(e.getNetwork())) {
                this.hideStarterPanel();
            }
        });
    }

    public void handleEvent(SetCurrentNetworkViewEvent e) {
        ViewUtil.invokeOnEDT(() -> {
            if (e.getNetworkView() != null && !this.isCommandDocGenNetwork((CyNetwork)e.getNetworkView().getModel())) {
                this.hideStarterPanel();
            }
        });
    }

    private boolean isCommandDocGenNetwork(CyNetwork network) {
        if (network != null) {
            String name = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
            return name != null && name.equals("cy:command_documentation_generation");
        }
        return false;
    }

    public void handleEvent(TableAddedEvent e) {
        CyNetwork network;
        CyTable table = e.getTable();
        if (table != null && table.isPublic() && (network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork()) != null && !this.isCommandDocGenNetwork(network)) {
            ViewUtil.invokeOnEDT(() -> this.hideStarterPanel());
        }
    }

    public void handleEvent(CytoPanelComponentSelectedEvent evt) {
        SideBar.TrimStack ts;
        CytoPanel cp = evt.getCytoPanel();
        if (cp instanceof CytoPanelImpl && evt.getSelectedIndex() >= 0 && (ts = this.getTrimStackOf((CytoPanelImpl)cp)) != null) {
            SidebarToggleButton btn = ts.getButton(evt.getSelectedIndex());
            CytoPanelStateInternal state = ((CytoPanelImpl)cp).getStateInternal();
            if (btn != null && !btn.isSelected() && state != CytoPanelStateInternal.HIDE) {
                if (this.undockedButtonGroup.contains(btn)) {
                    this.undockedButtonGroup.setSelected(btn, true);
                } else {
                    ts.getButtonGroup().setSelected(btn, true);
                }
            }
        }
    }

    public void showStarterPanel() {
        ViewUtil.invokeOnEDT(() -> {
            this.getCenterPanel().add((Component)this.getStarterPanel(), StarterPanel.NAME);
            this.getStarterPanel().update();
            ((CardLayout)this.getCenterPanel().getLayout()).show(this.getCenterPanel(), StarterPanel.NAME);
            if (this.appsFinishedStarting && this.getCenterPanel().getHeight() < this.getStarterPanel().getMinimumSize().height) {
                this.getRightPane().setDividerLocation(this.getStarterPanel().getMinimumSize().height + this.getRightPane().getDividerSize() / 2);
                this.getRightPane().resetToPreferredSizes();
            }
            if (this.popup != null && this.popup.getCytoPanel() != null) {
                this.popup.getCytoPanel().setStateInternal(CytoPanelStateInternal.MINIMIZE);
            }
        });
    }

    public void hideStarterPanel() {
        ViewUtil.invokeOnEDT(() -> {
            if (this.isStarterPanelVisible()) {
                this.getCenterPanel().remove(this.getStarterPanel());
                ((CardLayout)this.getCenterPanel().getLayout()).show(this.getCenterPanel(), NetworkViewMainPanel.NAME);
            }
        });
    }

    public boolean isStarterPanelVisible() {
        return this.getStarterPanel().isVisible();
    }

    public boolean isShowSideBarLabels() {
        return Boolean.parseBoolean(ViewUtil.getViewProperty("sideBar.showLabels", "true", this.serviceRegistrar));
    }

    public void setShowSideBarLabels(boolean show) {
        ViewUtil.setViewProperty("sideBar.showLabels", "" + show, this.serviceRegistrar);
        for (CytoPanelImpl cp : this.getAllCytoPanels()) {
            SideBar.TrimStack ts = this.getTrimStackOf(cp);
            if (ts == null) continue;
            ts.update();
        }
    }

    private void removeCytoPanel(CytoPanelImpl cytoPanel) {
        cytoPanel.setStateInternal(CytoPanelStateInternal.HIDE);
        this.getTrimStackOf(cytoPanel).update();
        this.getSideBarOf(cytoPanel).update();
        if (this.isPopupShowingFor(cytoPanel)) {
            this.disposeComponentPopup();
        } else if (this.getSplitPaneOf(cytoPanel) != null) {
            this.getSplitPaneOf(cytoPanel).update();
        }
    }

    private void showCytoPanel(CytoPanelImpl cytoPanel) {
        if (cytoPanel.getCytoPanelComponentCount() == 0) {
            return;
        }
        CytoPanelStateInternal state = cytoPanel.getStateInternal();
        if (state == CytoPanelStateInternal.HIDE) {
            cytoPanel.setStateInternal(CytoPanelStateInternal.DOCK);
        }
        this.getTrimStackOf(cytoPanel).update();
        this.getSideBarOf(cytoPanel).update();
    }

    private void floatCytoPanel(final CytoPanelImpl cytoPanel) {
        if (this.isPopupShowingFor(cytoPanel)) {
            this.disposeComponentPopup();
            this.addToCytoPanelButtonGroup(cytoPanel);
        }
        this.showCytoPanel(cytoPanel);
        if (!this.isFloating(cytoPanel)) {
            BiModalJSplitPane splitPane = this.getSplitPaneOf(cytoPanel);
            if (splitPane != null) {
                splitPane.removeCytoPanel(cytoPanel);
            }
            JFrame frame = new JFrame(cytoPanel.getTitle(), this.getGraphicsConfiguration());
            this.floatingFrames.put(cytoPanel, frame);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (!CytoscapeDesktop.this.ignoreFloatingFrameCloseEvents) {
                        cytoPanel.setStateInternal(CytoPanelStateInternal.DOCK);
                    }
                }
            });
            if (cytoPanel.getThisComponent().getSize() != null) {
                frame.getContentPane().setPreferredSize(cytoPanel.getThisComponent().getSize());
                frame.getContentPane().setSize(cytoPanel.getThisComponent().getSize());
            }
            frame.getContentPane().add(cytoPanel.getThisComponent(), "Center");
            frame.pack();
            this.setLocationOfFloatingFrame(frame, cytoPanel);
            frame.setVisible(true);
            if (splitPane != null) {
                splitPane.update();
            }
        }
    }

    private void dockCytoPanel(CytoPanelImpl cytoPanel) {
        SidebarToggleButton selBtn;
        if (this.isPopupShowingFor(cytoPanel)) {
            this.disposeComponentPopup();
        }
        this.addToCytoPanelButtonGroup(cytoPanel);
        SideBar.TrimStack ts = this.getTrimStackOf(cytoPanel);
        SidebarToggleButton sidebarToggleButton = selBtn = ts != null ? ts.getButton(cytoPanel.getSelectedIndex()) : null;
        if (selBtn != null) {
            selBtn.setSelected(true);
        }
        if (this.isFloating(cytoPanel)) {
            this.disposeFloatingCytoPanel(cytoPanel);
        }
        this.showCytoPanel(cytoPanel);
        BiModalJSplitPane splitPane = this.getSplitPaneOf(cytoPanel);
        if (splitPane != null) {
            splitPane.addCytoPanel(cytoPanel);
            splitPane.update();
            if (this.appsFinishedStarting) {
                this.restoreDockedSize(cytoPanel);
            }
        }
    }

    private void undockCytoPanel(CytoPanelImpl cytoPanel) {
        SidebarToggleButton btn;
        if (this.isFloating(cytoPanel)) {
            this.disposeFloatingCytoPanel(cytoPanel);
        }
        cytoPanel.getThisComponent().setVisible(true);
        if (this.popup == null) {
            this.popup = new ComponentPopup(cytoPanel);
            Toolkit.getDefaultToolkit().addAWTEventListener(this.glassPaneMouseListener, 16L);
        } else {
            CytoPanelImpl oldCytoPanel = this.popup.getCytoPanel();
            this.popup.setCytoPanel(cytoPanel);
            if (oldCytoPanel != null && !oldCytoPanel.equals(cytoPanel) && oldCytoPanel.getStateInternal() != CytoPanelStateInternal.MINIMIZE) {
                oldCytoPanel.setStateInternal(CytoPanelStateInternal.MINIMIZE);
            }
        }
        BiModalJSplitPane splitPane = this.getSplitPaneOf(cytoPanel);
        if (splitPane != null) {
            splitPane.update();
        }
        SideBar.TrimStack ts = this.getTrimStackOf(cytoPanel);
        ts.update();
        SideBar bar = this.getSideBarOf(cytoPanel);
        bar.update();
        if (!bar.isShowing()) {
            return;
        }
        this.updateComponentPopupBounds();
        ((JComponent)this.getGlassPane()).add(this.popup);
        if (!this.getGlassPane().isVisible()) {
            this.getGlassPane().setVisible(true);
        }
        if (!this.popup.isVisible()) {
            this.popup.setVisible(true);
        }
        if ((btn = ts.getButton(cytoPanel.getSelectedIndex())) != null && !btn.isSelected()) {
            btn.setSelected(true);
            ts.update();
        }
    }

    private void hideCytoPanel(CytoPanelImpl cytoPanel) {
        if (this.isFloating(cytoPanel)) {
            this.disposeFloatingCytoPanel(cytoPanel);
        } else if (this.isPopupShowingFor(cytoPanel)) {
            this.disposeComponentPopup();
            AbstractButton btn = this.undockedButtonGroup.getSelectedButton();
            if (btn != null) {
                btn.setSelected(false);
            }
            this.isAdjusting = true;
            this.undockedButtonGroup.clearSelection();
            this.isAdjusting = false;
        } else {
            BiModalJSplitPane splitPane = this.getSplitPaneOf(cytoPanel);
            if (splitPane != null) {
                splitPane.update();
            }
        }
    }

    private void minimizeCytoPanel(CytoPanelImpl cytoPanel) {
        this.hideCytoPanel(cytoPanel);
        if (!this.isPopupShowingFor(cytoPanel)) {
            SideBar.TrimStack ts = this.getTrimStackOf(cytoPanel);
            ts.getButtonGroup().clearSelection();
            this.addToUndockedButtonGroup(cytoPanel);
        }
    }

    private void disposeFloatingCytoPanel(CytoPanelImpl cytoPanel) {
        JFrame frame = this.floatingFrames.remove(cytoPanel);
        if (frame != null) {
            frame.remove(cytoPanel.getThisComponent());
            this.ignoreFloatingFrameCloseEvents = true;
            try {
                frame.dispose();
            }
            finally {
                this.ignoreFloatingFrameCloseEvents = false;
            }
        }
    }

    private boolean isFloating(CytoPanelImpl cytoPanel) {
        JFrame frame = this.floatingFrames.get(cytoPanel);
        return frame != null && frame == SwingUtilities.getWindowAncestor(cytoPanel.getThisComponent());
    }

    private boolean isPopupShowingFor(CytoPanelImpl cytoPanel) {
        return this.popup != null && this.popup.getCytoPanel().equals(cytoPanel);
    }

    private void toggleMaximizeCytoPanel(CytoPanelImpl cytoPanel) {
        if (this.isPopupShowingFor(cytoPanel)) {
            cytoPanel.setMaximized(!cytoPanel.isMaximized());
            this.updateComponentPopupBounds();
        }
    }

    private void addToUndockedButtonGroup(CytoPanelImpl cytoPanel) {
        List<SidebarToggleButton> buttons = this.getSidebarButtons(cytoPanel);
        SideBar.TrimStack ts = this.getTrimStackOf(cytoPanel);
        if (ts != null) {
            ts.getButtonGroup().remove(buttons);
        }
        this.undockedButtonGroup.add(buttons);
    }

    private void addToCytoPanelButtonGroup(CytoPanelImpl cytoPanel) {
        List<SidebarToggleButton> buttons = this.getSidebarButtons(cytoPanel);
        this.undockedButtonGroup.remove(buttons);
        SideBar.TrimStack ts = this.getTrimStackOf(cytoPanel);
        if (ts != null) {
            ts.getButtonGroup().add(buttons);
        }
    }

    private List<SidebarToggleButton> getSidebarButtons(CytoPanelImpl cytoPanel) {
        SideBar.TrimStack ts = this.getTrimStackOf(cytoPanel);
        return ts != null ? ts.getAllButtons() : Collections.emptyList();
    }

    private void setLocationOfFloatingFrame(JFrame frame, CytoPanelImpl cytoPanel) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenDimension = tk.getScreenSize();
        Rectangle bounds = this.getBounds();
        bounds.setLocation(this.getLocationOnScreen());
        Point p = CytoPanelUtil.getLocationOfExternalWindow(screenDimension, bounds, frame.getSize(), cytoPanel.getCytoPanelNameInternal(), false);
        frame.setLocation(p);
        frame.setVisible(true);
    }

    private int getInsertIndex(CytoPanelComponent cpc, CytoPanelImpl cytoPanel) {
        String id;
        int index = -1;
        int total = cytoPanel.getCytoPanelComponentCount();
        if (cytoPanel.getCytoPanelName() == CytoPanelName.WEST && cpc instanceof CytoPanelComponent2 && (index = this.controlComponentsOrder.indexOf(id = ((CytoPanelComponent2)cpc).getIdentifier())) >= 0 && this.controlComponentsOrder.size() > index + 1) {
            for (int i = index + 1; i < this.controlComponentsOrder.size(); ++i) {
                String nextId = this.controlComponentsOrder.get(i);
                int nextIndex = cytoPanel.indexOfComponent(nextId);
                if (nextIndex < 0 || index < nextIndex) continue;
                index = nextIndex;
                break;
            }
        }
        if (index < 0 || index > total) {
            index = total;
        }
        return index;
    }

    private void onSidebarButtonSelected(SidebarToggleButton btn, boolean selected) {
        if (this.updatingTrimStack) {
            return;
        }
        CytoPanelImpl cytoPanel = btn.getCytoPanel();
        CytoPanelStateInternal state = cytoPanel.getStateInternal();
        if (state == CytoPanelStateInternal.HIDE) {
            return;
        }
        if (selected) {
            JFrame frame;
            cytoPanel.setSelectedComponent(btn.getCytoPanelComponent());
            if (state == CytoPanelStateInternal.MINIMIZE) {
                cytoPanel.setStateInternal(CytoPanelStateInternal.UNDOCK);
            } else if (state == CytoPanelStateInternal.FLOAT && (frame = this.floatingFrames.get(cytoPanel)) != null) {
                frame.toFront();
            }
        } else if (state == CytoPanelStateInternal.UNDOCK) {
            cytoPanel.setStateInternal(CytoPanelStateInternal.MINIMIZE);
        } else if (state == CytoPanelStateInternal.MINIMIZE) {
            this.disposeComponentPopup();
        }
    }

    private BiModalJSplitPane getSplitPaneOf(CytoPanelImpl cytoPanel) {
        switch (cytoPanel.getCytoPanelNameInternal()) {
            case BOTTOM: {
                return this.getMasterPane();
            }
            case SOUTH: {
                return this.getRightPane();
            }
            case EAST: {
                return this.getTopRightPane();
            }
            case WEST: {
                return this.getLeftPane();
            }
            case SOUTH_WEST: {
                return this.getLeftPane();
            }
        }
        return null;
    }

    private SideBar getSideBarOf(CytoPanelImpl cytoPanel) {
        switch (cytoPanel.getCytoPanelNameInternal()) {
            case BOTTOM: 
            case SOUTH: {
                return this.getSouthSideBar();
            }
            case WEST: 
            case SOUTH_WEST: {
                return this.getWestSideBar();
            }
        }
        return this.getEastSideBar();
    }

    private SideBar.TrimStack getTrimStackOf(CytoPanelImpl cytoPanel) {
        SideBar bar = this.getSideBarOf(cytoPanel);
        return bar != null ? bar.getStack(cytoPanel) : null;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.cyMenus.getJToolBar(), "North");
            this.mainPanel.add((Component)this.getMasterPane(), "Center");
            this.mainPanel.add((Component)this.getWestSideBar(), "West");
            this.mainPanel.add((Component)this.getEastSideBar(), "East");
            this.mainPanel.add((Component)this.getBottomPanel(), "South");
        }
        return this.mainPanel;
    }

    private SideBar getWestSideBar() {
        if (this.westSideBar == null) {
            this.westSideBar = new SideBar(7, this.getNorthWestPanel(), this.getSouthWestPanel());
            this.westSideBar.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    if (CytoscapeDesktop.this.southSideBar != null && CytoscapeDesktop.this.southSideBar.isVisible()) {
                        CytoscapeDesktop.this.southSideBar.update();
                    }
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    if (CytoscapeDesktop.this.southSideBar != null && CytoscapeDesktop.this.southSideBar.isVisible()) {
                        CytoscapeDesktop.this.southSideBar.update();
                    }
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    if (CytoscapeDesktop.this.southSideBar != null && CytoscapeDesktop.this.southSideBar.isVisible()) {
                        CytoscapeDesktop.this.southSideBar.update();
                    }
                }
            });
        }
        return this.westSideBar;
    }

    private SideBar getEastSideBar() {
        if (this.eastSideBar == null) {
            this.eastSideBar = new SideBar(3, this.getEastPanel());
            this.eastSideBar.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    if (CytoscapeDesktop.this.southSideBar != null && CytoscapeDesktop.this.southSideBar.isVisible()) {
                        CytoscapeDesktop.this.southSideBar.update();
                    }
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    if (CytoscapeDesktop.this.southSideBar != null && CytoscapeDesktop.this.southSideBar.isVisible()) {
                        CytoscapeDesktop.this.southSideBar.update();
                    }
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    if (CytoscapeDesktop.this.southSideBar != null && CytoscapeDesktop.this.southSideBar.isVisible()) {
                        CytoscapeDesktop.this.southSideBar.update();
                    }
                }
            });
        }
        return this.eastSideBar;
    }

    private SideBar getSouthSideBar() {
        if (this.southSideBar == null) {
            this.southSideBar = new SideBar(5, this.getAutomationPanel(), this.getSouthPanel());
        }
        return this.southSideBar;
    }

    private BiModalJSplitPane getMasterPane() {
        if (this.masterPane == null) {
            this.masterPane = new BiModalJSplitPane(0, this.getTopPane(), this.getAutomationPanel().getThisComponent());
            this.masterPane.setDividerLocation(600);
        }
        return this.masterPane;
    }

    private BiModalJSplitPane getTopPane() {
        if (this.topPane == null) {
            this.topPane = new BiModalJSplitPane(1, this.getLeftPane(), this.getRightPane());
            this.topPane.setDividerLocation(400);
            this.topPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent evt) {
                    CytoscapeDesktop.this.updateComponentPopupBounds();
                }
            });
        }
        return this.topPane;
    }

    private BiModalJSplitPane getLeftPane() {
        if (this.leftPane == null) {
            this.leftPane = new BiModalJSplitPane(0, this.getNorthWestPanel().getThisComponent(), this.getSouthWestPanel().getThisComponent());
            this.leftPane.setResizeWeight(1.0);
        }
        return this.leftPane;
    }

    private BiModalJSplitPane getRightPane() {
        if (this.rightPane == null) {
            this.rightPane = new BiModalJSplitPane(0, this.getTopRightPane(), this.getSouthPanel().getThisComponent());
            this.rightPane.setDividerLocation(540);
            this.rightPane.setResizeWeight(1.0);
        }
        return this.rightPane;
    }

    private BiModalJSplitPane getTopRightPane() {
        if (this.topRightPane == null) {
            this.topRightPane = new BiModalJSplitPane(1, this.getCenterPanel(), this.getEastPanel().getThisComponent());
            this.topRightPane.setResizeWeight(1.0);
        }
        return this.topRightPane;
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new CardLayout());
            if (this.netViewMediator.getNetworkViewMainPanel() != null) {
                this.centerPanel.add((Component)this.netViewMediator.getNetworkViewMainPanel(), NetworkViewMainPanel.NAME);
            }
        }
        return this.centerPanel;
    }

    private JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel(new BorderLayout());
            this.bottomPanel.add(this.getSouthSideBar());
        }
        return this.bottomPanel;
    }

    public StarterPanel getStarterPanel() {
        if (this.starterPanel == null) {
            this.starterPanel = new StarterPanel(this.serviceRegistrar);
            this.starterPanel.getCloseButton().addActionListener(e -> this.hideStarterPanel());
        }
        return this.starterPanel;
    }

    private CytoPanelImpl getNorthWestPanel() {
        if (this.northWestPanel == null) {
            this.northWestPanel = new CytoPanelImpl(CytoPanelNameInternal.WEST, 0, CytoPanelStateInternal.DOCK, this.serviceRegistrar);
        }
        return this.northWestPanel;
    }

    private CytoPanelImpl getSouthWestPanel() {
        if (this.southWestPanel == null) {
            this.southWestPanel = new CytoPanelImpl(CytoPanelNameInternal.SOUTH_WEST, 1, CytoPanelStateInternal.MINIMIZE, this.serviceRegistrar);
        }
        return this.southWestPanel;
    }

    private CytoPanelImpl getEastPanel() {
        if (this.eastPanel == null) {
            this.eastPanel = new CytoPanelImpl(CytoPanelNameInternal.EAST, 2, CytoPanelStateInternal.DOCK, this.serviceRegistrar);
        }
        return this.eastPanel;
    }

    private CytoPanelImpl getSouthPanel() {
        if (this.southPanel == null) {
            this.southPanel = new CytoPanelImpl(CytoPanelNameInternal.SOUTH, 3, CytoPanelStateInternal.DOCK, this.serviceRegistrar);
        }
        return this.southPanel;
    }

    private CytoPanelImpl getAutomationPanel() {
        if (this.automationPanel == null) {
            this.automationPanel = new CytoPanelImpl(CytoPanelNameInternal.BOTTOM, 4, CytoPanelStateInternal.MINIMIZE, this.serviceRegistrar);
        }
        return this.automationPanel;
    }

    private void saveDockedSize(CytoPanelImpl cytoPanel) {
        ViewUtil.invokeOnEDT(() -> {
            if (cytoPanel != null) {
                this.dockPreferredSizes.put(cytoPanel.getCytoPanelNameInternal(), cytoPanel.getThisComponent().getSize());
            }
        });
    }

    private Dimension getDockedSize(CytoPanelImpl cytoPanel) {
        Dimension dim = this.dockPreferredSizes.get((Object)cytoPanel.getCytoPanelNameInternal());
        return dim != null ? dim : cytoPanel.getThisComponent().getPreferredSize();
    }

    private void restoreDockedSize(CytoPanelImpl cytoPanel) {
        Dimension dim = this.getDockedSize(cytoPanel);
        if (dim != null) {
            int h;
            if (cytoPanel.getCytoPanelNameInternal() == CytoPanelNameInternal.EAST) {
                int w = this.getTopRightPane().getWidth() - dim.width - 5;
                if (w >= 0) {
                    this.getCenterPanel().setPreferredSize(new Dimension(w, this.getCenterPanel().getPreferredSize().height));
                }
            } else if (cytoPanel.getCytoPanelNameInternal() == CytoPanelNameInternal.SOUTH && (h = this.getRightPane().getHeight() - dim.height - 5) >= 0) {
                this.getTopRightPane().setPreferredSize(new Dimension(this.getTopRightPane().getPreferredSize().width, h));
            }
            cytoPanel.getThisComponent().setPreferredSize(dim);
            BiModalJSplitPane splitPane = this.getSplitPaneOf(cytoPanel);
            if (splitPane != null) {
                splitPane.resetToPreferredSizes();
            }
        }
    }

    private void updateComponentPopupBounds() {
        if (this.popup == null) {
            return;
        }
        CytoPanelImpl cytoPanel = this.popup.getCytoPanel();
        if (cytoPanel == null) {
            return;
        }
        SideBar bar = this.getSideBarOf(cytoPanel);
        CytoPanelNameInternal name = cytoPanel.getCytoPanelNameInternal();
        try {
            Dimension dim;
            Dimension maxDim = this.popup.getMaximumSize();
            Dimension newDim = cytoPanel.isMaximized() ? maxDim : this.undockPreferredSizes.get((Object)name);
            Dimension dimension = dim = newDim != null ? newDim : cytoPanel.getThisComponent().getPreferredSize();
            if (newDim == null) {
                if (name == CytoPanelNameInternal.SOUTH) {
                    dim.width = (int)((float)maxDim.width * 0.75f);
                    dim.height = (int)((float)maxDim.height * 0.5f);
                } else if (name == CytoPanelNameInternal.BOTTOM) {
                    dim.width = (int)((float)maxDim.width * 0.5f);
                    dim.height = (int)((float)maxDim.height * 0.75f);
                } else {
                    if (dim.width <= 0) {
                        dim.width = 200;
                    }
                    if (dim.height <= 0) {
                        dim.height = maxDim.height;
                    }
                }
            }
            dim.height = Math.min(dim.height, maxDim.height);
            dim.width = Math.max(dim.width, 106);
            dim.height = Math.max(dim.height, 106);
            Point p = bar.compassDirection == 5 ? this.getBottomPanel().getLocation() : bar.getLocation();
            p = SwingUtilities.convertPoint(this.getMainPanel(), p, this.getGlassPane());
            if (bar.compassDirection == 7) {
                p.x += bar.getWidth();
                if (name == CytoPanelNameInternal.SOUTH_WEST) {
                    p.y += bar.getHeight() - dim.height;
                }
            } else if (bar.compassDirection == 3) {
                p.x -= dim.width;
            } else if (bar.compassDirection == 5) {
                if (name == CytoPanelNameInternal.SOUTH) {
                    p.x += bar.getWidth() - dim.width;
                    if (this.getEastSideBar().isShowing()) {
                        p.x -= this.getEastSideBar().getPreferredSize().width;
                    }
                } else {
                    p.x += this.getWestSideBar().getPreferredSize().width;
                }
                p.y -= dim.height;
            }
            this.popup.setBounds(p.x, p.y, dim.width, dim.height);
            cytoPanel.getThisComponent().revalidate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void disposeComponentPopup() {
        if (this.popup != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.glassPaneMouseListener);
            ((JComponent)this.getGlassPane()).remove(this.popup);
            this.getGlassPane().setVisible(false);
            this.popup.dispose();
            this.popup = null;
        }
    }

    private class GlassPaneMouseListener
    implements AWTEventListener {
        private GlassPaneMouseListener() {
        }

        @Override
        public void eventDispatched(AWTEvent ae) {
            MenuElement[] path;
            if (CytoscapeDesktop.this.popup == null || !CytoscapeDesktop.this.popup.isShowing()) {
                return;
            }
            if (!(ae instanceof MouseEvent) || ae.getID() != 501) {
                return;
            }
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window window = keyboardFocusManager.getActiveWindow();
            if (!(window instanceof CytoscapeDesktop)) {
                return;
            }
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            for (MenuElement me : path = msm.getSelectedPath()) {
                if (!(me instanceof JPopupMenu)) continue;
                return;
            }
            Point mouseLoc = MouseInfo.getPointerInfo().getLocation();
            if (mouseLoc.x >= CytoscapeDesktop.this.popup.getLocationOnScreen().x && mouseLoc.x <= CytoscapeDesktop.this.popup.getLocationOnScreen().x + CytoscapeDesktop.this.popup.getWidth() && mouseLoc.y >= CytoscapeDesktop.this.popup.getLocationOnScreen().y && mouseLoc.y <= CytoscapeDesktop.this.popup.getLocationOnScreen().y + CytoscapeDesktop.this.popup.getHeight()) {
                return;
            }
            boolean overButton = false;
            block1: for (CytoPanelImpl cp : CytoscapeDesktop.this.getAllCytoPanels()) {
                SideBar.TrimStack ts;
                if (cp.getStateInternal() != CytoPanelStateInternal.MINIMIZE && cp.getStateInternal() != CytoPanelStateInternal.UNDOCK || !(ts = CytoscapeDesktop.this.getTrimStackOf(cp)).isShowing()) continue;
                for (SidebarToggleButton btn : ts.getAllButtons()) {
                    if (!btn.isShowing() || mouseLoc.x < btn.getLocationOnScreen().x || mouseLoc.x > btn.getLocationOnScreen().x + btn.getWidth() || mouseLoc.y < btn.getLocationOnScreen().y || mouseLoc.y > btn.getLocationOnScreen().y + btn.getHeight()) continue;
                    overButton = true;
                    break block1;
                }
            }
            if (!overButton && CytoscapeDesktop.this.popup != null) {
                if (CytoscapeDesktop.this.popup.getCytoPanel() != null && CytoscapeDesktop.this.popup.getCytoPanel().getStateInternal() != CytoPanelStateInternal.MINIMIZE) {
                    CytoscapeDesktop.this.popup.getCytoPanel().setStateInternal(CytoPanelStateInternal.MINIMIZE);
                } else {
                    CytoscapeDesktop.this.disposeComponentPopup();
                    AbstractButton btn = CytoscapeDesktop.this.undockedButtonGroup.getSelectedButton();
                    if (btn != null) {
                        btn.setSelected(false);
                    }
                    CytoscapeDesktop.this.isAdjusting = true;
                    CytoscapeDesktop.this.undockedButtonGroup.clearSelection();
                    CytoscapeDesktop.this.isAdjusting = false;
                }
            }
        }
    }

    private class ComponentPopup
    extends JRootPane {
        private static final int IN_BORDER_WIDTH = 1;
        private static final int OUT_BORDER_WIDTH = 5;
        private static final int BORDER_WIDTH = 6;
        private static final int MIN_SIZE = 106;
        private int tb;
        private int lb;
        private int bb;
        private int rb;
        private int[] locations = new int[]{1, 5, 7, 3, 8, 2, 6, 4};
        private int[] cursors = new int[]{8, 9, 10, 11, 6, 7, 4, 5};
        private CytoPanelImpl cytoPanel;
        private Point dragPoint;
        private int cursor = 0;

        ComponentPopup(CytoPanelImpl cytoPanel) {
            this.cytoPanel = cytoPanel;
            if (LookAndFeelUtil.isNimbusLAF()) {
                this.setOpaque(false);
            }
            this.addListeners();
            this.update();
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension dim = CytoscapeDesktop.this.getTopPane().getSize();
            dim.width += 5;
            dim.height += 5;
            return dim;
        }

        void dispose() {
            this.setVisible(false);
            this.getContentPane().removeAll();
            this.cytoPanel = null;
        }

        void update() {
            Component c;
            this.getContentPane().removeAll();
            this.updateBorder();
            Component component = c = this.cytoPanel != null ? this.cytoPanel.getThisComponent() : null;
            if (c != null) {
                this.getContentPane().add(c, "Center");
                c.revalidate();
                c.repaint();
            }
        }

        void updateBorder() {
            MatteBorder outBorder;
            this.rb = 0;
            this.bb = 0;
            this.lb = 0;
            this.tb = 0;
            CytoPanelNameInternal name = this.cytoPanel.getCytoPanelNameInternal();
            switch (name) {
                case WEST: {
                    this.bb = 6;
                    this.rb = 6;
                    break;
                }
                case SOUTH_WEST: {
                    this.tb = 6;
                    this.rb = 6;
                    break;
                }
                case EAST: {
                    this.bb = 6;
                    this.lb = 6;
                    break;
                }
                case SOUTH: {
                    this.tb = 6;
                    this.lb = 6;
                    break;
                }
                case BOTTOM: {
                    this.tb = 6;
                    this.rb = 6;
                }
            }
            if (LookAndFeelUtil.isWinLAF() || LookAndFeelUtil.isAquaLAF()) {
                DropShadowBorder shadow = new DropShadowBorder();
                shadow.setShadowColor(UIManager.getColor("Label.foreground"));
                shadow.setShadowOpacity(0.1f);
                shadow.setShadowSize(5);
                shadow.setShowLeftShadow(this.lb > 0);
                shadow.setShowRightShadow(this.rb > 0);
                shadow.setShowBottomShadow(this.bb > 0);
                shadow.setShowTopShadow(this.tb > 0);
                outBorder = shadow;
            } else {
                outBorder = BorderFactory.createMatteBorder(Math.max(0, this.tb - 1), Math.max(0, this.lb - 1), Math.max(0, this.bb - 1), Math.max(0, this.rb - 1), new Color(0, 0, 0, 0));
            }
            this.getRootPane().setBorder(BorderFactory.createCompoundBorder(outBorder, BorderFactory.createMatteBorder(Math.max(0, this.tb - 5), Math.max(0, this.lb - 5), Math.max(0, this.bb - 5), Math.max(0, this.rb - 5), UIManager.getColor("Separator.foreground"))));
        }

        void setCytoPanel(CytoPanelImpl cytoPanel) {
            if (this.cytoPanel != cytoPanel) {
                this.cytoPanel = cytoPanel;
                this.update();
            }
        }

        CytoPanelImpl getCytoPanel() {
            return this.cytoPanel;
        }

        private void addListeners() {
            this.getRootPane().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ComponentPopup.this.cursor = ComponentPopup.this.getCursor(evt);
                    ComponentPopup.this.dragPoint = evt.getPoint();
                    ComponentPopup.this.requestFocus();
                    ComponentPopup.this.repaint();
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    ComponentPopup.this.cursor = 0;
                    ComponentPopup.this.dragPoint = null;
                    ComponentPopup.this.setCursor(Cursor.getDefaultCursor());
                    ComponentPopup.this.revalidate();
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    ComponentPopup.this.setCursor(Cursor.getDefaultCursor());
                }
            });
            this.getRootPane().addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent evt) {
                    ComponentPopup.this.setCursor(Cursor.getPredefinedCursor(ComponentPopup.this.getCursor(evt)));
                }

                @Override
                public void mouseDragged(MouseEvent evt) {
                    if (ComponentPopup.this.dragPoint != null) {
                        ComponentPopup.this.setCursor(Cursor.getPredefinedCursor(ComponentPopup.this.cursor));
                        int x = ComponentPopup.this.getX();
                        int y = ComponentPopup.this.getY();
                        int w = ComponentPopup.this.getWidth();
                        int h = ComponentPopup.this.getHeight();
                        int dx = evt.getX() - ComponentPopup.this.dragPoint.x;
                        int dy = evt.getY() - ComponentPopup.this.dragPoint.y;
                        switch (ComponentPopup.this.cursor) {
                            case 8: {
                                y += dy;
                                h -= dy;
                                break;
                            }
                            case 9: {
                                ComponentPopup.this.dragPoint = evt.getPoint();
                                h += dy;
                                break;
                            }
                            case 10: {
                                x += dx;
                                w -= dx;
                                break;
                            }
                            case 11: {
                                w += dx;
                                ComponentPopup.this.dragPoint = evt.getPoint();
                                break;
                            }
                            case 6: {
                                x += dx;
                                y += dy;
                                w -= dx;
                                h -= dy;
                                break;
                            }
                            case 7: {
                                y += dy;
                                w += dx;
                                h -= dy;
                                ComponentPopup.this.dragPoint = new Point(evt.getX(), ComponentPopup.this.dragPoint.y);
                                break;
                            }
                            case 4: {
                                x += dx;
                                w -= dx;
                                h += dy;
                                ComponentPopup.this.dragPoint = new Point(ComponentPopup.this.dragPoint.x, evt.getY());
                                break;
                            }
                            case 5: {
                                w += dx;
                                h += dy;
                                ComponentPopup.this.dragPoint = evt.getPoint();
                            }
                        }
                        int maxWidth = CytoscapeDesktop.this.getTopPane().getWidth() + 5;
                        int maxHeight = CytoscapeDesktop.this.getTopPane().getHeight() + 5;
                        w = Math.max(w, 106);
                        h = Math.max(h, 106);
                        w = Math.min(w, maxWidth);
                        h = Math.min(h, maxHeight);
                        Point p = CytoscapeDesktop.this.getMasterPane().getLocation();
                        p = SwingUtilities.convertPoint(CytoscapeDesktop.this.getMainPanel(), p, CytoscapeDesktop.this.getGlassPane());
                        int minX = p.x;
                        int minY = p.y;
                        int maxX = minX + CytoscapeDesktop.this.getTopPane().getWidth();
                        int maxY = minY + CytoscapeDesktop.this.getTopPane().getHeight();
                        switch (ComponentPopup.this.cursor) {
                            case 7: 
                            case 8: {
                                y = Math.max(y, minY);
                                y = Math.min(y, maxY - h);
                                break;
                            }
                            case 4: 
                            case 10: {
                                x = Math.max(x, minX);
                                x = Math.min(x, maxX - w);
                                break;
                            }
                            case 6: {
                                x = Math.max(x, minX);
                                x = Math.min(x, maxX - w);
                                y = Math.max(y, minY);
                                y = Math.min(y, maxY - h);
                            }
                        }
                        switch (ComponentPopup.this.cursor) {
                            case 9: {
                                ComponentPopup.this.dragPoint = evt.getPoint();
                                break;
                            }
                            case 11: {
                                ComponentPopup.this.dragPoint = evt.getPoint();
                                break;
                            }
                            case 7: {
                                ComponentPopup.this.dragPoint = new Point(evt.getX(), ComponentPopup.this.dragPoint.y);
                                break;
                            }
                            case 4: {
                                ComponentPopup.this.dragPoint = new Point(ComponentPopup.this.dragPoint.x, evt.getY());
                                break;
                            }
                            case 5: {
                                ComponentPopup.this.dragPoint = evt.getPoint();
                            }
                        }
                        ComponentPopup.this.setBounds(x, y, w, h);
                        ComponentPopup.this.cytoPanel.setMaximized(false);
                        if (ComponentPopup.this.getParent() != null) {
                            ComponentPopup.this.getParent().revalidate();
                        }
                        if (ComponentPopup.this.cytoPanel != null) {
                            CytoscapeDesktop.this.undockPreferredSizes.put(ComponentPopup.this.cytoPanel.getCytoPanelNameInternal(), new Dimension(w, h));
                        }
                    }
                }
            });
        }

        private Rectangle getRectangle(int x, int y, int w, int h, int location) {
            CytoPanelNameInternal name = this.cytoPanel != null ? this.cytoPanel.getCytoPanelNameInternal() : null;
            switch (location) {
                case 1: {
                    if (name != CytoPanelNameInternal.BOTTOM && name != CytoPanelNameInternal.SOUTH && name != CytoPanelNameInternal.SOUTH_WEST) break;
                    return new Rectangle(x + this.lb, y, w - this.rb, 6);
                }
                case 5: {
                    if (name != CytoPanelNameInternal.WEST && name != CytoPanelNameInternal.EAST) break;
                    return new Rectangle(x + this.lb, y + h - this.bb, w - 6, 6);
                }
                case 7: {
                    if (name != CytoPanelNameInternal.EAST && name != CytoPanelNameInternal.SOUTH) break;
                    return new Rectangle(x, y + this.tb, 6, h - 6);
                }
                case 3: {
                    if (name != CytoPanelNameInternal.WEST && name != CytoPanelNameInternal.SOUTH_WEST && name != CytoPanelNameInternal.BOTTOM) break;
                    return new Rectangle(x + w - this.rb, y + this.tb, 6, h - 6);
                }
                case 8: {
                    if (name != CytoPanelNameInternal.SOUTH) break;
                    return new Rectangle(x, y, 6, 6);
                }
                case 2: {
                    if (name != CytoPanelNameInternal.SOUTH_WEST && name != CytoPanelNameInternal.BOTTOM) break;
                    return new Rectangle(x + w - this.rb, y, 6, 6);
                }
                case 6: {
                    if (name != CytoPanelNameInternal.EAST) break;
                    return new Rectangle(x, y + h - this.bb, 6, 6);
                }
                case 4: {
                    if (name != CytoPanelNameInternal.WEST) break;
                    return new Rectangle(x + w - this.rb, y + h - this.bb, 6, 6);
                }
            }
            return null;
        }

        private int getCursor(MouseEvent evt) {
            Component c = evt.getComponent();
            int w = c.getWidth();
            int h = c.getHeight();
            for (int i = 0; i < this.locations.length; ++i) {
                Rectangle rect = this.getRectangle(0, 0, w, h, this.locations[i]);
                if (rect == null || !rect.contains(evt.getPoint())) continue;
                return this.cursors[i];
            }
            return 0;
        }
    }

    private class SidebarToggleButton
    extends JToggleButton {
        private final CytoPanelImpl cytoPanel;
        private final CytoPanelComponent cytoPanelComponent;

        public SidebarToggleButton(CytoPanelImpl cytoPanel, CytoPanelComponent cytoPanelComponent) {
            this.cytoPanel = cytoPanel;
            this.cytoPanelComponent = cytoPanelComponent;
            this.setFont(this.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setContentAreaFilled(false);
            this.setOpaque(true);
        }

        CytoPanelImpl getCytoPanel() {
            return this.cytoPanel;
        }

        CytoPanelComponent getCytoPanelComponent() {
            return this.cytoPanelComponent;
        }

        @Override
        public String toString() {
            return this.cytoPanelComponent != null ? this.cytoPanelComponent.getTitle() : super.toString();
        }
    }

    private class SideBar
    extends JPanel {
        private static final int BORDER_WIDTH = 1;
        private final Map<CytoPanelImpl, TrimStack> stacks = new LinkedHashMap<CytoPanelImpl, TrimStack>();
        private final int compassDirection;

        public SideBar(int compassDirection, CytoPanelImpl ... cytoPanels) {
            this.compassDirection = compassDirection;
            Color borderColor = UIManager.getColor("Separator.foreground");
            if (compassDirection == 7) {
                this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, borderColor));
            } else if (compassDirection == 3) {
                this.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, borderColor));
            } else if (compassDirection == 5) {
                this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor));
            }
            BoxLayout layout = new BoxLayout(this, compassDirection == 5 ? 0 : 1);
            this.setLayout(layout);
            for (CytoPanelImpl cp : cytoPanels) {
                TrimStack ts = new TrimStack(cp);
                this.stacks.put(cp, ts);
            }
            this.addMouseListener(new ContextMenuMouseListener());
            this.update();
        }

        TrimStack getStack(CytoPanelImpl cytoPanel) {
            return this.stacks.get(cytoPanel);
        }

        void update() {
            this.removeAll();
            if (this.compassDirection == 5 && CytoscapeDesktop.this.westSideBar != null && CytoscapeDesktop.this.westSideBar.isVisible() && CytoscapeDesktop.this.westSideBar.getWidth() > 0) {
                this.add(Box.createHorizontalStrut(CytoscapeDesktop.this.westSideBar.getWidth() - 1));
            }
            boolean visible = false;
            int i = 0;
            for (TrimStack ts : this.stacks.values()) {
                if (ts.isVisible()) {
                    visible = true;
                }
                this.add(ts);
                if (i == 0) {
                    this.add(this.compassDirection == 5 ? Box.createHorizontalGlue() : Box.createVerticalGlue());
                }
                ++i;
            }
            if (this.compassDirection == 5 && CytoscapeDesktop.this.eastSideBar != null && CytoscapeDesktop.this.eastSideBar.isVisible() && CytoscapeDesktop.this.eastSideBar.getWidth() > 0) {
                this.add(Box.createHorizontalStrut(CytoscapeDesktop.this.eastSideBar.getWidth() - 1));
            }
            if (visible != this.isVisible()) {
                this.setVisible(visible);
            }
            if (this.isVisible()) {
                this.updateUI();
            }
        }

        public JMenuItem createMenuItemFromButton(JButton btn) {
            int iconSize = 16;
            JMenuItem mi = new JMenuItem(btn.getToolTipText());
            mi.setIcon((Icon)new TextIcon(btn.getText(), btn.getFont(), iconSize, iconSize));
            mi.addActionListener(e -> btn.doClick());
            mi.setEnabled(btn.isVisible() && btn.isEnabled());
            return mi;
        }

        private class ContextMenuMouseListener
        extends MouseAdapter {
            private final CytoPanelImpl cytoPanel;

            public ContextMenuMouseListener() {
                this(null);
            }

            public ContextMenuMouseListener(CytoPanelImpl cytoPanel) {
                this.cytoPanel = cytoPanel;
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.maybeShowContextMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.maybeShowContextMenu(evt);
            }

            private void maybeShowContextMenu(MouseEvent evt) {
                if (!evt.isPopupTrigger()) {
                    return;
                }
                ViewUtil.invokeOnEDT(() -> {
                    JPopupMenu menu = new JPopupMenu();
                    if (this.cytoPanel != null) {
                        String title = this.cytoPanel.getTitle();
                        menu.add(SideBar.this.createMenuItemFromButton(this.cytoPanel.getFloatButton()));
                        menu.add(SideBar.this.createMenuItemFromButton(this.cytoPanel.getDockButton()));
                        menu.add(SideBar.this.createMenuItemFromButton(this.cytoPanel.getUndockButton()));
                        menu.add(SideBar.this.createMenuItemFromButton(this.cytoPanel.getMinimizeButton()));
                        menu.addSeparator();
                        JMenuItem mi = new JMenuItem("Hide " + (String)title);
                        mi.addActionListener(e -> CytoscapeDesktop.this.removeCytoPanel(this.cytoPanel));
                        mi.setEnabled(this.cytoPanel.getStateInternal() != CytoPanelStateInternal.HIDE);
                        menu.add(mi);
                    } else {
                        for (CytoPanelImpl cp : CytoscapeDesktop.this.getAllCytoPanels()) {
                            CytoPanelStateInternal state = cp.getStateInternal();
                            CytoPanelAction action = new CytoPanelAction(cp.getCytoPanelNameInternal(), CytoscapeDesktop.this, 0.0f);
                            JCheckBoxMenuItem mi = new JCheckBoxMenuItem((Action)((Object)action));
                            mi.setSelected(state != CytoPanelStateInternal.HIDE);
                            menu.add(mi);
                            action.updateEnableState();
                        }
                    }
                    menu.addSeparator();
                    JCheckBoxMenuItem mi = new JCheckBoxMenuItem("Show Labels");
                    mi.addActionListener(e -> CytoscapeDesktop.this.setShowSideBarLabels(mi.isSelected()));
                    mi.setSelected(CytoscapeDesktop.this.isShowSideBarLabels());
                    menu.add(mi);
                    Component parent = (Component)evt.getSource();
                    menu.show(parent, evt.getX(), evt.getY());
                });
            }
        }

        private class TrimStack
        extends JPanel {
            private static final int BTN_HPAD = 8;
            private static final int BTN_VPAD = 4;
            private final CytoPanelImpl cytoPanel;
            private final int orientation;
            private final List<SidebarToggleButton> buttons = new ArrayList<SidebarToggleButton>();
            private final ToggleableButtonGroup buttonGroup;

            TrimStack(CytoPanelImpl cytoPanel) {
                this.cytoPanel = cytoPanel;
                this.orientation = SideBar.this.compassDirection == 5 ? 0 : 1;
                BoxLayout layout = new BoxLayout(this, this.orientation == 1 ? 0 : 1);
                this.setLayout(layout);
                this.addMouseListener(new ContextMenuMouseListener(cytoPanel));
                this.buttonGroup = new ToggleableButtonGroup(){

                    @Override
                    public void setSelected(ButtonModel model, boolean selected) {
                        if (CytoscapeDesktop.this.isAdjusting || selected == this.isSelected(model)) {
                            return;
                        }
                        CytoscapeDesktop.this.isAdjusting = true;
                        CytoscapeDesktop.this.onSidebarButtonSelected((SidebarToggleButton)this.getButton(model), selected);
                        super.setSelected(model, selected);
                        CytoscapeDesktop.this.isAdjusting = false;
                    }
                };
                this.update();
            }

            SidebarToggleButton getButton(int index) {
                return index >= 0 && index < this.buttons.size() ? this.buttons.get(index) : null;
            }

            List<SidebarToggleButton> getAllButtons() {
                return new ArrayList<SidebarToggleButton>(this.buttons);
            }

            ToggleableButtonGroup getButtonGroup() {
                return this.buttonGroup;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void update() {
                CytoscapeDesktop.this.updatingTrimStack = true;
                try {
                    if (this.cytoPanel.getStateInternal() == CytoPanelStateInternal.MINIMIZE || this.cytoPanel.getStateInternal() == CytoPanelStateInternal.UNDOCK) {
                        this.buttonGroup.remove(this.buttons);
                    } else {
                        CytoscapeDesktop.this.undockedButtonGroup.remove(this.buttons);
                    }
                    if (this.cytoPanel.getStateInternal() == CytoPanelStateInternal.HIDE) {
                        this.setVisible(false);
                        return;
                    }
                    this.removeAll();
                    Map oldButtons = this.buttons.stream().collect(Collectors.toMap(SidebarToggleButton::getCytoPanelComponent, Function.identity()));
                    this.buttons.clear();
                    JPanel panel = null;
                    boolean showLabels = CytoscapeDesktop.this.isShowSideBarLabels();
                    int totalEdge = 0;
                    List<CytoPanelComponent> cpComponents = this.cytoPanel.getCytoPanelComponents();
                    int i = 0;
                    for (CytoPanelComponent cpc : cpComponents) {
                        int buttonEdge;
                        int index = i++;
                        SidebarToggleButton btn = (SidebarToggleButton)oldButtons.remove(cpc);
                        if (btn == null) {
                            String title = cpc.getTitle();
                            Icon icon = cpc.getIcon();
                            if ((title == null || title.trim().isEmpty()) && icon == null) continue;
                            Icon buttonIcon = icon;
                            if (buttonIcon == null) {
                                buttonIcon = ViewUtil.createDefaultIcon(title, 16, (IconManager)CytoscapeDesktop.this.serviceRegistrar.getService(IconManager.class));
                            } else if (buttonIcon instanceof ImageIcon) {
                                if (showLabels && buttonIcon.getIconHeight() > 16) {
                                    buttonIcon = ViewUtil.resizeIcon(buttonIcon, 16);
                                } else if (!(showLabels || buttonIcon.getIconHeight() <= 16 && buttonIcon.getIconWidth() <= 16)) {
                                    buttonIcon = IconManager.resizeIcon((Icon)buttonIcon, (int)16);
                                }
                            }
                            SidebarToggleButton newButton = btn = new SidebarToggleButton(this.cytoPanel, cpc);
                            btn.setIcon(buttonIcon);
                            btn.setToolTipText(title);
                            btn.setAlignmentX(0.5f);
                            btn.addItemListener(evt -> ViewUtil.updateToolBarStyle(newButton, false));
                            btn.addMouseListener(new ContextMenuMouseListener(this.cytoPanel));
                        }
                        this.buttons.add(btn);
                        btn.setText(showLabels ? cpc.getTitle() : null);
                        if (showLabels && this.orientation == 1) {
                            btn.setUI(new VerticalButtonUI(SideBar.this.compassDirection == 3));
                        } else {
                            btn.setUI(new BasicButtonUI());
                        }
                        btn.setPreferredSize(null);
                        Dimension d = btn.getPreferredSize();
                        d = this.orientation == 1 ? new Dimension(d.width + 8, d.height + 16) : new Dimension(d.width + 16, d.height + 8);
                        btn.setPreferredSize(d);
                        btn.setMinimumSize(d);
                        btn.setMaximumSize(d);
                        btn.setSize(d);
                        ViewUtil.updateToolBarStyle(btn, false);
                        if (!oldButtons.isEmpty()) {
                            this.buttonGroup.remove(oldButtons.values());
                            CytoscapeDesktop.this.undockedButtonGroup.remove(oldButtons.values());
                        }
                        if (this.cytoPanel.getStateInternal() == CytoPanelStateInternal.MINIMIZE || this.cytoPanel.getStateInternal() == CytoPanelStateInternal.UNDOCK) {
                            CytoscapeDesktop.this.undockedButtonGroup.add(btn);
                        } else {
                            this.buttonGroup.add(btn);
                            SidebarToggleButton selBtn = this.getButton(this.cytoPanel.getSelectedIndex());
                            if (selBtn != null) {
                                this.buttonGroup.setSelected(selBtn, true);
                            }
                        }
                        int n = buttonEdge = this.orientation == 1 ? d.height : d.width;
                        if (panel != null && SideBar.this.getSize() != null) {
                            int barEdge = this.orientation == 1 ? SideBar.this.getSize().height : SideBar.this.getSize().width;
                            for (TrimStack ts : SideBar.this.stacks.values()) {
                                if (ts == this || ts.getSize() == null) continue;
                                barEdge -= this.orientation == 1 ? ts.getSize().height : ts.getSize().width;
                            }
                            if (totalEdge + buttonEdge > barEdge) {
                                panel = null;
                            }
                        }
                        if (panel == null) {
                            panel = new JPanel();
                            panel.setAlignmentX(this.cytoPanel.getCytoPanelName() == CytoPanelName.SOUTH ? 1.0f : 0.0f);
                            panel.setAlignmentY(0.0f);
                            BoxLayout layout = new BoxLayout(panel, this.orientation == 1 ? 1 : 0);
                            panel.setLayout(layout);
                            if (SideBar.this.compassDirection == 7) {
                                this.add((Component)panel, 0);
                            } else {
                                this.add(panel);
                            }
                            totalEdge = 0;
                        }
                        totalEdge += buttonEdge;
                        panel.add(btn);
                    }
                    this.setVisible(!this.buttons.isEmpty());
                    if (this.isVisible()) {
                        if (!showLabels) {
                            LookAndFeelUtil.equalizeSize((JComponent[])this.buttons.toArray(new JComponent[this.buttons.size()]));
                        }
                        if (SideBar.this.compassDirection == 7) {
                            this.add(Box.createHorizontalGlue(), 0);
                        } else if (SideBar.this.compassDirection == 5) {
                            this.add(Box.createVerticalGlue());
                        } else {
                            this.add(Box.createHorizontalGlue());
                        }
                        this.updateUI();
                    }
                }
                finally {
                    CytoscapeDesktop.this.updatingTrimStack = false;
                }
            }

            public int hashCode() {
                int prime = 31;
                int result = 11;
                result = 31 * result + this.getOuterType().hashCode();
                result = 31 * result + (this.cytoPanel == null ? 0 : this.cytoPanel.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof TrimStack)) {
                    return false;
                }
                TrimStack other = (TrimStack)obj;
                if (!this.getOuterType().equals(other.getOuterType())) {
                    return false;
                }
                return !(this.cytoPanel == null ? other.cytoPanel != null : !this.cytoPanel.equals(other.cytoPanel));
            }

            private SideBar getOuterType() {
                return SideBar.this;
            }
        }
    }
}

