/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Set;
import org.cytoscape.application.swing.CyNetworkViewDesktopMgr;
import org.cytoscape.internal.view.NetworkViewContainer;
import org.cytoscape.internal.view.NetworkViewFrame;
import org.cytoscape.internal.view.NetworkViewMediator;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.view.model.CyNetworkView;

public class CyDesktopManager
implements CyNetworkViewDesktopMgr {
    public static int MINIMUM_WIN_WIDTH = 200;
    public static int MINIMUM_WIN_HEIGHT = 200;
    private final NetworkViewMediator netViewMediator;

    public CyDesktopManager(NetworkViewMediator netViewMediator) {
        this.netViewMediator = netViewMediator;
    }

    public Dimension getDesktopViewAreaSize() {
        return this.netViewMediator.getNetworkViewMainPanel().getSize();
    }

    public Rectangle getBounds(CyNetworkView view) {
        Rectangle bounds = null;
        NetworkViewFrame frame = this.netViewMediator.getNetworkViewFrame(view);
        if (frame != null) {
            bounds = frame.getBounds();
        } else {
            NetworkViewContainer card = this.netViewMediator.getNetworkViewCard(view);
            if (card != null) {
                bounds = card.getBounds();
            }
        }
        return bounds;
    }

    public void setBounds(CyNetworkView view, Rectangle bounds) {
    }

    public void arrangeWindows(CyNetworkViewDesktopMgr.ArrangeType type) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = ge.getScreenDevices();
        CyNetworkView currentView = this.netViewMediator.getNetworkViewMainPanel().getCurrentNetworkView();
        Set<NetworkViewFrame> allViewFrames = this.netViewMediator.getAllNetworkViewFrames();
        for (GraphicsDevice gd : devices) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            ArrayList<NetworkViewFrame> frames = new ArrayList<NetworkViewFrame>();
            for (NetworkViewFrame f : allViewFrames) {
                if (!f.getGraphicsConfiguration().equals(gc)) continue;
                if (type == CyNetworkViewDesktopMgr.ArrangeType.CASCADE) {
                    CyNetworkView lastView;
                    NetworkViewFrame lastFrame = frames.isEmpty() ? null : (NetworkViewFrame)frames.get(frames.size() - 1);
                    CyNetworkView cyNetworkView = lastView = lastFrame == null ? null : lastFrame.getNetworkView();
                    if (lastView != null && lastView.equals(currentView)) {
                        frames.add(frames.size() - 1, f);
                        continue;
                    }
                    frames.add(f);
                    continue;
                }
                frames.add(f);
            }
            if (frames.isEmpty()) continue;
            Rectangle effectiveScreenArea = ViewUtil.getEffectiveScreenArea(gc);
            this.arrangeWindows(frames.toArray(new NetworkViewFrame[frames.size()]), type, effectiveScreenArea);
        }
    }

    private void arrangeWindows(NetworkViewFrame[] frames, CyNetworkViewDesktopMgr.ArrangeType type, Rectangle bounds) {
        int frameCount;
        int n = frameCount = frames != null ? frames.length : 0;
        if (frameCount == 0) {
            return;
        }
        int screenX = bounds.x;
        int screenY = bounds.y;
        int screenWidth = bounds.width;
        int screenHeight = bounds.height;
        if (type == CyNetworkViewDesktopMgr.ArrangeType.CASCADE) {
            int i;
            int delta_x = 20;
            int delta_y = 20;
            int delta_block = 50;
            int[] x = new int[frameCount];
            int[] y = new int[frameCount];
            int[] w = new int[frameCount];
            int[] h = new int[frameCount];
            x[0] = 0;
            y[0] = 0;
            w[0] = frames[0].getWidth();
            h[0] = frames[0].getHeight();
            boolean multiBlock = false;
            int blockSize = 0;
            for (i = 1; i < frameCount; ++i) {
                ++blockSize;
                x[i] = x[i - 1] + delta_x;
                y[i] = y[i - 1] + delta_y;
                if (screenHeight - y[i] < MINIMUM_WIN_HEIGHT) {
                    y[i] = 0;
                    multiBlock = true;
                }
                if (screenWidth - x[i] < MINIMUM_WIN_WIDTH && !multiBlock) {
                    x[i] = x[i - 1];
                }
                if (y[i] != 0 || !multiBlock) continue;
                for (int j = 0; j < blockSize; ++j) {
                    if (i - blockSize > 0) {
                        w[i - j - 1] = w[i - blockSize];
                        h[i - j - 1] = h[i - blockSize];
                        continue;
                    }
                    w[i - j - 1] = screenWidth - x[i - 1];
                    h[i - j - 1] = screenHeight - y[i - 1];
                }
                x[i] = x[i - blockSize] + delta_block;
                if (x[i] > screenWidth - delta_x * blockSize) {
                    x[i] = x[i - blockSize];
                }
                blockSize = 1;
            }
            if (!multiBlock) {
                for (i = 0; i < frameCount; ++i) {
                    w[frameCount - 1 - i] = screenWidth - x[frameCount - 1];
                    h[frameCount - 1 - i] = screenHeight - y[frameCount - 1];
                }
            } else {
                for (i = 0; i < blockSize; ++i) {
                    w[frameCount - 1 - i] = w[frameCount - blockSize - 1];
                    h[frameCount - 1 - i] = h[frameCount - blockSize - 1];
                    if (w[frameCount - 1 - i] <= screenWidth - x[frameCount - 1]) continue;
                    w[frameCount - 1 - i] = screenWidth - x[frameCount - 1];
                }
            }
            if (screenHeight - MINIMUM_WIN_HEIGHT < delta_y) {
                double delta_x1 = (double)(screenWidth - MINIMUM_WIN_WIDTH) / (double)(frameCount - 1);
                for (int i2 = 0; i2 < frameCount; ++i2) {
                    x[i2] = (int)Math.ceil((double)i2 * delta_x1);
                    y[i2] = 0;
                    w[i2] = MINIMUM_WIN_WIDTH;
                    h[i2] = MINIMUM_WIN_HEIGHT;
                }
            }
            for (int i3 = 0; i3 < frameCount; ++i3) {
                NetworkViewFrame f = frames[i3];
                f.setBounds(x[i3] + screenX, y[i3] + screenY, w[i3], h[i3]);
                f.toFront();
            }
        } else if (type == CyNetworkViewDesktopMgr.ArrangeType.GRID) {
            int maxCol;
            int maxRow = maxCol = new Double(Math.ceil(Math.sqrt(frameCount))).intValue();
            while (frameCount <= maxCol * (maxRow - 1)) {
                --maxRow;
            }
            int[] gridLayout = new int[maxCol];
            this.getGridLayout(frameCount, maxCol, maxRow, gridLayout);
            int w = screenWidth / maxCol;
            int curFrame = frameCount - 1;
            for (int col = maxCol - 1; col >= 0; --col) {
                int h = screenHeight / gridLayout[col];
                for (int i = 0; i < gridLayout[col]; ++i) {
                    int x = col * w;
                    int y = (gridLayout[col] - i - 1) * h;
                    frames[curFrame--].setBounds(x + screenX, y + screenY, w, h);
                }
            }
        } else if (type == CyNetworkViewDesktopMgr.ArrangeType.HORIZONTAL) {
            int x = 0;
            int y = 0;
            int w = screenWidth;
            int h = screenHeight / frameCount;
            if (h < MINIMUM_WIN_HEIGHT) {
                h = MINIMUM_WIN_HEIGHT;
            }
            double delta_y = 0.0;
            if (frameCount > 1) {
                delta_y = h < MINIMUM_WIN_HEIGHT ? (double)(screenHeight - MINIMUM_WIN_HEIGHT) / (double)(frameCount - 1) : (double)screenHeight / (double)frameCount;
            }
            for (int i = 0; i < frameCount; ++i) {
                y = (int)(delta_y * (double)i);
                if (y > screenHeight - MINIMUM_WIN_HEIGHT) {
                    y = screenHeight - MINIMUM_WIN_HEIGHT;
                }
                frames[frameCount - i - 1].setBounds(x + screenX, y + screenY, w, h);
            }
        } else if (type == CyNetworkViewDesktopMgr.ArrangeType.VERTICAL) {
            int x = 0;
            int y = 0;
            int w = screenWidth / frameCount;
            int h = screenHeight;
            if (w < MINIMUM_WIN_WIDTH) {
                w = MINIMUM_WIN_WIDTH;
            }
            double delta_x = 0.0;
            if (frameCount > 1) {
                delta_x = w < MINIMUM_WIN_WIDTH ? (double)(screenWidth - MINIMUM_WIN_WIDTH) / (double)(frameCount - 1) : (double)screenWidth / (double)frameCount;
            }
            for (int i = 0; i < frameCount; ++i) {
                x = (int)(delta_x * (double)i);
                if (x > screenWidth - MINIMUM_WIN_WIDTH) {
                    x = screenWidth - MINIMUM_WIN_WIDTH;
                }
                frames[frameCount - i - 1].setBounds(x + screenX, y + screenY, w, h);
            }
        }
        System.gc();
    }

    private void getGridLayout(int pTotal, int pCol, int pRow, int[] gridLayout) {
        if (pTotal > pRow) {
            int row = -1;
            if (pTotal % pCol == 0) {
                gridLayout[pCol - 1] = row = pTotal / pCol;
            } else {
                row = pRow;
                gridLayout[pCol - 1] = pRow;
            }
            this.getGridLayout(pTotal - row, pCol - 1, row, gridLayout);
        } else {
            gridLayout[0] = pTotal;
        }
    }
}

