/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.util.undo;

import java.util.Properties;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.events.NetworkDestroyedEvent;
import org.cytoscape.model.events.NetworkDestroyedListener;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.events.NetworkViewDestroyedEvent;
import org.cytoscape.view.model.events.NetworkViewDestroyedListener;
import org.cytoscape.work.swing.undo.SwingUndoSupport;

public class UndoMonitor
implements SetCurrentNetworkViewListener,
NetworkDestroyedListener,
NetworkViewDestroyedListener {
    private final CyServiceRegistrar serviceRegistrar;

    public UndoMonitor(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        ((SwingUndoSupport)serviceRegistrar.getService(SwingUndoSupport.class)).getUndoManager().setLimit(this.getLimit());
    }

    private int getLimit() {
        int lim;
        CyProperty cyProps = (CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        Properties props = (Properties)cyProps.getProperties();
        try {
            lim = Integer.parseInt(props.getProperty("undo.limit"));
        }
        catch (Exception e) {
            e.printStackTrace();
            lim = 10;
        }
        if (lim < 0) {
            lim = 10;
        }
        return lim;
    }

    public void handleEvent(SetCurrentNetworkViewEvent e) {
        if (e.getNetworkView() != null) {
            ((SwingUndoSupport)this.serviceRegistrar.getService(SwingUndoSupport.class)).getUndoManager().discardAllEdits();
        }
    }

    public void handleEvent(NetworkDestroyedEvent e) {
        if (((CyNetworkManager)e.getSource()).getNetworkSet().isEmpty()) {
            ((SwingUndoSupport)this.serviceRegistrar.getService(SwingUndoSupport.class)).getUndoManager().discardAllEdits();
        }
    }

    public void handleEvent(NetworkViewDestroyedEvent e) {
        if (((CyNetworkViewManager)e.getSource()).getNetworkViewSet().isEmpty()) {
            ((SwingUndoSupport)this.serviceRegistrar.getService(SwingUndoSupport.class)).reset();
        }
    }
}

