/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.task;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.cytoscape.internal.tunable.CyPropertyConfirmation;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.read.LoadMultipleNetworkFilesTaskFactory;
import org.cytoscape.task.read.OpenSessionTaskFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class LoadFileListTask
extends AbstractTask {
    private final Queue<File> queue;
    private List<File> netFiles;
    private final CyRootNetwork rootNetwork;
    private final boolean confirmLargeList;
    private final CyServiceRegistrar serviceRegistrar;

    public LoadFileListTask(List<File> files, CyRootNetwork rootNetwork, CyServiceRegistrar serviceRegistrar) {
        this(new ArrayDeque<File>(files), new ArrayList<File>(), rootNetwork, true, serviceRegistrar);
    }

    private LoadFileListTask(Queue<File> sourceQueue, List<File> netFiles, CyRootNetwork rootNetwork, boolean confirmLargeList, CyServiceRegistrar serviceRegistrar) {
        this.queue = sourceQueue;
        this.netFiles = netFiles;
        this.rootNetwork = rootNetwork;
        this.confirmLargeList = confirmLargeList;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Import Files");
        tm.setStatusMessage("Scanning Files...");
        tm.setProgress(-1.0);
        while (!this.queue.isEmpty() && !this.cancelled) {
            File f = this.queue.remove();
            if (f.isDirectory()) {
                File[] listFiles = f.listFiles();
                if (listFiles == null) continue;
                this.queue.addAll(Arrays.asList(listFiles));
                continue;
            }
            if (!f.exists() || !f.canRead() || f.isHidden()) continue;
            this.netFiles.add(f);
            if (!this.confirmLargeList) continue;
            ConfirmLargeFileListTask confirmTask = new ConfirmLargeFileListTask();
            String propVal = confirmTask.confirmation.getPropertyValue();
            int max = -1;
            try {
                max = Integer.parseInt(propVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (max <= 0 || this.netFiles.size() <= max) continue;
            this.insertTasksAfterCurrentTask(new Task[]{confirmTask});
            return;
        }
        if (this.cancelled) {
            return;
        }
        int cysCount = 0;
        File cysFile = null;
        Iterator<File> iter = this.netFiles.iterator();
        while (iter.hasNext() && !this.cancelled) {
            File file = iter.next();
            if (!this.isCySession(file)) continue;
            iter.remove();
            if (++cysCount > 1) {
                throw new RuntimeException("The file list cannot contain more than one Cytoscape Session (.cys) file.");
            }
            cysFile = file;
        }
        if (this.cancelled) {
            return;
        }
        if (!this.netFiles.isEmpty()) {
            this.insertTasksAfterCurrentTask(((LoadMultipleNetworkFilesTaskFactory)this.serviceRegistrar.getService(LoadMultipleNetworkFilesTaskFactory.class)).createTaskIterator(this.netFiles, cysFile == null ? this.rootNetwork : null));
        }
        if (this.cancelled) {
            return;
        }
        if (cysFile != null) {
            this.insertTasksAfterCurrentTask(((OpenSessionTaskFactory)this.serviceRegistrar.getService(OpenSessionTaskFactory.class)).createTaskIterator(cysFile, true));
        }
    }

    private boolean isCySession(File f) {
        return f != null && f.isFile() && f.getName().toLowerCase().endsWith(".cys");
    }

    public class ConfirmLargeFileListTask
    extends AbstractTask {
        private static final String FILE_THRESHOLD_PROP = "networkImport.fileThreshold";
        @Tunable(description="<html><b>Are you sure you want to import all these files?</b><br><br>The import list contains more than ${networkImport.fileThreshold} files,<br>which may take too long to process.</html>", params="doNotAskLabel=Always import and do not ask me again;cancelLabel=Cancel;okLabel=Import")
        public CyPropertyConfirmation confirmation;

        public ConfirmLargeFileListTask() {
            this.confirmation = new CyPropertyConfirmation(FILE_THRESHOLD_PROP, LoadFileListTask.this.serviceRegistrar);
        }

        public void run(TaskMonitor tm) throws Exception {
            if (!this.cancelled && this.confirmation.isConfirmed()) {
                this.insertTasksAfterCurrentTask(new Task[]{new LoadFileListTask(LoadFileListTask.this.queue, LoadFileListTask.this.netFiles, LoadFileListTask.this.rootNetwork, false, LoadFileListTask.this.serviceRegistrar)});
            }
        }
    }
}

