/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.shutdown;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.application.events.CyShutdownEvent;
import org.cytoscape.application.events.CyShutdownListener;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDirPropertyWriter
implements CyShutdownListener {
    private final Map<CyProperty<?>, Map<?, ?>> configDirProperties;
    private final CyServiceRegistrar serviceRegistrar;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public ConfigDirPropertyWriter(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.configDirProperties = new HashMap();
    }

    public void handleEvent(CyShutdownEvent event) {
        for (Map.Entry<CyProperty<?>, Map<?, ?>> keyAndValue : this.configDirProperties.entrySet()) {
            String propertyName = (String)keyAndValue.getValue().get("cyPropertyName");
            if (propertyName == null || propertyName.isEmpty()) continue;
            Object propertyFileName = propertyName.endsWith(".props") ? propertyName : propertyName + ".props";
            CyApplicationConfiguration config = (CyApplicationConfiguration)this.serviceRegistrar.getService(CyApplicationConfiguration.class);
            File outputFile = new File(config.getConfigurationDirectoryLocation(), (String)propertyFileName);
            Properties props = (Properties)keyAndValue.getKey().getProperties();
            try {
                FileOutputStream out = new FileOutputStream(outputFile);
                props.store(out, null);
                out.close();
            }
            catch (Exception e) {
                logger.error("Error in wring properties file.");
            }
        }
    }

    public void addCyProperty(CyProperty<?> cyProp, Map<?, ?> properties) {
        if (cyProp.getSavePolicy() == CyProperty.SavePolicy.CONFIG_DIR || cyProp.getSavePolicy() == CyProperty.SavePolicy.SESSION_FILE_AND_CONFIG_DIR) {
            this.configDirProperties.put(cyProp, properties);
        }
    }

    public void removeCyProperty(CyProperty<?> cyProp, Map<?, ?> properties) {
        if (cyProp.getSavePolicy() == CyProperty.SavePolicy.CONFIG_DIR || cyProp.getSavePolicy() == CyProperty.SavePolicy.SESSION_FILE_AND_CONFIG_DIR) {
            this.configDirProperties.remove(cyProp);
        }
    }
}

