/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.command;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.application.events.CyShutdownEvent;
import org.cytoscape.application.events.CyShutdownListener;
import org.cytoscape.application.swing.CytoPanelComponent2;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.internal.command.CommandTaskRunner;
import org.cytoscape.internal.command.JResultsPane;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;

public class CommandToolPanel
extends JPanel
implements CytoPanelComponent2,
ActionListener,
CyShutdownListener {
    private static final String NEXT_ACTION = "next";
    private static final String PREV_ACTION = "previous";
    private static final String CLEAR_ACTION = "clear";
    public static final int MAX_SAVED_COMMANDS = 500;
    private static final Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");
    private final CyServiceRegistrar serviceRegistrar;
    private final CommandTaskRunner commandRunner;
    private List<String> commandList = new ArrayList<String>();
    private int commandIndex = 0;
    private JResultsPane resultsText;
    private JTextField inputField;
    private File savedCommandsFile;
    private TextIcon icon;

    public CommandToolPanel(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.commandRunner = new CommandTaskRunner(serviceRegistrar);
        this.restoreCommandHistory();
        this.initComponents();
        this.setOpaque(false);
    }

    private void restoreCommandHistory() {
        CyApplicationConfiguration appConfig = (CyApplicationConfiguration)this.serviceRegistrar.getService(CyApplicationConfiguration.class);
        File appConfigDir = appConfig.getConfigurationDirectoryLocation();
        this.savedCommandsFile = new File(appConfigDir.getAbsolutePath() + File.separator + "commandHistory.txt");
        if (this.savedCommandsFile.exists()) {
            this.readCommandHistory(this.savedCommandsFile);
        }
    }

    private void readCommandHistory(File commandsFile) {
        try (BufferedReader br = new BufferedReader(new FileReader(commandsFile));){
            String line;
            while ((line = br.readLine()) != null) {
                this.commandList.add(line);
            }
            this.commandIndex = this.commandList.size();
        }
        catch (IOException e) {
            logger.error((Object)("Error reading command history from '" + commandsFile.getAbsolutePath() + "': " + e));
        }
    }

    public String getIdentifier() {
        return "CLI";
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return null;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = new TextIcon("%", ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont("cytoscape-3", 16.0f), 16, 16);
        }
        return this.icon;
    }

    public String getTitle() {
        return "Command Line";
    }

    @Override
    public void setVisible(boolean tf) {
        super.setVisible(tf);
        this.getInputField().requestFocusInWindow();
    }

    private void initComponents() {
        JLabel inputLabel = new JLabel("Command:");
        this.resultsText = new JResultsPane(null, this);
        this.resultsText.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.resultsText);
        this.resultsText.setScrollPane(scrollPane);
        JButton clearButton = new JButton("Clear");
        clearButton.setToolTipText("Clear Log");
        clearButton.setActionCommand(CLEAR_ACTION);
        clearButton.addActionListener(this);
        if (LookAndFeelUtil.isAquaLAF()) {
            clearButton.putClientProperty("JButton.buttonType", "gradient");
        }
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{inputLabel, clearButton});
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(clearButton).addComponent(inputLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(scrollPane, -1, 880, Short.MAX_VALUE).addComponent(this.getInputField(), -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(clearButton, 0, -1, -2).addComponent(scrollPane, 0, 580, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(inputLabel, -2, -1, -2).addComponent(this.getInputField(), -2, -1, -2)));
    }

    public void executeCommand(String command) {
        this.resultsText.appendCommand(command);
        this.commandRunner.runCommand(command, this.resultsText);
    }

    public void handleEvent(CyShutdownEvent shutdown) {
        if (this.savedCommandsFile.exists()) {
            this.savedCommandsFile.delete();
        }
        int start = 0;
        if (this.commandList.size() > 500) {
            start = this.commandList.size() - 500;
        }
        try (FileWriter writer = new FileWriter(this.savedCommandsFile);){
            for (int i = start; i < this.commandList.size(); ++i) {
                writer.write(this.commandList.get(i) + "\n");
            }
        }
        catch (Exception ioe) {
            logger.error((Object)("Error writing command history to '" + this.savedCommandsFile.getAbsolutePath() + "': " + ioe));
            System.err.println("Error writing command history to '" + this.savedCommandsFile.getAbsolutePath() + "': " + ioe);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (CLEAR_ACTION.equals(e.getActionCommand())) {
            this.resultsText.clear();
        } else {
            String input = this.getInputField().getText();
            this.commandList.add(input);
            this.commandIndex = this.commandList.size();
            this.executeCommand(input);
            this.getInputField().setText("");
        }
    }

    private JTextField getInputField() {
        if (this.inputField == null) {
            this.inputField = new JTextField();
            this.inputField.setFont(this.inputField.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            LineAction previousAction = new LineAction(PREV_ACTION);
            this.inputField.getInputMap().put(KeyStroke.getKeyStroke(38, 0), PREV_ACTION);
            this.inputField.getActionMap().put(PREV_ACTION, previousAction);
            LineAction nextAction = new LineAction(NEXT_ACTION);
            this.inputField.getInputMap().put(KeyStroke.getKeyStroke(40, 0), NEXT_ACTION);
            this.inputField.getActionMap().put(NEXT_ACTION, nextAction);
            this.inputField.addActionListener(this);
        }
        return this.inputField;
    }

    private class LineAction
    extends AbstractAction {
        final String action;

        public LineAction(String action) {
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String inputCommand;
            if (CommandToolPanel.this.commandList.size() == 0) {
                return;
            }
            switch (this.action) {
                case "next": {
                    ++CommandToolPanel.this.commandIndex;
                    break;
                }
                case "previous": {
                    --CommandToolPanel.this.commandIndex;
                    break;
                }
                default: {
                    return;
                }
            }
            if (CommandToolPanel.this.commandIndex >= CommandToolPanel.this.commandList.size()) {
                inputCommand = "";
                CommandToolPanel.this.commandIndex = CommandToolPanel.this.commandList.size();
            } else if (CommandToolPanel.this.commandIndex < 0) {
                inputCommand = "";
                CommandToolPanel.this.commandIndex = -1;
            } else {
                inputCommand = CommandToolPanel.this.commandList.get(CommandToolPanel.this.commandIndex);
            }
            CommandToolPanel.this.getInputField().setText(inputCommand);
            CommandToolPanel.this.getInputField().selectAll();
        }
    }
}

