/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterJob;
import java.util.Properties;
import java.util.Set;
import javax.swing.KeyStroke;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.presentation.RenderingEngine;

public class PrintAction
extends AbstractCyAction {
    private static final String MENU_LABEL = "Print...";
    private final CyServiceRegistrar serviceRegistrar;

    public PrintAction(CyApplicationManager appMgr, CyNetworkViewManager networkViewManager, CyServiceRegistrar serviceRegistrar) {
        super(MENU_LABEL, appMgr, "networkAndView", networkViewManager);
        this.serviceRegistrar = serviceRegistrar;
        this.setPreferredMenu("File");
        this.setMenuGravity(28.1f);
        this.insertSeparatorBefore = true;
        this.setAcceleratorKeyStroke(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
    }

    public void actionPerformed(ActionEvent e) {
        RenderingEngine engine = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentRenderingEngine();
        PrinterJob printJob = PrinterJob.getPrinterJob();
        CyProperty cyProps = (CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        Properties props = (Properties)cyProps.getProperties();
        Set<Object> keys = props.keySet();
        for (Object key : keys) {
            engine.getProperties().put(key, props.get(key));
        }
        printJob.setPrintable(engine.createPrintable());
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }
}

