/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.actions;

import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.KeyStroke;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.internal.dialogs.PreferencesDialog;
import org.cytoscape.internal.dialogs.PreferencesDialogFactory;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.bookmark.Bookmarks;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class PreferenceAction
extends AbstractCyAction {
    private final CySwingApplication desktop;
    private final PreferencesDialogFactory dialogFactory;
    private PreferencesDialog preferencesDialog;
    private Map<String, Properties> propMap = new HashMap<String, Properties>();
    private Map<String, Bookmarks> bookmarkMap = new HashMap<String, Bookmarks>();
    private Map<String, CyProperty<?>> cyPropMap = new HashMap();

    public PreferenceAction(CySwingApplication desktop, PreferencesDialogFactory dialogFactory) {
        super("Properties...");
        this.desktop = desktop;
        this.dialogFactory = dialogFactory;
        this.setPreferredMenu("Edit.Preferences");
        this.setMenuGravity(11.0f);
        if (LookAndFeelUtil.isMac()) {
            this.setAcceleratorKeyStroke(KeyStroke.getKeyStroke(44, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() + 256));
        }
    }

    public void actionPerformed(ActionEvent e) {
        Window owner = ViewUtil.getWindowAncestor(e, this.desktop);
        this.preferencesDialog = this.dialogFactory.getPreferencesDialog(owner, this.propMap, this.cyPropMap);
        this.preferencesDialog.setVisible(true);
    }

    public boolean isEnabled() {
        return !this.dialogFactory.isDialogVisible();
    }

    public void addCyProperty(CyProperty<?> p, Map<?, ?> d) {
        String propertyName = p.getName();
        Object obj = p.getProperties();
        if (obj instanceof Properties) {
            this.propMap.put(propertyName, (Properties)obj);
            this.cyPropMap.put(propertyName, p);
        } else if (obj instanceof Bookmarks) {
            this.bookmarkMap.put(propertyName, (Bookmarks)obj);
        } else {
            System.out.println("PreferenceAction: Do not know what kind of properties it is.");
        }
    }

    public void removeCyProperty(CyProperty<?> p, Map<?, ?> d) {
        String propertyName = p.getName();
        Object obj = p.getProperties();
        if (obj instanceof Properties) {
            this.propMap.remove(propertyName);
        } else if (obj instanceof Bookmarks) {
            this.bookmarkMap.remove(propertyName);
        }
    }
}

